/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_DEMO2_GEOMETRY_LOADER_UTIL_H
#define HK_DEMO2_GEOMETRY_LOADER_UTIL_H

#include <Common/Base/Math/hkMath.h>
#include <Common/SceneData/SceneDataToGeometryConverter/hkxSceneDataToGeometryConverter.h>

class hkResource;
struct hkGeometry;
class hkRootLevelContainer;
class hkgDisplayWorld;
class hkgDisplayContext;
class hkgGeometry;
class hkAabb;


/// A utility to load instanced geometry from any Havok file
namespace GeometryLoaderUtil
{

			// Load from a file.
		bool HK_CALL load(const char* filename, hkGeometry& geometry, hkAabb* aabb = HK_NULL);
		
			// A struct to represent instanced geometry
		typedef hkxSceneDataToGeometryConverter::GeometryInstances GeometryInstances;

			// Load from a generic resource into a single geometry (legacy)
		void	HK_CALL load( const hkResource* resource, hkGeometry& geometry );
			
			// Load from a generic resource into a collection of instanced geometries
		void	HK_CALL load( const hkResource* resource, GeometryInstances& geometriesOut );

			// Scales the input geometry so that the longest extent is 'size' , returns the applied scale.
		hkReal HK_CALL normalize(hkGeometry& geom, hkReal size, hkTransform* transformOut=HK_NULL );

		/// Creates and returns a display object for a group of geometries and adds it to the display world passed if not NULL
		hkgDisplayObject* HK_CALL createDisplay(const hkArray<const hkGeometry*>& meshes, hkgDisplayWorld* display, hkgDisplayContext* context, const hkVector4* color = HK_NULL);

		/// Creates and returns a display object for a geometry and adds it to the display world passed if not NULL
		hkgDisplayObject* HK_CALL createDisplay(const hkGeometry& mesh, hkgDisplayWorld* display, hkgDisplayContext* context, const hkVector4& color);


		void	HK_CALL merge( const hkGeometry& input, hkGeometry& output );

		//
		// Internal methods
		//

			// Convert all found nodes in a root level container into a geometry
		bool	HK_CALL load( const hkRootLevelContainer* level, GeometryInstances& geometriesOut );

			// Utility function
		void	HK_CALL merge( const hkGeometry& input, const hkMatrix4& transform, hkGeometry& output );

			// Utility function
		void	HK_CALL scale(hkGeometry& geom,const hkVector4& s);


			// Utility function		
		hkgGeometry*	HK_CALL createGeometry(const hkGeometry& mesh, hkgDisplayContext* context, const hkVector4& color);

}

#endif // HK_DEMO2_GEOMETRY_LOADER_UTIL_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
