/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_CONTACT_PAINTER_H
#define HK_CONTACT_PAINTER_H

#include <Physics2012/Dynamics/Collide/ContactListener/hkpContactListener.h>
#include <Physics2012/Dynamics/Entity/hkpEntityListener.h>

/// This implementation of a hkpContactListener simply draws a red "star" at a 
/// collision point when it receives a "contactPointAdded" Callback, and 
/// draws white "normals" whenever the contact is processed by the solver.
/// This implementation manages its own memory (it automatically deletes itself,
/// if the entity gets deleted).
class ContactPainter : public hkpContactListener, public hkpEntityListener
{
	public:

		HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO, ContactPainter);

		//
		// Construction and Destruction
		//

			/// \param rigidBody the body whose contacts should be painted.
			/// \scale a scaling parameter for contact painting.
		ContactPainter( hkpRigidBody* rigidBody, hkReal scale = 1.0f );

		virtual ~ContactPainter();

		//
		// Members from base class hkpContactListener which must be implemented:
		//

			/// Called after a contact point was added 
		virtual void contactPointCallback( const hkpContactPointEvent& event );

		//
		// Members from base class hkpContactListener which must be implemented:
		//

			/// Called when the entity is deleted. Important to use this event to remove ourselves as a listener.
		virtual void entityDeletedCallback( hkpEntity* entity );

			/// Called when the entity is removed from the hkpWorld
		virtual void entityRemovedCallback( hkpEntity* entity );

	public:

		hkReal m_scale;

};

#endif

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
