/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_SIMPLE_DEMO_CHARACTER_BASE_H
#define HK_SIMPLE_DEMO_CHARACTER_BASE_H

#include <Demos/DemoCommon/Utilities/Character/DemoCharacter/DemoCharacter.h>
#include <Demos/DemoCommon/Utilities/Character/DemoCharacter/PhysicsDemoCharacter/CharacterImperfectionStyle.h>

struct SimpleDemoCharacterCinfo : public DemoCharacterCinfo
{
	hkVector4		m_gravity;
	hkReal			m_maxVelocity;
};

class SimpleDemoCharacter : public DemoCharacter
{
public:
	HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
	SimpleDemoCharacter( SimpleDemoCharacterCinfo& info );

	virtual void initUpdateSt( hkReal timestep, void* worldPtr, const struct CharacterStepInput& input, struct CharacterActionInfo* actionInfo = HK_NULL ) HK_OVERRIDE;
	virtual void updateMt( hkReal timestep, void* worldPtr, const struct CharacterStepInput& input, struct CharacterActionInfo* actionInfo = HK_NULL ) HK_OVERRIDE;
	virtual void finishUpdateSt( hkReal timestep, void* worldPtr, const struct CharacterStepInput& input, struct CharacterActionInfo* actionInfo = HK_NULL ) HK_OVERRIDE;

	virtual void display( hkReal timestep, hkDemoEnvironment* env ) HK_OVERRIDE;
	void cleanupGraphics( hkDemoEnvironment* env ) HK_OVERRIDE {}

	virtual hkReal getMaxVelocity() const HK_OVERRIDE;

	void setImperfectionStyle(CharacterImperfectionStyle const* style);
	CharacterImperfectionStyle const* getImperfectionStyle() const;

	virtual void getTransform( hkTransform& transform ) const HK_OVERRIDE;
	virtual void getPosition(hkVector4 & position) const HK_OVERRIDE;
	virtual void getLinearVelocity( hkVector4& velOut ) const HK_OVERRIDE;

protected:

	hkVector4			m_gravity;

	hkReal				m_maxVelocity;

	hkRefPtr<const CharacterImperfectionStyle> m_imperfectionStyle;

	hkQueue<CharacterStepInput> m_laggedInput;
	hkQueue<hkVector4> m_laggedSteeringVel;
	hkVector4 m_prevOrderedVel;
	hkVector4 m_prevLaggedVel;

	hkReal m_swayAngle;

	hkVector4 m_observedPosOffset;
	hkVector4 m_prevPosOffset;

	hkBool m_prevPosWSValid;
	hkVector4 m_prevObservedPosWS;
	hkVector4 m_prevActualPosWS;
	hkReal m_prevTimestep;
};

class SimpleCharacterFactory : public CharacterFactory
{
public:
	HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
	virtual DemoCharacter* createCharacterUsingProxy(	CharacterProxy* proxy,
		const hkVector4& gravity,
		hkDemoEnvironment* env,
		CharacterType characterType = MAX_CHARACTER_TYPE ) HK_OVERRIDE;

	virtual CharacterProxy* createProxy( const CharacterProxyCinfo& cinfo ) HK_OVERRIDE;
};


#endif // HK_SIMPLE_DEMO_CHARACTER_BASE_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
