/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */


#include <Demos/demos.h>
#include <Demos/DemoCommon/Utilities/Character/DemoCharacter/SimpleDemoCharacter/SimpleDemoCharacter.h>
#include <Demos/DemoCommon/Utilities/Character/CharacterProxy/SimpleCharacterProxy/SimpleCharacterProxy.h>
#include <Demos/DemoCommon/Utilities/Character/CharacterStepInput.h>
#include <Common/Visualize/hkDebugDisplay.h>



SimpleDemoCharacter::SimpleDemoCharacter( SimpleDemoCharacterCinfo& info )
: DemoCharacter(info)
{
	m_gravity = info.m_gravity;
	m_maxVelocity = info.m_maxVelocity;
	m_prevOrderedVel.setZero();
	m_prevLaggedVel.setZero();
	m_swayAngle = 0;
	m_observedPosOffset.setZero();
	m_prevPosOffset.setZero();
	m_prevPosWSValid = false;

	CharacterImperfectionStyle* style = new CharacterImperfectionStyle;
	//style->sway(10, 3, 0.2, 0);
	//style->lagInput(4);
	//style->lagVelocity(4);
	//style->reportVelocityFromOrdered();
	//style->averageLaggedInput();
	//style->overAccelerate(0.1);
	//style->underStrafe(1);
	//style->leakDvToDp(0.2);
	//style->putPosNoiseInWorld();
	//style->reportVelocityFromObservedPos();
	//style->underTurn(0.1);
	//style->quantizeVelocity(2);
	//setImperfectionStyle(style);
	style->removeReference();
}

void SimpleDemoCharacter::initUpdateSt( hkReal timestep, void* worldPtr, const struct CharacterStepInput& input, struct CharacterActionInfo* actionInfo)
{

}

void SimpleDemoCharacter::updateMt( hkReal timestep, void* worldPtr, const struct CharacterStepInput& input, struct CharacterActionInfo* actionInfo)
{

}

static hkReal round(hkReal x, hkReal precision)
{
	if(precision <= 0)
	{
		return x;
	}

	return hkMath::floor((x / precision) + hkReal(0.5)) * precision;
}

static hkVector4 round(hkVector4Parameter x, hkVector4Parameter precision)
{
	hkVector4 res;
	res.set(
		round(x.getComponent<0>(), precision.getComponent<0>()),
		round(x.getComponent<1>(), precision.getComponent<1>()),
		round(x.getComponent<2>(), precision.getComponent<2>()),
		round(x.getComponent<3>(), precision.getComponent<3>()));
	return res;
}

void SimpleDemoCharacter::finishUpdateSt( hkReal timestep, void* worldPtr, const CharacterStepInput& input, struct CharacterActionInfo* actionInfo )
{
	hkVector4 desiredVelocityWS;desiredVelocityWS.setZero4();

	//CharacterStepInput& newInput = (CharacterStepInput&) input;
	//newInput.m_forwardVelocity *= 0.9f;

	CharacterStepInput usedInput;
	if(m_imperfectionStyle)
	{
		m_laggedInput.enqueue(input);
		if(m_laggedInput.getSize() > m_imperfectionStyle->m_inputLag)
		{
			if(m_imperfectionStyle->m_averageLaggedInput)
			{
				hkReal oriX = 0, oriY = 0;
				for(int i=0; i<m_laggedInput.getSize(); i++)
				{
					usedInput.m_forwardVelocity += m_laggedInput.getElement(i).m_forwardVelocity;
					usedInput.m_strafeLeftRightVelocity += m_laggedInput.getElement(i).m_strafeLeftRightVelocity;
					oriX += hkMath::cos(m_laggedInput.getElement(i).m_orientation);
					oriY += hkMath::sin(m_laggedInput.getElement(i).m_orientation);
				}

				usedInput.m_forwardVelocity /= m_laggedInput.getSize();
				usedInput.m_strafeLeftRightVelocity /= m_laggedInput.getSize();
				usedInput.m_orientation = hkMath::atan2(oriY, oriX);

				CharacterStepInput temp;
				m_laggedInput.dequeue(temp);
			}
			else
			{
				m_laggedInput.dequeue(usedInput);
			}
		}
	}
	else
	{
		usedInput = input;
	}

	m_prevOrderedVel.set(
		input.m_forwardVelocity, 
		input.m_strafeLeftRightVelocity, 
		0, 
		1);

	hkVector4 groundSurfaceVelocity;
	bool supported = m_characterProxy->isSupported( timestep, groundSurfaceVelocity );

	hkVector4 characterLinearVelocity;
	m_characterProxy->getLinearVelocity( characterLinearVelocity );
	if ( usedInput.m_jumpVelocity )
	{
		if (!supported)
		{
			desiredVelocityWS = characterLinearVelocity;
		}
		else
		{
			// this is the common case: add the motion velocity to the downward part of the proxy velocity (not upward though)
			hkReal vertComponent = hkMath::min2( hkReal(0.0f), characterLinearVelocity.dot3( m_characterProxy->getUpLocal() ).getReal());
			desiredVelocityWS.addMul4(vertComponent, m_characterProxy->getUpLocal() );
		}
	}
	else
	{
		// when jumping, add the motion velocity to the vertical proxy velocity
		hkReal vertComponent = characterLinearVelocity.dot3(m_characterProxy->getUpLocal());
		desiredVelocityWS.addMul4(vertComponent, m_characterProxy->getUpLocal());
	}

	hkTransform wFc;
	m_characterProxy->getTransform( wFc );

	hkVector4 usedInputV; usedInputV.set(
		usedInput.m_forwardVelocity, 
		usedInput.m_strafeLeftRightVelocity, 
		usedInput.m_orientation, 
		1);


	hkVector4 deltaPos; deltaPos.setZero();

	m_prevLaggedVel = usedInputV;

	if(m_imperfectionStyle)
	{
		usedInputV = round(usedInputV, m_imperfectionStyle->m_velocityQuantum);

		m_imperfectionStyle->m_orderedVTransform.transformPosition(usedInputV, usedInputV);


		hkVector4 dv; dv.setSub(usedInputV, m_prevLaggedVel);
		m_imperfectionStyle->m_orderedDvTransform.transformPosition(dv, dv);
		hkVector4 dp; m_imperfectionStyle->m_dvToDp.transformPosition(dv, dp);
		deltaPos.add(dp);

		usedInputV.setAdd(m_prevLaggedVel, dv);

	}

	// Add the forward velocity
	hkRotation rot; rot.setAxisAngle(getProxy()->getUpWorld(), usedInputV.getComponent<2>());
	hkVector4 forwardDir;
	forwardDir.setRotatedDir(rot, m_characterProxy->getZeroOrientationWorld());
	hkVector4 leftDir;
	leftDir.setCross(getProxy()->getUpWorld(), forwardDir);

	hkVector4 orderedVel;
	orderedVel.setMul4( usedInputV.getComponent<0>(), forwardDir );
	orderedVel.addMul4( usedInputV.getComponent<1>(), leftDir );

	hkVector4 laggedVel;
	if(m_imperfectionStyle)
	{
		m_laggedSteeringVel.enqueue(orderedVel);
		if(m_laggedSteeringVel.getSize() > m_imperfectionStyle->m_velocityLag)
		{
			m_laggedSteeringVel.dequeue(laggedVel);
		}
		else
		{
			laggedVel.setZero();
		}
	}
	else
	{
		laggedVel = orderedVel;
	}



	if (supported)
	{
		desiredVelocityWS.add(laggedVel);

		// Add in Jump velocity
		desiredVelocityWS.addMul4( usedInput.m_jumpVelocity, m_characterProxy->getUpLocal() );

		// Add in surface velocity for supported characters, but don't double-apply upwards velocity.
		hkSimdReal surfaceVerticalSpeed = m_characterProxy->getUpLocal().dot<3>(groundSurfaceVelocity);
		hkSimdReal clampedSurfaceVerticalSpeed; clampedSurfaceVerticalSpeed.setMax(surfaceVerticalSpeed, 0);
		hkVector4 tangentialSurfaceVelocity;
		tangentialSurfaceVelocity.setSubMul(
			groundSurfaceVelocity, 
			m_characterProxy->getUpLocal(), 
			clampedSurfaceVerticalSpeed);
		desiredVelocityWS.add4(tangentialSurfaceVelocity);
	}
	else
	{
		if(!usedInput.m_jumpVelocity) // if this is nonzero, horizontal was added earlier
		{
			hkVector4 horizontalVelocity;
			horizontalVelocity.setSubMul(characterLinearVelocity, m_characterProxy->getUpWorld(), characterLinearVelocity.dot<3>(m_characterProxy->getUpWorld()));
			desiredVelocityWS.add(horizontalVelocity);
		}



	}

	// Add some gravity
	desiredVelocityWS.addMul4( timestep, m_gravity );

	m_characterProxy->setLinearVelocity( desiredVelocityWS, timestep );

	m_characterProxy->setOrientation( usedInputV.getComponent<2>() );

	if(m_imperfectionStyle)
	{
		hkVector4 laggedVelWithSpeed = usedInputV;
		laggedVelWithSpeed.setComponent<2>(usedInputV.length<2>());
		hkReal swayFreq = m_imperfectionStyle->m_swayFreq.dot4xyz1(laggedVelWithSpeed);
		if(swayFreq > 1e-2)
		{
			m_swayAngle += timestep * swayFreq * (HK_REAL_PI * 2);
			hkReal swayPosMag = m_imperfectionStyle->m_posSwayMagnitude.dot4xyz1(laggedVelWithSpeed);
			//hkReal swayAngMag = m_imperfectionStyle->m_posSwayMagnitude.dot4xyz1(laggedVelWithSpeed);

			hkReal cosA = hkMath::cos(m_swayAngle);
			hkReal sinA = hkMath::sin(m_swayAngle);

			hkVector4 posSway;
			posSway.set(swayPosMag * cosA, swayPosMag * sinA, 0, 0);
			deltaPos.add(posSway);

			
		}
		else
		{
			m_swayAngle = 0;
		}

		hkVector4 deltaPosWS;
		deltaPosWS.setMul(deltaPos.getComponent<0>(), forwardDir);
		deltaPosWS.addMul(deltaPos.getComponent<1>(), leftDir);

		if(m_imperfectionStyle->m_posNoiseInWorld)
		{
			m_characterProxy->getTransform( wFc );
			wFc.getTranslation().sub(m_prevPosOffset);
			wFc.getTranslation().add(deltaPosWS);
			m_characterProxy->setTransform(wFc);
		}
		else
		{
			m_observedPosOffset = deltaPosWS;
		}

		m_prevPosOffset = deltaPosWS;
	}

	getPosition(m_prevObservedPosWS);
	m_prevActualPosWS = getProxy()->getPosition();
	m_prevTimestep = timestep;
	m_prevPosWSValid = true;
}

void SimpleDemoCharacter::display( hkReal timestep, hkDemoEnvironment* env )
{
	hkTransform t;
	m_characterProxy->getTransform(t);
	hkVector4 to;
	to.setRotatedDir( t.getRotation(), m_characterProxy->getForwardLocal());
	hkVector4 pos = t.getTranslation();
	pos.addMul( .05f, m_characterProxy->getUpWorld() );
	HK_DISPLAY_ARROW( pos, to, hkColor::WHITE );
	// Nothing for simple proxy

}

// get maximum velocity
hkReal SimpleDemoCharacter::getMaxVelocity() const
{
	return m_maxVelocity;
}

void SimpleDemoCharacter::setImperfectionStyle( CharacterImperfectionStyle const* style )
{
	m_imperfectionStyle = style;
}

CharacterImperfectionStyle const* SimpleDemoCharacter::getImperfectionStyle() const
{
	return m_imperfectionStyle;
}

void SimpleDemoCharacter::getTransform( hkTransform& transform ) const
{
	getProxy()->getTransform(transform);
	if(m_imperfectionStyle && ! m_imperfectionStyle->m_posNoiseInWorld)
	{
		transform.getTranslation().add(m_observedPosOffset);
	}
}

void SimpleDemoCharacter::getPosition( hkVector4 & position ) const
{
	position = getProxy()->getPosition();
	if(m_imperfectionStyle && ! m_imperfectionStyle->m_posNoiseInWorld)
	{
		position.add(m_observedPosOffset);
	}
}

void SimpleDemoCharacter::getLinearVelocity( hkVector4& velOut ) const
{
	int velocitySource = m_imperfectionStyle ? m_imperfectionStyle->m_velocitySource : CharacterImperfectionStyle::VELSOURCE_PROXY;

	switch(velocitySource)
	{
	case CharacterImperfectionStyle::VELSOURCE_PROXY:
		getProxy()->getLinearVelocity(velOut);
		break;

	case CharacterImperfectionStyle::VELSOURCE_CUR_ORDERED:
	case CharacterImperfectionStyle::VELSOURCE_LAGGED_ORDERED:
		{
			hkVector4 orderedVel;
			if(velocitySource == CharacterImperfectionStyle::VELSOURCE_CUR_ORDERED)
			{
				orderedVel = m_prevOrderedVel;
			}
			else
			{
				orderedVel = m_prevLaggedVel;
			}

			hkTransform wFc;
			m_characterProxy->getTransform( wFc );

			hkVector4 forwardDir;
			forwardDir.setRotatedDir( wFc.getRotation(), m_characterProxy->getForwardLocal() );
			hkVector4 up;
			up.setRotatedDir(wFc.getRotation(), m_characterProxy->getUpLocal());
			hkVector4 leftDir;
			leftDir.setCross(up, forwardDir);

			velOut.setMul(forwardDir, orderedVel.getComponent<0>());
			velOut.addMul(leftDir, orderedVel.getComponent<1>());
		}
		break;

	case CharacterImperfectionStyle::VELSOURCE_ACTUAL_POS:
		{
			if(!m_prevPosWSValid)
			{
				velOut.setZero();
				break;
			}

			hkVector4 offset;
			offset.setSub(getProxy()->getPosition(), m_prevActualPosWS);
			velOut.setMul(offset, 1/m_prevTimestep);
		}
		break;

	case CharacterImperfectionStyle::VELSOURCE_OBSERVED_POS:
		{
			if(!m_prevPosWSValid)
			{
				velOut.setZero();
				break;
			}

			hkVector4 offset;
			getPosition(offset);
			offset.sub(m_prevObservedPosWS);
			velOut.setMul(offset, 1/m_prevTimestep);
		}
		break;
	}
}


DemoCharacter* SimpleCharacterFactory::createCharacterUsingProxy(	CharacterProxy* proxy,
																  const hkVector4& gravity,
																  hkDemoEnvironment* env,
																  CharacterType characterType )
{
	// Simple Character only
	SimpleDemoCharacterCinfo sinfo;
	sinfo.m_characterProxy = proxy;	
	sinfo.m_maxVelocity = 6.f;
	sinfo.m_gravity.setZero();

	return new SimpleDemoCharacter( sinfo );
}

CharacterProxy* SimpleCharacterFactory::createProxy( const CharacterProxyCinfo& cinfo )
{
	SimpleCharacterProxy* proxy = new SimpleCharacterProxy( cinfo );
	return proxy;
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
