/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_CHARACTER_IMPERFECTION_STYLE_H
#define HK_CHARACTER_IMPERFECTION_STYLE_H

struct CharacterImperfectionStyle : public hkReferencedObject
{
	HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);

	CharacterImperfectionStyle() { makePerfect(); }

	void makePerfect();

	void speedUp(hkReal factor = 0.1);
	void slowDown(hkReal factor = 0.1);

	void overAccelerate(hkReal factor = 0.1);
	void underAccelerate(hkReal factor = 0.1);

	void leakDvToDp(hkReal tau = 0.1);

	void overStrafe(hkReal factor = 0.1);
	void underStrafe(hkReal factor = 0.1);

	void overTurn(hkReal factor = 1.1);
	void underTurn(hkReal factor = 0.1);

	void lagInput(hkInt32 frames);
	void lagVelocity(hkInt32 frames);

	void averageLaggedInput();

	void sway(hkReal maxVel, hkReal freqAtMaxVel, hkReal posMagnitudeAtMaxVel, hkReal angMagnitudeAtMaxVel);

	void posWhiteNoise(hkReal maxVel, hkReal varianceAtZeroVel, hkReal varianceAtMaxVel);

	void putPosNoiseInWorld();

	void reportVelocityFromOrdered();
	void reportVelocityFromLagged();
	void reportVelocityFromObservedPos();
	void reportVelocityFromActualPos();

	void quantizeVelocity(hkReal quantum = 1.0);



	// Semantics of the elements of vectors/matrices used below
	enum
	{
		FWD = 0,
		SIDE = 1,
		ANG = 2,
		SPEED = 2,
		AFF = 3
	};

	/// Affine transformation applied to ordered velocity to produce actual velocity
	hkMatrix4 m_orderedVTransform;

	/// Affine transformation applied to ordered delta-velocity to produce actual delta-velocity
	hkMatrix4 m_orderedDvTransform;

	/// leak from actual delta-velocity to delta-position
	hkMatrix4 m_dvToDp;

	/// Multiplied by [forwardvel^2,sidevel^2,0,1] to produce variance of pos gaussian noise
	hkVector4 m_posVariance;

	/// Multiplied by [forwardvel,sidevel,speed,1] to produce frequency of pos/ang sway noise
	hkVector4 m_swayFreq;

	/// Multiplied by [forwardvel,sidevel,speed,1] to produce magnitude of pos sway noise
	hkVector4 m_posSwayMagnitude;

	/// Multiplied by [forwardvel,sidevel,speed,1] to produce magnitude of ang sway noise
	hkVector4 m_angSwayMagnitude;

	/// True if positional noise should be integrated into the physics world; false to make it observed by AI only
	hkBool m_posNoiseInWorld;

	enum VelocitySource
	{
		VELSOURCE_PROXY,
		VELSOURCE_CUR_ORDERED,
		VELSOURCE_LAGGED_ORDERED,
		VELSOURCE_OBSERVED_POS,
		VELSOURCE_ACTUAL_POS
	};

	/// How velocity as fed back to AI is determined
	VelocitySource m_velocitySource;

	/// Number of frames to delay ordered input
	hkInt32 m_inputLag;

	/// Number of frames to delay outputted velocity
	hkInt32 m_velocityLag;

	hkBool m_averageLaggedInput;

	hkVector4 m_velocityQuantum;
};


#endif

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
