/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#include <Demos/demos.h>
#include <Demos/DemoCommon/Utilities/Character/DemoCharacter/PhysicsDemoCharacter/CharacterImperfectionStyle.h>

void CharacterImperfectionStyle::makePerfect()
{
	m_orderedVTransform.setIdentity();
	m_orderedDvTransform.setIdentity();
	m_dvToDp.setZero();
	m_posVariance.setZero();
	m_swayFreq.setZero();
	m_posSwayMagnitude.setZero();
	m_angSwayMagnitude.setZero();
	m_posNoiseInWorld = false;
	m_velocitySource = VELSOURCE_PROXY;
	m_inputLag = 0;
	m_velocityLag = 0;
	m_averageLaggedInput = false;
	m_velocityQuantum.setZero();
}

void CharacterImperfectionStyle::speedUp( hkReal factor /*= 0.1*/ )
{
	hkSimdReal scale = factor + 1;
	m_orderedVTransform.setElement<FWD, FWD>(scale);
	m_orderedVTransform.setElement<SIDE, SIDE>(scale);
}

void CharacterImperfectionStyle::slowDown( hkReal factor /*= 0.1*/ )
{
	hkSimdReal scale = 1 - factor;
	m_orderedVTransform.setElement<FWD, FWD>(scale);
	m_orderedVTransform.setElement<SIDE, SIDE>(scale);
}

void CharacterImperfectionStyle::overAccelerate( hkReal factor /*= 0.1*/ )
{
	hkSimdReal scale = factor + 1;
	m_orderedDvTransform.setElement<FWD, FWD>(scale);
	m_orderedDvTransform.setElement<SIDE, SIDE>(scale);
}

void CharacterImperfectionStyle::underAccelerate( hkReal factor /*= 0.1*/ )
{
	hkSimdReal scale = 1 - factor;
	m_orderedDvTransform.setElement<FWD, FWD>(scale);
	m_orderedDvTransform.setElement<SIDE, SIDE>(scale);
}

void CharacterImperfectionStyle::leakDvToDp( hkReal tau /*= 0.1*/ )
{
	hkSimdReal scale = tau;
	m_dvToDp.setElement<FWD, FWD>(scale);
	m_dvToDp.setElement<SIDE, SIDE>(scale);
}

void CharacterImperfectionStyle::overStrafe( hkReal factor /*= 0.1*/ )
{
	hkSimdReal scale = factor + 1;
	m_orderedVTransform.setElement<SIDE, SIDE>(scale);
}

void CharacterImperfectionStyle::underStrafe( hkReal factor /*= 0.1*/ )
{
	hkSimdReal scale = 1 - factor;
	m_orderedVTransform.setElement<SIDE, SIDE>(scale);
}

void CharacterImperfectionStyle::overTurn( hkReal factor /*= 1.1*/ )
{
	hkSimdReal scale = factor + 1;
	m_orderedVTransform.setElement<ANG, ANG>(scale);
}

void CharacterImperfectionStyle::underTurn( hkReal factor /*= 0.1*/ )
{
	hkSimdReal scale = 1 - factor;
	m_orderedVTransform.setElement<ANG, ANG>(scale);
}

void CharacterImperfectionStyle::lagInput( hkInt32 frames )
{
	m_inputLag = frames;
}

void CharacterImperfectionStyle::lagVelocity( hkInt32 frames )
{
	m_velocityLag = frames;
}

void CharacterImperfectionStyle::averageLaggedInput()
{
	m_averageLaggedInput = true;
}

void CharacterImperfectionStyle::sway(hkReal maxVel, hkReal freqAtMaxVel, hkReal posMagnitudeAtMaxVel, hkReal angMagnitudeAtMaxVel)
{
	m_swayFreq.setComponent<SPEED>(freqAtMaxVel/maxVel);
	m_posSwayMagnitude.setComponent<SPEED>(posMagnitudeAtMaxVel/maxVel);
	m_angSwayMagnitude.setComponent<SPEED>(angMagnitudeAtMaxVel/maxVel);
}

void CharacterImperfectionStyle::posWhiteNoise(hkReal maxVel, hkReal varianceAtZeroVel, hkReal varianceAtMaxVel )
{
	hkReal scale = (varianceAtMaxVel - varianceAtZeroVel) / maxVel;
	m_posVariance.set(scale, scale, 0, varianceAtZeroVel);
}

void CharacterImperfectionStyle::putPosNoiseInWorld()
{
	m_posNoiseInWorld = true;
}

void CharacterImperfectionStyle::reportVelocityFromOrdered()
{
	m_velocitySource = VELSOURCE_CUR_ORDERED;
}

void CharacterImperfectionStyle::reportVelocityFromLagged()
{
	m_velocitySource = VELSOURCE_LAGGED_ORDERED;
}

void CharacterImperfectionStyle::reportVelocityFromObservedPos()
{
	m_velocitySource = VELSOURCE_OBSERVED_POS;
}

void CharacterImperfectionStyle::reportVelocityFromActualPos()
{
	m_velocitySource = VELSOURCE_ACTUAL_POS;
}

void CharacterImperfectionStyle::quantizeVelocity( hkReal quantum /*= 1.0*/ )
{
	m_velocityQuantum.setComponent<0>(quantum);
	m_velocityQuantum.setComponent<1>(quantum);
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
