/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */


#include <Demos/demos.h>

#include <Demos/DemoCommon/Utilities/Character/DemoCharacter/DemoCharacter.h>
#include <Demos/DemoCommon/Utilities/Character/CharacterProxy/CharacterProxy.h>
#include <Common/Base/Memory/System/Debug/hkDebugMemorySystem.h>

DemoCharacter::DemoCharacter( DemoCharacterCinfo& info ) 
	: m_characterProxy( info.m_characterProxy ) 
{ 
	m_characterProxy->addReference(); 
}

DemoCharacter::~DemoCharacter( )
{ 
	m_characterProxy->removeReference(); 
}

bool DemoCharacter::isCrouching() const
{
	State state;
	getState( state );
	return state.m_isCrouching;
}

bool DemoCharacter::isDying() const
{
	State state;
	getState( state );
	return state.m_isDying;
}

// access to the proxy
CharacterProxy* DemoCharacter::getProxy() const 
{ 
	return m_characterProxy; 
}

void DemoCharacter::getTransform( hkTransform& transform ) const
{
	getProxy()->getTransform(transform);
}

void DemoCharacter::getPosition( hkVector4 & position ) const
{
	position = getProxy()->getPosition();
}

void DemoCharacter::getLinearVelocity( hkVector4& velOut ) const
{
	getProxy()->getLinearVelocity(velOut);
}

void DemoCharacter::update( hkReal timestep, void* worldPtr, const struct CharacterStepInput& input, struct CharacterActionInfo* actionInfo /*= HK_NULL */ )
{
	initUpdateSt(timestep, worldPtr, input, actionInfo);
	updateMt(timestep, worldPtr, input, actionInfo);
	finishUpdateSt(timestep, worldPtr, input, actionInfo);
}

DemoCharacter* CharacterFactory::createCharacter(	const hkVector4& position,
													const hkQuaternion& rotation,
													const hkVector4& gravity,
													int filterInfo,
													hkDemoEnvironment* env,
													CharacterType characterType )
{
	CharacterProxyCinfo cinfo;
	cinfo.m_characterHeight = 2.0f;
	cinfo.m_characterRadius = 0.4f;
	cinfo.m_forwardLocal.set(1,0,0);
	cinfo.m_upLocal.setNeg4(gravity);
	cinfo.m_upLocal.normalize3();
	cinfo.m_upWorld = cinfo.m_upLocal;
	cinfo.m_zeroOrientationWorld.set(1,0,0);
	cinfo.m_collisionFilterInfo = filterInfo;
	cinfo.m_position = position;
	cinfo.m_rotation = rotation;

	CharacterProxy* proxy = createProxy( cinfo );
	DemoCharacter* character = createCharacterUsingProxy( proxy, gravity, env, characterType );
	proxy->removeReference();

	return character;
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
