/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#include <Demos/demos.h>
#include <Graphics/Common/Window/hkgWindow.h>

#include <Demos/DemoCommon/Utilities/Character/CharacterUtils.h>
#include <Demos/DemoCommon/Utilities/Character/CharacterStepInput.h>
#include <Common/Visualize/hkDebugDisplay.h>
#include <Physics2012/Collide/Query/CastUtil/hkpWorldRayCastInput.h>
#include <Physics2012/Collide/Query/Collector/RayCollector/hkpAllRayHitCollector.h>
#include <Physics2012/Collide/Shape/Convex/Capsule/hkpCapsuleShape.h>
#include <Physics2012/Utilities/CharacterControl/CharacterRigidBody/hkpCharacterRigidBody.h>
#include <Physics2012/Utilities/CharacterControl/StateMachine/hkpDefaultCharacterStates.h>
#include <Physics2012/Utilities/Weapons/hkpFirstPersonGun.h>
#include <Physics2012/Utilities/CharacterControl/FirstPersonCharacter/hkpFirstPersonCharacter.h>

	#include <Common/Base/Fwd/hkwindows.h>

void HK_CALL CharacterUtils::displayCharacterState(hkpCharacterContext* context, hkDemoEnvironment* env )
{

	// Rigid body controller state
	hkpCharacterStateType stateRBC = context->getState();
	const char * stateStrRBC;

	switch (stateRBC)
	{
	case HK_CHARACTER_ON_GROUND:
		stateStrRBC = "On Ground";	break;
	case HK_CHARACTER_JUMPING:
		stateStrRBC = "Jumping"; break;
	case HK_CHARACTER_IN_AIR:
		stateStrRBC = "In Air"; break;
	case HK_CHARACTER_CLIMBING:
		stateStrRBC = "Climbing"; break;
	default:
		stateStrRBC = "Other";	break;
	}

	char buffer[255];
	hkString::snprintf(buffer, 255, "State: %s", stateStrRBC);
	env->m_textDisplay->outputText(buffer, 20, 450, 0xffffffff);
}

// Objects colors
#define NORMAL_GRAY				hkColor::rgbFromChars( 192, 192, 192, 255 )
#define TRANSPARENT_GREY		hkColor::rgbFromChars( 192, 192, 192, 125 )

void HK_CALL CharacterUtils::updateCamera( const hkpFirstPersonCharacter* character, hkgWindow* window )
{
	const hkReal height = character->m_eyeHeight; 

	hkVector4 from;
	from = character->m_characterRb->getPosition();
	from.addMul4(height, character->m_characterRb->m_up );

	hkVector4 forward;
	character->getForwardDir( forward );

	hkVector4 to;
	to.setAddMul4( from, forward, 4 );

/*
	hkVector4 to;
	to = character->m_characterRb->getPosition();
	to.addMul4(height, character->m_characterRb->m_up );


	hkVector4 dir;
	dir.setMul4( height, character->m_characterRb->m_up );
	dir.addMul4( -4.f, forward);

	hkVector4 from;
	from.setAdd4(to, dir);
*/
/*	// Make object in the line of sight transparent
	if(m_makeOccludingObjectsTransparent)
	{
		// Cast down to landscape to get an accurate position
		hkpWorldRayCastInput raycastIn;

		// Reverse direction for raycasting
		raycastIn.m_from = to;
		raycastIn.m_to = from;
		raycastIn.m_filterInfo = hkpGroupFilter::calcFilterInfo(0);

		hkpAllRayHitCollector collector;

		world->castRay( raycastIn, collector);

		for (int i = 0; i < m_transparentObjects.getSize(); ++i )
		{
			HK_SET_OBJECT_COLOR(m_transparentObjects[i], NORMAL_GRAY );
		}
		m_transparentObjects.clear();

		// Loop over all collected objects
		for(int i=0; i < collector.getHits().getSize();i++)
		{				
			hkpWorldRayCastOutput raycastOut = collector.getHits()[i];
			hkpRigidBody* rb = hkpGetRigidBody(raycastOut.m_rootCollidable);
			if (rb && rb->isFixedOrKeyframed())
			{
				HK_SET_OBJECT_COLOR((hkUlong)raycastOut.m_rootCollidable, TRANSPARENT_GREY );

				m_transparentObjects.pushBack((hkUlong)raycastOut.m_rootCollidable);
			}
		}
	}
*/
	window->getContext()->lock();
	for(int i = 0; i < window->getNumViewports(); ++i)
	{
		hkgViewport* viewPort = window->getViewport(i);
		hkgCamera* c = viewPort->getCamera();

		float upN[3];
		character->m_characterRb->m_up.store<3,HK_IO_NATIVE_ALIGNED>(&upN[0]);
		hkgVec3Normalize(upN);
		// set up camera
		c->setFrom(&from(0));
		c->setTo(&to(0));
		c->setUp(upN);
		c->orthogonalize();
		c->computeModelView();
		c->computeProjection();
		//c->setHandednessMode(HKG_CAMERA_HANDEDNESS_MODE( rightHanded ? HKG_CAMERA_HANDEDNESS_RIGHT : HKG_CAMERA_HANDEDNESS_LEFT) );
		viewPort->setWorldUp( upN );
	}
	window->getContext()->unlock();
}


static void HK_CALL setInputFromUserControls( hkpFirstPersonCharacter* character, hkDemoEnvironment* env, hkpFirstPersonCharacter::CharacterControls& controls )
{
	// Get user input data
	hkReal deltaAngle;
	hkReal deltaElevation;

	CharacterUserInput::Sensivity sensivity;
	{
		sensivity.m_mouseX = character->m_horizontalSensitivity;
		sensivity.m_mouseY = character->m_verticalSensitivity;
		sensivity.m_padX = character->m_sensivityPadX;
		sensivity.m_padY = character->m_sensivityPadY;
	}

	CharacterUserInput::getUserInputForCharacter(env, sensivity, deltaAngle, deltaElevation, controls.m_straffeLeftRight, controls.m_forwardBack, controls.m_disableDPad );

	controls.m_straffeLeftRight *= character->m_leftRightSpeedModifier;
	controls.m_forwardBack      *= character->m_forwardBackwardSpeedModifier;

	if (! (character->m_flags & hkpFirstPersonCharacter::INVERT_UP_DOWN)) 
	{
		deltaElevation = -deltaElevation;
	}

	character->m_currentAngle += deltaAngle;
	character->m_currentElevation += deltaElevation;
	
	if (character->m_currentElevation < -character->m_maxUpDownAngle) character->m_currentElevation = -character->m_maxUpDownAngle;
	if (character->m_currentElevation > character->m_maxUpDownAngle)  character->m_currentElevation = character->m_maxUpDownAngle;

	hkQuaternion currentOrient; currentOrient.setAxisAngle(character->m_characterRb->m_up, character->m_currentAngle);
 
	controls.m_wantJump = env->m_window->getKeyboard().wasKeyPressed( HKG_VKEY_SPACE ) || ((env->m_gamePad->getButtonState() & HKG_PAD_BUTTON_1) != 0);

	controls.m_forward.set(1,0,0);
	controls.m_forward.setRotatedDir( currentOrient, controls.m_forward );

	controls.m_fire = false;
	if ( (env->m_window->getMouse().getButtonState() & HKG_MOUSE_LEFT_BUTTON) ||
		 (env->m_gamePad->getButtonState() & HKG_PAD_BUTTON_R1) )
	{
		if ( character->m_gunCounter-- < 0 )
		{
			character->m_gunCounter = 10;
			controls.m_fire = true;
		}
	}
	else
	{
		character->m_gunCounter = 0;
	}

	controls.m_fireRmb = false;
	if ( (env->m_window->getMouse().getButtonState() & HKG_MOUSE_RIGHT_BUTTON) ||
		 (env->m_gamePad->getButtonState() & HKG_PAD_BUTTON_R2) )
	{
		if ( character->m_gunCounterRmb-- < 0 )
		{
			character->m_gunCounterRmb = 20;
			controls.m_fireRmb = true;
		}
	}
	else
	{
		character->m_gunCounterRmb = 0;
	}
}

void HK_CALL CharacterUtils::stepCharacter( hkReal timestep, hkpFirstPersonCharacter* character, hkDemoEnvironment* env )
{
	if ( character->m_flags & hkpFirstPersonCharacter::HAS_USER_CONTROL )
	{
		character->m_world->lock();
		hkpFirstPersonCharacter::CharacterControls controls;
		if ( character->m_flags & hkpFirstPersonCharacter::DISABLE_DPAD )
		{
			controls.m_disableDPad = true;
		}

		setInputFromUserControls( character, env, controls );

		if ( character->m_flags & hkpFirstPersonCharacter::DISABLE_JUMP )
		{
			controls.m_wantJump = false;
		}

		if ( controls.m_fire && character->m_currentGun )
		{
			hkTransform viewTransform;
			character->getViewTransform( viewTransform );
			character->m_currentGun->fireGun( character->m_world, viewTransform );
		}

		character->update( timestep, controls, false );
		updateCamera( character, env->m_window );

		if (character->m_currentGun)
		{
			hkpRigidBody* body = character->m_characterRb->m_character;
			hkTransform viewTransform; character->getViewTransform(viewTransform);
			character->m_currentGun->stepGun( timestep, character->m_world, body, viewTransform, controls.m_fire, controls.m_fireRmb );
		}
		character->m_world->unlock();
	}


	const hkgKeyboard& keyBoard = env->m_window->getKeyboard();
	if (keyBoard.wasKeyPressed('P') || keyBoard.wasKeyPressed('O') )
	{
		if (character->m_flags & hkpFirstPersonCharacter::HAS_USER_CONTROL)
		{
			character->m_flags = character->m_flags & (~hkpFirstPersonCharacter::HAS_USER_CONTROL);
		}
		else
		{
			character->m_flags = character->m_flags | hkpFirstPersonCharacter::HAS_USER_CONTROL;
		}
		if (character->m_flags & hkpFirstPersonCharacter::HAS_USER_CONTROL)
		{
			// Snap mouse back to middle
			env->m_window->setMousePosition(env->m_window->getWidth() >> 1, env->m_window->getHeight() >> 1);
			env->m_mousePickingEnabled = false;

			// position rigid body at camera position
			hkgViewport* viewPort = env->m_window->getViewport(0);
			hkgCamera* c = viewPort->getCamera();

			hkVector4 position;		c->getFrom( position );
			hkVector4 to; 			c->getTo( to );
			hkVector4 dir; dir.setSub4( to, position );
			dir.normalize3();

			{
				position.subMul4( character->m_eyeHeight, character->m_characterRb->m_up);
				hkpRigidBody* body = character->getRigidBody();
				body->setPosition( position );
				body->setLinearVelocity( hkVector4::getZero() );
			}
			character->setForwardDir( dir );
			if ( keyBoard.wasKeyPressed('O') )
			{
				character->m_gravity.setZero4();
				character->m_specialGravity = true;
			}
			else
			{
				character->m_specialGravity = false;
			}
		}
		else
		{
			env->m_mousePickingEnabled = true;
		}
	}
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
