/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#include <Demos/demos.h>
#include <Graphics/Common/Window/hkgWindow.h>

#include <Demos/DemoCommon/Utilities/Character/CharacterStepInput.h>
#include <Common/Base/DebugUtil/DeterminismUtil/hkCheckDeterminismUtil.h>

	#include <Common/Base/Fwd/hkwindows.h>


static void HK_CALL _deadzone(hkReal& stickX, hkReal& stickY)
{
	hkReal INPUT_DEADZONE = 0.15f; // PS2 style .. large

	const hkReal deadzoneScale = 1.0f/(1.0f-INPUT_DEADZONE);
	stickX = ( stickX < -INPUT_DEADZONE) ? (stickX + INPUT_DEADZONE) * deadzoneScale : (
		( stickX > INPUT_DEADZONE ) ? (stickX - INPUT_DEADZONE) * deadzoneScale : 0);
	stickY = ( stickY < -INPUT_DEADZONE) ? (stickY + INPUT_DEADZONE) * deadzoneScale : (
		( stickY > INPUT_DEADZONE ) ? (stickY - INPUT_DEADZONE) * deadzoneScale : 0);
}

void HK_CALL CharacterUserInput::getUserInputForCharacter( hkDemoEnvironment* env, hkReal& deltaAngle, hkReal& posX, hkReal& posY, bool disableDPAD, bool lockMouse, bool disableWASD )
{
	// Mouse
	deltaAngle = 0.f;
	posX = 0.f;
	posY = 0.f;

	// We don't want to use user-input if we are checking determinism
#if !defined(HK_ENABLE_DETERMINISM_CHECKS)

#if defined(HK_PLATFORM_WIN32) && !defined(HK_PLATFORM_WINRT) && !defined(HK_PLATFORM_DURANGO)
	// Only run this function if the window is in focus, because it grabs the mouse
	if ( GetForegroundWindow() != env->m_window->getPlatformHandle() )
		return;
#endif

	const hkgPad& pad = *(env->m_gamePad);

	bool haveProperGamePad = env->m_window->hasGamePads() && !(env->m_options->m_forceKeyboardGamepad);

	// No gamepad (win32 and PlayStation(R)3 default at the mo)
	if (!haveProperGamePad)
	{
		const hkReal MOUSE_SENSITIVITY = 1.0f;
		int mouseX = env->m_window->getMouse().getPosX();
		int halfWindowWidth = env->m_window->getCurrentViewport()->getWidth() >> 1;

		{
			hkReal inc  = hkReal(halfWindowWidth - mouseX) / halfWindowWidth;
			inc = (inc < -1.0f) ? -1.0f : inc;
			inc = (inc >  1.0f) ?  1.0f : inc;
			deltaAngle = 3.4f * inc * MOUSE_SENSITIVITY;
		}


		// Snap mouse back to middle
		if(lockMouse)
		{
			int halfWindowHeight = env->m_window->getCurrentViewport()->getHeight() >> 1;
			env->m_window->setMousePosition(halfWindowWidth, halfWindowHeight);
		}


		if (!disableWASD)
		{
			const hkgKeyboard& keyboard = env->m_window->getKeyboard();
			if (keyboard.getKeyState('A')) posX=1.f;
			if (keyboard.getKeyState('D')) posX=-1.f;
			if (keyboard.getKeyState('W')) posY=-1.f;
			if (keyboard.getKeyState('S')) posY=1.f;
		}
	}
	else if (pad.isConnected())
	{
		if ( (pad.getButtonState() & HKG_PAD_BUTTON_L1) == 0)
		{
			const hkReal PAD_SENSITIVITY = 0.05f;
			hkReal stickX = pad.getStickPosX(1);
			hkReal stickY = pad.getStickPosY(1);
			_deadzone(stickX, stickY);
			deltaAngle = 3.4f * -stickX * PAD_SENSITIVITY;
			posY = -stickY;
		}

		{
			hkReal stickZ = pad.getStickPosX(0);
			hkReal stickZZ = 0;
			_deadzone(stickZ, stickZZ);
			posX = -stickZ; // strafe on stick0
		}
	}

	// dpad == dir keys on PC
	if (!disableDPAD)
	{
		if ((pad.getButtonState() & HKG_PAD_DPAD_UP) != 0)   posY=-1.f;
		if ((pad.getButtonState() & HKG_PAD_DPAD_LEFT) != 0) posX=1.f;
		if ((pad.getButtonState() & HKG_PAD_DPAD_RIGHT) != 0)posX=-1.f;
		if ((pad.getButtonState() & HKG_PAD_DPAD_DOWN) != 0) posY=1.f;
	}

	// Normalize the movement vector
	hkReal lenSqd = posY * posY + posX * posX;
	if (lenSqd > HK_REAL_MIN)
	{
		lenSqd = hkMath::sqrt(lenSqd);
		posY /= lenSqd;
		posX /= lenSqd;
	}

#endif
}

void HK_CALL CharacterUserInput::getUserInputForCharacter( hkDemoEnvironment* env, const Sensivity& sensivity, hkReal& deltaAngle, hkReal& deltaElevation, hkReal& posX, hkReal& posY, bool disableDPAD, bool lockMouse, bool disableWASD )
{
	// Mouse
	deltaAngle = 0.f;
	deltaElevation = 0.f;
	posX = 0.f;
	posY = 0.f;

	// We don't want to use user-input if we are checking determinism
#if !defined(HK_ENABLE_DETERMINISM_CHECKS)

#if defined(HK_PLATFORM_WIN32) && !defined(HK_PLATFORM_WINRT) && !defined(HK_PLATFORM_DURANGO)

	// Only run this function if the window is in focus, because it grabs the mouse
	if ( GetForegroundWindow() != env->m_window->getPlatformHandle() )
	{
		return;
	}
#endif

	const hkgPad& pad = *(env->m_gamePad);

	if (pad.isConnected())
	{
		if ( (pad.getButtonState() & HKG_PAD_BUTTON_L1) == 0)
		{
			hkReal stickX = pad.getStickPosX(1);
			hkReal stickY = pad.getStickPosY(1);
			_deadzone(stickX, stickY);
			posX = -stickX; // strafe on stick1
			posY = -stickY;
		}

		{
			const hkReal PAD_SENSITIVITY = 0.02f;
			hkReal stickX = pad.getStickPosX(0);
			hkReal stickY = pad.getStickPosY(0);
			_deadzone(stickX, stickY);
			deltaAngle		= 3.4f * -stickX * PAD_SENSITIVITY * sensivity.m_padX;
			deltaElevation	= 3.4f * -stickY * PAD_SENSITIVITY * sensivity.m_padY;
		}

		// dpad == dir keys on PC
		if (!disableDPAD)
		{
			if ((pad.getButtonState() & HKG_PAD_DPAD_UP) != 0)   posY=-1.f;
			if ((pad.getButtonState() & HKG_PAD_DPAD_LEFT) != 0) posX=1.f;
			if ((pad.getButtonState() & HKG_PAD_DPAD_RIGHT) != 0)posX=-1.f;
			if ((pad.getButtonState() & HKG_PAD_DPAD_DOWN) != 0) posY=1.f;
		}
	}

	// No gamepad (win32 and PlayStation(R)3 default at the mo)
	if( env->m_window->getMouse().isConnected() )
	{
		int mouseX = env->m_window->getMouse().getPosX();
		int halfWindowWidth = env->m_window->getCurrentViewport()->getWidth() >> 1;

		{
			hkReal inc  = hkReal(halfWindowWidth - mouseX) / halfWindowWidth;
			inc = (inc < -1.0f) ? -1.0f : inc;
			inc = (inc >  1.0f) ?  1.0f : inc;
			if ( inc != 0 )
			{
				deltaAngle = 3.4f * inc * sensivity.m_mouseX;
			}
		}

		int mouseY = env->m_window->getMouse().getPosY();
		int halfWindowHeight = env->m_window->getCurrentViewport()->getHeight() >> 1;
		{
			hkReal inc  = hkReal(halfWindowHeight - mouseY) / halfWindowHeight;
			inc = (inc < -1.0f) ? -1.0f : inc;
			inc = (inc >  1.0f) ?  1.0f : inc;
			if ( inc != 0.0f )
			{
				deltaElevation = 3.4f * inc * sensivity.m_mouseY;
			}
		}

		// Snap mouse back to middle
		if(lockMouse)
		{
			env->m_window->setMousePosition(halfWindowWidth, halfWindowHeight);
		}

		if (!disableWASD)
		{
			const hkgKeyboard& keyboard = env->m_window->getKeyboard();
			if (keyboard.getKeyState( 'A')) posX=1.f;
			if (keyboard.getKeyState( 'D')) posX=-1.f;
			if (keyboard.getKeyState( 'W')) posY=-1.f;
			if (keyboard.getKeyState( 'S')) posY=1.f;
		}
	}


	// Normalize the movement vector
	hkReal lenSqd = posY * posY + posX * posX;
	if (lenSqd > 1.0f)
	{
		lenSqd = hkMath::sqrt(lenSqd);
		posY /= lenSqd;
		posX /= lenSqd;
	}
#endif
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
