/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_SIMPLE_CHARACTER_PROXY_H
#define HK_SIMPLE_CHARACTER_PROXY_H

#include <Demos/DemoCommon/Utilities/Character/CharacterProxy/CharacterProxy.h>

class SimpleCharacterProxy : public CharacterProxy
{
	public:
	HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
		SimpleCharacterProxy( const CharacterProxyCinfo& info );

		virtual ~SimpleCharacterProxy();
		 
		virtual void addToWorld( void* world ) HK_OVERRIDE; 

		virtual void removeFromWorld( void* world ) HK_OVERRIDE; 

			// Get the current transform of the character
		virtual void getTransform( hkTransform& transform ) const HK_OVERRIDE;

			// Get the current transform of the character
		virtual void setTransform( const hkTransform& transform ) HK_OVERRIDE;

		virtual const hkVector4& getPosition() const HK_OVERRIDE;

			// Get the linear velocity of the proxy
		virtual void getLinearVelocity( hkVector4& velOut ) const HK_OVERRIDE;

			// Set the linear velocity of the proxy
		virtual void setLinearVelocity( hkVector4Parameter newVelocity, hkReal timestep ) HK_OVERRIDE;

			// Return true if the proxy is supported
		virtual bool isSupported( hkReal timestep, hkVector4& surfaceVelocity ) const HK_OVERRIDE;

		virtual void setCollisionFilterInfo(hkUint32 filterInfo) HK_OVERRIDE;
		virtual hkUint32 getCollisionFilterInfo( ) HK_OVERRIDE;

		virtual void setDisplayColor( int color ) HK_OVERRIDE;

protected:
		void updateDisplayTransform();

		hkTransform m_transform;
		hkVector4 m_linearVelocity;
};

#endif // HK_SIMPLE_CHARACTER_PROXY_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
