/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#include <Demos/demos.h>
#include <Demos/DemoCommon/Utilities/Character/CharacterProxy/SimpleCharacterProxy/SimpleCharacterProxy.h>
#include <Common/Visualize/Shape/hkDisplayCapsule.h>
#include <Common/Visualize/hkDebugDisplay.h>


SimpleCharacterProxy::SimpleCharacterProxy( const CharacterProxyCinfo& info )
: CharacterProxy( info )
{
		
	//
	// Create a capsule to represent the character standing
	//

	hkReal totalHeight = info.m_characterHeight;
	hkReal radius = info.m_characterRadius;
	hkReal lineSegLen = totalHeight - radius - radius;

	hkVector4 vertexA; vertexA.setMul4( radius, info.m_upLocal );
	hkVector4 vertexB; vertexB.setMul4( radius + lineSegLen, info.m_upLocal );

	hkDisplayCapsule* capsule = new hkDisplayCapsule( vertexA, vertexB, radius );

	hkInplaceArray<hkDisplayGeometry*, 1> geoms;
	geoms.pushBack(capsule);

	m_transform.set(info.m_rotation, info.m_position);
	m_linearVelocity.setZero();

	hkTransform displayOffset = m_transform;
	HK_ADD_GEOMETRY( geoms, displayOffset, (hkUlong) this );

	int color = hkColor::BLUE;
	HK_SET_OBJECT_COLOR( (hkUlong)this, color);

	capsule->removeReference();
}

SimpleCharacterProxy::~SimpleCharacterProxy()
{
	removeFromWorld(HK_NULL);
}


void SimpleCharacterProxy::addToWorld( void* w )
{
	updateDisplayTransform();
}

void SimpleCharacterProxy::removeFromWorld( void* w )
{
	HK_REMOVE_GEOMETRY( (hkUlong) this );
}


// Get the current transform of the character
void SimpleCharacterProxy::getTransform( hkTransform& transform ) const
{
	transform = m_transform;
}

// Get the current transform of the character
void SimpleCharacterProxy::setTransform( const hkTransform& transform )
{	
	m_transform = transform;
	updateDisplayTransform();
}

const hkVector4& SimpleCharacterProxy::getPosition() const
{
	return m_transform.getTranslation();
}

// Get the linear velocity of the proxy
void SimpleCharacterProxy::getLinearVelocity( hkVector4& velOut ) const
{
	velOut = m_linearVelocity;
}

// Set the linear velocity of the proxy
void SimpleCharacterProxy::setLinearVelocity( hkVector4Parameter newVelocity, hkReal timestep )
{
	m_linearVelocity = newVelocity;
}

// Return true if the proxy is supported
bool SimpleCharacterProxy::isSupported( hkReal timestep, hkVector4& surfaceVelocity  ) const
{
	surfaceVelocity.setZero();
	return true;
}

void SimpleCharacterProxy::setCollisionFilterInfo(hkUint32 filterInfo)
{
}

hkUint32 SimpleCharacterProxy::getCollisionFilterInfo( )
{
	return 0;
}

void SimpleCharacterProxy::setDisplayColor( int color )
{
	HK_SET_OBJECT_COLOR( (hkUlong) this, color );
}

void SimpleCharacterProxy::updateDisplayTransform()
{
	HK_UPDATE_GEOMETRY( m_transform, (hkUlong) this );
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
