/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */


#include <Demos/demos.h>
#include <Demos/DemoCommon/Utilities/Character/CharacterProxy/RigidBodyCharacterProxy/RigidBodyCharacterProxy.h>
#include <Physics2012/Collide/Shape/Convex/Capsule/hkpCapsuleShape.h>
#include <Physics2012/Utilities/CharacterControl/CharacterRigidBody/hkpCharacterRigidBody.h>
#include <Physics2012/Utilities/CharacterControl/CharacterRigidBody/hkpCharacterRigidBodyListener.h>
#include <Physics2012/Collide/Filter/Group/hkpGroupFilter.h>
#include <Physics2012/Dynamics/Entity/hkpRigidBody.h>

RigidBodyCharacterProxy::RigidBodyCharacterProxy( const CharacterProxyCinfo& info )
: CharacterProxy( info )
{
		
	//
	// Create a capsule to represent the character standing
	//

	hkReal totalHeight = info.m_characterHeight;
	hkReal radius = info.m_characterRadius;
	hkReal lineSegLen = totalHeight - radius - radius;

	hkVector4 vertexA; vertexA.setMul4( radius, info.m_upLocal );
	hkVector4 vertexB; vertexB.setMul4( radius + lineSegLen, info.m_upLocal );
	hkpCapsuleShape* characterShape = new hkpCapsuleShape(vertexA, vertexB, radius);

	//
	// Construct a character rigid body
	//
	hkpCharacterRigidBodyCinfo charInfo;
	charInfo.m_shape = characterShape;
	charInfo.m_up = info.m_upLocal;

	charInfo.m_position = info.m_position;
	charInfo.m_rotation = info.m_rotation;

	charInfo.m_collisionFilterInfo = info.m_collisionFilterInfo;

	m_characterRb.setAndDontIncrementRefCount( new hkpCharacterRigidBody( charInfo ) );
	characterShape->removeReference();

	// Add listener
	{
		hkpCharacterRigidBodyListener* listener = new hkpCharacterRigidBodyListener();
		m_characterRb->setListener( listener );
		listener->removeReference();
	}	

	// Disable deactivation to avoid warning 0xF034546F
	m_characterRb->getRigidBody()->enableDeactivation(false);
}

RigidBodyCharacterProxy::~RigidBodyCharacterProxy()
{
}


void RigidBodyCharacterProxy::addToWorld( void* w )
{
	hkpWorld* world = reinterpret_cast<hkpWorld*>(w);
	world->addEntity( m_characterRb->getRigidBody() );
}

void RigidBodyCharacterProxy::removeFromWorld( void* w )
{
	hkpWorld* world = reinterpret_cast<hkpWorld*>(w);
	world->removeEntity( m_characterRb->getRigidBody() );
}


// Get the current transform of the character
void RigidBodyCharacterProxy::getTransform( hkTransform& transform ) const
{
	transform = m_characterRb->getRigidBody()->getTransform();
}

// Get the current transform of the character
void RigidBodyCharacterProxy::setTransform( const hkTransform& transform )
{	
	// XXX todo - assert the transform keeps the character upright
	hkTransform fixed = transform;
	fixed.getRotation().renormalize();

	const hkTransform& oldTransform = m_characterRb->getRigidBody()->getTransform();

	// To allow deactivation of the rigid body we should only set its transform
	// if it is different from the old one.
	if ( !oldTransform.isApproximatelyEqual( transform ) )
	{
		hkpRigidBody* rb = m_characterRb->getRigidBody();
		rb->getWorld()->markForWrite();
		rb->setTransform( transform );
		rb->getWorld()->unmarkForWrite();
	}
}

const hkVector4& RigidBodyCharacterProxy::getPosition() const
{
	return m_characterRb->getRigidBody()->getTransform().getTranslation();
}

// Get the linear velocity of the proxy
void RigidBodyCharacterProxy::getLinearVelocity( hkVector4& velOut ) const
{
	velOut = m_characterRb->getRigidBody()->getLinearVelocity();
}

// Set the linear velocity of the proxy
void RigidBodyCharacterProxy::setLinearVelocity( hkVector4Parameter newVelocity, hkReal timestep )
{
	const hkVector4& oldVelocity = m_characterRb->getRigidBody()->getLinearVelocity();

	// This liberal equality check is required if we want the rigid body
	// to ever deactivate.  If we want the rigid body to deactivate we should
	// not set the velocity if it is the same as the old one.
	if ( !oldVelocity.equals3( newVelocity, 1e-2f ) )
	{
		m_characterRb->getRigidBody()->markForWrite();
		m_characterRb->getRigidBody()->setLinearVelocity( newVelocity );
		m_characterRb->getRigidBody()->unmarkForWrite();
	}
}

// Return true if the proxy is supported
bool RigidBodyCharacterProxy::isSupported( hkReal timestep, hkVector4& surfaceVelocity  ) const
{
	surfaceVelocity.setZero();
	
	hkpSurfaceInfo ground;
	// Check support
	hkStepInfo stepInfo; stepInfo.m_deltaTime = timestep; stepInfo.m_invDeltaTime = 1.f / timestep;
	m_characterRb->getRigidBody()->markForRead();
	m_characterRb->checkSupport(stepInfo, ground);
	surfaceVelocity = ground.m_surfaceVelocity;
	m_characterRb->getRigidBody()->unmarkForRead();
	return ground.m_supportedState == hkpSurfaceInfo::SUPPORTED;
}

void RigidBodyCharacterProxy::setCollisionFilterInfo(hkUint32 filterInfo)
{
	m_characterRb->getRigidBody()->setCollisionFilterInfo(filterInfo);
	if( m_characterRb->getRigidBody()->getWorld() )
	{
		m_characterRb->getRigidBody()->getWorld()->updateCollisionFilterOnEntity( m_characterRb->getRigidBody(),
			HK_UPDATE_FILTER_ON_ENTITY_FULL_CHECK,	HK_UPDATE_COLLECTION_FILTER_IGNORE_SHAPE_COLLECTIONS	);
	}
}

hkUint32 RigidBodyCharacterProxy::getCollisionFilterInfo( )
{
	return 	m_characterRb->getRigidBody()->getCollisionFilterInfo( );
}

hkpRigidBody* RigidBodyCharacterProxy::getRigidBody()
{
	return m_characterRb->getRigidBody();
}

const hkpRigidBody* RigidBodyCharacterProxy::getRigidBody() const
{
	return m_characterRb->getRigidBody();
}

void RigidBodyCharacterProxy::setDisplayColor( int color )
{
	hkpRigidBody* rb = m_characterRb->getRigidBody();
	rb->removeProperty(HK_PROPERTY_DEBUG_DISPLAY_COLOR);
	rb->addProperty(HK_PROPERTY_DEBUG_DISPLAY_COLOR, color);
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
