/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_CHARACTER_PROXY_CHARACTER_H
#define HK_CHARACTER_PROXY_CHARACTER_H

struct CharacterProxyCinfo
{
	HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO, CharacterProxyCinfo);
	CharacterProxyCinfo();

	hkVector4	m_forwardLocal;
	hkVector4	m_upLocal;		// Note that this must be perpendicular to the m_forwardLocal direction
	hkVector4	m_position;
	hkVector4	m_upWorld;
	hkVector4	m_zeroOrientationWorld;
	hkQuaternion m_rotation;

	// Character height
	hkReal		m_characterRadius;
	hkReal		m_characterHeight;

	// Filter info
	hkUint32	m_collisionFilterInfo;
};

class CharacterProxy : public hkReferencedObject
{
	public:
	HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
		CharacterProxy( const CharacterProxyCinfo& info );

			/// The world here is either an hkpWorld or hknpWorld
		virtual void addToWorld( void* world ) = 0; 
	
			/// The world here is either an hkpWorld or hknpWorld
		virtual void removeFromWorld( void* world ) = 0; 

			/// Get the current transform of the character
		virtual void getTransform( hkTransform& transform ) const = 0;

			/// Get the current transform of the character
		virtual void setTransform( const hkTransform& transform ) = 0;

			/// Get the position
		virtual const hkVector4& getPosition() const = 0;

			/// Get the linear velocity of the proxy
		virtual void getLinearVelocity( hkVector4& velOut ) const = 0;

			/// Set the linear velocity of the proxy
		virtual void setLinearVelocity( hkVector4Parameter newVelocity, hkReal timestep ) = 0;

			/// Get the orientation as an angle about the up axis.
			/// Implemented in terms of getTransform()
		virtual hkReal getOrientation() const;

			/// Set the orientation as an angle about the up axis.
		/// Implemented in terms of getTransform()/setTransform()
		virtual void setOrientation(hkReal orientation);
	
			// Return true if the proxy is supported, and fill in values of the supporting surface velocity
		virtual bool isSupported( hkReal timestep, hkVector4& surfaceVelocity ) const = 0;

			// Get the forward direction in local space
		const hkVector4& getForwardLocal() const;

			// The the up direction in local space
		const hkVector4& getUpLocal() const;

		const hkVector4& getUpWorld() const;

		const hkVector4& getZeroOrientationWorld() const;

		//const hkVector4& getGravity() const;

			// Set the collision filter information on the collision representation
		virtual void setCollisionFilterInfo(hkUint32 filterInfo) = 0;

			// Set the collision filter information on the collision representation
		virtual hkUint32 getCollisionFilterInfo( ) = 0;

		virtual void setDisplayColor( int color ) = 0;


	private:

		// For character
		hkVector4 m_forwardLocal;
		hkVector4 m_upLocal;

		hkVector4 m_upWorld;
		hkVector4 m_zeroOrientationWorld;
};

#endif // HK_CHARACTER_PROXY_CHARACTER_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
