/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */


#include <Demos/demos.h>
#include <Demos/DemoCommon/Utilities/Character/CharacterProxy/CharacterProxy.h>


CharacterProxyCinfo::CharacterProxyCinfo()
{
	m_forwardLocal.setConstant<HK_QUADREAL_1000>();
	m_upLocal.setConstant<HK_QUADREAL_0010>();
	m_position.setZero();
	m_upWorld.setConstant<HK_QUADREAL_0010>();
	m_zeroOrientationWorld.setConstant<HK_QUADREAL_1000>();
	m_rotation.setIdentity();

	m_characterHeight = 2.0f;
	m_characterRadius = 0.4f;
	m_collisionFilterInfo = 0;
}


CharacterProxy::CharacterProxy( const CharacterProxyCinfo& info ) 
	: m_forwardLocal(info.m_forwardLocal), 
	  m_upLocal(info.m_upLocal),
	  m_upWorld(info.m_upWorld),
	  m_zeroOrientationWorld(info.m_zeroOrientationWorld)
{
		
}

// Get the forward direction in local space
const hkVector4& CharacterProxy::getForwardLocal() const
{
	return m_forwardLocal;
}

// The the up direction in local space
const hkVector4& CharacterProxy::getUpLocal() const
{
	return m_upLocal;
}

const hkVector4& CharacterProxy::getUpWorld() const
{
	return m_upWorld;
}

const hkVector4& CharacterProxy::getZeroOrientationWorld() const
{
	return m_zeroOrientationWorld;
}

hkReal CharacterProxy::getOrientation() const
{
	hkTransform transform; getTransform(transform);
	hkQuaternion rotation; rotation.set(transform.getRotation());
	hkVector4 forwardWorld; forwardWorld.setRotatedDir(rotation, getZeroOrientationWorld());

	hkSimdReal cos = forwardWorld.dot<3>(getZeroOrientationWorld());

	hkVector4 cp; cp.setCross(getZeroOrientationWorld(), forwardWorld);
	hkSimdReal sin = cp.dot<3>(getUpWorld());

	hkSimdReal orientation = hkVector4Util::atan2(sin, cos);

	return orientation.getReal();
}

void CharacterProxy::setOrientation( hkReal orientation )
{
	// We want to set a rotation such that
	hkRotation rot; rot.setAxisAngle(getUpWorld(), orientation);
	hkVector4 forwardWorld; forwardWorld.setRotatedDir(rot, getZeroOrientationWorld());

	// Dir-space axes, for this function, are (fwd, left, up)
	hkVector4 leftWorld; leftWorld.setCross(getUpWorld(), forwardWorld);

	hkRotation dirToWorld; dirToWorld.setCols(forwardWorld, leftWorld, getUpWorld());

	hkVector4 leftLocal; leftLocal.setCross(getUpLocal(), getForwardLocal());

	hkRotation dirToLocal; dirToLocal.setCols(getForwardLocal(), leftLocal, getUpLocal());

	hkRotation localToWorld; localToWorld.setMulInverse(dirToWorld, dirToLocal);

	hkTransform previousTransform; getTransform(previousTransform);

	hkRotation prevRotation = previousTransform.getRotation();

	if(!localToWorld.isApproximatelyEqual(prevRotation))
	{
		hkTransform newTransform = previousTransform;
		newTransform.setRotation(localToWorld);
		setTransform(newTransform);
	}
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
