/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#include <Demos/demos.h>

#include <Demos/DemoCommon/Utilities/CameraUtils/CameraUtils.h>

#include <Graphics/Common/Window/hkgWindow.h>
#include <Graphics/Common/Camera/hkgCamera.h>
#include <Graphics/Bridge/DisplayHandler/hkgDisplayHandler.h>
#include <Graphics/Common/DisplayWorld/hkgDisplayWorld.h>
#include <Graphics/Bridge/SceneData/hkgAssetConverter.h>
#include <Graphics/Bridge/SceneData/hkgSceneDataConverter.h>
#include <Demos/DemoCommon/DemoFramework/hkDemo.h>

void HK_CALL CameraUtils::spewCameraDetailsToConsole( const hkgCamera* camera )
{
	HK_ASSERT2(0x7e4dcd1a, camera != HK_NULL, "CameraUtils: provided camera is NULL");
	float from[3], to[3], dir[3], up[3];
	camera->getFrom(from);
	camera->getTo(to);
	camera->getUp(up);
	hkgVec3Sub(dir, to, from);
	hkgVec3Normalize(dir);

	hkStringBuf camInfo; camInfo.printf(
		"\nhkVector4 camFrom(%.3ff, %.3ff, %.3ff);\n"  \
		"hkVector4 camTo(%.3ff, %.3ff, %.3ff); // = dir(%.3ff, %.3ff, %.3ff)\n"   \
		"hkVector4 camUp(%.3ff, %.3ff, %.3ff);\n" \
		"// FOV : %.2f, Near : %.5f, Far %.5f\n",
		from[0], from[1], from[2],
		to[0], to[1], to[2],
		dir[0], dir[1], dir[2],
		up[0], up[1], up[2],
		camera->getFOV(), camera->getNear(), camera->getFar() );

	HK_REPORT( camInfo.cString() );
}

void HK_CALL CameraUtils::spewCameraDetailsToConsole( const hkDemoEnvironment* env )
{
	HK_ASSERT2(0x6f98cd2d, ( (env != HK_NULL) && (env->m_window != HK_NULL) ) ,"CameraUtils: invalid environment provided");
	
	const hkgCamera* camera = env->m_window->getViewport( 0 )->getCamera();
	spewCameraDetailsToConsole( camera );
}

#if defined(HK_REAL_IS_DOUBLE)
#define store3ToFloat(v,f) { HK_ALIGN_REAL(double d[4]); v.store<4>(d); f[0] = float(d[0]); f[1] = float(d[1]); f[2] = float(d[2]); }
#else
#define store3ToFloat(v,f) v.store<4>(f)
#endif

void HK_CALL CameraUtils::centerCameraAroundDisplay( const hkDemoEnvironment* env )
{
	hkgAabb bounds;
	env->m_displayWorld->getWorldBounds(bounds);

	HK_ALIGN_REAL(float p[4]);

	extArray<hkgDisplayHandler::DisplayPoint>& displayPoints = env->m_displayHandler->getDisplayPoints();
	for(int i = 0; i < displayPoints.getSize(); i++)
	{
		store3ToFloat(displayPoints[i].m_position,p);
		bounds.addPoint( p );
	}

	extArray<hkgDisplayHandler::DisplayLine>& displayLines = env->m_displayHandler->getDisplayLines();
	for(int i = 0; i < displayLines.getSize(); i++)
	{
		store3ToFloat(displayLines[i].m_start,p);
		bounds.addPoint( p );
		store3ToFloat(displayLines[i].m_end,p);
		bounds.addPoint( p );
	}

	extArray<hkgDisplayHandler::DisplayTriangle>& displayTriangles = env->m_displayHandler->getDisplayTriangles();
	for(int i = 0; i < displayTriangles.getSize(); i++)
	{
		store3ToFloat(displayTriangles[i].m_a,p);
		bounds.addPoint( p );
		store3ToFloat(displayTriangles[i].m_b,p);
		bounds.addPoint( p );
		store3ToFloat(displayTriangles[i].m_c,p);
		bounds.addPoint( p );
	}

	// If no geometry present - this will be an invalid AABB !
	if( bounds.m_min[0] < bounds.m_max[0])
	{
		hkgWindow* window = env->m_window;
		hkgViewport* v = window->getCurrentViewport();
		hkgCamera* c = v->getCamera();

		float to[3] ;
		bounds.getCentroid( to );
		c->setTo(to);
		c->setUp( v->getWorldUpPtr() );
		// Also set far plane in case we have a large geometry
		{
			float from[3];
			c->getFrom(from);
			hkVector4 dir;	dir.set( from[0] - to[0], from[1] - to[1], from[2] - to[2] );
			float lookDistance = float( dir.length3().getReal() );

			dir.set( bounds.m_min[0] - bounds.m_max[0], bounds.m_min[1] - bounds.m_max[1], bounds.m_min[2] - bounds.m_max[2] );
			float boundsDiag = float( dir.length3().getReal() );

			float currentFar = c->getFar();
			c->setFar( hkMath::max2( 2 * hkMath::max2( lookDistance, boundsDiag), currentFar)  );
		}
		c->computeModelView();
		c->computeProjection();
	}
}

void HK_CALL CameraUtils::setCameraFromScene(const hkDemoEnvironment* env, char const* name)
{
	for(int ic=0; ic<env->m_sceneConverter->m_cameras.getSize(); ic++)
	{
		hkgAssetConverter::Mapping const& mapping = env->m_sceneConverter->m_cameras[ic];
		hkgCamera* camera = static_cast<hkgCamera*>(mapping.m_hkgObject);
		if(hkString::strCmp(name, camera->getCameraName()) == 0)
		{
			hkgWindow* w = env->m_window;
			for(int i = 0; i < w->getNumViewports(); ++i)
			{
				hkgCamera* viewportCamera = w->getViewport(i)->getCamera();
				viewportCamera->setFOV(camera->getFOV());
				viewportCamera->setUp(camera->getUpPtr());
				viewportCamera->setTo(camera->getToPtr());
				viewportCamera->setFrom(camera->getFromPtr());
				viewportCamera->setNear(camera->getNear());
				viewportCamera->setFar(camera->getFar());

				viewportCamera->computeModelView();
				viewportCamera->computeProjection();
			}
			return;
		}
	}
	HK_ERROR(0x366d6f84, "No camera named '" << name << "' found in the converted scene.");
}


#undef storeToFloat

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
