/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_ANIMATED_HKG_CAMERA
#define HK_ANIMATED_HKG_CAMERA

struct AnimatedCamera
{
	HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,AnimatedCamera);

	class hkaSkeleton* m_skeleton;
	class hkaAnimationBinding* m_binding;
	class hkaAnimatedSkeleton* m_camera;
	hkTransform m_offset;
	class hkaDefaultAnimationControl* m_control;

	float getDuration() const;
};

// just transform animated. Not FOV etc

void LoadAnimatedCameras( const char* filename, hkArray<AnimatedCamera>& cameras );
void StepAnimatedCamera( AnimatedCamera& camera, float t /*time along camera path*/, class hkgViewport* dest );
void CleanupAnimatedCameras( hkArray<AnimatedCamera>& cameras );

#endif

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
