/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#include <Demos/demos.h>
#include <Demos/DemoCommon/Utilities/CameraUtils/AnimatedCamera.h>

#include <Demos/DemoCommon/Utilities/Asset/hkAssetManagementUtil.h>

#include <Animation/Animation/hkaAnimationContainer.h>
#include <Animation/Animation/Animation/hkaAnimationBinding.h>
#include <Animation/Animation/Animation/hkaAnnotationTrack.h>
#include <Animation/Animation/Animation/hkaAnimation.h>
#include <Animation/Animation/Playback/Control/Default/hkaDefaultAnimationControl.h>
#include <Animation/Animation/Playback/hkaAnimatedSkeleton.h>
#include <Animation/Animation/Rig/hkaPose.h>

#include <Common/Serialize/Util/hkLoader.h>
#include <Common/Serialize/Util/hkRootLevelContainer.h>
#include <Common/Serialize/Util/hkSerializeUtil.h>

float AnimatedCamera::getDuration() const
{
	return m_binding? float(m_binding->m_animation->m_duration) : 0.f;
}

void LoadAnimatedCameras( const char* filename, hkArray<AnimatedCamera>& cameras )
{
	hkStringBuf assetFile(filename); hkAssetManagementUtil::getFilePath(assetFile);
	hkIstream streamIn(assetFile);
	if (!streamIn.isOk())
	{
		HK_WARN( 0x3b382458, "Could not find file: " << filename );
		return;
	}
	hkResource* resource = hkSerializeUtil::loadOnHeap( streamIn.getStreamReader() );

	if( resource == HK_NULL )
	{
		HK_WARN( 0x3b382458, "Could not load resources from file: " << filename );
		return;
	}

	hkRootLevelContainer* container = (hkRootLevelContainer*)resource->getContentsPointer( hkRootLevelContainerClass.getName(), hkBuiltinTypeRegistry::getInstance().getTypeInfoRegistry() );
	if (!container)
	{
		HK_ASSERT3(0x27343437, container != HK_NULL , "Strange root type in " << filename);
		resource->removeReference();
		return;
	}
	
	hkaAnimationContainer* ac = reinterpret_cast<hkaAnimationContainer*>( container->findObjectByType( hkaAnimationContainerClass.getName() ));
	HK_ASSERT2(0x27343435, ac && (ac->m_animations.getSize() > 0 ), "No animation loaded");
	HK_ASSERT2(0x27343435, ac && (ac->m_bindings.getSize() > 0), "No binding loaded");

	int numAnimations = ac ? ac->m_animations.getSize() : 0;
	//HK_ON_DEBUG( int numSkeletons= ac ? ac->m_skeletons.getSize() : 0 );
	HK_ASSERT2(0x27343435, ac && (ac->m_bindings.getSize() >= numAnimations), "No enough binding loaded");
	//HK_ASSERT2(0x27343435, ac && (numSkeletons >= numAnimations), "No enough skeletons loaded");
	cameras.setSize(numAnimations);

		
	for (int ai=0; ai < numAnimations; ++ai)
	{
		AnimatedCamera& cam = cameras[ai];
		cam.m_binding = ac->m_bindings[ai]; cam.m_binding->addReference();
		cam.m_skeleton = ac->findSkeletonByName( cam.m_binding->m_originalSkeletonName ); cam.m_skeleton->addReference();
		cam.m_camera = new hkaAnimatedSkeleton( cam.m_skeleton );
		cam.m_control = new hkaDefaultAnimationControl( cam.m_binding );

		cam.m_control->setPlaybackSpeed(1.0f);
		cam.m_camera->addAnimationControl( cam.m_control );
		
		cam.m_offset.setIdentity();
	}
}

void StepAnimatedCamera( AnimatedCamera& camera, float t, class hkgViewport* dest )
{
	if (t < 0) t = 0;
	else if (t > camera.m_binding->m_animation->m_duration) return; // t = camera.m_binding->m_animation->m_duration;

	camera.m_control->setLocalTime(t);

	hkaPose pose (camera.m_camera->getSkeleton());
	camera.m_camera->sampleAndCombineAnimations( pose.accessUnsyncedPoseLocalSpace().begin(), pose.getFloatSlotValues().begin()  );
	
	const hkArray<hkQsTransform>& ms = pose.getSyncedPoseModelSpace();

	hkgCamera* destCamera = dest->getCamera();
	const hkQsTransform& trans = ms[0];
	
	// preserve to distance so that speed when in free mode not affected
	float dirOrig[3];
	hkgVec4Sub( dirOrig, destCamera->getToPtr(), destCamera->getFromPtr() );
	float dLen = hkgVec3Length(dirOrig);

	hkTransform matL; trans.copyToTransform( matL );
	hkTransform mat; mat.setMul( camera.m_offset, matL ); 
	// This sort of assumes default Max camera setup (with scene Z up)
	const hkVector4& from = mat.getColumn<3>(); from.store3(  destCamera->getFromPtr() );
	const hkVector4& up = mat.getColumn<1>(); up.store3( destCamera->getUpPtr() );
	hkVector4 to = mat.getColumn<2>(); // dir 
	to.normalize3();
	to.mul( hkSimdReal(-dLen) );
	to.add( from );
	to.store3( destCamera->getToPtr() );
	
	destCamera->computeModelView();
	
}

void CleanupAnimatedCameras( hkArray<AnimatedCamera>& cameras )
{
	for (int ci=0; ci < cameras.getSize(); ++ci)
	{
		AnimatedCamera& cam = cameras[ci];
		cam.m_skeleton->removeReference();
		cam.m_binding->removeReference();
		cam.m_camera->removeReference();
		cam.m_control->removeReference();
	}
	cameras.setSize(0);
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
