/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef DEMOS_UTILITIES_BOOTSTRAPDEMO_H
#define DEMOS_UTILITIES_BOOTSTRAPDEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDemoDatabase.h>

class hkMonitorStreamAnalyzer;

// Havok Bootstrapper
class BootstrapDemo : public hkDemo
{
	public:
	HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
		BootstrapDemo(hkDemoEnvironment* env);
		~BootstrapDemo();

		void makeFakeInput() {}
		void advanceFrame();

		virtual void preRenderDisplayWorld(class hkgViewport* v);
		virtual void postRenderDisplayWorld(class hkgViewport* v);

		virtual Result stepDemo();
		virtual Result stepVisualDebugger();
		virtual bool visualDebuggerEnabled();
		virtual void resetTimerStreams();

		void mtSafeDeleteDemo(hkDemo* demo);
		void outputTimings();


		// Bootstrap test type
		enum TestType
		{
			TEST_NORMAL,
			TEST_NORMAL_CONTINUE,	// continue with the last successfull demo
			TEST_SERIALIZE_BINARY,
			TEST_SERIALIZE_XML,
			TEST_DETERMINISM,
			TEST_MULTITHREADING_DETERMINISM,
			TEST_STATISTICS,
			TEST_STATISTICS_DETAILED,
			TEST_STATISTICS_SINGLE_THREADED,
			TEST_STATISTICS_CRITICAL,
			TEST_MEMORY_EXCEPTIONS,
			TEST_MEMORY_SNAPSHOT,
		};

		//// Tweakable parameters
		//struct Options
		//{
		//	HK_DECLARE_REFLECTION();
		//	Options() { m_stepsPerDemo = 100; }
		//	//int m_expireDemo,
		//	int m_stepsPerDemo; //+default(100) +absmin(1) +absmax(500)
		//	//int m_timePerDemo,
		//};
		//DEMO_OPTIONS_DECLARE(Options);

		static const char* getPlatform(hkBool simple = false);

	private:

		// Submethods
		void NormalStepDemo();
		void SerializeStepDemo();
		void DeterminismStepDemo();
		void MemoryExceptionsStepDemo();
		void StatsStepDemo();

		hkStringBuf getStatsFileName( const char* extension );
		
		// Common
		int m_demoTypeMask;
		TestType m_testType;
		int m_originalTexturePixelsLimit;
		hkDemoFrameworkOptions m_originalOptions;

		hkArray< hkDemo::RegressionInfo > m_demoRegressions;

		struct DemoEntry
		{
			HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,BootstrapDemo::DemoEntry);
			const hkDemoEntry* m_entry;
			//int m_numIterations;
		};

		hkArray<DemoEntry> m_entries;
		hkDemo* m_demo;
		int m_demoIndex;
		int m_steps;

		// Used when generating stats etc.
		int m_forcedNumThreads;
		int m_forcedNumSpus;

		// Serialization
		hkResource* m_allocatedData;
		hkpWorld* m_originalWorld;
		int m_counter;


		// Stats
		hkUint64 m_statsTicksPreCreate; // ticks just before demo created
		hkUint64 m_statsTicksPostCreate; // ticks just after demo created
		hkReal m_statsTotalTime; // seconds of sim time
		int m_statsNumSamples; // number of samples recorded

		hkStorageStringMap< int > m_pathToProductIndex;
		hkArray< hkReal > m_productTimes;

		// Determinism
		int m_runsPerGame;
		int m_runIndex;

		hkBool m_forceMultithreadedSimulationBackup;
};

#endif // DEMOS_UTILITIES_BOOTSTRAPDEMO_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
