/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#include <Demos/demos.h>
#include <Common/Base/System/hkBaseSystem.h>
#include <Graphics/Common/Window/hkgWindow.h>
#include <Graphics/Common/Texture/hkgTexture.h>

//
void	displayBitmap(class hkgWindow* window, int x, int y, int w, int h, const hkUint8* rgbBitmap, hkReal scale)
{
	static const float white[4] = { 1.0f, 1.0f, 1.0f, 1.0f};

	hkgDisplayContext*	ctx				=	window->getContext(); ctx->lock();
	hkgTexture*			textureObject	=	hkgTexture::create(ctx);
	textureObject->setFilterMode(HKG_TEXTURE_FILTER_POINT);
	textureObject->setTextureWrapModeU(HKG_TEXTURE_CLAMP);
	textureObject->setTextureWrapModeV(HKG_TEXTURE_CLAMP);
	hkUint8*			textureData		=	textureObject->allocateSurface(w, h, false, false, HK_NULL);
	hkString::memCpy(textureData, rgbBitmap, 3*w*h);
	textureObject->realize(true);
	
	
	hkgViewport*		curView			=	window->getCurrentViewport();
	hkgViewport*		orthoView		=	window->getWindowOrthoView();
	hkReal				windowHeight	=	(hkReal)window->getHeight();
	float				uMin			=	0;
	float				vMin			=	0;
	float				uMax			=	1.0f;
	float				vMax			=	1.0f;
	
	orthoView->setAsCurrent(ctx);	
	ctx->setDepthReadState(false);
	ctx->setDepthWriteState(true);
	ctx->setLightingState(false);
	ctx->setCurrentSoleTexture(textureObject, HKG_TEXTURE_MODULATE);
	ctx->setTexture2DState(true);
	ctx->setBlendState(false);
	ctx->setCurrentColor4( white );

	float p[3],uv[2],tl[3],lr[3];
	p[2] = -0.01f;
	tl[0] = 0.0f + x;
	tl[1] = float(windowHeight)  - y;

	lr[0] = float( w * scale) + x;
	lr[1] = float(windowHeight) - float( h * scale) - y;

	ctx->beginGroup( HKG_IMM_TRIANGLE_LIST );

	p[0] = tl[0]; p[1] = tl[1]; 
	uv[0] = uMin; uv[1] = vMin;
	ctx->setCurrentTextureCoord( uv );
	ctx->setCurrentPosition( p );

	p[0] = tl[0]; p[1] = lr[1]; 
	uv[0] = uMin; uv[1] = vMax;
	ctx->setCurrentTextureCoord( uv );
	ctx->setCurrentPosition( p );

	p[0] = lr[0]; p[1] = tl[1]; 
	uv[0] = uMax; uv[1] = vMin;
	ctx->setCurrentTextureCoord( uv );
	ctx->setCurrentPosition( p );

	p[0] = tl[0]; p[1] = lr[1];
	uv[0] = uMin; uv[1] = vMax;
	ctx->setCurrentTextureCoord( uv );
	ctx->setCurrentPosition( p );

	p[0] = lr[0]; p[1] = tl[1]; 
	uv[0] = uMax; uv[1] = vMin;
	ctx->setCurrentTextureCoord( uv );
	ctx->setCurrentPosition( p );

	p[0] = lr[0]; p[1] = lr[1]; 
	uv[0] = uMax; uv[1] = vMax;
	ctx->setCurrentTextureCoord( uv );
	ctx->setCurrentPosition( p );

	ctx->endGroup();
	ctx->setCurrentSoleTexture( HK_NULL, HKG_TEXTURE_DECAL );	

	curView->setAsCurrent(ctx);

	textureObject->removeReference();
	ctx->unlock();
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
