/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */
#include <Demos/demos.h>
#include <Common/Base/Config/hkConfigSimd.h>
#include <Demos/DemoCommon/DemoFramework/hkFloatingPointExceptionCheck.h>

#if defined(HK_PLATFORM_PC) || defined(HK_PLATFORM_XBOX) || defined(HK_PLATFORM_XBOX360)
	#include <float.h>
#endif

#	define CHECK_FPU_EXCEPTIONS

#if defined(CHECK_FPU_EXCEPTIONS)
	static hkBool g_checkFPU = false;
	static unsigned int g_checkFPUStack[255];
	static int  g_checkFPUStackIndex = 0;
#endif

int hkGetFPUState()
{
#if defined(CHECK_FPU_EXCEPTIONS)
#       if defined(HK_PLATFORM_WINRT) || defined(HK_PLATFORM_DURANGO)
		unsigned int control_word;
		return _controlfp_s( &control_word, 0, 0 );
#		else
		return _controlfp( 0, 0 );
#		endif
#else
	return 0;
#endif
}

void hkSetFPUState(int cw, bool reset = false)
{
#if defined(CHECK_FPU_EXCEPTIONS)
		if (!reset)
		{
#       if defined(HK_PLATFORM_WINRT) || defined(HK_PLATFORM_DURANGO)
			unsigned int control_word;
			_controlfp_s( &control_word, cw, MCW_EM );
#		else
			_controlfp( cw, MCW_EM );
#endif
		}
		else
		{
#       if defined(HK_PLATFORM_WINRT) || defined(HK_PLATFORM_DURANGO)
			unsigned int control_word;
			_controlfp_s( &control_word, 0xFFFFFFFF, MCW_EM );
#		else
			_controlfp( 0xFFFFFFFF, MCW_EM ); // Sets all bits (clearing the exceptions )
#endif
		}
#endif
}


void HK_CALL hkPushFPUState(unsigned int state)
{
#ifndef HK_ALLOW_FPU_EXCEPTION_CHECKING
	HK_ASSERT2(0x670b60a4, false, "FPU exception testing not supported in this configuration. See hkMath.h.");
#endif

#if defined(CHECK_FPU_EXCEPTIONS)
	// Get the current state
	int cw = hkGetFPUState();

	// Push the current state onto the stack
	HK_ASSERT2(0x6c9871d4, g_checkFPUStackIndex < 255, "FPU check overflow");
	g_checkFPUStack[g_checkFPUStackIndex] = cw;
	g_checkFPUStackIndex++;
	
	hkSetFPUState(state);
#endif
}

void HK_CALL hkPopFPUState()
{
#if defined(CHECK_FPU_EXCEPTIONS)
	g_checkFPUStackIndex--;
	HK_ASSERT2(0x7511c51f, g_checkFPUStackIndex >= 0, "FPU check underflow");
	int cw = g_checkFPUStack[g_checkFPUStackIndex];
	
	// set the state back
	hkSetFPUState( cw );
#endif
}

hkFPUExceptionDisabler::hkFPUExceptionDisabler()
{
#if defined(HK_ALLOW_FPU_EXCEPTION_CHECKING)
	hkPushFPUState(MCW_EM);
#endif
}

hkFPUExceptionDisabler::~hkFPUExceptionDisabler()
{
#if defined(HK_ALLOW_FPU_EXCEPTION_CHECKING)
	
	// Clear any pending FP exceptions. This must be done
	// prior to enabling FP exceptions since otherwise there
	// may be a 'deferred crash' as soon the exceptions are
	// enabled.
	_clearfp();
	hkPopFPUState();
#endif
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
