/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */
#include <Demos/demos.h>

#include <Graphics/Common/Window/hkgWindow.h>

#include <Demos/DemoCommon/DemoFramework/hkDemoFrameworkOptions.h>
#include <Demos/DemoCommon/DemoFramework/hkPerformanceCounterUtility.h>
#include <Demos/DemoCommon/DemoFramework/MonitorStatsRecorder.h>

#include <Common/Base/System/Io/IStream/hkIStream.h>

#include <Common/Base/System/Hardware/hkHardwareInfo.h>

#if defined(HK_PLATFORM_WIN32) && !defined(HK_PLATFORM_WINRT)
#define HK_FPU_EXCEPTION_MASK ((unsigned int) ~(EM_ZERODIVIDE | _EM_DENORMAL))

bool RunningOnVistaOrHigher()
{
	OSVERSIONINFOEX osvi;
	ZeroMemory(&osvi, sizeof(OSVERSIONINFOEX));
	osvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFOEX);
	BOOL bOsVersionInfoEx = GetVersionEx ((OSVERSIONINFO *) &osvi);
	if( !bOsVersionInfoEx )
	{
		osvi.dwOSVersionInfoSize = sizeof (OSVERSIONINFO);
		if (!GetVersionEx ( (OSVERSIONINFO *) &osvi) )
			return false;
	}

	return (osvi.dwPlatformId == VER_PLATFORM_WIN32_NT) && (osvi.dwMajorVersion >= 6);
}

#else
#define HK_FPU_EXCEPTION_MASK 0
#endif

#ifndef PRINTF
#include <stdio.h>
#define PRINTF printf
#endif

hkDemoFrameworkOptions::hkDemoFrameworkOptions()
:	m_windowed(true),
	m_enableShadows(false), // disable by default (even on PC as some lower Nvidia cards claim to suppot fully but don't quite)
	m_forceNoShadows(false), // allow demos to turn them on if they like, even if m_enableShadows if off generally.
	m_shadowMapRes(0), // 0 == use default platform size
	m_enableMsaa(true), // Multisampled Anti Aliasing
	m_msaaSamples(4), // 4x, 8x, 16x etc
	m_msaaQuality(0), // Different quality and sample values can trigger different h/w modes. 0 == default
	m_enableVsync(false), // Vertical Sync (Vblank) support.
	m_vsyncInterval(1),
	m_forceKeyboardGamepad(false), // if true, on pc, even if gamepad found, use keyboard to fake one.
	m_fakeTouchEvents(false),
	m_width(1280),
	m_height(720),
	m_xPos(20),
	m_yPos(20),
	m_repositionConsole(false),
	m_invertFlyMode(false),
	m_trackballMode(0),
	m_mouseGain(1.f),
	m_debugger(false),
	m_vdbCaptureFile(HK_NULL),
	m_enableVirtualFramebuffer(false),
#if defined(HK_PLATFORM_ANDROID) || defined(HK_PLATFORM_TIZEN) || ( defined(HK_PLATFORM_WINRT) && ( (WINAPI_FAMILY==WINAPI_FAMILY_PHONE_APP) || ( defined(HK_ARCH_ARM) && (WINAPI_FAMILY==WINAPI_FAMILY_APP) ) ) ) || defined(USING_FILESERVER)
	m_enableVirtualFileServer(true), // Resources too big to fix in package if all products built
#else
	m_enableVirtualFileServer(false),
#endif
	m_enableVirtualFileServerWait(true),  // always wait (unless -vfsnowait is used)
	m_industrial(false),
	m_timestep(0.016f),
	#if HK_PLATFORM_IS_CONSOLE
	m_lockFps(0), // consoles don't need framelock.
	#else
	m_lockFps(60),
	#endif
	m_showFps(false),
	m_consoleFps(false),
	m_notimers(false),
	m_maxIterations(-1),
	m_numRepetitions(1),
	m_defaultDemo(HK_NULL),
	m_windowTitle("Havok"),
	m_masterFile(HK_NULL),
	#if defined( HK_ATOM )
		m_renderer("ogles"), // OGL is supported on Atom powered netbooks
    #elif defined (HK_PLATFORM_MAC386)
        m_renderer("ogles2"),
    #elif defined(HK_PLATFORM_LINUX)
		m_renderer("ogles"), // Use OGLES until OGLES2 is repaired
    #elif defined(HK_PLATFORM_IOS) 
        m_renderer("ogles"),
    #elif defined(HK_PLATFORM_ANDROID) || defined(HK_PLATFORM_TIZEN)
        m_renderer("ogles2"), // Try OGLES2 (which uses GLSL shaders)
	#elif defined(HK_PLATFORM_WIIU)
		m_renderer("ogles2"),
	#else
		m_renderer("d3d11"), // DirectX11 the default on PC and PPU simulator (supports lower feature level than 11 though) (and console native renderer on all else)
	#endif
	m_multiGpu(false),
	m_forceCpu(false),
	m_numSaveFrames(0),
	m_saveFrames(false),
	m_statsDir(HK_NULL),
	m_overrideFileDir(HK_NULL),
	m_enableWiiFilewriter(false),
	m_statBarX(0),
	m_statBarY(1),
	m_statBarScreenFraction(5),
	m_statBarStartTime(17),
	m_enablePerformanceCounter( false ),
	m_perfomanceCounterOption(hkPerformanceCounterUtility::IDCACHE_MISSES_PENALTY),
	m_fpuExceptionFlags(0),
	m_graphicsDevice( unsigned(-1) ),
	m_argc(0),
	m_argv(HK_NULL),
	m_forceCompiledShaders(false),
	m_windowHint(0),
	m_runLastDemo(false),
	m_runNextDemo(false),
	m_bootstrapDemoIndex(-1),
	m_bootstrapEndDemoIndex(0),
	m_anisotropicFiltering(false),
	m_edgedFaces(false),
	m_reportingLevel( 5 /* hkDemo::REPORT_ALL */),
	m_masterSoundVolume(100),
	m_renderStereo(false),
	m_replayType(REPLAY_NONE),
	m_inputFilename(HK_NULL),
	m_saveMemoryStatistics(false),
	m_enableWiiLockedCache(false),
	m_recordMovie(false),
	m_motionBlurSamples(1),
	m_enableExceptionHandler(false),
	m_firstFrameToRecord(0),
	m_numFramesToRecord(0),
	m_outputRecordDir(""),
	m_numMonitors(0),
	m_firstMonitor(HK_NULL),
	m_memorySystemType(MEMORY_DEFAULT),
	m_enableCheckingMemoryStackTrace(true),
	m_saveOutputToLog(false),
	m_logFile("demoOutput.log"),
	m_isContinuousIntegration(false),
	m_printList(false)
{
	m_numThreads = hkHardwareInfo::calcNumHardwareThreads();
	// clip number of threads to 4, this is needed for some PCs which have to CPUs (=24 threads)
	m_numThreads = hkMath::min2( 4, m_numThreads );	// clip to 4 threads
	m_forceMT = m_numThreads > 1;
	m_numSpaceSplitterCells = 16;
	m_enableSolverDynamicScheduling = false;

	m_numSpus = 0;

#if defined(HK_PLATFORM_WIN32) && !defined(HK_PLATFORM_WINRT)
	#if defined(HK_COMPILER_MSVC) && (HK_COMPILER_MSVC_VERSION >= 1500) // for VS2008 and higher check if we can use dx10 normally, otherwise in VS2005 fallback to start with
		if (!RunningOnVistaOrHigher())
	#endif
	{
		m_renderer = "d3d9s"; // don't even bother trying;
	}
#endif

    
	m_useSpuThreads = false;
	m_attributes[0] = 0;
	m_renderParallelWithSimulation = false;
	m_physicsArgs = 0;
}

hkDemoFrameworkOptions::~hkDemoFrameworkOptions()
{
}

void tokenizeArgs(const char* src, int &argc, char** &argv);
void tokenizeArgs(const char* src, int &argc, char** &argv)
{
	char *bp = const_cast<char*>(src);
	while (*bp) {
		char *start = HK_NULL;

		// pass up leading spaces
		while (*bp == ' ')
			bp++;

		// if we get to the end of the string after reading spaces then quit
		if ( *bp == '\0' )
		{
			break;
		}

		// handle a quoted string
		if ( *bp == '\"' )
		{
			bp++;
			start = bp;

			while (*bp && *bp != '\"')
				bp++;

		}
		else
		{
			start = bp;

			while (*bp && *bp != ' ')
				bp++;
		}

		argv[argc++] = start;

		// only increment the pointer if we are not at the end of the string
		if (*bp)
			*bp++ = '\0';
	}
}



void hkDemoFrameworkOptions::parse(int argc, const char** argv, int firstArg)
{
	m_argc = argc;
	m_argv = argv;

	int i = 0; // 0 so that we get the first arg in hkdemo.cfg
	while( i < argc )
	{
		if(argv[i][0] == '-')
		{
			switch( hkString::toLower(argv[i][1]))
			{
			case '?': //print out the options available
				{
					PRINTF("\nHavok demo framework command line options (either at cmdline or through the hkdemo.cfg file):\n");
					PRINTF("\t\t -aSTRING      Assign a user attributes string to the demo\n");
					PRINTF("\t\t -norepos      Disable reposition of console window on startup [PC, default]\n");
					PRINTF("\t\t -repos        Reposition of console window on startup [PC]\n");
					PRINTF("\t\t -d            Run the VDB server\n");
					PRINTF("\t\t -dc Filename  Run the VDB server can save a capture to file \n");
					PRINTF("\t\t -g DemoName   Run the given demo only\n");
					PRINTF("\t\t -lastdemo     When running bootstrap demos (e.g. -g bootstrapall), start from the last demo run by the bootstrap\n");
					PRINTF("\t\t -nextdemo     When running bootstrap demos (e.g. -g bootstrapall), start from the demo after the last demo run by the bootstrap\n");
					PRINTF("\t\t -bdi          When running bootstrap demos (e.g. -g bootstrapall), start from this index\n");
					PRINTF("\t\t -bde          When running bootstrap demos (e.g. -g bootstrapall), end at this index\n");
					PRINTF("\t\t -r {ogles,olges2,ogls,d3d9,d3d9s,d3d10,d3d11,null}  Attempt to use the given renderer. ");
					PRINTF("\t\t               Must be last option if used. [mainly PC, null allowed on all]\n");
					PRINTF("\t\t -re <repetitions>		Run each demo <repetitions> times\n");
					PRINTF("\t\t			   Currently used only when running with -g or in the determinism bootstrap\n");
					PRINTF("\t\t -trackball    Use trackball style navigation (default navigation is fly mode):\n");
					PRINTF("\t\t               can be like Max (-trackballMax), Maya (-trackballMaya) or normal (-trackball).\n");
					PRINTF("\t\t -invertfly    Use inverted fly mode (flight sim style, forward/up is pitch down).\n");
					PRINTF("\t\t -mouseGainXXX Set mouse gain to XXX in [0,1]. Smaller values give smoother camera motion but less responsiveness.");
					PRINTF("\t\t -f            Force fullscreen mode [PC]\n");
					PRINTF("\t\t -w            Force windowed mode [PC]\n");
					PRINTF("\t\t -shadows      Force shadows on (using shadow maps) in all applicable demos on \n");
					PRINTF("\t\t -smapXXX      Set shadow map resolution to XXX \n");
					PRINTF("\t\t -noshadows    Force shadows off\n");
					PRINTF("\t\t -msaa		   Force MSAA on \n");
					PRINTF("\t\t -msaaQualityXX  Turn MSAA on with Quality set to XX \n");
					PRINTF("\t\t -msaaSamplesXX	 Turn MSAA on with Samples set to XX \n");
					PRINTF("\t\t -nomsaa       Force MSAAoff \n");
					PRINTF("\t\t -vsync        Force VSYNC on \n");
					PRINTF("\t\t -vsyncIntervalXX   Turn VSYNC on with Interval of XX (usually 1..4)\n");
					PRINTF("\t\t -novsync      Force VSYNC off \n");
					PRINTF("\t\t -aniso        Turn anisotropic texture filtering on\n");
					PRINTF("\t\t -sli          Use multiple GPUs if available\n");
					PRINTF("\t\t -fakegamepad  Force keyboard input to override gamepad (fake gamepad)[PC]\n");
					PRINTF("\t\t -faketouch    Use mouse lbutton down + move as touch events [PC, for testing]\n");
					PRINTF("\t\t -record FILE   Record all input to FILE.\n");
					PRINTF("\t\t -playback FILE Playback input from FILE\n");
					PRINTF("\t\t -timestepDDD  Set the default timestep to DDD. This value may be overriden by any particular demo.\n");
					PRINTF("\t\t -lDDD         Force demo not to exceed DDD Hz (lock framerate) using a software wait[PC]\n");
					PRINTF("\t\t -fps          Show the fps in thw upper left corner\n");
					PRINTF("\t\t -xDDD         Set the window width(DDD pixels) (no space) [PC]\n");
					PRINTF("\t\t -yDDD         Set the window height(DDD pixels)  (no space) [PC]\n");
					PRINTF("\t\t -xpDDD        Set the window x position (DDD pixels of the virtual screen)  (no space) [PC]\n");
					PRINTF("\t\t -ypDDD        Set the window y position (DDD pixels of the virtual screen)  (no space) [PC]\n");
					PRINTF("\t\t -i (num)      Run the demo for (num) iterations.\n");
					PRINTF("\t\t -m Filename   Set the master resource file for demos [PS2]\n");
					PRINTF("\t\t -st           force the demo(s) to run in single-threaded simulation mode\n");
					PRINTF("\t\t -mt           force the demo(s) to run in multi-threaded simulation mode, optionally specifying the number of threads\n");
					PRINTF("\t\t               For example -mt4 will attempt to use 4 threads.\n");
					PRINTF("\t\t -mcDDD        when runnning in multi-threaded simulation mode, optionally specify the number of space splitter cells\n");
					PRINTF("\t\t -md		   when runnning in multi-threaded simulation mode, enable dynamic solver scheduling\n");
					PRINTF("\t\t -mtr          force the demo(s) to run in multi-threaded simulation mode, in parallel with rendering\n");
					PRINTF("\t\t -spu(num)     Set the number of SPUs used to (num). -mt must be set for SPUs to be used. \n");
					PRINTF("\t\t -sputhread	   Use spuThreads instead of SPURS. \n");
					PRINTF("\t\t -c	           Run using the debug mem manager [Debug only, not in hkdemo.cfg]\n");
					PRINTF("\t\t -cf           Run using the fast debug mem manager (no stack tracing) [Debug only, not in hkdemo.cfg]\n");
					PRINTF("\t\t -memstat      Save memory statistics after demo is finished. -c must be set also. \n");
					PRINTF("\t\t -p{i,d,l,f}   Enable performance counter and set it to count instruction cache(i), d cache(d), load-hit-store(l), and instr flushed (f), or combo of them.\n");
					PRINTF("\t\t               or dcache (pd) misses [PS2]\n");
					PRINTF("\t\t -h{VGA,480p,480i,576p,576i,720p,720i,1080p,1080i}  Set the display hint \n");
					PRINTF("\t\t -device{0,1,2,3} Set the display device (adapter) to use on multi monitor PCs \n");
					PRINTF("\t\t -rl(0,1,2,3,4,5) Set the reporting level 0 = NONE, 5 = ALL");
					PRINTF("\t\t -video        Dump all displayed frames to disk\n");
					PRINTF("\t\t -volumeXXX    Set Master sound volume (100 == Normal)\n");
					PRINTF("\t\t -wiifw        Enable filewriter (cannot use VDB if enabled) [Wii]\n");
					PRINTF("\t\t -rm FILE      Record .AVI movie to FILE\n");
					PRINTF("\t\t -mbDDD        Set the number of motion blur samples to DDD. Use in conjunction with '-rm'.\n");
					PRINTF("\t\t -exceptionHandler  Enable exception handler\n");
					PRINTF("\t\t -fpu          Enable FPU exceptions (Win32 only) \n");
					PRINTF("\t\t -rcm[OPTIONS] [MONITOR_NAME...] FIRST_FRAME NUM_FRAMES FILE\n"
						   "Record the value of the specified monitors for each frame. For nested monitors you must specify the full path concatenating monitor names with '/'.\n"
						   "If no monitor name is specified all monitors will be recorded (only supported with XML output format)\n"
						   "OPTIONS may be 'x' or 'c' for XML or CSV output (defaults to XML) and additionally 'a' to capture monitors in all threads instead of only the main thread ones\n"
						   "If FILE ends with '/' the full demo name will be appended to form the full file name.\n"
						   "When used in conjunction with -re and with CSV output a separate file will be generated per repetition and an aggregated one with the average all repetitions.\n");
					PRINTF("\t\t -vfb		   Enable virtual framebuffer server (VNC like console connect)\n");
					PRINTF("\t\t -vfs          Enable virtual file server (grabs resources from a connected VFB server, if enabled)\n");
					PRINTF("\t\t -novfs        Disable virtual file server\n");
					PRINTF("\t\t -notimers     Force monitor stream size to 0\n");
					PRINTF("\t\t -log          Save console output to log file\n");
					PRINTF("\t\t -pa		   Pass in physics arguments.\n");
					PRINTF("\t\t -list		   Lists all the demos with their code.\n");
					break;
				}

			case 'a':
				{
					if (hkString::strCasecmp(argv[i], "-aniso") == 0)
					{
						m_anisotropicFiltering = true;
					}
					else
					{
						hkString::snprintf(m_attributes, 50, &argv[i][2]);
					}
					break;
				}

			case 'b': // dont re-boot iop
				{
					// note that the following expression will not read off the end of the string
					// (although it looks suspicious) due to short-circuit expression evaluation
					if ((argv[i][2] == 'i') &&
						(argv[i][3] == 'n') &&
						(argv[i][4] == '\0' ) ) // -bin
					{
						m_forceCompiledShaders = true;
					}
					else if (argv[i][2] == 'd' && argv[i][3] == 'i' && ++i < argc) // -bdi (bootstrapDemoIndex)
					{
						m_bootstrapDemoIndex = hkString::atoi(argv[i]);
					}
					else if (argv[i][2] == 'd' && argv[i][3] == 'e' && ++i < argc) // -bde (bootstrapDemoIndex)
					{
						m_bootstrapEndDemoIndex = hkString::atoi(argv[i]);
					}
					break;
				}
			case 'c':
				{
					if ( argv[i][2] && (argv[i][2] == 'o') ) //-co
					{
						m_memorySystemType = MEMORY_OPTIMIZER;
					}
					else if ( argv[i][2] && (argv[i][2] == 'f') ) //-cf
					{
						m_memorySystemType = MEMORY_CHECKING;
						m_enableCheckingMemoryStackTrace = false;
					}
					else if ( argv[i][2] && (argv[i][2] == 'i') ) // -ci
					{
						if ( argv[i][3] && (argv[i][3] == 'S') ) // -ciStats
						{
							setContinuousIntegrationOptionsStats();
						}
						else // -ciDebug
						{
							setContinuousIntegrationOptionsDebug();
						}
					}
					else
					{
						m_memorySystemType = MEMORY_CHECKING;
					}
					break;
				}
			case 'd': // debugger
				{

					// -device{0,1,choose} Set the display device (adapter) to use on mutlimon PCS \n");
					if ( argv[i][2] && argv[i][3] && (argv[i][2] == 'e') && (argv[i][3] == 'v') )
					{
						if (argv[i][5] && argv[i][6] && argv[i][7])
						{
							if (argv[i][7] == '0')
								m_graphicsDevice = 0;
							else if (argv[i][7] == '1')
								m_graphicsDevice = 1;
							else if (argv[i][7] == '2')
								m_graphicsDevice = 2;
							else if (argv[i][7] == '3')
								m_graphicsDevice = 3;
						}
					}
					else
					{
						if ( argv[i][2] && argv[i][2] == 'c')
						{
							// -dc
							if(++i < argc)
							{
								m_vdbCaptureFile = argv[i];
							}
						}
						m_debugger = true;
					}
					break;
				}
			case 'e': // exceptionHandler, edgefaces
				{
					if ( argv[i][2] && (argv[i][2] == 'd') )
					{
						m_edgedFaces = true;
					}
					else
					{
						m_enableExceptionHandler = true;
					}
					break;
				}
			case 'f': // fullscreen
				{
					// -fakegamepad
					if ( argv[i][2] && (argv[i][2] == 'a') && (argv[i][3] /*'k'*/ && argv[i][4] /*'e'*/ && argv[i][5]) )
					{
						if ( argv[i][5] == 'g' )
						{
							m_forceKeyboardGamepad = true;
						}
						else // 't'
						{
							m_fakeTouchEvents = true;
						}
					}
					// -forcecpu
					else if ( argv[i][2] && (argv[i][2] == 'o') )
					{
						m_forceCpu = true;
					}
					else if ( argv[i][2] && (argv[i][2] == 'p') ) // fps or fpu
					{
						if ( argv[i][3] && (argv[i][3] == 's') )
						{
							if ( argv[i][4] && (argv[i][4] == 'c') ) // fpsconsole
							{
								m_consoleFps = true;
							}
							else
							{
								m_showFps = true;
							}
						}
						else
						{
							m_fpuExceptionFlags = HK_FPU_EXCEPTION_MASK;
						}

					}
					else // assume -f or -fullscreen etc
					{
						m_windowed = false;
					}
					break;
				}
			case 'g':
				{
					if(++i < argc)
					{
						m_defaultDemo = argv[i];
					}
					break;
				}
			case 'i': // Iterations
				{
					if (argv[i][2] && (hkString::toLower(argv[i][2]) == 'n')) // -invert
					{
						m_invertFlyMode = true;
					}
					else if(++i < argc)
					{
						m_maxIterations = hkString::atoi(argv[i]);
					}
					break;
				}
			case 'l':
				{
					// -lastdemo
					if ( argv[i][2] && (argv[i][2] == 'a') )
					{
						m_runLastDemo = true;
					}
					else if ( argv[i][2] && (argv[i][2] == 'o') && argv[i][3] && (argv[i][3] == 'g'))
					{
						m_saveOutputToLog = true;
					}
					// -list
					else if (argv[i][2] && argv[i][2] == 'i')
					{
						m_printList = true;
					}
					else
					{
						m_lockFps = -1;
						if( argv[i][2] != HK_NULL) // '-l60'
						{
							m_lockFps = hkString::atoi(argv[i]+2);
						}
						else if( i+1 < argc && argv[i+1][0] != '-') // '-l' '60'
						{
							++i;
							m_lockFps = hkString::atoi(argv[i]);
						}
						if( m_lockFps == -1) // '-l' or parse error
						{
							m_lockFps = 60;
						}
					}
					break;
				}
			case 'm':
				{
					// -mt (force multithreaded)
					if ( argv[i][2] == 't' )
					{
						m_forceMT = true;
						if ( argv[i][3] >= '0' && argv[i][3] <= '9')
						{
							m_numThreads = argv[i][3] - '0';
						}
						// -mtr (run rendering in parallel with simulation)
						if ( argv[i][3] == 'r' )
						{
							m_renderParallelWithSimulation = true;
						}
					}
					else if ( argv[i][2] == 's' )
					{
						m_enableMsaa = true;
						if ((argv[i][3] == 'a') && (argv[i][4] == 'a') && argv[i][5] )
						{
							if ( (argv[i][5] == 'Q') || ( argv[i][5] == 'q') )
							{
								// -msaaQualityXX
								m_msaaQuality =  hkString::atoi(argv[i]+12);
							}
							else if ( (argv[i][5] == 'S') || ( argv[i][5] == 's') )
							{
								// -msaaSamplesXX
								m_msaaSamples =  hkString::atoi(argv[i]+12);
							}
						}
					}
					else if ( argv[i][2] == 'e' ) // -memstat
					{
						m_saveMemoryStatistics = true;
					}
					else if (argv[i][2] == 'b')	// -mbDDD
					{
						m_motionBlurSamples = hkString::atoi(argv[i]+3);
					}
					else if (argv[i][2] == 'o')	// -mouseGainXXX
					{
						m_mouseGain = hkString::atof(argv[i]+10);
						m_mouseGain = hkMath::clamp(m_mouseGain, hkReal(0.01f), hkReal(1));
					}
					else if (argv[i][2] == 'c')	// -mcDDD
					{
						m_numSpaceSplitterCells = hkString::atoi(argv[i]+3);
					}
					else if (argv[i][2] == 'd')	// -md
					{
						m_enableSolverDynamicScheduling = true;
					}
					else // assume -m
					{
						if(++i < argc)
						{
							m_masterFile = argv[i];
						}
					}
					break;
				}
			case 'n':
				{
					if ( argv[i][2] && (argv[i][2] == 'e') &&
					     argv[i][3] && (argv[i][3] == 'x') ) // -nextdemo
					{
						m_runNextDemo = true;
					}
					else if ( argv[i][2] && (argv[i][2] == 'o') && argv[i][3] && (argv[i][3] == 'r')) // -norepos
					{
						m_repositionConsole = false;
					}
					else if ( argv[i][2] && (argv[i][2] == 'o') && argv[i][3] && (argv[i][3] == 'm') ) // -nomsaa
					{
						m_enableMsaa = false;
					}
					else if ( argv[i][2] && (argv[i][2] == 'o') && argv[i][3] && (argv[i][3] == 'v') ) // -nov**
					{
						if ( argv[i][4] && (argv[i][4] == 'f') )// -novfs
						{
							m_enableVirtualFileServer = false;
						}
						else // -novsync
						{
							m_enableVsync = false;
						}
					}
					else if ( argv[i][2] && (argv[i][2] == 'o') && argv[i][3] && (argv[i][3] == 's') )// -noshadows
					{
						m_enableShadows = false;
						m_forceNoShadows = true;
					}
					else if ( argv[i][2] && (argv[i][2] == 'o') && argv[i][3] && (argv[i][3] == 't') ) // -notimers
					{
						m_notimers = true;
					}
					break;
				}
			case 'o':
				{
					if(++i < argc)
					{
						m_overrideFileDir = argv[i];
					}
					break;
				}


			case 'p': // p{i|d|l|lp|f}
				{
					if ( argv[i][2] == 'a' )
					{
						if(++i < argc)
						{
							m_physicsArgs = argv[i];
						}
					}
					else
					{
						if (hkString::strCasecmp(argv[i], "-playback") == 0)
						{
							if (++i < argc)
							{
								m_replayType = REPLAY_PLAYBACK;
								m_inputFilename = argv[i];
							}
						}
						else
						{
							m_enablePerformanceCounter = true;
							if (argv[i][2] && (argv[i][2] != ' ') )
							{
								int idx = 1;
								m_perfomanceCounterOption = hkPerformanceCounterUtility::DISABLE; //0
								while (++idx >= 2)
								{
									switch (argv[i][idx])
									{
									case 'i' :
										m_perfomanceCounterOption |= hkPerformanceCounterUtility::ICACHE_MISSES_PENALTY;
										break;
									case 'd' :
										m_perfomanceCounterOption |= hkPerformanceCounterUtility::DCACHE_MISSES_PENALTY;
										break;
									case 'l' :
										if (argv[i][idx+1] =='p')
										{
											m_perfomanceCounterOption |= hkPerformanceCounterUtility::LOAD_HIT_STORE_PENALTY;
											++idx;
										}
										else
											m_perfomanceCounterOption |= hkPerformanceCounterUtility::LOAD_HIT_STORE;
										break;
									case 'f' :
										m_perfomanceCounterOption |= hkPerformanceCounterUtility::INSTRUCTIONS_FLUSHED;
										break;
									default:
										idx = 0; break;
									}
								}
							}
						}
					}

					break;
				}
			case 'r':
				{
					if (hkString::strNcasecmp(argv[i], "-rcm", 4) == 0) //-rcm F C D
					{
						m_outputRecordFormat = MonitorStatsRecorder::XML;
						m_recordAllThreads = false;

						// Parse the options
						const char* option = argv[i] + 4;
						while (*option != '\0')
						{
							switch (*option)
							{
								case 'x':
									m_outputRecordFormat = MonitorStatsRecorder::XML;
									break;
								case 'c':
									m_outputRecordFormat = MonitorStatsRecorder::CSV;
									break;
								case 'a':
									m_recordAllThreads = true;
									break;
							}
							++option;
						}

						m_numMonitors = 0;
						m_firstMonitor = argv + i + 1;
						while(argv[i+1][0] < '0' || argv[i+1][0] > '9')
						{
							++m_numMonitors; ++i;
						}
						m_firstFrameToRecord = hkString::atoi(argv[++i]);
						m_numFramesToRecord = hkString::atoi(argv[++i]);
						m_outputRecordDir = argv[++i];
					}
					else if (hkString::strCasecmp(argv[i], "-repos") == 0) //-repos windows
					{
						m_repositionConsole = true;
					}
					else if (hkString::strNcasecmp(argv[i], "-rl", 3) == 0 && argv[i][3] ) //-rl# reporting level
					{
						m_reportingLevel = argv[i][3] - '0';
						m_reportingLevel = hkMath::clamp( (int)m_reportingLevel, (int)hkDemoEnvironment::REPORT_OFF, (int)hkDemoEnvironment::REPORT_ALL );
					}
					else if (hkString::strCasecmp(argv[i], "-record") == 0)
					{
						if (++i < argc)
						{
							m_replayType = REPLAY_RECORD;
							m_inputFilename = argv[i];
						}
					}
					else if (hkString::strCasecmp(argv[i], "-rm") == 0) //-rm record move to file
					{
						if (++i < argc)
						{
							m_recordMovie = true;
							m_movieFilename = argv[i];
						}
					}

					// Number of demo repetitions
					else if (hkString::strCasecmp(argv[i], "-re") == 0)
					{
						if (++i < argc)
						{
							m_numRepetitions = hkString::atoi(argv[i]);
						}
					}

					else if(++i < argc) //// renderer
					{
#ifndef HK_ANDROID_PLATFORM_8
						m_renderer = argv[i];
						if( argv[i][0] == 'n' )
						{
							m_lockFps = 0; // turn off frame lock for null renderer
						}
#else
						if( argv[i][0] != 'n' ) {
							HK_WARN(0x5129131, "-r parameter ignored - currently only null renderer is supported on Android 2.2");
						}
#endif
					}
					break;
				}
			case 's': // set the stats output directory or shadows
				{
#ifdef HK_PLATFORM_WINRT
					if (argv[i][2] == 'e') // -Server:
						break;
#endif
					// -st singlethreaded
					if ( argv[i][2] == 't' )
					{
						if (argv[i][3] == 'a') // -statbars[tart], -statbarx, -statbary, -statbarf[raction] all followed by a space then the int
						{
							switch (argv[i][8])
							{
							case 's':
								if(++i < argc)
								{
									m_statBarStartTime =  hkString::atoi(argv[i]);
									if (m_statBarStartTime < 1 || m_statBarStartTime > 255)
									{
										m_statBarStartTime = 17;
									}
								}
								break;

							case'x':
								if(++i < argc)
								{
									m_statBarX =  hkString::atoi(argv[i]);
									if (m_statBarX < 0 || m_statBarStartTime > 10000)
									{
										m_statBarX = 0;
									}
								}
								break;

							case 'y':
								if(++i < argc)
								{
									m_statBarY =  hkString::atoi(argv[i]);
									if (m_statBarY < 0 || m_statBarY > 10000)
									{
										m_statBarY = 0;
									}
								}
								break;

							case 'f':
								if(++i < argc)
								{
									m_statBarScreenFraction =  hkString::atoi(argv[i]);
									if (m_statBarScreenFraction < 1 || m_statBarScreenFraction > 100)
									{
										m_statBarScreenFraction = 5;
									}
								}
								break;
							}
						}
						else if (argv[i][3] == 'e') // -stereo
						{
							m_renderStereo = true;
						}
						else
						{
							// -st
							m_forceMT = false;
							m_numThreads = 1;
						}
						break;
					}

					// -spu (set num spus, spuThread)
					if ( ( argv[i][2] == 'p' ) && ( argv[i][3] == 'u' ) )
					{
						if ( argv[i][4] == 't' )
						{
							m_useSpuThreads = true;
						}
						else
						{
							if ( argv[i][4] >= '0' && argv[i][4] <=	 '5')
							{
								m_numSpus = argv[i][4] - '0';
							}
						}
						break;
					}
					// shadows
					if (argv[i][2] && (hkString::toLower(argv[i][2]) == 'h'))
					{
						m_enableShadows = true;
						m_forceNoShadows = false;
					}
					// -smapRES
					else if ( argv[i][2] && (hkString::toLower(argv[i][2]) == 'm') && argv[i][3] && argv[i][4] && argv[i][5] )
					{
						m_shadowMapRes =  hkString::atoi(argv[i]+5);
					}
					// sli
					else if (argv[i][2] && (hkString::toLower(argv[i][2]) == 'l'))
					{
						m_multiGpu = true;
					}
					// else stats
					else if(++i < argc)
					{
						m_statsDir = argv[i];
					}
					break;
				}
			case 't':
				{
					if (argv[i][2] && argv[i][2] == 'r') // '-trackball'
					{
						const char* name = &(argv[i][1]);
						if ( hkString::strNcasecmp(name, "trackball", 9) == 0)
						{
							m_trackballMode = 1;
							const char* style = &(argv[i][10]);
							if ( style[0] )
							{
								if (hkString::strNcasecmp(style, "Maya", 4) == 0)
									m_trackballMode = 3;
								else if (hkString::strNcasecmp(style, "Max", 3) == 0)
									m_trackballMode = 2;
							}
						}
					}
					else if (argv[i][2] && argv[i][2] == 'i')	// '-timestepDDD'
					{
						m_timestep = hkString::atof(argv[i]+9);
					}
					else if(++i < argc) // -t windowname
					{
						m_windowTitle = argv[i];
					}
					break;
				}
			case 'v':  // -video
				{
					if (argv[i][2] &&  argv[i][2] == 'i')
					{
						m_saveFrames = true;
					}
					else if (argv[i][2] &&  argv[i][2] == 'o') // -volumeXXX
					{
						m_masterSoundVolume = hkString::atoi(argv[i]+7);
					}
					else if (argv[i][2] && (argv[i][2] == 'f') && argv[i][3] && (argv[i][3] == 'b') ) // -vfb
					{
						m_enableVirtualFramebuffer = true;
					}
					else if (argv[i][2] && (argv[i][2] == 'f') && argv[i][3] && (argv[i][3] == 's') ) // -vfs
					{
						m_enableVirtualFileServer = true;
						if (argv[i][4] && (argv[i][4] == 'n')) // -vfsnowait
						{
							m_enableVirtualFileServerWait = false;
						}
						else
						{
							m_enableVirtualFileServerWait = true;
						}
					}
					else if (argv[i][2] && argv[i][2] == 's') // -vsync
					{
						m_enableVsync = true;
						if ( (argv[i][6] == 'I') || ( argv[i][6] == 'i') )
						{
							// -vsyncIntervalXX
							m_vsyncInterval =  hkString::atoi(argv[i]+14);
						}
					}
					break;
				}
			case 'w':
				{
					if ( argv[i][2] == 'i' )
					{
						if ( argv[i][3] == 'i' ) // '-wiifw'
						{
							m_enableWiiFilewriter = true;
						}
					}
					else
					{
						m_windowed = true; // // windowed
					}
					break;
				}
			case 'x': // x res (width)
				{
					if (argv[i][2] == 'p') // '-xp640'
					{
						m_xPos =  hkString::atoi(argv[i]+3);
					}
					else if( argv[i][2] != HK_NULL) // '-x640'
					{
						m_width = hkString::atoi(argv[i]+2);
					}
					break;
				}
			case 'y': // y res (height)
				{
					if (argv[i][2] == 'p') // '-xp640'
					{
						m_yPos =  hkString::atoi(argv[i]+3);
					}
					else if( argv[i][2] != HK_NULL) // '-y480'
					{
						m_height = hkString::atoi(argv[i]+2);
					}
					break;
				}
			case 'h':
				{
					// -h{VGA,480p,480i,576p,576i,720p,720i,1080p,1080i}
					if( argv[i][2] != HK_NULL)
					{
						m_windowHint |= (hkString::strCasecmp(&argv[i][2], "VGA")==0)   ? HKG_WINDOW_HINT_VGA : 0;
						m_windowHint |= (hkString::strCasecmp(&argv[i][2], "480p")==0)  ? HKG_WINDOW_HINT_480p : 0;
						m_windowHint |= (hkString::strCasecmp(&argv[i][2], "480i")==0)  ? HKG_WINDOW_HINT_480i : 0;
						m_windowHint |= (hkString::strCasecmp(&argv[i][2], "576p")==0)  ? HKG_WINDOW_HINT_576p : 0;
						m_windowHint |= (hkString::strCasecmp(&argv[i][2], "576i")==0)  ? HKG_WINDOW_HINT_576i : 0;
						m_windowHint |= (hkString::strCasecmp(&argv[i][2], "720p")==0)  ? HKG_WINDOW_HINT_720p : 0;
						m_windowHint |= (hkString::strCasecmp(&argv[i][2], "720i")==0)  ? HKG_WINDOW_HINT_720i : 0;
						m_windowHint |= (hkString::strCasecmp(&argv[i][2], "1080p")==0) ? HKG_WINDOW_HINT_1080p : 0;
						m_windowHint |= (hkString::strCasecmp(&argv[i][2], "1080i")==0) ? HKG_WINDOW_HINT_1080i : 0;
					}
					break;
				}

			default:
				{
					//hkPRINTF("option `%s' was not understood", argv[i]);
				}
			}
		}
		else
		{
			//hkPRINTF("option `%s' was not understood", argv[i]);
		}

		++i;
	}
#if defined FORCE_STATS_GENERATION
	{
		m_renderer = "n";
		m_lockFps = 0;
		m_defaultDemo = "DemoCommon/Utilities/Bootstrap/BootstrapStats";
	}
#endif

#ifdef HK_ANDROID_PLATFORM_8
	// currently only NULL renderer is supported on Android 2.2
	m_renderer = "n";
	m_lockFps = 0; // turn off frame lock for null renderer
#endif
}

static const char* _temp_argv[128];
void hkDemoFrameworkOptions::parseFile(const char* cfgFile)
{

	// open the cmdline settings file
	hkIstream stream(cfgFile);

	// If we have a command line file
	if (stream.isOk())
	{
		// copy argv so we can expand it
		for( int i = 0; i < m_argc; i++ )
		{
			_temp_argv[i] = m_argv[i];
		}
		m_argv = _temp_argv;
		int oldArgc = m_argc;

		// read the settings file
		// comment lines start with ;
		// can have arguments spread over multiple lines
		// or all arguments can be on same line

		int curLen = 0;
		while( stream.isOk() )
		{
			HK_ASSERT2(0x1d4eaa89, curLen < 1024, "hkdemo.cfg command line arguments has exceeded maximum number of allowed chars (1024)");

			// curGlobalLine holds a pointer to the next free position in the m_argvBuffer
			char* curGlobalLine =  m_argvBuffer + curLen;

			if( stream.getline( curGlobalLine, 255 ) <= 0 )
			{
				continue;
			}

			// comment lines are ignored
			if( curGlobalLine[0] == ';' )
			{
				continue;
			}

			hkStringBuf curLine( curGlobalLine );

			while(curLine.getLength() > 0)
			{
				// trim whitespace at end
				char trim = curLine[curLine.getLength() - 1];
				if( (' ' == trim) || ('\r' == trim) || ('\n' == trim) )
				{
					curLine.chompEnd(1);
				}
				else
				{
					break;
				}
			}

			int cr = curLine.getLength();

			// ignore empty lines
			if( 0 == cr )
			{
				continue;
			}

			// hold onto the lines with cmd line args
			curGlobalLine[cr] = 0;

			// tokenize the line using ' ', increment argc and add each token to argv
			tokenizeArgs(curGlobalLine, m_argc, (char**&)m_argv);

			curLen += cr + 1;
		}

		// set the last argument to null
		m_argv[m_argc] = HK_NULL;

		// parse new options (but not the ones that were already parsed in main())
		parse(m_argc, m_argv, oldArgc);
	}
}

void hkDemoFrameworkOptions::setContinuousIntegrationOptionsDebug()
{
	// equivalent to "-cf"
#if defined(HK_PLATFORM_WIIU) || defined(HK_PLATFORM_PSVITA) || defined(HK_REAL_IS_DOUBLE)
	m_memorySystemType = MEMORY_DEFAULT;
#else
	m_memorySystemType = MEMORY_CHECKING;
#endif

#if HK_PLATFORM_IS_CONSOLE == 1
	m_enableCheckingMemoryStackTrace = false;
#endif

	// Check for FPU exceptions if supported
#ifdef HK_ALLOW_FPU_EXCEPTION_CHECKING
	m_fpuExceptionFlags = HK_FPU_EXCEPTION_MASK;
#endif

	// equivalent to "-r n"
	m_renderer = "null";
	m_lockFps = 0;

	// equivalent to -rl3
	m_reportingLevel = hkDemoEnvironment::REPORT_WARN;

	// equivalent to -exceptionHandler
	m_enableExceptionHandler = true;

	// equivalent to -log
	m_saveOutputToLog = true;
	m_isContinuousIntegration = true;
}

void hkDemoFrameworkOptions::setContinuousIntegrationOptionsStats()
{
	// equivalent to "-r n"
	m_renderer = "null";
	m_lockFps = 0;
	m_isContinuousIntegration = true;
	// equivalent to -log
	m_saveOutputToLog = true;
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
