/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_DEMOFRAMEWORK_DEMOFRAMEWORK_H
#define HK_DEMOFRAMEWORK_DEMOFRAMEWORK_H

#include <Demos/DemoCommon/DemoFramework/hkDemo.h>
#include <Common/Base/Container/StringMap/hkStringMap.h>


struct hkDemoFrameworkOptions;
class hkDemoEnvironment;
class hkMemoryRouter;

////////////////////////////////////////////////////////////////////////////
// Main line

int HK_CALL frameworkMain(hkDemoFrameworkOptions& options, const char* startUpDemo);

// Main line calls the following:
bool frameworkInitBaseSystem( hkMemoryAllocator* base, hkDemoFrameworkOptions& options );
hkDemo* frameworkStartDemo( hkDemoEnvironment& environment, const char* startUpDemo );
hkDemo::Result frameworkStep( hkDemoEnvironment& environment, hkDemo* demo, int& stepCount, int demoSteps = 1 /* on 30Hz devices with fast CPUs we step demos twice, rendering once */);
hkResult frameworkQuitBaseSystem();

////////////////////////////////////////////////////////////////////////////
// Graphics

bool initRendererAndEnv(hkDemoEnvironment& env);
bool startRenderFrame(hkDemoEnvironment& env);
void checkFrameRate(hkDemoEnvironment& env);
void sendCurrentFrameOverNetwork(hkDemoEnvironment& env);
void tickFrame(hkDemoEnvironment& env, bool justCamera); // view not paused, used for motion blur etc to advance 'current'
void renderFrame(hkDemoEnvironment& env, hkDemo* demo);
void clearFrameData(hkDemoEnvironment& env);
void quitRendererAndEnv(hkDemoEnvironment& env);

////////////////////////////////////////////////////////////////////////////
// Misc 

// 'debug render now' support
void HK_CALL debugRenderImmediate(int wait, int clear);
extern hkDemoEnvironment* s_debugEnvironmentHandle;

// Reposition and/or hide the console window 
void adjustConsoleWindow(const hkDemoFrameworkOptions& options);

// Process Log files
void addHeaderToTestLogfile(const char* logPath, const char* demoName, hkBool demoPassed, hkReal time);

#if defined(HK_SERIALIZE_LATEST_VERSION_ONLY)
// Rename assets when support for old serialization is limited to the current version
namespace hkDemoFrameworkUtils
{
	const char* HK_CALL getDemoAssetNameForCurrentVersion(const char* basePath, const char* fname);
	const char* HK_CALL getDemoAssetNameForCurrentVersion(const char* fname);
}

#	define HK_GET_DEMOS_ASSET_FILENAME(fname) hkDemoFrameworkUtils::getDemoAssetNameForCurrentVersion(fname)
#	define HK_GET_DEMOS_ASSET_RELATIVE_FILENAME(basePath, fname) hkDemoFrameworkUtils::getDemoAssetNameForCurrentVersion(basePath, fname)
#else
#	define HK_GET_DEMOS_ASSET_RELATIVE_FILENAME(basePath, fname) fname
#	define HK_GET_DEMOS_ASSET_FILENAME(fname) fname
#endif
#define HK_IS_UPDATED_ASSET(fname) (hkString::strStr(fname, "_current"))

// Persistent cache for referenced objects, e.g. to cache shapes across demo runs
class hkDemoReferencedObjectCache
{
	public:

		struct Entry
		{
			HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DEMO, hkDemoReferencedObjectCache::Entry );

			hkReferencedObject*	m_refObj;
			hkStringPtr			m_extendedKey;
		};

	public:

		HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DEMO, hkDemoReferencedObjectCache );

		~hkDemoReferencedObjectCache();
		void insert( const char* keyA, const char* keyB, hkReferencedObject* ptr );
		bool hasKey( const char* keyA, const char* keyB );
		hkReferencedObject* getWithDefault( const char* keyA, const char* keyB, hkReferencedObject* defaultValue );

	public:

		hkStringMap<Entry*>	m_cache;
		hkArray<Entry*>		m_entries;
};

extern hkDemoReferencedObjectCache* s_demoObjectCache;



#endif //HK_DEMOFRAMEWORK_DEMOFRAMEWORK_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
