/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */
#include <Demos/demos.h>
#include <Demos/DemoCommon/DemoFramework/hkDemo.h>

#include <Graphics/Common/hkGraphics.h>

#include <Demos/DemoCommon/DemoFramework/hkDemoFramework.h>

#include <Demos/DemoCommon/DemoFramework/hkTextDisplay.h>
#include <Demos/DemoCommon/DemoFramework/hkPerformanceCounterUtility.h>
#include <Demos/DemoCommon/DemoFramework/hkDemoDatabase.h>
#include <Demos/DemoCommon/DemoFramework/hkDemoConsole.h>
#include <Demos/DemoCommon/DemoFramework/hkDefaultDemo.h>
#include <Demos/DemoCommon/Utilities/ExceptionHandler/hkExceptionHandler.h>

#include <Graphics/Common/Window/hkgWindow.h>

#include <Common/Visualize/hkVisualDebugger.h>

#include <Common/Base/Fwd/hkcstdio.h>
#include <Common/Base/Memory/System/Util/hkMemoryInitUtil.h>
#include <Common/Base/System/Error/hkDefaultError.h>
#include <Common/Base/Memory/MemoryClasses/hkMemoryClassDefinitions.h>
#include <Common/Base/System/Io/IStream/hkIStream.h>
#include <Common/Base/System/Io/Reader/hkStreamReader.h>
#include <Common/Base/System/Io/Writer/hkStreamWriter.h>
#include <Common/Base/System/Io/Reader/Buffered/hkBufferedStreamReader.h>

#	include <Common/Base/System/Io/FileSystem/hkServerFileSystem.h>

#include <Common/Base/Memory/System/hkMemorySystem.h>
#include <Common/Base/Thread/Semaphore/hkSemaphoreBusyWait.h>
#include <Common/Base/System/Io/FileSystem/hkFileSystem.h>
#include <Common/Base/System/Io/FileSystem/Union/hkUnionFileSystem.h>
#include <Common/Base/System/Io/Socket/hkSocket.h>
#include <Common/Base/Container/String/hkUtf8.h>
#include <Common/Base/Memory/Allocator/Malloc/hkMallocAllocator.h>
#include <Common/Base/Config/hkProductFeatures.h>
#include <Common/Base/Memory/Tracker/LayoutCalculator/hkTrackerExternalLayoutHandlerManager.h>

#include <Demos/DemoCommon/DemoFramework/TrackerHandlers/hkTrackerExtLayoutHandler.h>

#include <Common/Base/Config/hkOptionalComponent.h>
#include <Common/Base/KeyCode.h>
#include <Common/Base/System/Init/PlatformInit.cxx>



#ifdef HK_ANDROID_PLATFORM_8
#    include <jni.h>
#    include <android/log.h>
#endif


#if defined(HK_SERIALIZE_LATEST_VERSION_ONLY)
namespace hkDemoFrameworkUtils
{
	hkStringBuf buf;

	// Insert "_currentVersion" into assets filenames. The old serialization system may be limited to the current
	// Havok version on some platforms due to code size issues. Updated versions of tagfile and XML assets should
	// be available in such cases.
	const char* HK_CALL getDemoAssetNameForCurrentVersion(const char* fname)
	{
		if ( !fname )
		{
			return HK_NULL;
		}

		if (hkString::endsWith(fname, ".hkx"))
		{
			return fname;
		}

		int index = hkString::lastIndexOf(fname, '.');
		buf.set(fname, index);
		buf.append("_current");
		buf.append(fname + index);

		hkRefPtr<hkStreamReader> reader = hkFileSystem::getInstance().openReader(buf.cString());
		if ( reader && reader->isOk() )
		{
			return buf.cString();
		}
		return fname;
	}

	static bool HK_CALL isPathAbsolute( const char* filePath )
	{
		hkStringBuf fileBuf = filePath;
		if( fileBuf.getLength() == 0 )
		{
			return false;
		}

		bool hasDirectoryColon = fileBuf[1] == ':';
		bool hasNetworkSlashes = fileBuf.startsWith( "//" ) || fileBuf.startsWith( "\\\\" );
		return (hasDirectoryColon || hasNetworkSlashes);
	}

	static void HK_CALL getFullNormalizedPath( const char* rootPath, const char* fileName, hkStringBuf& fullPath )
	{
		HK_ON_DEBUG( int rootPathLen  = rootPath  ? hkString::strLen(rootPath)  : 0 );
		HK_ON_DEBUG( int assetPathLen = fileName ? hkString::strLen(fileName) : 0 );
		HK_ON_DEBUG( hkStringBuf rootPathCopy = rootPath );
		HK_ON_DEBUG( hkStringBuf assetPathCopy = fileName );

		if( rootPath == HK_NULL )
		{
			fullPath = fileName;
		}
		else if( fileName == HK_NULL )
		{
			fullPath = rootPath;
		}
		else
		{
			if( isPathAbsolute( fileName ) )
			{
				fullPath = fileName;
			}
			else
			{
				hkStringBuf assetPathString( fileName );
				fullPath = rootPath;

				// Normalize both paths
				fullPath.pathNormalize();
				assetPathString.pathNormalize();

				if( fullPath.getLength() == 0 )
				{
					fullPath = ".";
				}

				// Add a separating slash
				char lastChar = fullPath[fullPath.getLength()-1];
				if( lastChar != '/' && lastChar != '\\' )
				{
					fullPath += "\\";
				}

				fullPath += assetPathString;
			}
		}

		fullPath.pathNormalize();

		HK_ASSERT3(0x318fb398, hkString::strLen( fullPath.cString() ) > 1, 
			"Error in getFullNormalizedPath(). strLen returns " << hkString::strLen( fullPath.cString() ) << " but hkStringBuf::getLength() returns " << fullPath.getLength() << ". \n"
			<< "Inputs were " << ( rootPath ? rootPathCopy.cString() : "NULL" ) << " and " << ( fileName ? assetPathCopy.cString() : "NULL" ) << ".\n"
			<< "Inputs lengths were " << rootPathLen << " and " << assetPathLen << ".";
		);
	}

	const char* HK_CALL getDemoAssetNameForCurrentVersion(const char* basePath, const char* fname)
	{
		if ( !fname )
		{
			return HK_NULL;
		}

		if (hkString::endsWith(fname, ".hkx"))
		{
			return fname;
		}

		int index = hkString::lastIndexOf(fname, '.');
		buf.set(fname, index);
		buf.append("_current");
		buf.append(fname + index);

		hkStringBuf strb;
		getFullNormalizedPath(basePath, buf.cString(), strb);

		hkRefPtr<hkStreamReader> reader = hkFileSystem::getInstance().openReader(strb.cString());
		if ( reader && reader->isOk() )
		{
			return buf.cString();
		}
		return fname;
	}
}
#endif


// Enable FORCE_STATS_GENERATION to run the stats bootstrapper with the renderer switched off.
// This works for all platforms but is for Wii mostly, as the renderer can't be disabled via
// command args until file IO is supported.
// #define FORCE_STATS_GENERATION


hkDemoReferencedObjectCache* s_demoObjectCache;


hkDemoReferencedObjectCache::~hkDemoReferencedObjectCache()
{
	for ( int i=0; i<m_entries.getSize(); i++ )
	{
		m_entries[i]->m_refObj->removeReference();
		delete m_entries[i];
	}
	m_entries.clear();
}


void hkDemoReferencedObjectCache::insert( const char* keyA, const char* keyB, hkReferencedObject* ptr )
{
	if ( hasKey( keyA, keyB ) )
	{
		return;
	}

	Entry* entry = new Entry();
	entry->m_refObj      = ptr;
	entry->m_extendedKey . printf("%s%s", keyA, keyB );

	m_cache.insert( entry->m_extendedKey.cString(), entry );
	m_entries.pushBack( entry );
}


bool hkDemoReferencedObjectCache::hasKey( const char* keyA, const char* keyB )
{
	hkStringBuf extendedKey( keyA );
	extendedKey.append( keyB );
	return m_cache.hasKey( extendedKey );
}


hkReferencedObject* hkDemoReferencedObjectCache::getWithDefault( const char* keyA, const char* keyB, hkReferencedObject* defaultValue )
{
	hkStringBuf extendedKey( keyA );
	extendedKey.append( keyB );

	Entry* entry = m_cache.getWithDefault( extendedKey, HK_NULL );
	if ( entry )
	{
		return entry->m_refObj;
	}
	return defaultValue;
}

static void HK_CALL _demoResizeNotify(hkgWindow* w,unsigned int width, unsigned int height, void* userContext )
{
	if (userContext)
	{
		((hkDemo*)userContext)->windowResize(width, height);
	}
}

static void HK_CALL _demoDropFiles(const hkgWindow* w, unsigned int x, unsigned int y, const char* filename, void* userContext )
{
	if (userContext)
	{
		((hkDemo*)userContext)->windowDropFile(filename, x, y);
	}
}

static bool HK_CALL _demoTouchStateChange( hkgWindow* w, unsigned int pointerId, float x, float y, bool state /* true == down */, void* userContext )
{
	if (userContext)
	{
		if (state)
		{
			return ((hkDemo*)userContext)->touchDown(pointerId,(int)x,(int)y);
		}
		else
		{
			((hkDemo*)userContext)->touchUp(pointerId, (int)x,(int)y);
			return true;
		}
	}
	return false;
}

static void HK_CALL _demoTouchMove( hkgWindow* w, unsigned int pointerId, float x, float y, float dx, float dy, void* userContext )
{
	if (userContext)
	{
		((hkDemo*)userContext)->touchMove(pointerId, (int)x, (int)y, (int)dx, (int)dy);
	}
}

static void HK_CALL _demoAccelChange( const hkgWindow* w, const float highPass[3], const float lowPass[3], void* userContext )
{
	if (userContext)
	{
		((hkDemo*)userContext)->accelerometerChange(highPass, lowPass);
	}
}

static void HK_CALL errorReportFunction(const char* str, void*)
{
		#ifndef HK_PLATFORM_WINRT
			OutputDebugStringA(str);
			OutputDebugStringA("\n");
		#else
			OutputDebugString( hkUtf8::WideFromUtf8(str) );
			OutputDebugString( L"\n" );
		#endif

	hkprintf("%s\n", str);
	hkDemoConsole::getInstance().getStdout().flush();
}

void addHeaderToTestLogfile(const char* logPath, const char* demoName, hkBool demoPassed, hkReal time)
{
	// Take the file at logPath, read it in and write it out again with a header on top
	// of the form:
	// Name: *demoName*
	// Status: PASS/FAIL
	// originalOutput...
	hkStringBuf logContents;
	{
		hkIfstream inFile(logPath);
		char buffer[1024];
		while(inFile.getline(buffer, 1024) != -1)
		{
			logContents.printf(buffer);
		}
	}
	hkStringBuf logContentsWithHeader;
	logContentsWithHeader.appendPrintf("Name: %s\n", demoName);
	if(demoPassed)
	{
		logContentsWithHeader.appendPrintf("Status: PASS\n");
	}
	else
	{
		logContentsWithHeader.appendPrintf("Status: FAIL\n");
	}
	logContentsWithHeader.appendPrintf("Time: %f\n", float(time) );
	logContentsWithHeader.append(logContents.cString());
	hkOfstream outFile(logPath);
	if(outFile.isOk())
	{
		outFile << logContentsWithHeader.cString();
	}
}

static hkBool32 hasOptionPrefix(char const*const* argv, int argc, const char* prefix )
{
	for( int i = 1; i < argc; ++i )
	{
		const char* s = argv[i];
		if( s && hkString::beginsWith(s, prefix) )
		{
			return true;
		}
	}
	return false;
}

#ifdef HK_DYNAMIC_DLL
#include <Common/CommonAll/hkKeyCodeDllInit.cxx> 
#endif

bool frameworkInitBaseSystem( hkMemoryAllocator* base, hkDemoFrameworkOptions& options )
{
	hkMemoryRouter* memoryRouter;

#ifdef HK_FEATURE_PRODUCT_PHYSICS_2012
#if defined(HK_SHOWCASE_BUILD)
	hkMemorySystem::FrameInfo frameInfo(128*1024*1024);	// the borg cube in Havok destruction needs a large buffer
#    else
	hkMemorySystem::FrameInfo frameInfo(6*1024*1024);	// the bridge in Havok destruction needs a large buffer
#    endif
#else
	hkMemorySystem::FrameInfo frameInfo(0);
#endif

	// Initialize the memory tracker before the memory system, so that it can
	// track memory system internal allocations
#if defined(HK_MEMORY_TRACKER_ENABLE)
	hkMemoryInitUtil::initMemoryTracker();
#endif

	if( options.m_memorySystemType == hkDemoFrameworkOptions::MEMORY_OPTIMIZER )
	{
		memoryRouter = hkMemoryInitUtil::initOptimizer(base, frameInfo);
		extAllocator::initDefault();
	}
	else if( options.m_memorySystemType == hkDemoFrameworkOptions::MEMORY_CHECKING )
	{
		memoryRouter = hkMemoryInitUtil::initChecking(base, frameInfo);
		extAllocator::initChecking();
	}
	else
	{
		//hkFreeListAllocator::Cinfo info;
		//hkFreeListAllocator::setFixedSizeCinfo(8 * 1024, info);
		//memoryRouter = hkMemoryInitUtil::initFreeList(base, HK_NULL, frameInfo, &info);

		memoryRouter = hkMemoryInitUtil::initFreeListLargeBlock(base, frameInfo);
		
		extAllocator::initDefault();
	}

	if (memoryRouter == HK_NULL)
	{
		return false;
	}

	if ( hkBaseSystem::init( memoryRouter, errorReportFunction ) != HK_SUCCESS)
	{
		return false;
	}

	// Let our product dlls init (add classes, set keycodes)
	#ifdef HK_DYNAMIC_DLL
		initDlls();
	#endif

	if(options.m_masterFile != HK_NULL)
	{
		// used to be hkPackedFileSystem, now unused?
	}
	if( options.m_masterFile == HK_NULL ) // master not specified or not found
	{
		hkFileSystem* basefs =  &hkFileSystem::getInstance();
		hkUnionFileSystem* ufs = new hkUnionFileSystem();
		if( const char* p = hkDemoDatabase::getInstance().getPrefix() )
		{
			if( p[0] != 0 )
			{
				ufs->mount(basefs, "", p, true );
			}
		}
		
		// Add a platform-specific default mount(s).
		PlatformAddDefaultMounts(basefs, ufs); // from PlatformInit.cxx

		//ufs->mount(basefs, "", "e:/dev/head/demo/demos", true);
		if( options.m_overrideFileDir != HK_NULL )
		{
			ufs->mount(basefs, "", options.m_overrideFileDir, true );
		}
		hkFileSystem::replaceInstance(ufs);
	}

	if ( options.m_enableExceptionHandler )
	{
		hkExceptionHandler::setExceptionHandlingEnabled( true );
	}

#ifdef ENABLE_SN_TUNER
	snTunerInit();
#endif

	// Rebuild this here AFTER we have set up the filesystem
	hkDemoDatabase::getInstance().rebuildDatabase(options.m_isContinuousIntegration);

	return true;
}

hkResult frameworkQuitBaseSystem()
{
	// Dump out anything registered but not used
	{
		hkOstream stream("unusedSystems.txt");
		if (stream.isOk())	// If we have multiple instances running, they will all try to open this same file.
		{
			hkOptionalComponent::writeReport(stream);
		}
	}

	hkBaseSystem::quit();
	#if defined(HK_MEMORY_TRACKER_ENABLE)
		hkMemoryInitUtil::quitMemoryTracker();
	#endif
	hkResult result = hkMemoryInitUtil::quit();
	extAllocator::quit();
	return result;
}

hkDemo* frameworkStartDemo( hkDemoEnvironment& environment, const char* startUpDemo )
{
	hkDemoDatabase& database = hkDemoDatabase::getInstance();
	environment.m_window->getContext()->lock();

	hkDemo* demo = database.createDemo(startUpDemo, &environment);

	environment.m_window->setWindowResizeFunction( _demoResizeNotify, demo );
	environment.m_window->setWindowDropFileFunction( _demoDropFiles, demo );
	environment.m_window->setTouchMoveFunction( _demoTouchMove, demo );
	environment.m_window->setTouchStateChangeFunction( _demoTouchStateChange, demo );
	environment.m_window->setWindowAccelerometerFunction ( _demoAccelChange, demo );

	environment.m_window->getContext()->unlock();

	return demo;
}

hkDemo::Result frameworkStep( hkDemoEnvironment& environment, hkDemo* demo, int& stepCount, int numDemoSteps )
{
	bool graphicsWindowOK = startRenderFrame(environment);

	demo->advanceFrame();

	hkDemo::Result step = hkDemo::DEMO_OK;
	while ( (numDemoSteps > 0) && (step != hkDemo::DEMO_STOP) && (step != hkDemo::DEMO_RESTART) )
	{
		step = demo->stepDemo();
		--numDemoSteps;
	}
	
	const hkDemoFrameworkOptions& options = *environment.m_options;

	// Automatically stop the demo if the user limit for iterations is reached.
	if (options.m_maxIterations > 0)
	{
		stepCount++;
		//hkprintf("Iteration %d of %d\n", stepCount, options.m_maxIterations);
		if (stepCount == options.m_maxIterations)
		{
			step = hkDemo::DEMO_STOP;
			hkprintf("Elapsed Time: %0.3fs\n", environment.m_frameTimer.getElapsedSeconds());
			hkprintf("Average FPS: %0.3f\n", options.m_maxIterations / environment.m_frameTimer.getElapsedSeconds());
		}
	}

	if ( (step != hkDemo::DEMO_STOP) && (step != hkDemo::DEMO_RESTART) )
	{
		environment.m_frameTimer.updateAndWait( environment );

		// Render the views
		if (graphicsWindowOK)
		{
			renderFrame( environment, demo );

			tickFrame( environment, (step == hkDemo::DEMO_PAUSED) ); 
		}
		else // window may be hidden etc, so strings from demo step may mount up
		{
			clearFrameData( environment );
		}
	}

	// Handy reboot to launcher on some platforms@
	HKG_PAD_BUTTON buttons = HKG_PAD_BUTTON_L1 | HKG_PAD_BUTTON_L2 | HKG_PAD_BUTTON_R1 | HKG_PAD_BUTTON_R2;
	if ( (environment.m_gamePad->getButtonState() & buttons) == buttons )
	{
		step = hkDemo::DEMO_STOP;
	}

	return step;
}

///// COMMON DEFAULT MAIN LINE

#ifdef HK_ANDROID_PLATFORM_8
extern "C" {

JNIEXPORT jint JNICALL Java_com_havok_demos_dev_HavokDemos_demoFrameworkMain(JNIEnv* env)
{
	const char* startUpDemo = "Menu";
	hkDemoFrameworkOptions options;
#else
int HK_CALL frameworkMain(hkDemoFrameworkOptions& options, const char* startUpDemo)
{
#endif
	
	hkMallocAllocator mallocBase;
	if( !frameworkInitBaseSystem(&mallocBase, options) )
	{
		// If base sys init failed then something badly wrong.
		return -1234;
	}

	// Read demo options from hkdemo.cfg (not supported on Wii currently).
	options.parseFile( "hkdemo.cfg" );
	
#if defined(HK_PLATFORM_WIN32) && !defined(HK_PLATFORM_WINRT)	&& !defined(HK_PLATFORM_DURANGO)
	adjustConsoleWindow(options);
#endif
	

	if (options.m_enableVirtualFileServer)
	{
		hkServerFileSystem* fileServerConnect = new hkServerFileSystem();
		hkFileSystem::replaceInstance( fileServerConnect  );
		fileServerConnect->setMode( hkServerFileSystem::Mode( hkServerFileSystem::VIRTUAL_READWRITE | hkServerFileSystem::VIRTUAL_DIRLIST | (options.m_enableVirtualFileServerWait? hkServerFileSystem::WAIT_FOR_CONNECT : 0)) );
		
		//XX would be nice to print the IP addr to the screen at this point. That would preclude the servers hkdemo.cfg from altering the graphics options though..

		// reparse the hkdemo.cfg, may well be from server now (would assume if on client then empty (or just -vfb -vfs say) / no conflicting options from server)
		options.parseFile( "hkdemo.cfg" );
	}


	if (options.m_saveOutputToLog)
	{
		// Do this *after* we've set up the VFS, so that if it's enabled, the log is written to the host machine.
		hkFileSystem& fs = hkFileSystem::getInstance();
		hkRefPtr<hkStreamWriter> writer = fs.openWriter( options.m_logFile );
		if(writer)
		{
			// seek to the end so that we start writing from there
			writer->seek(0, hkStreamWriter::STREAM_END);
			hkDemoConsole::getInstance().addStreamWriter(writer);
			// hkDemoConsole owns the reference now, so it's OK if "writer" goes out of scope.
		}
		else
		{
			HK_WARN(0x5c932a3e, "Couldn't open log file (" << options.m_logFile << ") for writing.");
		}

		// make a directory to write individual demo logs to
		fs.mkdir( "logs" );
	}

	// register external tracker handlers for demo specific ext classes.
#if defined(HK_MEMORY_TRACKER_ENABLE)
	hkTrackerExternalLayoutHandlerManager& extHandlerManager = hkTrackerExternalLayoutHandlerManager::getInstance();
	hkTrackerLayoutHandler* handler = new hkTrackerExtLayoutHandler;
	extHandlerManager.addHandler("extArray", handler);
	extHandlerManager.addHandler("extInplaceArray", handler);
	extHandlerManager.addHandler("extMap", handler);
	handler->removeReference();
#endif

	int exitCode = 0;
	{
		hkDemoEnvironment environment;
		environment.m_options = &options;
		s_debugEnvironmentHandle = &environment;
		s_demoObjectCache = new hkDemoReferencedObjectCache();

		// Init HKG 
		if ( initRendererAndEnv(environment) )
		{
			// Make a demo (usualy the Menu demo)
			hkDemo* demo = frameworkStartDemo( environment, startUpDemo );

			// Main loop
			int stepCount = 0;
			while ( environment.m_window->peekMessages() == HKG_WINDOW_MSG_CONTINUE )
			{
				hkDemo::Result step = frameworkStep( environment, demo, stepCount ); 
				if ( step == hkDemo::DEMO_STOP )
				{
					break;
				}
				else if ( step == hkDemo::DEMO_RESTART )
				{
					delete demo;
					demo = frameworkStartDemo( environment, options.m_defaultDemo );
				}
			}

			// Delete the demo
			if (demo)
			{
				delete demo;
			}

			// Quit HKG
			quitRendererAndEnv(environment);
		}
		exitCode = environment.m_exitCode;

		// on some platforms we can't access the process exit code, write it out for ease of access
		hkOstream stream("exitcode.txt");
		if (stream.isOk())
		{
			stream << exitCode;
		}
	}
	
	delete s_demoObjectCache;

	hkResult frameworkQuitResult = frameworkQuitBaseSystem();
	
	return exitCode | int(frameworkQuitResult == HK_FAILURE);
}

#ifdef HK_ANDROID_PLATFORM_8
}
#endif

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
