/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */
#ifndef HK_DEMOFRAMEWORK_DEMOCONSOLE_H
#define HK_DEMOFRAMEWORK_DEMOCONSOLE_H

/// Contains the standard output and standard error used by Havok.
class hkDemoConsole : public hkReferencedObject, public hkLocalSingleton<hkDemoConsole>
{
	//+hk.MemoryTracker(ignore=True)
	public:

		hkDemoConsole();
		~hkDemoConsole();

		hkOstream& getStdout();
		hkOstream& getStderr();

		void addStreamWriter( hkStreamWriter* w );
		void popStreamWriter();

		hkOstream m_stdout;
		hkOstream m_stderr;

		// Needed to make sure we don't write from multiple threads (mainly for writing warnings/errors to log files)
		class hkCriticalSection* m_writeLock;

	private:

		friend class hkSingleton<hkDemoConsole>;
};


// Don't just redirect hkprintf to printf directly, on some platforms that can go no where, and we may want to see them over the network too
int HK_CALL hkprintf(const char * fmt, ...);
int HK_CALL hklog(const char * str);

/// Convenience macro to access havok stdout
#define hkcout		hkDemoConsole::getInstance().getStdout()

/// Convenience macro to access havok stderr
#define hkcerr		hkDemoConsole::getInstance().getStderr()

#endif // HK_DEMOFRAMEWORK_DEMOCONSOLE_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
