/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */
#include <Demos/demos.h>
#include <Demos/DemoCommon/DemoFramework/hkDemoConsole.h>

#include <Common/Base/System/Io/FileSystem/hkFileSystem.h>
#include <Common/Base/System/Io/Writer/hkStreamWriter.h>
#include <Common/Base/Fwd/hkcstdio.h>

HK_LOCAL_SINGLETON_IMPLEMENTATION(hkDemoConsole);

	#include <Common/Base/System/Io/Writer/Printf/hkPrintfStreamWriter.h>
	#define DefaultConsoleWriter hkPrintfStreamWriter
	#define USING_PRINTF

	
class ListStreamWriter : public hkStreamWriter
{
public:
	//
	// hkStreamWriter interface
	//
	virtual hkBool isOk() const HK_OVERRIDE;
	virtual int write(const void* buf, int nbytes) HK_OVERRIDE;
	virtual void flush() HK_OVERRIDE;
	virtual hkBool seekTellSupported() const HK_OVERRIDE;

		/// Add writer to the list. A reference count will be added.
	void addWriter( hkStreamWriter* writer );
	void popWriter();
	int getNumWriters();

protected:
	hkArray< hkRefPtr<hkStreamWriter> > m_writers;
};

void ListStreamWriter::addWriter( hkStreamWriter* writer )
{
	m_writers.expandOne() = writer;
}

hkBool ListStreamWriter::isOk() const
{
	if(m_writers.isEmpty())
		return false;

	for (int i=0; i<m_writers.getSize(); i++)
	{
		if( !m_writers[i]->isOk() )
			return false;
	}

	return true;
}

int ListStreamWriter::write( const void* buf, int nbytes )
{
	int nwrote = 0;

	for (int i=0; i<m_writers.getSize(); i++)
	{
		int n = m_writers[i]->write(buf, nbytes);
		nwrote = hkMath::max2(nwrote, n);
	}

	return nwrote;
}

void ListStreamWriter::flush()
{
	for (int i=0; i<m_writers.getSize(); i++)
	{
		m_writers[i]->flush();
	}
}

hkBool ListStreamWriter::seekTellSupported() const
{
	return false;
}

void ListStreamWriter::popWriter()
{
	m_writers.popBack();
}

int ListStreamWriter::getNumWriters()
{
	return m_writers.getSize();
}

hkDemoConsole::hkDemoConsole()
:	m_stdout( new ListStreamWriter ),
	m_stderr( new ListStreamWriter ),
	m_writeLock(HK_NULL)
{
#ifdef USING_PRINTF
	// Set stdouf (for printf) to be unbuffered (IONBF) instead of the default full buffering.
	// This is important for continuous integration: if we don't do this, the output might not be flush after an assert,
	// so it won't show up in the log.
	setvbuf(stdout, NULL, _IONBF, 0);
#endif

	{
		hkStreamWriter* out = new DefaultConsoleWriter;
		static_cast<ListStreamWriter*>( m_stdout.getStreamWriter() )->addWriter(out);
		out->removeReference();
	}
	{
		hkStreamWriter* err = new DefaultConsoleWriter;
		static_cast<ListStreamWriter*>( m_stderr.getStreamWriter() )->addWriter(err);
		err->removeReference();
	}


	m_stdout.getStreamWriter()->removeReference();
	m_stderr.getStreamWriter()->removeReference();

	m_writeLock = new hkCriticalSection(1000);

}

hkDemoConsole::~hkDemoConsole()
{
	delete m_writeLock;
}

hkOstream& hkDemoConsole::getStdout()
{
	return m_stdout;
}

hkOstream& hkDemoConsole::getStderr() 
{ 
	return m_stderr;
}

void hkDemoConsole::addStreamWriter( hkStreamWriter* w )
{
	static_cast<ListStreamWriter*>( m_stdout.getStreamWriter() )->addWriter(w);
}

void hkDemoConsole::popStreamWriter()
{
	ListStreamWriter* listWriter = static_cast<ListStreamWriter*>( m_stdout.getStreamWriter() );

	// don't allow popping the last (default) writer
	if(listWriter->getNumWriters() > 1)
	{
		listWriter->popWriter();
	}
}

#include <Common/Base/Fwd/hkcstdlib.h>

int HK_CALL hkprintf(const char * fmt, ...)
{
	va_list args; 
	va_start(args, fmt);

	extStringBuf s;
	int nchars = 0;
	while(1)
	{
		int size = s.getArray().getCapacity();
		nchars = hkString::vsnprintf(s.getArray().begin(), size, fmt, args);
		if( (nchars >= 0) && (nchars < size) ) 
		{
			// usual case, it worked. update length		
			s.getArray().setSize( nchars + 1);
			s.getArray()[nchars] = 0; 
			break;
		}
		else if( nchars < 0 )
		{
			nchars = size*2 > 255 ? size*2 : 255; 
		}
		s.getArray().setSize( nchars + 1);
		s.getArray()[nchars] = 0; 
	}
		
	va_end(args);

	return hklog(s.cString());
}

int HK_CALL hklog(const char *s)
{
	// Lock the critical section.
	// If multiple threads try to warn at the same thing, we might (at best) get garbage output.
	// This can actually crash when using the virtual file system on some platforms (e.g. Xbox360)
	hkCriticalSectionLock csLock(hkDemoConsole::getInstance().m_writeLock);

	// out to a log, stdout, whatever:
#ifndef HK_PLATFORM_WINRT
	hkcout << s;
	hkDemoConsole::getInstance().getStdout().flush();
#else
	int sLen = hkString::strLen(s) + 1;
	wchar_t* wideStr = hkAllocateStack<wchar_t>( sLen );
	mbstowcs_s(HK_NULL, wideStr, sLen, s, sLen - 1); 
	OutputDebugString(wideStr);
	hkDeallocateStack<wchar_t>( wideStr, sLen);
#endif
	// capture it all over network too if connected
	if ( (hkVirtualFramebufferServer::getCurrentInstance() != HK_NULL) && (hkVirtualFramebufferServer::getCurrentInstance()->getNumConnectedClients() > 0))
	{
		hkVirtualFramebufferServer::getCurrentInstance()->sendString( s );
	}

	return hkString::strLen(s);;
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
