/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_DEFAULTDEMO_H
#define HK_DEFAULTDEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDemo.h>

#include <Common/Base/UnitTest/hkUnitTest.h>

class hkgDisplayObject;
class hkgDisplayHandler;
class hkgCamera;
class hkgWindow;
class hkgLight;
class hkgAabb;
class hkgRay;

class hkpWorld;
class hkDemoEnvironment;
class hkpMouseSpringAction;
class hkStopwatch;
class hkClassRegistry;
class hkStreamReader;
class hkProcess;
class hkpPhysicsContext;
class hkProcessContext;
struct hkgViewportPickData;

class hkVisualDebugger;
class hkVtableClassRegistry;
struct hkTimerData;

class hkDefaultDemo;
class DemoStepper : public hkReferencedObject
{
	public:
	HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
		virtual hkDemo::Result stepDemo( hkDefaultDemo* demo ) = 0;
};

// Timer gather on some platforms can affect overall time
// normally platforms where there is no inline tick counter gather available
// So if you want representative step times then you may want to disable timers
// in demo runs
#define DEMOS_ENABLE_TIMER_CAPTURE 1

// Maximum number of SPUs that will be allowed to work on an SPU thread pool


#if defined(HK_REAL_IS_DOUBLE)
#	define HK_ASSET_NAME(n)	n ".dp"
#else
#	define HK_ASSET_NAME(n)	n
#endif


class hkDefaultDemo : public hkDemo
{
	public:
	HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
		// The constructor
		hkDefaultDemo(hkDemoEnvironment* env, bool isMenuDemo = false );

		// The destructor
		virtual ~hkDefaultDemo();

		virtual void postConstruct() { ; }

		virtual void preDeleteDemo() { ; }

		virtual Result stepDemo();

		virtual void onStepCompleted();


		void addStepper( DemoStepper* stepper );

		virtual Result stepVisualDebugger();
		virtual bool visualDebuggerEnabled() { return m_vdb != HK_NULL; }

		// From hkDemo
		virtual void addTimersToVdb( const extArray<hkTimerData>& threadStreams, const extArray<hkTimerData>& spuStreams );

		// This implementation will setup the VDB and the local debug viewers
		void setupGraphics();
		void shutdownVDB();

		// Helper to temporarily switch on/off graphics states
		void setGraphicsState(unsigned short/*HKG_ENABLED_STATE*/ state, hkBool on);

		void forceShadowState(bool shadowsOn);
		void forceEdgedFacesState(bool edgedFacesOn);

		void startGraphicsCodeSection() const;
		void endGraphicsCodeSection() const;

		// Cleanup the viewers
		void cleanupGraphics();

		// set a default camera
		void setupDefaultCameras( hkDemoEnvironment* env, const hkVector4& from, const hkVector4& to, const hkVector4& up, const hkReal nearPlane = 1.0f, const hkReal farPlane = 500.0f, bool rightHanded = true) const;

		enum CameraAxis
		{
			CAMERA_AXIS_X,
			CAMERA_AXIS_Y,
			CAMERA_AXIS_Z,
		};
		// Set up a camera looking at the origin with up axis.
		void setupDefaultCameras( hkEnum<CameraAxis,int> upAxis, hkReal fromX, hkReal fromY, hkReal fromZ ) const;

		// Gets the current path of the demo
		const char* getMenuPath() const { return m_menuPath.cString(); }

		int getDemoVariant() const { return m_variantId;	}

		// Start a little progress slider. E.g. good for loading or processing big files
		void progressBegin(const char* what);

		// Update the progress slider with a value between 0 and 1.
		void progressSet(hkReal fraction);

		// Convenience function needed to output text
		hkUint32 getWindowHeight() const;

		// disable backface culling
		void disableBackFaceCulling();


		// Remove progress slider.
		void progressEnd();

		// Unprojects and calls objectPicked.
		virtual void mouseDown();

		// Calls objectReleased.
		virtual void mouseUp();

		// Unprojects and calls objectDragged.
		virtual void mouseDrag();

		static void HK_CALL setupLights(hkDemoEnvironment* env);
		static void HK_CALL setupSkyBox(hkDemoEnvironment* env, const char* skyBoxFileName = HK_NULL);
		static void HK_CALL setupSkyEnvironment(hkDemoEnvironment* env, const char* skyBoxFileName, const char* diffuseIrradianceMap, const char* specularIrradianceMap );
		static void HK_CALL setSoleDirectionLight(hkDemoEnvironment* env, hkVector4Parameter dir, hkColor::Argb color);
		static void HK_CALL setThreeStageLights(hkDemoEnvironment* env, const hkReal keyDir[3], const hkReal fillDir[3], hkColor::Argb keyColor, hkColor::Argb fillColor, hkColor::Argb rimColor, const hkReal* keyPos = HK_NULL, hkReal keyInnerAngle = 0, hkReal keyOuterAngle = 0 );
		static void HK_CALL setupFixedShadowFrustum(hkDemoEnvironment* env, const hkgLight& light, const hkgAabb& areaOfInterest, hkReal extraNear = 0, hkReal extraFar = 0, int numSplits = 0, int preferedUpAxis = -1 );
		static void HK_CALL loadingScreen(hkDemoEnvironment* env, const char* screenFile = HK_NULL);

		// Split the screen. (0, 0.5) == Split left/right, (0.5, 0) == top/bottom split, (0.5, 0.5) == quad view
		// If you don't share the displayworld, the a new {world, displayHandler, converter) will be created for the new view.
		void splitScreen( hkReal h, hkReal v, bool shareCamera, bool shareDisplayWorld, unsigned int/*HKG_DISPLAY_OBJECT_COPY_FLAGS*/ flags );

		// handy simple version of above (does a set sole dir then a fixed shadow frustum)
		virtual void setLightAndFixedShadow(hkVector4Parameter lightDir, float* shadowAabbMin, float* shadowAabbMax, hkReal extraNear = 0, hkReal extraFar = 0, int numSplits = 0);

		static void HK_CALL removeLights(hkDemoEnvironment* env);

		// Called by setupgraphics	if options request it
		virtual void setupVisualDebugger(const hkArray<hkProcessContext*>& contexts, hkBool runServer = true, const char* captureFile = HK_NULL);

		// Setup the VDB and Local graphics pipes.
		// Called by setupgraphics
		virtual void setupContexts(hkArray<hkProcessContext*>& contexts);

			/// get the local (on screen) viewer, for instance the hhShapeDisplayViewer, by name (eg "Shapes", or hkpShapeDisplayViewer::getName() );
		hkProcess* getLocalViewerByName( const char* name ) const;

		template<typename ProcessType>
		ProcessType* getLocalViewer() const
		{
			return static_cast<ProcessType*>(getLocalViewerByName(ProcessType::getName()));
		}

		hkProcess* addLocalViewerByName(const char* name);

		template<typename ProcessType>
		hkProcess* addLocalViewer()
		{
			return static_cast<ProcessType*>(addLocalViewerByName(ProcessType::getName()));
		}

		void removeLocalViewerByName(const char* name);

		template<typename ProcessType>
		void removeLocalViewer()
		{
			removeLocalViewerByName(ProcessType::getName());
		}

		hkProcess* toggleLocalViewerByName(const char* name);

		template<typename ProcessType>
		hkProcess* toggleLocalViewer()
		{
			return static_cast<ProcessType*>(toggleLocalViewerByName(ProcessType::getName()));
		}

			/// get the viewers used by VDB clients, for instance the hhShapeDisplayViewer, by name (eg "Shapes", or hkpShapeDisplayViewer::getName() );
		void getVDBViewersByName( const char* name, hkArray<hkProcess*>& processes );


		int getNumSpus();

		// Called by the BootstrapDemo before it steps the demo
		// Use this to fake any gamepad input to make the demo interesting
		virtual void makeFakeInput() HK_OVERRIDE { }

		// Open the task queue and set the thread pool to process it. If that is already the state, nothing is done.
		void openTaskQueue();

		// Close the task queue and wait for the thread pool to stop processing it. Returns true if the queue was open.
		bool closeTaskQueue();

	//
	// Internal
	//
	public:

		// Called by mouseDown, should return true if it picks an object
		virtual hkBool objectPicked( const hkgDisplayObject* displayObject, const hkVector4& worldPosition, const hkgViewportPickData* pickData ) { return false; }
		// Called by mouseDown, if the given ray picks an object (not necessarily a display object),
		// the implementation has to set the picked world position and return true.
		virtual hkBool rayPick( const hkgRay& pickRay, hkVector4& pickedPosition ) { return false; }

		// Called by mouseUp
		virtual void objectReleased() { }

		// Called by mouseDrag
		virtual void objectDragged( const hkVector4& newWorldSpacePoint ) { }

		hkArray<DemoStepper*> m_steppers;

		//
		hkReal m_timestep;

		// The path in the demo menu
		extStringPtr m_menuPath;

		// The path of the demo (not necessarily the resources)
		extStringPtr m_demoPath;

		// An optional resource path sometime set by demo factories
		extStringPtr m_resourcePath;

		int		m_variantId;
		int		m_demoTypeAndFlags;

		// Some helper to print progress bars while loading
		hkStopwatch* m_lastProgress;
		extStringPtr m_progressName;

		// If true objectDragged is called, else objectPicked
		hkBool m_mouseActive;
		// The z-coordinate of the object picked
		hkReal m_mousePosDepth;

		// Tracks how many steps we've taken in a demo.
		int m_stepCounter;

		// We remove reference as last step in destructor - handy for storing hkPackfileData
		hkArray<hkReferencedObject*> m_delayedCleanup;

		// A utilitiy class for creating a character in a demo - will do different things depending on what products are present
		// Don't use directly - call getCharacterFactory()
		hkRefPtr<class CharacterFactory> m_characterFactory;

		enum FactoryType
		{
				/// Creates a SimpleCharacterFactory
			CHARACTER_FACTORY_PHYSICS,

				/// Creates a AnimatedCharacterFactory
			CHARACTER_FACTORY_ANIMATED,

				/// Creates a RagdollCharacterFactory
			CHARACTER_FACTORY_RAGDOLL,

				/// Creates a BehaviorCharacterFactory
			CHARACTER_FACTORY_BEHAVIOR,

				/// Creates a factory depending on which products are registered.
			CHARACTER_FACTORY_DEFAULT = -1
		};

		// Initializes m_characterFactory if it isn't already.
		// If CHARACTER_FACTORY_DEFAULT is specified, or an unsupported one is requested,
		// the factory will be set to the highest one supported.
		class CharacterFactory* getCharacterFactory( FactoryType factoryType = CHARACTER_FACTORY_DEFAULT );

		// Sets a new character factory
		void  setCharacterFactory( class CharacterFactory* newFactory );

		struct DefaultOptions
		{
			HK_DECLARE_REFLECTION();
			hkBool m_saveMemorySnapshot;
		};
		DEMO_OPTIONS_DECLARE(DefaultOptions);

	public:

		// Some debug viewers (debuglines, states, shapes, etc)
		extArray<extStringPtr> m_debugViewerNames;
		extArray<hkProcess*> m_debugProcesses;
		hkVisualDebugger* m_vdb;
		hkVtableClassRegistry* m_vdbClassReg;

		hkArray<hkProcessContext*> m_contexts;

		// Which timers to graph
		hkArray<extStringPtr> m_graphedTimerNames;

	public:
			// Handles timer display for multithreaded demos
		virtual void addOrRemoveThreads( );
		virtual void getNumTimerStreams( int& numThreadStreams, int& numSpuStreams, int maxThreads = 0x7fffffff ) const;
		virtual void getTimerStreamInfo( extArray<hkTimerData>& timerStreams, extArray<hkTimerData>& spuStreams, int maxThreads = 0x7fffffff );
		virtual void resetTimerStreams();

		virtual void getGraphedTimers( extArray<extStringPtr>& timerNames );

		int toggleShowFps();
		int toggleShowShadowMap();
		int showCameraInfo();
		int centerCamera();

		class AiDemoComponent* getAiDemoComponent();
		void setAiDemoComponent(AiDemoComponent* aiDemoComponent);

	public:

			// Wii-specific call to enable/disable the locked cache
		void enableLockedCache(bool enable);

	public:

		//
		// Multi-threading data
		//
		class hkJobQueue* m_jobQueue;
		class hkSpuUtil* m_spuUtil;
		hkRefPtr<class hkThreadPool> m_threadPool;
		hkRefPtr<class hkTaskQueue> m_taskQueue;

		/// If set to false, the user cannot reduce the number of active SPUs to zero using the demo framework.
		/// This is necessary for e.g. the collision query demos to avoid a situation where an SPU job remains on
		/// the job queue if no active SPU is available and the PPU is not allowed to take it.
		hkBool m_allowZeroActiveSpus;

		hkBool m_allowChangingNumThreads;

		hkBool m_forcedShadowsOff;
		hkBool m_forcedShadowsOn;
		hkBool m_forcedDebugShadowMap;

		hkBool m_forcedEdgedFacesOff;
		hkBool m_forcedEdgedFacesOn;

	private:

		// Derived classes should access this using getAiDemoComponent()
		hkReferencedObject* m_aiDemoComponent;

		struct MonitorStatsRecorder* m_monitorRecorder;

	protected:

		// Calls hkError::getInstance().setEnabled(id, isEnabled) after first recording the current value.
		void setErrorEnabled( int id, bool isEnabled );

		// Restores the enable flag on all errors to their original values.
		void restoreErrorEnabled();

	private:

		// the ID and old enabled flag for an error
		struct IdAndEnabled
		{
			int m_id;
			bool m_isEnabled;
		};

		// a stack of errors that have been enabled or disabled
		hkArray<IdAndEnabled> m_errorEnabledStack;
};

#endif // HK_DEFAULTDEMO_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
