/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_DEFAULTANIMATIONDEMO_H
#define HK_DEFAULTANIMATIONDEMO_H

#include <Graphics/Common/Window/hkgWindow.h>

class hkaAnimationContext;

class hkDefaultAnimationDemo : public hkDefaultDemo 
{
	public:
	HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
			/// The constructor
		hkDefaultAnimationDemo(hkDemoEnvironment* env);

			/// The destructor
		virtual ~hkDefaultAnimationDemo();

		virtual Result stepDemo();

		

		virtual void setupContexts(hkArray<hkProcessContext*>& contexts);

	protected:

			/// Called by mouseDown, should return true if it picks an object
		virtual hkBool objectPicked( const hkgDisplayObject* displayObject, const hkVector4& worldPosition, const hkgViewportPickData* pd );

			/// Called by mouseUp
		virtual void objectReleased();

			/// Called by mouseDrag
		virtual void objectDragged( const hkVector4& newWorldSpacePoint );

			/// The context.
		hkaAnimationContext* m_animationViewersContext;
};

#include <Common/Base/KeyCode.h>

#if defined(HK_FEATURE_PRODUCT_PHYSICS)

	#define HKA_DECLARE_PHYSICS_DEMO(DEMO_CLASS, DEMO_TYPE, HELP, DETAILS) \
		static hkDemo* HK_CALL hkCreateHkaNp##DEMO_CLASS(hkDemoEnvironment* env) { return new DEMO_CLASS(env); } \
		hkDemoEntryRegister hkDemoEntryRegisterHkaNp##DEMO_CLASS (&hkCreateHkaNp##DEMO_CLASS, (DEMO_TYPE) | (HK_DEMO_TYPE_USES_PHYSICS), __FILE__, -1, HK_NULL, HELP, DETAILS, true)

	#define HKA_DECLARE_PHYSICS_DEMO_FACTORY(DEMO_CLASS, DEMO_TYPE, CREATE_FUNC, HELP, DETAILS) \
		static hkDemo* HK_CALL hkCreateHkaNp##DEMO_CLASS(hkDemoEnvironment* env) { return new DEMO_CLASS(env); } \
		hkDemoEntryRegister hkDemoEntryRegisterHkaNp##DEMO_CLASS (&hkCreateHkaNp##DEMO_CLASS, DEMO_TYPE | HK_DEMO_TYPE_USES_PHYSICS, __FILE__, CREATE_FUNC, HELP, DETAILS, true)

#else

	#define HKA_DECLARE_PHYSICS_DEMO(DEMO_CLASS, DEMO_TYPE, HELP, DETAILS)
	#define HKA_DECLARE_PHYSICS_DEMO_FACTORY(DEMO_CLASS, DEMO_TYPE, CREATE_FUNC, HELP, DETAILS)

#endif

#if defined(HK_FEATURE_PRODUCT_PHYSICS_2012)

	#define HKA_DECLARE_PHYSICS_2012_DEMO(DEMO_CLASS, DEMO_TYPE, HELP, DETAILS) \
		static hkDemo* HK_CALL hkCreateHkaP##DEMO_CLASS(hkDemoEnvironment* env) { return new DEMO_CLASS(env); } \
		hkDemoEntryRegister hkDemoEntryRegisterHkaP##DEMO_CLASS (&hkCreateHkaP##DEMO_CLASS, (DEMO_TYPE) | (HK_DEMO_TYPE_USES_PHYSICS_2012), "HKA_PHYSICS_2012" __FILE__, -1, HK_NULL, HELP, DETAILS, true)

	#define HKA_DECLARE_PHYSICS_2012_DEMO_VARIANT_USING_STRUCT(DEMO_CLASS, DEMO_TYPE, VARIANT_STRUCT, VARIANT_TABLE, HELP) \
		static hkDemo* HK_CALL hkCreateHkaP##DEMO_CLASS(hkDemoEnvironment* env) { return new DEMO_CLASS(env); } \
		hkDemoEntryRegister hkDemoEntryRegisterTableHkaP##DEMO_CLASS[ sizeof(VARIANT_TABLE)/sizeof(VARIANT_STRUCT) ];	\
		hkDemoEntryRegister hkDemoEntryRegisterHkaP##DEMO_CLASS \
		(&hkCreateHkaP##DEMO_CLASS, (DEMO_TYPE) | (HK_DEMO_TYPE_USES_PHYSICS_2012), "HKA_PHYSICS_2012" __FILE__, &hkDemoEntryRegisterTableHkaP##DEMO_CLASS[0], sizeof(VARIANT_TABLE)/sizeof(VARIANT_STRUCT), sizeof(VARIANT_STRUCT), &VARIANT_TABLE[0].m_name, HELP, &VARIANT_TABLE[0].m_details )

	#define HKA_DECLARE_PHYSICS_2012_DEMO_FACTORY(DEMO_CLASS, DEMO_TYPE, CREATE_FUNC, HELP, DETAILS) \
		static hkDemo* HK_CALL hkCreateHkaP##DEMO_CLASS(hkDemoEnvironment* env) { return new DEMO_CLASS(env); } \
		hkDemoEntryRegister hkDemoEntryRegisterHkaP##DEMO_CLASS (&hkCreateHkaP##DEMO_CLASS, DEMO_TYPE | HK_DEMO_TYPE_USES_PHYSICS_2012, "HKA_PHYSICS_2012" __FILE__, CREATE_FUNC, HELP, DETAILS, true)

#else

	#define HKA_DECLARE_PHYSICS_2012_DEMO(DEMO_CLASS, DEMO_TYPE, HELP, DETAILS)
	#define HKA_DECLARE_PHYSICS_2012_DEMO_VARIANT_USING_STRUCT(DEMO_CLASS, DEMO_TYPE, VARIANT_STRUCT, VARIANT_TABLE, HELP)
	#define HKA_DECLARE_PHYSICS_2012_DEMO_FACTORY(DEMO_CLASS, DEMO_TYPE, CREATE_FUNC, HELP, DETAILS)

#endif

#endif // HK_DEFAULTANIMATIONDEMO_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
