/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_DEMOFRAMEWORK_EXT_LAYOUT_HANDLER_H
#define HK_DEMOFRAMEWORK_EXT_LAYOUT_HANDLER_H

#include <Common/Base/Memory/Tracker/LayoutCalculator/hkTrackerLayoutCalculator.h>

// Ext container classes are available in the demo framework and use a different allocator
// (the extern allocator) to avoid interfering with sdk allocations. These classes
// will eventually end up as members of memory system heap allocated object and in
// that case we must avoid following the references and adding new tracker blocks
// belonging to the ext memory allocator.

class hkTrackerExtLayoutHandler: public hkTrackerLayoutHandler
{
public: 
	//+hk.MemoryTracker(ignore=True)
	HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);

	virtual void getReferences(
		hkTrackerLayoutBlock* curBlock,
		const void* curData,
		const hkTrackerTypeTreeNode* curType,
		hkTrackerLayoutCalculator* layoutCalc,
		hkArray<const hkTrackerLayoutBlock*>::Temp& newBlocks );
	virtual hk_size_t getSize(
		const hkTrackerTypeTreeNode* curType,
		hkTrackerLayoutCalculator* layoutCalc );
};

#endif // HK_DEMOFRAMEWORK_EXT_LAYOUT_HANDLER_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
