/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#include <Demos/demos.h>
#include <Demos/DemoCommon/DemoFramework/TrackerHandlers/hkTrackerExtLayoutHandler.h>

void hkTrackerExtLayoutHandler::getReferences(
	hkTrackerLayoutBlock* curBlock,
	const void* curData,
	const hkTrackerTypeTreeNode* curType,
	hkTrackerLayoutCalculator* layoutCalc,
	hkArray<const hkTrackerLayoutBlock*>::Temp& newBlocks )
{
	// no new references and no new tracker blocks
}

hk_size_t hkTrackerExtLayoutHandler::getSize(
	const hkTrackerTypeTreeNode* curType,
	hkTrackerLayoutCalculator* layoutCalc )
{
	if(curType->m_name == "extArray")
	{
		return sizeof(extArray<hkUint8>);
	}
	else if(curType->m_name == "extInplaceArray")
	{
		const hkTrackerTypeTreeNode* contentType = curType->m_contains;
		hk_size_t contentSize = layoutCalc->calcTypeSize(contentType);
		const int inplaceSize = curType->m_contains->m_next->m_dimension;
		return sizeof(extArray<hkUint8>) + inplaceSize*contentSize;
	}
	else if(curType->m_name == "extMap")
	{
		return sizeof(extMap<void*, void*>);
	}
	HK_ASSERT(0, 0);
	return 0;
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
