/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_MONITORSTATSRECORDER_H
#define HK_MONITORSTATSRECORDER_H

#include <Common/Base/Monitor/MonitorStreamAnalyzer/hkMonitorStreamAnalyzer.h>


struct MonitorStatsRecorder
{
	public:

		enum OutputFormat
		{
			XML,
			CSV
		};

	public:

		HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO, MonitorStatsRecorder);

		MonitorStatsRecorder(hkDefaultDemo* demo);

		~MonitorStatsRecorder();

		// This must be called every frame
		bool appendFrame();

		HK_FORCE_INLINE hkBool32 isFinished() const { return (m_demo->m_stepCounter - m_firstFrame + 1) >= m_numFrames; }

	protected:

		void exportToXml(const hkMonitorStreamAnalyzer::Node** threadsStatsRoot, const char* filename) const;

		void processStatsNodeXml(
			const hkMonitorStreamAnalyzer::Node* node, const hkStringBuf& parentName, hkOstream& stream) const;

		void exportToCsv(const hkMonitorStreamAnalyzer::Node** threadsStatsRoot, const char* filename) const;

		void exportValuesToCsv(const hkReal* values, const char* filename) const;

		void processStatsNodeCsv(
			const hkMonitorStreamAnalyzer::Node* node, const hkStringBuf& parentName, hkReal* monitorValues) const;

		// Produces a file with the aggregated statistics of several demo repetitions
		void aggregateStats();

	public:

		hkMonitorStreamAnalyzer* m_analyzer;
		hkArray<hkReal>	m_monitorValues;
		hkDefaultDemo* m_demo;
		int m_firstFrame;
		int m_numFrames;
		int m_numMonitors;
		const char** m_monitorNames;
		hkStringBuf m_fileName;
		OutputFormat m_outputFormat;
		int m_numThreads;
};

#endif // HK_MONITORSTATSRECORDER_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
