/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef	CONVEX_HULL_DEMO_H	
#define CONVEX_HULL_DEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultDemo.h>

class hkxMesh;

class ConvexHullDemo : public hkDefaultDemo 
{
	public:
		struct Variant
		{
			HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,ConvexHullDemo::Variant);
			Variant(int test,const char* name,const char* details="") : m_test(test),m_name(name),m_details(details) {}
			int			m_test;
			const char*	m_name;
			const char*	m_details;
		};
		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

								ConvexHullDemo(hkDemoEnvironment* env);		
		Result					stepDemo();
		const Variant*			m_variant;
		hkStopwatch				m_stopWatch;
		hkPointerMap<int,int>	m_hullPerSeconds;
		hkArray<hkVector4>		m_points;
		int						m_currentTest;
		int						m_numSteps;
		int						m_numSamples;
		int						m_numLoops;
		int						m_numHulls;
		hkReal					m_timeAccumulator;
		hkReal					m_accuracy;
		hkBool					m_loopDemos;
	private:
};

#endif //CONVEX_HULL_DEMO_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
