/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */
#include <Demos/demos.h>
#include <Common/Serialize/hkSerialize.h>
#include <Common/Serialize/Util/hkSerializeUtil.h>
#include <Common/Serialize/Util/hkNativePackfileUtils.h>

class SerializeStreamsDemo : public hkDefaultDemo
{
	public:

		SerializeStreamsDemo( hkDemoEnvironment* env)
			: hkDefaultDemo(env), m_done(false)
		{
		}

		Result stepDemo()
		{
			if( 0 ) // we don't actually call these functions as they use dummy data
			{
				
					// We as the hkFileSystem to open a stream from a filename
				hkResource* res0 = hkSerializeUtil::load("Resources/Common/Api/Serialize/SimpleLoad/simple.xml");
				res0->removeReference();

					// Fill buffer using external read
					// This has a fast path for up to date binary packfiles
					// The buffer is not modified
				char* buf = HK_NULL; int bufSize = 0; 
				hkResource* res1 = hkSerializeUtil::load(buf, bufSize);
				res1->removeReference();

					// There is also a non-copying version for up to date binary packfiles.
					// The buffer must remain valid for the lifetime of the contained objects.
					// Don't forget to call hkNativePackfileUtils::unloadInPlace to destruct the contents.
				/* void* contents2 = */ hkNativePackfileUtils::loadInPlace(buf, bufSize);
				// contents2 = HK_NULL;
				hkNativePackfileUtils::unloadInPlace(buf, bufSize);

					// The data may be streamed instead of loaded all at once.
				hkStreamReader* sr = HK_NULL;
				hkResource* res3 = hkSerializeUtil::load(sr);
				res3->removeReference();
				
			}
			if( 0 ) // writing
			{
				
				// This is the object you want to save
				const void* object = HK_NULL;
				const hkClass* objectClass = HK_NULL;

				// This will expand the buffer to fit
				hkArray<char> expandingBuf;
				hkResult result0 = hkSerializeUtil::save(object, *objectClass, hkOstream(expandingBuf).getStreamWriter() );

				// This will truncate the file and return HK_FAILURE if the buffer is too small.
				char fixedBuf[10000]; int fixedBufSize = 10000;
				hkResult result1 = hkSerializeUtil::save(object, *objectClass, hkOstream(fixedBuf, fixedBufSize).getStreamWriter() );
				

				// use the variables.
				result0 = result1;
			}

			m_env->m_textDisplay->outputText("This is a source code demo", 20, 150, 0xffffffff);
			return DEMO_OK;
		}

		hkBool m_done;
};


static const char helpText[] = \
"This demo does not produce output. It is a source code example which shows\n" \
"how the packfile readers and writers interface with the stream classes.\n" \
"See also the plain streams demo.";



HK_DECLARE_DEMO(SerializeStreamsDemo, HK_DEMO_TYPE_PHYSICS_2012, "Packfile Stream examples", helpText);

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
