/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_NATIVEPACKFILELOAD_H
#define HK_NATIVEPACKFILELOAD_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysics2012Demo.h>
#include <Common/Serialize/Util/hkNativePackfileUtils.h>

/// This demo shows how to quickly load native binary packfiles.

// Variant 0 allocates a new buffer and loads the packfile objects into it. The packfile data is then no
// longer needed and may be released.
// Variant 1 loads the packfile in-place -- no new allocation is performed and the packfile buffer must
// remain allocated for the lifetime of the objects.
class NativePackfileLoadDemo : public hkDefaultPhysics2012Demo
{
	public:
	HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
		NativePackfileLoadDemo( hkDemoEnvironment* env);
		~NativePackfileLoadDemo();

		Result stepDemo();

	protected:

			// A buffer (re-sizable array of chars) to store data only from native binary packfile
		hkArray<char> m_dataBuffer;
			// Used for the third demo variant.
		hkResource* m_resource;
};

#endif // HK_NATIVEPACKFILELOAD_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
