/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#include <Demos/demos.h>
#include <Demos/Common/Api/Serialize/NativePackfileLoad/NativePackfileLoadDemo.h>
#include <Common/Base/Reflection/hkClass.h>
#include <Common/Base/System/Io/Reader/hkStreamReader.h>
#include <Common/Base/System/Io/IStream/hkIStream.h>
#include <Common/Serialize/Util/hkNativePackfileUtils.h>
#include <Common/Serialize/Util/hkRootLevelContainer.h>
#include <Common/Serialize/Util/hkStructureLayout.h>
#include <Physics2012/Utilities/Serialize/hkpPhysicsData.h>
#include <Common/Serialize/Util/hkSerializeUtil.h>


NativePackfileLoadDemo::NativePackfileLoadDemo( hkDemoEnvironment* env) 
	: hkDefaultPhysics2012Demo(env), m_resource(HK_NULL)
{
	// Disable warning: 'm_contactRestingVelocity not set, setting it to REAL_MAX, so that the new collision restitution code will be disabled'
	hkError::getInstance().setEnabled(0xf03243ed, false);
	hkError::getInstance().setEnabled(0x9fe65234, false);
	
	// Setup the camera
	{
		hkVector4 from(31, 31, 14);
		hkVector4 to(2.5f, -2, -.3f);
		hkVector4 up(0, 0, 1);
		setupDefaultCameras( env, from, to, up );
	}

	// The packfile will be in this buffer.
	// Normally it would be generated offline and loaded from disk, but for convenience,
	// we'll recreate it each time so it's guaranteed to be up to date.
	
	hkArray<char> inputBuffer;
	// SNIP: don't copy & paste this part - this is the offline bit
	if( hkRootLevelContainer* container = hkSerializeUtil::loadObject<hkRootLevelContainer>(HK_GET_DEMOS_ASSET_FILENAME("Resources/Common/Api/Serialize/SimpleLoad/simple.hkt")) )
	{
		hkPackfileWriter::Options options;
		hkSerializeUtil::savePackfile( container, hkRootLevelContainerClass, hkOstream(inputBuffer).getStreamWriter(), options );
		delete container;
	}
	HK_ASSERT2(0x26f2503c, inputBuffer.getSize(), "file load failed");
	// END SNIP
	
	// Now we have native packfile data in the 'm_packfileBuf' variable.
	// Extract only valuable data, stripping out all extras, such as headers and fixups tables
	// and load it into m_dataBuffer

	// Load the buffer and get the top level object in the file in one step
	hkRootLevelContainer* container = HK_NULL;
	// Variant 0 allocates a new buffer and loads the packfile into it. Once the packfile is loaded, buf is
	// no longer needed and will be relased when it goes out of scope
	if(m_variantId == 0)
	{
		int bufferSize = hkNativePackfileUtils::getRequiredBufferSize( inputBuffer.begin(), inputBuffer.getSize() );
		m_dataBuffer.reserveExactly(bufferSize);
		container = static_cast<hkRootLevelContainer*>(hkNativePackfileUtils::load(inputBuffer.begin(), inputBuffer.getSize(), m_dataBuffer.begin(), m_dataBuffer.getCapacity()));
	}
	// Variant 1 loads the buffer in-place. We swap the contents into m_dataBuffer rather than allocating a new
	// data buffer.
	else if(m_variantId == 1)
	{
		m_dataBuffer.swap(inputBuffer);
		container = static_cast<hkRootLevelContainer*>(hkNativePackfileUtils::loadInPlace(m_dataBuffer.begin(), m_dataBuffer.getSize()));
	}
	// Variant 2 uses the utility method in which the data is owned by a hkResource
	// In this variant, we can free the input buffer after loading.
	else if(m_variantId == 2)
	{
		m_resource = hkNativePackfileUtils::load(inputBuffer.begin(), inputBuffer.getSize());
		inputBuffer.clear();
		container = m_resource->getContents<hkRootLevelContainer>();
	}
	HK_ASSERT2(0xa6451543, container != HK_NULL, "Could not load root level obejct" );
	hkpPhysicsData* physicsData = static_cast<hkpPhysicsData*>( container->findObjectByType( hkpPhysicsDataClass.getName() ) );
	HK_ASSERT2(0xa6451544, physicsData != HK_NULL, "Could not find physics data in root level object" );
	HK_ASSERT2(0xa6451535, physicsData->getWorldCinfo() != HK_NULL, "No physics cinfo in loaded file - cannot create a hkpWorld" );

	// Create a world and add the physics systems to it
	m_world = new hkpWorld( *physicsData->getWorldCinfo() );
	m_world->lock();

	// Register all collision agents
	hkpAgentRegisterUtil::registerAllAgents( m_world->getCollisionDispatcher() );

	// Add all the physics systems to the world
	for ( int i = 0; i < physicsData->getPhysicsSystems().getSize(); ++i )
	{
		m_world->addPhysicsSystem( physicsData->getPhysicsSystems()[i] );
	}

	// Setup graphics - this creates graphics objects for all rigid bodies and phantoms in the world
	setupGraphics();

	m_world->unlock();
}

NativePackfileLoadDemo::~NativePackfileLoadDemo()
{
	// Re-enable warning
	hkError::getInstance().setEnabled(0xf03243ed, true);
	hkError::getInstance().setEnabled(0x9fe65234, true);

	m_world->markForWrite();
	m_world->removeReference();
	m_world = HK_NULL;

	if(m_variantId == 0)
	{
		hkNativePackfileUtils::unload(m_dataBuffer.begin(), m_dataBuffer.getCapacity());
	}
	else if(m_variantId == 1)
	{
		hkNativePackfileUtils::unloadInPlace(m_dataBuffer.begin(), m_dataBuffer.getCapacity());
	}
	else if(m_variantId == 2)
	{
		delete m_resource;
	}
}

hkDemo::Result NativePackfileLoadDemo::stepDemo()
{
	return hkDefaultPhysics2012Demo::stepDemo();
}


static const char helpString[] = \
"This demo demonstrates how to load a native physics file.";

// loading float32 assets in double64 builds is not supported
#if defined(HK_REAL_IS_DOUBLE)
#define THIS_DEMO_TYPE (HK_DEMO_TYPE_PHYSICS_2012 | HK_DEMO_TYPE_SERIALIZE)
#else
#define THIS_DEMO_TYPE (HK_DEMO_TYPE_PHYSICS_2012 | HK_DEMO_TYPE_SERIALIZE | HK_DEMO_TYPE_CRITICAL)
#endif
HK_DECLARE_DEMO_VARIANT(NativePackfileLoadDemo, THIS_DEMO_TYPE, "Native Binary",  0 , "Shows how to load a native binary physics file", helpString);
HK_DECLARE_DEMO_VARIANT(NativePackfileLoadDemo, THIS_DEMO_TYPE, "Native Binary Inplace",  1 , "Shows how to load a native binary physics file inplace", helpString);
HK_DECLARE_DEMO_VARIANT(NativePackfileLoadDemo, THIS_DEMO_TYPE, "Native Binary Resource",  2 , "Shows how to load a native packfile wrapped in a resource", helpString);

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
