/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#include <Demos/demos.h>
#include <Common/Serialize/hkSerialize.h>
#include <Common/Serialize/Util/hkSerializeUtil.h>
#include <Common/Serialize/Util/hkNativePackfileUtils.h>
#include <Common/Base/System/Io/FileSystem/hkFileSystem.h>

class LoadAllDemo : public hkDefaultDemo
{
public:

	LoadAllDemo( hkDemoEnvironment* env)
		: hkDefaultDemo(env), m_done(false), m_color(hkColor::RED)
	{
	}

	Result stepDemo()
	{
		if(!m_done)
		{
			hkError::getInstance().setEnabled(0x6088f48f, false); // assert type is not registered in the xml packfile reader
			hkError::getInstance().setEnabled(0x5ef4a323, false); // warning in detectFormat that the file format is unknown
			hkError::getInstance().setEnabled(0x371d81e7, false); // unable to version data warning			

			hkFileSystem::Iterator it(&hkFileSystem::getInstance(), "Resources/");
			while(it.advance())
			{
				const hkFileSystem::Entry& entry = it.current();
				if(entry.isDir())
				{
					it.recurseInto(entry.getPath());
				}
				else
				{
					hkSerializeUtil::ErrorDetails error;
					hkRefPtr<hkResource> res = hkRefNew<hkResource>(hkSerializeUtil::load(entry.getPath(), &error));
					if(!res)
					{				
						switch(error.id)
						{
							case hkSerializeUtil::ErrorDetails::ERRORID_UNSUPPORTED_FORMAT:
								// todo: regexp to check that entry.getPath() is really of an unsupported format?
								break;

							case hkSerializeUtil::ErrorDetails::ERRORID_PACKFILE_PLATFORM:
								// ok to fail here.
								break;

							case hkSerializeUtil::ErrorDetails::ERRORID_VERSIONING_FAILED:
								// this probably means that some types are missing, probably ok.
								break;

							default:
								hkStringBuf err; err.printf("Failed to load %s (error=%d, message=%s).\n", entry.getPath(), (hkSerializeUtil::ErrorDetails::ErrorID) error.id, error.defaultMessage.cString());
								hkprintf(err.cString());
								m_errorMsg.append(err.cString());
						}
					}
					else
					{
						hkArray<hkResource::Import> impOut;
						hkArray<hkResource::Export> expOut;
						res->getImportsExports(impOut, expOut);
					}
				}
			}	

			if(m_errorMsg.getLength() == 0)
			{
				m_errorMsg.printf("No errors.\n");
				m_color = hkColor::GREEN;
			}

			hkError::getInstance().setEnabled(0x6088f48f, true);
			hkError::getInstance().setEnabled(0x5ef4a323, true);
			hkError::getInstance().setEnabled(0x371d81e7, true);

			m_done = true;
		}


		m_env->m_textDisplay->outputText(m_errorMsg.cString(), 20, 150, m_color);

		return DEMO_OK;
	}

	bool m_done;
	hkStringBuf m_errorMsg;
	hkColor::Argb m_color;
};


static const char helpText[] = \
	"This demo tries to load every file it find in the Resource/ folder.\n";



HK_DECLARE_DEMO(LoadAllDemo, HK_DEMO_TYPE_SERIALIZE, "LoadAllDemo", helpText);

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
