/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */
#include <Demos/demos.h>
#include <Common/Base/hkBase.h>
#include <Common/Compat/hkCompat.h>
#include <Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Serialize/Data/hkDataObject.h>
#include <Common/Base/Reflection/hkClass.h>
#include <Common/Base/Reflection/hkClassMember.h>
#include <Common/Base/Reflection/hkInternalClassMember.h>
#include <Common/Base/Reflection/hkClassMemberAccessor.h>
#include <Demos/Common/Api/Serialize/CustomPatches/CustomPatchesDemo.h>
#include <Common/Base/KeyCode.h>

//
// Example function patch
//
// The object being patched is wrapped in a hkDataObject
// This can be accessed as a dictionary of members
// Member values are of type hkDataObject::Value,
// asInt(), asInt64(), asReal() etc. provide access
// to the native type
static void HK_CALL CustomContainer_0_to_1(hkDataObject& obj)
{
	hkReal obj_realMember = obj["realMember"].asReal();
	if(obj_realMember > 0.0f)
	{
		obj["positive"] = 1;
	}
	else
	{
		obj["positive"] = 0;
	}
}

// This automatically registers the patches from the HK_PATCHES_FILE
// with the given hkVersionPatchmanager
void HK_CALL CustomRegisterPatches(hkVersionPatchManager& man)
{
#	define HK_PATCHES_FILE <Demos/Common/Api/Serialize/CustomPatches/CustomPatches.cxx>
#	include <Common/Serialize/Version/hkVersionPatchManager.cxx>
#	undef HK_PATCHES_FILE
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
