/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_BROWSEDEMO_H
#define HK_BROWSEDEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultDemo.h>
#include <Demos/DemoCommon/Utilities/FileBrowser/FileBrowser.h>

class hkResource;
class hkPackfileData;
class hkRootLevelContainer;

/// This demo shows how browse the filesystem to load a resource file.
class BrowseDemo : public hkDefaultDemo
{
	public:

		enum Variant
		{
			VARIANT_LOAD_FLAT,
			VARIANT_LOAD_HEAP,
		};

		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
		BrowseDemo( hkDemoEnvironment* env );
		~BrowseDemo();

		Result stepDemo();

	protected:

		hkResult readAndSetupPackfile(const char* filename);

	protected:

		FileBrowser m_fileBrowser;
		hkRefPtr<hkResource> m_loadedData; // A handle to a deallocator which will deallocate loaded data if any
		hkRootLevelContainer* m_contents; //
		hkBool32 m_running;
};

#endif // HK_BROWSEDEMO_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
