/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#include <Demos/demos.h>

#include <Graphics/Common/Window/hkgWindow.h>

#include <Demos/Common/Api/Serialize/Browse/BrowseDemo.h>
#include <Common/Serialize/Util/hkRootLevelContainer.h>
#include <Common/Serialize/Util/hkSerializeUtil.h>

#define START_HORIZONTAL (20+m_env->m_window->getTVDeadZoneH())
#define START_VERTICAL (20+m_env->m_window->getTVDeadZoneV())

BrowseDemo::BrowseDemo( hkDemoEnvironment* env) 
:	hkDefaultDemo(env)
,	m_contents(HK_NULL)
,	m_running(false)
{
	// Disable warning: 'm_contactRestingVelocity not set, setting it to REAL_MAX, so that the new collision restitution code will be disabled'
	hkError::getInstance().setEnabled(0xf03243ed, false);
	
	// Setup the camera
	{
		hkVector4 from(31, 31, 14);
		hkVector4 to(2.5f, -2, -.3f);
		hkVector4 up(0, 0, 1);
		setupDefaultCameras( env, from, to, up );
	}
	m_fileBrowser.m_curDir = "Resources";
}

BrowseDemo::~BrowseDemo()
{
	// Re-enable warning
	hkError::getInstance().setEnabled(0xf03243ed, true);
}

hkResult BrowseDemo::readAndSetupPackfile(const char* filename)
{
	if( m_env->m_variantId == VARIANT_LOAD_FLAT )
	{
		if( hkResource* res = hkSerializeUtil::load(filename) )
		{
			m_contents = res->getContents<hkRootLevelContainer>();
			m_loadedData.setAndDontIncrementRefCount(res);
		}
	}
	else if( m_env->m_variantId == VARIANT_LOAD_HEAP )
	{
		if( hkObjectResource* res = hkSerializeUtil::loadOnHeap(filename) )
		{
			m_contents = res->getContents<hkRootLevelContainer>();
			m_loadedData.setAndDontIncrementRefCount(res);
		}
	}

	if( m_loadedData == HK_NULL )
	{
		HK_WARN(0xa6451543, "Could not load the file" );
	}
	else
	{
		hkArray<hkResource::Import> impOut;
		hkArray<hkResource::Export> expOut;
		m_loadedData->getImportsExports(impOut, expOut);
	}

	return HK_FAILURE;
}


hkDemo::Result BrowseDemo::stepDemo()
{
	// the file list must be displayed only if we have the directory contents and 
	// we have not loaded a file yet
	if( m_contents == HK_NULL )
	{
		if(m_fileBrowser.parseAndDisplayDirectoryAndFiles( m_env, 20, 20, true ))
		{
			hkStringBuf fname( m_fileBrowser.m_curDir, "/", m_fileBrowser.m_listing.getEntries()[m_fileBrowser.m_curIndex].getPath() );
			if( readAndSetupPackfile( fname.cString() ) == HK_SUCCESS )
			{
				// this is necessary because the first time it was called the world was NULL
				// and setup was not completed
				postConstruct(); 
				m_fileBrowser.m_curDir = fname; // abuse m_curDir and store loaded filename
			}
		}
	}
	else
	{
		int startH = START_HORIZONTAL; 
		int startV = START_VERTICAL; 

		hkStringBuf s; s.printf("%s loaded\nPress \x10 to %spause\n\x12 or 'X' for an XML snapshot\n\x13 or 'B' for a binary snapshot",
			m_fileBrowser.m_curDir.cString(), m_running ? "" : "un" );
		m_env->m_textDisplay->outputText(s, startH, startV, 0xffffffff);
		startV += 4*20;
		const hkgPad& pad = *m_env->m_gamePad;
		const hkgKeyboard& key = m_env->m_window->getKeyboard();
		if( pad.wasButtonPressed( HKG_PAD_BUTTON_0 ) )
		{
			m_running = !m_running;
		}
		int useBinary = -1;
		if( pad.wasButtonPressed( HKG_PAD_BUTTON_2 ) || key.wasKeyPressed('X') )
		{
			useBinary = 0;
		}
		else if( pad.wasButtonPressed( HKG_PAD_BUTTON_3 ) || key.wasKeyPressed('B') )
		{
			useBinary = 1;
		}

		if( useBinary != -1 )
		{
			hkStringBuf fname( m_fileBrowser.m_curDir, "_SNAP.hkx" );
			hkOstream os( fname.cString() );
			hkSerializeUtil::save( m_contents, os.getStreamWriter() ); //todo:useBinary
			s.printf("Wrote to %s", fname.cString() );
			m_env->m_textDisplay->outputText(s, startH, startV, 0xffffffff, 120 );
		}
	}
	if( m_running )
	{
		return hkDefaultDemo::stepDemo();
	}
	return DEMO_OK;
}


static const char helpString[] = \
"This demo loads havok files and can reexport as xml or binary.\n" \
"Use arrow keys and \x10 to start";

HK_DECLARE_DEMO_VARIANT(BrowseDemo, HK_DEMO_TYPE_TEST, "LoadFlattened", 0, helpString, "This variant loads files with flattened (packfile-like) memory");
HK_DECLARE_DEMO_VARIANT(BrowseDemo, HK_DEMO_TYPE_TEST, "LoadOnHeap", 1, helpString, "This variant loads files with individual refcounts");

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
