/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */
#ifndef CLASS_WITH_ATTRIBUTES_H
#define CLASS_WITH_ATTRIBUTES_H

#include <Demos/Common/Api/CustomAttributes/ExampleAttributes.h>

extern const class hkClass ClassWithAttributesClass;

/// A fictional game object with custom attribute markup for use by tools.
/// The attributes are generated by plugins in the Tools/Serialize/attributes/ folder.
/// In this case all attributes are in the "Example" module.
class ClassWithAttributes
{
	public:
	HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,ClassWithAttributes);
		//+Example.IconPath("resources/icons/CustomAttributes.png")
		//+Example.VisibleInTool(true)
		//+Example.GuiLayoutOrder(4,0,1)

		HK_DECLARE_REFLECTION();

		int m_mass;
			//+Example.IconPath("resources/icons/heavy.png")
			
		hkReal m_restitution;
			//+Example.GroupWith("mass")
			//+Example.RangeReal( absmin=0, softmax=1.0, absmax=1.8 )

		const char* m_pathToResource;
			//+Example.StringRole("ROLE_FILENAME")
			//+Example.Filename(globpattern="*.hk*:*.xml", storeAs="relative")
			
		const char* m_name;
			//+Example.StringRole("ROLE_IDENTIFIER")
			//+Example.IconData("IconData_Identifier")
};

#endif //CLASS_WITH_ATTRIBUTES_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
