/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */
#include <Demos/demos.h>
#include <Common/Base/Config/hkOptionalComponent.h>
#include <Demos/Common/Api/Base/RegisterCheck/ExampleSystem.h>


class RegisterCheckDemo : public hkDefaultDemo
{
	public:

		RegisterCheckDemo( hkDemoEnvironment* env)
			: hkDefaultDemo(env)
		{
			HK_OPTIONAL_COMPONENT_REQUEST(ExampleSystem);
			HK_OPTIONAL_COMPONENT_REQUEST(AlternateExampleSystem);
		}

		Result stepDemo()
		{
			if( m_env->m_window->getKeyboard().wasKeyPressed(HKG_VKEY_SPACE) )
			{
				ExampleSystem* sys = ExampleSystem::create();
				sys->doSomething();
				delete sys;
			}

			hkStringBuf sb = "The following systems are linked in.\n" \
				"Used systems are marked with an 'X', unused with a '.'\n" \
				"If there are no systems marked as used, try running another demo before this one\n\n";

			for( const hkOptionalComponent* cur = hkOptionalComponent::getFirstComponent(); cur != HK_NULL; cur = cur->getNext() )
			{
				sb.appendPrintf("%s\t%s\n", cur->isUsed()?"X":".", cur->getName());
			}
			m_env->m_textDisplay->outputText(sb, 20, 120, 0xffffffff);
			return DEMO_OK;
		}
};


HK_DECLARE_DEMO(RegisterCheckDemo, HK_DEMO_TYPE_PHYSICS, "Check for unused but linked systems", HK_NULL);

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
