/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */
#ifndef HK_EXAMPLE_SYSTEM_H
#define HK_EXAMPLE_SYSTEM_H

class ExampleSystem : public hkReferencedObject
{
	public:

		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);
			
			// typedef for readability
		typedef ExampleSystem* (*CreateFunction)();

			// This is the "normal" way of creating ExampleSystem objects.	
			// It is a function pointer so can be set to null if unused.
			// The pointer can also be replaced to return a derived object.
		static CreateFunction create;

			// Directly create an ExampleSystem. This creates a hard dependency on ExampleSystem,
			// it is analogous to calling new ExampleSystem. We need this auxiliary function because
			// we can't assign the constructor to the create function pointer.
		static ExampleSystem* createExampleSystem();

		virtual void doSomething();

	protected:

		ExampleSystem();
};

#endif //HK_EXAMPLE_SYSTEM_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
