/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */
#include <Demos/demos.h>
#include <Demos/Common/Api/Base/RegisterCheck/ExampleSystem.h>
#include <Common/Base/Config/hkOptionalComponent.h>

ExampleSystem::ExampleSystem()
{
}

void ExampleSystem::doSomething()
{
}


ExampleSystem::CreateFunction ExampleSystem::create; // defaults to null

ExampleSystem* ExampleSystem::createExampleSystem()
{
	HK_OPTIONAL_COMPONENT_MARK_USED(ExampleSystem);
	return new ExampleSystem();
}
// First parameter - an arbitrary identifier (it need not match the class name exactly)
// Second parameter - the function pointer which will be set if this component is requested
// Third parameter - the value the function pointer will be set to
HK_OPTIONAL_COMPONENT_DEFINE(ExampleSystem, ExampleSystem::create, ExampleSystem::createExampleSystem);






	/// This is an example of how to replace a component with another.
	/// Instead of calling HK_OPTIONAL_COMPONENT_DEFINE(ExampleSystem) one would
	/// call HK_OPTIONAL_COMPONENT_DEFINE(AlternateExampleSystem) to use this one.
class AlternateExampleSystem : public ExampleSystem
{
	public:

		static ExampleSystem* createExampleSystem()
		{
			HK_OPTIONAL_COMPONENT_MARK_USED(AlternateExampleSystem);
			return new AlternateExampleSystem;
		}

		virtual void doSomething() { }

	protected:

		AlternateExampleSystem() {}
};

HK_OPTIONAL_COMPONENT_DEFINE(AlternateExampleSystem, ExampleSystem::create, AlternateExampleSystem::createExampleSystem);

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
