/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */
//HK_REFLECTION_PARSER_EXCLUDE_FILE

#include <Demos/demos.h>
static const char s_libraryName[] = "Demos";
#include <Common/Base/KeyCode.h>

// Make VAX ignore symbols from this file


#if defined(HK_FEATURE_PRODUCT_ANIMATION)
#include <Common/Base/Memory/Tracker/hkTrackerClassDefinition.h>

 void HK_CALL DemosANIMATIONRegister() {}

#include <Demos/Animation/Api/Blending/Additive/AdditiveBlendingDemo.h>


// AdditiveBlendingDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AdditiveBlendingDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AdditiveBlendingDemo)
    HK_TRACKER_MEMBER(AdditiveBlendingDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(AdditiveBlendingDemo, m_skeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(AdditiveBlendingDemo, m_binding, 0, "hkaAnimationBinding* [2]") // class hkaAnimationBinding* [2]
    HK_TRACKER_MEMBER(AdditiveBlendingDemo, m_control, 0, "hkaDefaultAnimationControl* [2]") // class hkaDefaultAnimationControl* [2]
    HK_TRACKER_MEMBER(AdditiveBlendingDemo, m_skeletonInstance, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
    HK_TRACKER_MEMBER(AdditiveBlendingDemo, m_skinBindings, 0, "hkArray<hkaMeshBinding *, hkContainerHeapAllocator>") // hkArray< class hkaMeshBinding *, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(AdditiveBlendingDemo, m_attachments, 0, "hkArray<hkaBoneAttachment *, hkContainerHeapAllocator>") // hkArray< class hkaBoneAttachment *, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(AdditiveBlendingDemo, m_attachmentObjects, 0, "hkArray<hkgDisplayObject*, hkContainerHeapAllocator>") // hkArray< class hkgDisplayObject*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(AdditiveBlendingDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Api/Blending/Normal/NormalBlendingDemo.h>


// NormalBlendingDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(NormalBlendingDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(NormalBlendingDemo)
    HK_TRACKER_MEMBER(NormalBlendingDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(NormalBlendingDemo, m_skeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(NormalBlendingDemo, m_animation, 0, "hkaAnimation* [2]") // class hkaAnimation* [2]
    HK_TRACKER_MEMBER(NormalBlendingDemo, m_binding, 0, "hkaAnimationBinding* [2]") // class hkaAnimationBinding* [2]
    HK_TRACKER_MEMBER(NormalBlendingDemo, m_control, 0, "hkaDefaultAnimationControl* [2]") // class hkaDefaultAnimationControl* [2]
    HK_TRACKER_MEMBER(NormalBlendingDemo, m_skeletonInstance, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
    HK_TRACKER_MEMBER(NormalBlendingDemo, m_skinBindings, 0, "hkArray<hkaMeshBinding *, hkContainerHeapAllocator>") // hkArray< class hkaMeshBinding *, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(NormalBlendingDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Api/Compression/Advanced/PerBoneCompressionDemo.h>


// PerBoneCompressionDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(PerBoneCompressionDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(PerBoneCompressionDemo)
    HK_TRACKER_MEMBER(PerBoneCompressionDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(PerBoneCompressionDemo, m_skeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(PerBoneCompressionDemo, m_animationRecords, 0, "hkArray<TestRecord*, hkContainerHeapAllocator>") // hkArray< class TestRecord*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(PerBoneCompressionDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Api/Compression/Standard/CompressionDemo.h>


// CompressionDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(CompressionDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(CompressionDemo)
    HK_TRACKER_MEMBER(CompressionDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(CompressionDemo, m_skeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(CompressionDemo, m_animationRecords, 0, "hkArray<TestRecord*, hkContainerHeapAllocator>") // hkArray< class TestRecord*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(CompressionDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Api/InverseKinematics/Crabby/CrabbyDemo.h>


// CrabbyDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(CrabbyDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(CrabbyDemo)
    HK_TRACKER_MEMBER(CrabbyDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(CrabbyDemo, m_skeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(CrabbyDemo, m_animation, 0, "hkaAnimation*") // class hkaAnimation*
    HK_TRACKER_MEMBER(CrabbyDemo, m_binding, 0, "hkaAnimationBinding*") // class hkaAnimationBinding*
    HK_TRACKER_MEMBER(CrabbyDemo, m_skinBindings, 0, "hkArray<hkaMeshBinding *, hkContainerHeapAllocator>") // hkArray< class hkaMeshBinding *, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(CrabbyDemo, m_crabbyModelPose, 0, "hkaPose*") // class hkaPose*
    HK_TRACKER_MEMBER(CrabbyDemo, m_solvers, 0, "hkArray<hkaThreeJointsIkSolver*, hkContainerHeapAllocator>") // hkArray< class hkaThreeJointsIkSolver*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(CrabbyDemo, m_legMovement, 0, "hkArray<CrabbyDemoLegMovement*, hkContainerHeapAllocator>") // hkArray< class CrabbyDemoLegMovement*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(CrabbyDemo, m_geometry, 0, "hkGeometry*") // struct hkGeometry*
    HK_TRACKER_MEMBER(CrabbyDemo, m_displayConvex, 0, "hkDisplayConvex*") // class hkDisplayConvex*
    HK_TRACKER_MEMBER(CrabbyDemo, m_geometryArray, 0, "hkArray<hkDisplayGeometry*, hkContainerHeapAllocator>") // hkArray< class hkDisplayGeometry*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(CrabbyDemo, s_libraryName, FootIkDemoBase)

#include <Demos/Animation/Api/InverseKinematics/FootIk/FootIkDemo.h>


// FootIkDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(FootIkDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(WhichLeg)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(FootIkDemo)
    HK_TRACKER_MEMBER(FootIkDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(FootIkDemo, m_skeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(FootIkDemo, m_animation, 0, "hkaAnimation* [2]") // class hkaAnimation* [2]
    HK_TRACKER_MEMBER(FootIkDemo, m_skinBindings, 0, "hkArray<hkaMeshBinding *, hkContainerHeapAllocator>") // hkArray< class hkaMeshBinding *, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(FootIkDemo, m_skeletonInstance, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
    HK_TRACKER_MEMBER(FootIkDemo, m_binding, 0, "hkaAnimationBinding* [2]") // class hkaAnimationBinding* [2]
    HK_TRACKER_MEMBER(FootIkDemo, m_control, 0, "hkaDefaultAnimationControl* [2]") // class hkaDefaultAnimationControl* [2]
    HK_TRACKER_MEMBER(FootIkDemo, m_geometry, 0, "hkGeometry*") // struct hkGeometry*
    HK_TRACKER_MEMBER(FootIkDemo, m_displayConvex, 0, "hkDisplayConvex*") // class hkDisplayConvex*
    HK_TRACKER_MEMBER(FootIkDemo, m_geometryArray, 0, "hkArray<hkDisplayGeometry*, hkContainerHeapAllocator>") // hkArray< class hkDisplayGeometry*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(FootIkDemo, m_footPlacementComponent, 0, "hkaFootPlacementIkSolver* [2]") // class hkaFootPlacementIkSolver* [2]
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(FootIkDemo, s_libraryName, FootIkDemoBase)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(FootIkDemo, WhichLeg, s_libraryName)

#include <Demos/Animation/Api/InverseKinematics/FootIkDemoBase.h>


// FootIkDemoBase ::

HK_TRACKER_DECLARE_CLASS_BEGIN(FootIkDemoBase)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(FootIkDemoBase)
    HK_TRACKER_MEMBER(FootIkDemoBase, m_landscapeShape, 0, "hkReferencedObject*") // class hkReferencedObject*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(FootIkDemoBase, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Api/InverseKinematics/LookAt/LookAtDemo.h>


// LookAtDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(LookAtDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(LookAtDemo)
    HK_TRACKER_MEMBER(LookAtDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(LookAtDemo, m_skeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(LookAtDemo, m_animation, 0, "hkaAnimation*") // class hkaAnimation*
    HK_TRACKER_MEMBER(LookAtDemo, m_skinBindings, 0, "hkArray<hkaMeshBinding *, hkContainerHeapAllocator>") // hkArray< class hkaMeshBinding *, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(LookAtDemo, m_skeletonInstance, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
    HK_TRACKER_MEMBER(LookAtDemo, m_binding, 0, "hkaAnimationBinding*") // class hkaAnimationBinding*
    HK_TRACKER_MEMBER(LookAtDemo, m_control, 0, "hkaDefaultAnimationControl*") // class hkaDefaultAnimationControl*
    HK_TRACKER_MEMBER(LookAtDemo, m_attachments, 0, "hkArray<hkaBoneAttachment *, hkContainerHeapAllocator>") // hkArray< class hkaBoneAttachment *, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(LookAtDemo, m_attachmentObjects, 0, "hkArray<hkgDisplayObject*, hkContainerHeapAllocator>") // hkArray< class hkgDisplayObject*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(LookAtDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Api/InverseKinematics/Reaching/ReachingDemo.h>


// ReachingDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ReachingDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ReachingDemo)
    HK_TRACKER_MEMBER(ReachingDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(ReachingDemo, m_skeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(ReachingDemo, m_animation, 0, "hkaAnimation*") // class hkaAnimation*
    HK_TRACKER_MEMBER(ReachingDemo, m_skinBindings, 0, "hkArray<hkaMeshBinding *, hkContainerHeapAllocator>") // hkArray< class hkaMeshBinding *, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(ReachingDemo, m_skeletonInstance, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
    HK_TRACKER_MEMBER(ReachingDemo, m_binding, 0, "hkaAnimationBinding*") // class hkaAnimationBinding*
    HK_TRACKER_MEMBER(ReachingDemo, m_control, 0, "hkaDefaultAnimationControl*") // class hkaDefaultAnimationControl*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ReachingDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Api/LayeringAndPartitions/Additive/AdditivePartitions.h>


// AdditivePartitions ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AdditivePartitions)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AdditivePartitions)
    HK_TRACKER_MEMBER(AdditivePartitions, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(AdditivePartitions, m_skeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(AdditivePartitions, m_binding, 0, "hkaAnimationBinding* [2]") // class hkaAnimationBinding* [2]
    HK_TRACKER_MEMBER(AdditivePartitions, m_skinBindings, 0, "hkArray<hkaMeshBinding *, hkContainerHeapAllocator>") // hkArray< class hkaMeshBinding *, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(AdditivePartitions, m_control, 0, "hkaDefaultAnimationControl* [2]") // class hkaDefaultAnimationControl* [2]
    HK_TRACKER_MEMBER(AdditivePartitions, m_skeletonInstance, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(AdditivePartitions, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Api/LayeringAndPartitions/Mirroring/MirroringPartitions.h>


// MirroringPartitionsDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MirroringPartitionsDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MirroringPartitionsDemo)
    HK_TRACKER_MEMBER(MirroringPartitionsDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(MirroringPartitionsDemo, m_skeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(MirroringPartitionsDemo, m_animation, 0, "hkaAnimation* [3]") // class hkaAnimation* [3]
    HK_TRACKER_MEMBER(MirroringPartitionsDemo, m_binding, 0, "hkaAnimationBinding* [3]") // class hkaAnimationBinding* [3]
    HK_TRACKER_MEMBER(MirroringPartitionsDemo, m_skinBindings, 0, "hkArray<hkaMeshBinding *, hkContainerHeapAllocator>") // hkArray< class hkaMeshBinding *, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(MirroringPartitionsDemo, m_control, 0, "hkaDefaultAnimationControl* [3]") // class hkaDefaultAnimationControl* [3]
    HK_TRACKER_MEMBER(MirroringPartitionsDemo, m_skeletonInstance, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(MirroringPartitionsDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Api/LayeringAndPartitions/Multithreading/SampleOnly/SampleOnlyPartitionsMultithreadingDemo.h>


// SampleOnlyPartitionsMultithreadingDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SampleOnlyPartitionsMultithreadingDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SampleOnlyPartitionsMultithreadingDemo)
    HK_TRACKER_MEMBER(SampleOnlyPartitionsMultithreadingDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(SampleOnlyPartitionsMultithreadingDemo, m_skeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(SampleOnlyPartitionsMultithreadingDemo, m_animation, 0, "hkaAnimation*") // class hkaAnimation*
    HK_TRACKER_MEMBER(SampleOnlyPartitionsMultithreadingDemo, m_binding, 0, "hkaAnimationBinding*") // class hkaAnimationBinding*
    HK_TRACKER_MEMBER(SampleOnlyPartitionsMultithreadingDemo, m_controls, 0, "hkArray<hkaDefaultAnimationControl*, hkContainerHeapAllocator>") // hkArray< class hkaDefaultAnimationControl*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(SampleOnlyPartitionsMultithreadingDemo, m_windowedAverage, 0, "WindowedAverage*") // class WindowedAverage*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SampleOnlyPartitionsMultithreadingDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Api/LayeringAndPartitions/PartitionPlayback/PartitionPlaybackDemo.h>


// PartitionPlaybackDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(PartitionPlaybackDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(PartitionPlaybackDemo)
    HK_TRACKER_MEMBER(PartitionPlaybackDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(PartitionPlaybackDemo, m_skeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(PartitionPlaybackDemo, m_animation, 0, "hkaAnimation* [2]") // class hkaAnimation* [2]
    HK_TRACKER_MEMBER(PartitionPlaybackDemo, m_binding, 0, "hkaAnimationBinding* [2]") // class hkaAnimationBinding* [2]
    HK_TRACKER_MEMBER(PartitionPlaybackDemo, m_skinBindings, 0, "hkArray<hkaMeshBinding *, hkContainerHeapAllocator>") // hkArray< class hkaMeshBinding *, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(PartitionPlaybackDemo, m_control, 0, "hkaDefaultAnimationControl* [2]") // class hkaDefaultAnimationControl* [2]
    HK_TRACKER_MEMBER(PartitionPlaybackDemo, m_skeletonInstance, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(PartitionPlaybackDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Api/LayeringAndPartitions/Retargeting/RetargetingPartitionsDemo.h>


// RetargetingPartitionsDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(RetargetingPartitionsDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(RetargetingPartitionsDemo)
    HK_TRACKER_MEMBER(RetargetingPartitionsDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(RetargetingPartitionsDemo, m_animatedSkeleton, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
    HK_TRACKER_MEMBER(RetargetingPartitionsDemo, m_binding, 0, "hkaAnimationBinding*") // class hkaAnimationBinding*
    HK_TRACKER_MEMBER(RetargetingPartitionsDemo, m_skeleton, 0, "hkaSkeleton* [2]") // class hkaSkeleton* [2]
    HK_TRACKER_MEMBER(RetargetingPartitionsDemo, m_skinBindings, 0, "hkArray<hkaMeshBinding *, hkContainerHeapAllocator> [2]") // hkArray< class hkaMeshBinding *, struct hkContainerHeapAllocator > [2]
    HK_TRACKER_MEMBER(RetargetingPartitionsDemo, m_mapper, 0, "hkaSkeletonMapper*") // class hkaSkeletonMapper*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(RetargetingPartitionsDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Api/MeshAndDeformation/Attachments/AttachmentsDemo.h>


// AttachmentsDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AttachmentsDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AttachmentsDemo)
    HK_TRACKER_MEMBER(AttachmentsDemo, m_animation, 0, "hkaAnimation*") // class hkaAnimation*
    HK_TRACKER_MEMBER(AttachmentsDemo, m_skeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(AttachmentsDemo, m_binding, 0, "hkaAnimationBinding*") // class hkaAnimationBinding*
    HK_TRACKER_MEMBER(AttachmentsDemo, m_skeletonInstance, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
    HK_TRACKER_MEMBER(AttachmentsDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(AttachmentsDemo, m_skinBindings, 0, "hkArray<hkaMeshBinding *, hkContainerHeapAllocator>") // hkArray< class hkaMeshBinding *, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(AttachmentsDemo, m_attachments, 0, "hkArray<hkaBoneAttachment *, hkContainerHeapAllocator>") // hkArray< class hkaBoneAttachment *, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(AttachmentsDemo, m_attachmentObjects, 0, "hkArray<hkgDisplayObject*, hkContainerHeapAllocator>") // hkArray< class hkgDisplayObject*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(AttachmentsDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Api/MeshAndDeformation/Scaling/ScalingDemo.h>


// ScalingDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ScalingDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ScalingDemo)
    HK_TRACKER_MEMBER(ScalingDemo, m_animation, 0, "hkaAnimation*") // class hkaAnimation*
    HK_TRACKER_MEMBER(ScalingDemo, m_skeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(ScalingDemo, m_binding, 0, "hkaAnimationBinding*") // class hkaAnimationBinding*
    HK_TRACKER_MEMBER(ScalingDemo, m_skeletonInstance, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
    HK_TRACKER_MEMBER(ScalingDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(ScalingDemo, m_skinBindings, 0, "hkArray<hkaMeshBinding *, hkContainerHeapAllocator>") // hkArray< class hkaMeshBinding *, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ScalingDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Api/MeshAndDeformation/Skinning/SkinningDemo.h>


// SkinningDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SkinningDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SkinningDemo)
    HK_TRACKER_MEMBER(SkinningDemo, m_animation, 0, "hkaAnimation*") // class hkaAnimation*
    HK_TRACKER_MEMBER(SkinningDemo, m_skeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(SkinningDemo, m_binding, 0, "hkaAnimationBinding*") // class hkaAnimationBinding*
    HK_TRACKER_MEMBER(SkinningDemo, m_skinBindings, 0, "hkArray<hkaMeshBinding *, hkContainerHeapAllocator>") // hkArray< class hkaMeshBinding *, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(SkinningDemo, m_skeletonInstance, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
    HK_TRACKER_MEMBER(SkinningDemo, m_loader, 0, "hkLoader*") // class hkLoader*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SkinningDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Api/MotionExtraction/BasicMovement/BasicMovementDemo.h>


// BasicMovementDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(BasicMovementDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(BasicMovementDemo)
    HK_TRACKER_MEMBER(BasicMovementDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(BasicMovementDemo, m_skeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(BasicMovementDemo, m_animation, 0, "hkaAnimation* [3]") // class hkaAnimation* [3]
    HK_TRACKER_MEMBER(BasicMovementDemo, m_binding, 0, "hkaAnimationBinding* [3]") // class hkaAnimationBinding* [3]
    HK_TRACKER_MEMBER(BasicMovementDemo, m_control, 0, "hkaDefaultAnimationControl* [3]") // class hkaDefaultAnimationControl* [3]
    HK_TRACKER_MEMBER(BasicMovementDemo, m_skeletonInstance, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
    HK_TRACKER_MEMBER(BasicMovementDemo, m_skinBindings, 0, "hkArray<hkaMeshBinding *, hkContainerHeapAllocator>") // hkArray< class hkaMeshBinding *, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(BasicMovementDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Api/MotionExtraction/MirroredMotion/MirroredMotionDemo.h>


// MirroredMotionDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MirroredMotionDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MirroredMotionDemo)
    HK_TRACKER_MEMBER(MirroredMotionDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(MirroredMotionDemo, m_skeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(MirroredMotionDemo, m_animation, 0, "hkaAnimation* [2]") // class hkaAnimation* [2]
    HK_TRACKER_MEMBER(MirroredMotionDemo, m_binding, 0, "hkaAnimationBinding* [2]") // class hkaAnimationBinding* [2]
    HK_TRACKER_MEMBER(MirroredMotionDemo, m_control, 0, "hkaDefaultAnimationControl* [2]") // class hkaDefaultAnimationControl* [2]
    HK_TRACKER_MEMBER(MirroredMotionDemo, m_skeletonInstance, 0, "hkaAnimatedSkeleton* [2]") // class hkaAnimatedSkeleton* [2]
    HK_TRACKER_MEMBER(MirroredMotionDemo, m_skinBindings, 0, "hkArray<hkaMeshBinding *, hkContainerHeapAllocator> [2]") // hkArray< class hkaMeshBinding *, struct hkContainerHeapAllocator > [2]
    HK_TRACKER_MEMBER(MirroredMotionDemo, m_attachments, 0, "hkArray<hkaBoneAttachment *, hkContainerHeapAllocator> [2]") // hkArray< class hkaBoneAttachment *, struct hkContainerHeapAllocator > [2]
    HK_TRACKER_MEMBER(MirroredMotionDemo, m_env, 0, "hkDemoEnvironment*") // class hkDemoEnvironment*
    HK_TRACKER_MEMBER(MirroredMotionDemo, m_attachmentObjects, 0, "hkArray<hkgDisplayObject*, hkContainerHeapAllocator> [2]") // hkArray< class hkgDisplayObject*, struct hkContainerHeapAllocator > [2]
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(MirroredMotionDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Api/MotionExtraction/MotionExtraction/MotionExtractionDemo.h>


// MotionExtractionDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MotionExtractionDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MotionExtractionDemo)
    HK_TRACKER_MEMBER(MotionExtractionDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(MotionExtractionDemo, m_skeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(MotionExtractionDemo, m_animation, 0, "hkaAnimation* [3]") // class hkaAnimation* [3]
    HK_TRACKER_MEMBER(MotionExtractionDemo, m_binding, 0, "hkaAnimationBinding* [3]") // class hkaAnimationBinding* [3]
    HK_TRACKER_MEMBER(MotionExtractionDemo, m_skinBindings, 0, "hkArray<hkaMeshBinding *, hkContainerHeapAllocator>") // hkArray< class hkaMeshBinding *, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(MotionExtractionDemo, m_control, 0, "hkaDefaultAnimationControl* [3]") // class hkaDefaultAnimationControl* [3]
    HK_TRACKER_MEMBER(MotionExtractionDemo, m_skeletonInstance, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(MotionExtractionDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Api/Multithreading/SampleOnly/SampleOnlyMultithreadingDemo.h>


// SampleOnlyMultithreadingDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SampleOnlyMultithreadingDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SampleOnlyMultithreadingDemo)
    HK_TRACKER_MEMBER(SampleOnlyMultithreadingDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(SampleOnlyMultithreadingDemo, m_skeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(SampleOnlyMultithreadingDemo, m_animation, 0, "hkaAnimation*") // class hkaAnimation*
    HK_TRACKER_MEMBER(SampleOnlyMultithreadingDemo, m_binding, 0, "hkaAnimationBinding*") // class hkaAnimationBinding*
    HK_TRACKER_MEMBER(SampleOnlyMultithreadingDemo, m_controls, 0, "hkArray<hkaDefaultAnimationControl*, hkContainerHeapAllocator>") // hkArray< class hkaDefaultAnimationControl*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(SampleOnlyMultithreadingDemo, m_windowedAverage, 0, "WindowedAverage*") // class WindowedAverage*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SampleOnlyMultithreadingDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Api/Playback/AnimatedSkeleton/AnimatedSkeletonDemo.h>


// AnimatedSkeletonDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AnimatedSkeletonDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AnimatedSkeletonDemo)
    HK_TRACKER_MEMBER(AnimatedSkeletonDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(AnimatedSkeletonDemo, m_skeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(AnimatedSkeletonDemo, m_animation, 0, "hkaAnimation*") // class hkaAnimation*
    HK_TRACKER_MEMBER(AnimatedSkeletonDemo, m_binding, 0, "hkaAnimationBinding*") // class hkaAnimationBinding*
    HK_TRACKER_MEMBER(AnimatedSkeletonDemo, m_activeSkeletons, 0, "hkArray<hkaAnimatedSkeleton*, hkContainerHeapAllocator>") // hkArray< class hkaAnimatedSkeleton*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(AnimatedSkeletonDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Api/Playback/Annotation/AnnotationDemo.h>


// AnnotationDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AnnotationDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AnnotationDemo)
    HK_TRACKER_MEMBER(AnnotationDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(AnnotationDemo, m_skeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(AnnotationDemo, m_binding, 0, "hkaAnimationBinding*") // class hkaAnimationBinding*
    HK_TRACKER_MEMBER(AnnotationDemo, m_animation, 0, "hkaAnimation*") // class hkaAnimation*
    HK_TRACKER_MEMBER(AnnotationDemo, m_skinBindings, 0, "hkArray<hkaMeshBinding *, hkContainerHeapAllocator>") // hkArray< class hkaMeshBinding *, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(AnnotationDemo, m_skeletonInstance, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
    HK_TRACKER_MEMBER(AnnotationDemo, m_loopControl, 0, "hkaDefaultAnimationControl*") // class hkaDefaultAnimationControl*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(AnnotationDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Api/Playback/Binding/BindingDemo.h>


// BindingDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(BindingDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(BindingDemo)
    HK_TRACKER_MEMBER(BindingDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(BindingDemo, m_skeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(BindingDemo, m_animation, 0, "hkaAnimation* [2]") // class hkaAnimation* [2]
    HK_TRACKER_MEMBER(BindingDemo, m_binding, 0, "hkaAnimationBinding* [2]") // class hkaAnimationBinding* [2]
    HK_TRACKER_MEMBER(BindingDemo, m_control, 0, "hkaDefaultAnimationControl* [2]") // class hkaDefaultAnimationControl* [2]
    HK_TRACKER_MEMBER(BindingDemo, m_skeletonInstance, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(BindingDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Api/Playback/Control/ControlDemo.h>


// ControlDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ControlDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ControlDemo)
    HK_TRACKER_MEMBER(ControlDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(ControlDemo, m_skeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(ControlDemo, m_animation, 0, "hkaAnimation*") // class hkaAnimation*
    HK_TRACKER_MEMBER(ControlDemo, m_binding, 0, "hkaAnimationBinding*") // class hkaAnimationBinding*
    HK_TRACKER_MEMBER(ControlDemo, m_skeletonInstance, 0, "hkaAnimatedSkeleton* [5]") // class hkaAnimatedSkeleton* [5]
    HK_TRACKER_MEMBER(ControlDemo, m_listener, 0, "MyControlListener* [5]") // class MyControlListener* [5]
    HK_TRACKER_MEMBER(ControlDemo, m_control, 0, "hkaDefaultAnimationControl* [5]") // class hkaDefaultAnimationControl* [5]
    HK_TRACKER_MEMBER(ControlDemo, description, 0, "char* [5]") // const char* [5]
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ControlDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Api/Playback/CycleControl/CycleControl.h>


// CycleControlDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(CycleControlDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(CycleControlDemo)
    HK_TRACKER_MEMBER(CycleControlDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(CycleControlDemo, m_skeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(CycleControlDemo, m_animation, 0, "hkaAnimation*") // class hkaAnimation*
    HK_TRACKER_MEMBER(CycleControlDemo, m_binding, 0, "hkaAnimationBinding*") // class hkaAnimationBinding*
    HK_TRACKER_MEMBER(CycleControlDemo, m_skinBindings, 0, "hkArray<hkaMeshBinding *, hkContainerHeapAllocator>") // hkArray< class hkaMeshBinding *, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(CycleControlDemo, m_control, 0, "hkaDefaultAnimationControl*") // class hkaDefaultAnimationControl*
    HK_TRACKER_MEMBER(CycleControlDemo, m_skeletonInstance, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(CycleControlDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Api/Playback/EaseCurves/EaseCurvesDemo.h>


// EaseCurvesDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(EaseCurvesDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(EaseCurvesDemo)
    HK_TRACKER_MEMBER(EaseCurvesDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(EaseCurvesDemo, m_skeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(EaseCurvesDemo, m_animation, 0, "hkaAnimation* [3]") // class hkaAnimation* [3]
    HK_TRACKER_MEMBER(EaseCurvesDemo, m_binding, 0, "hkaAnimationBinding* [3]") // class hkaAnimationBinding* [3]
    HK_TRACKER_MEMBER(EaseCurvesDemo, m_skinBindings, 0, "hkArray<hkaMeshBinding *, hkContainerHeapAllocator>") // hkArray< class hkaMeshBinding *, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(EaseCurvesDemo, m_control, 0, "hkaDefaultAnimationControl* [3]") // class hkaDefaultAnimationControl* [3]
    HK_TRACKER_MEMBER(EaseCurvesDemo, m_skeletonInstance, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
    HK_TRACKER_MEMBER(EaseCurvesDemo, m_texture, 0, "hkgTexture*") // class hkgTexture*
    HK_TRACKER_MEMBER(EaseCurvesDemo, m_context, 0, "hkgDisplayContext*") // class hkgDisplayContext*
    HK_TRACKER_MEMBER(EaseCurvesDemo, m_graphCanvasData, 0, "hkUint8*") // hkUint8*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(EaseCurvesDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Api/Playback/FloatTracks/FloatTracksDemo.h>


// FloatTracksDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(FloatTracksDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(FloatTracksDemo)
    HK_TRACKER_MEMBER(FloatTracksDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(FloatTracksDemo, m_skeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(FloatTracksDemo, m_originalAnimation, 0, "hkaAnimation*") // class hkaAnimation*
    HK_TRACKER_MEMBER(FloatTracksDemo, m_animations, 0, "hkaAnimation* [4]") // class hkaAnimation* [4]
    HK_TRACKER_MEMBER(FloatTracksDemo, m_originalBinding, 0, "hkaAnimationBinding*") // class hkaAnimationBinding*
    HK_TRACKER_MEMBER(FloatTracksDemo, m_bindings, 0, "hkaAnimationBinding* [4]") // class hkaAnimationBinding* [4]
    HK_TRACKER_MEMBER(FloatTracksDemo, m_activeSkeletons, 0, "hkArray<hkaAnimatedSkeleton*, hkContainerHeapAllocator>") // hkArray< class hkaAnimatedSkeleton*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(FloatTracksDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Api/Playback/IndividualBones/IndividualBoneSamplingDemo.h>


// IndividualBoneSamplingDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(IndividualBoneSamplingDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(IndividualBoneSamplingDemo)
    HK_TRACKER_MEMBER(IndividualBoneSamplingDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(IndividualBoneSamplingDemo, m_skeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(IndividualBoneSamplingDemo, m_animation, 0, "hkaAnimation*") // class hkaAnimation*
    HK_TRACKER_MEMBER(IndividualBoneSamplingDemo, m_binding, 0, "hkaAnimationBinding*") // class hkaAnimationBinding*
    HK_TRACKER_MEMBER(IndividualBoneSamplingDemo, m_character, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(IndividualBoneSamplingDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Api/Playback/Masking/MaskingDemo.h>


// MaskingDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MaskingDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MaskingDemo)
    HK_TRACKER_MEMBER(MaskingDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(MaskingDemo, m_animation, 0, "hkaAnimation* [2]") // class hkaAnimation* [2]
    HK_TRACKER_MEMBER(MaskingDemo, m_binding, 0, "hkaAnimationBinding* [2]") // class hkaAnimationBinding* [2]
    HK_TRACKER_MEMBER(MaskingDemo, m_skeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(MaskingDemo, m_control, 0, "hkaDefaultAnimationControl* [2]") // class hkaDefaultAnimationControl* [2]
    HK_TRACKER_MEMBER(MaskingDemo, m_skeletonInstance, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(MaskingDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Api/Playback/Mirroring/MirroringDemo.h>


// MirroringDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MirroringDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MirroringDemo)
    HK_TRACKER_MEMBER(MirroringDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(MirroringDemo, m_skeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(MirroringDemo, m_animation, 0, "hkaAnimation* [3]") // class hkaAnimation* [3]
    HK_TRACKER_MEMBER(MirroringDemo, m_binding, 0, "hkaAnimationBinding* [3]") // class hkaAnimationBinding* [3]
    HK_TRACKER_MEMBER(MirroringDemo, m_skinBindings, 0, "hkArray<hkaMeshBinding *, hkContainerHeapAllocator>") // hkArray< class hkaMeshBinding *, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(MirroringDemo, m_control, 0, "hkaDefaultAnimationControl* [3]") // class hkaDefaultAnimationControl* [3]
    HK_TRACKER_MEMBER(MirroringDemo, m_skeletonInstance, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(MirroringDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Api/Playback/RuntimeBinding/RuntimeBindingDemo.h>


// RuntimeBindingDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(RuntimeBindingDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(RuntimeBindingDemo)
    HK_TRACKER_MEMBER(RuntimeBindingDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(RuntimeBindingDemo, m_skeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(RuntimeBindingDemo, m_animation, 0, "hkaAnimation*") // class hkaAnimation*
    HK_TRACKER_MEMBER(RuntimeBindingDemo, m_runtimeBinding, 0, "hkaAnimationBinding*") // class hkaAnimationBinding*
    HK_TRACKER_MEMBER(RuntimeBindingDemo, m_control, 0, "hkaDefaultAnimationControl*") // class hkaDefaultAnimationControl*
    HK_TRACKER_MEMBER(RuntimeBindingDemo, m_skeletonInstance, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(RuntimeBindingDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Api/Playback/Skeleton/SkeletonDemo.h>


// SkeletonDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SkeletonDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SkeletonDemo)
    HK_TRACKER_MEMBER(SkeletonDemo, m_animation, 0, "hkaInterleavedUncompressedAnimation*") // class hkaInterleavedUncompressedAnimation*
    HK_TRACKER_MEMBER(SkeletonDemo, m_skeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(SkeletonDemo, m_loader, 0, "hkLoader*") // class hkLoader*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SkeletonDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Api/Ragdoll/RagdollController/RagdollControllerDemoTweakOptions.h>


// RagdollControllerDemoBallGunOptions ::
HK_TRACKER_IMPLEMENT_SIMPLE(RagdollControllerDemoBallGunOptions, s_libraryName)


// RagdollControllerDemoDisplayOptions ::
HK_TRACKER_IMPLEMENT_SIMPLE(RagdollControllerDemoDisplayOptions, s_libraryName)


// RagdollControllerDemoRigidbodyRagdollControllerOptions ::
HK_TRACKER_IMPLEMENT_SIMPLE(RagdollControllerDemoRigidbodyRagdollControllerOptions, s_libraryName)


// RagdollControllerDemoPositionMotorConstraintOptions ::
HK_TRACKER_IMPLEMENT_SIMPLE(RagdollControllerDemoPositionMotorConstraintOptions, s_libraryName)


// RagdollControllerDemoTweakOptions ::

HK_TRACKER_DECLARE_CLASS_BEGIN(RagdollControllerDemoTweakOptions)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(DemoMode)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(RagdollControllerDemoTweakOptions)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(RagdollControllerDemoTweakOptions, s_libraryName, hkReferencedObject)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(RagdollControllerDemoTweakOptions, DemoMode, s_libraryName)

#include <Demos/Animation/Api/Retargeting/BasicPose/BasicPoseRetargetingDemo.h>


// BasicPoseRetargetingDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(BasicPoseRetargetingDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(BasicPoseRetargetingDemo)
    HK_TRACKER_MEMBER(BasicPoseRetargetingDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(BasicPoseRetargetingDemo, m_animatedSkeleton, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
    HK_TRACKER_MEMBER(BasicPoseRetargetingDemo, m_binding, 0, "hkaAnimationBinding*") // class hkaAnimationBinding*
    HK_TRACKER_MEMBER(BasicPoseRetargetingDemo, m_skeleton, 0, "hkaSkeleton* [2]") // class hkaSkeleton* [2]
    HK_TRACKER_MEMBER(BasicPoseRetargetingDemo, m_skinBindings, 0, "hkArray<hkaMeshBinding *, hkContainerHeapAllocator> [2]") // hkArray< class hkaMeshBinding *, struct hkContainerHeapAllocator > [2]
    HK_TRACKER_MEMBER(BasicPoseRetargetingDemo, m_mapper, 0, "hkaSkeletonMapper*") // class hkaSkeletonMapper*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(BasicPoseRetargetingDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Api/Retargeting/Blend/BlendedRetargetingDemo.h>


// BlendedRetargetingDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(BlendedRetargetingDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(BlendedRetargetingDemo)
    HK_TRACKER_MEMBER(BlendedRetargetingDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(BlendedRetargetingDemo, m_animatedSkeleton, 0, "hkaAnimatedSkeleton* [2]") // class hkaAnimatedSkeleton* [2]
    HK_TRACKER_MEMBER(BlendedRetargetingDemo, m_binding, 0, "hkaAnimationBinding* [2]") // class hkaAnimationBinding* [2]
    HK_TRACKER_MEMBER(BlendedRetargetingDemo, m_skinBindings, 0, "hkArray<hkaMeshBinding *, hkContainerHeapAllocator> [2]") // hkArray< class hkaMeshBinding *, struct hkContainerHeapAllocator > [2]
    HK_TRACKER_MEMBER(BlendedRetargetingDemo, m_mapper, 0, "hkaSkeletonMapper* [2]") // class hkaSkeletonMapper* [2]
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(BlendedRetargetingDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Api/Retargeting/BlendAdditive/BlendAdditiveRetargetingDemo.h>


// BlendAdditiveRetargetingDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(BlendAdditiveRetargetingDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(BlendAdditiveRetargetingDemo)
    HK_TRACKER_MEMBER(BlendAdditiveRetargetingDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(BlendAdditiveRetargetingDemo, m_animatedSkeleton, 0, "hkaAnimatedSkeleton* [2]") // class hkaAnimatedSkeleton* [2]
    HK_TRACKER_MEMBER(BlendAdditiveRetargetingDemo, m_binding, 0, "hkaAnimationBinding* [2]") // class hkaAnimationBinding* [2]
    HK_TRACKER_MEMBER(BlendAdditiveRetargetingDemo, m_skinBindings, 0, "hkArray<hkaMeshBinding *, hkContainerHeapAllocator> [2]") // hkArray< class hkaMeshBinding *, struct hkContainerHeapAllocator > [2]
    HK_TRACKER_MEMBER(BlendAdditiveRetargetingDemo, m_mapper, 0, "hkaSkeletonMapper*") // class hkaSkeletonMapper*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(BlendAdditiveRetargetingDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Api/Retargeting/BlendPartial/BlendPartialRetargetingDemo.h>


// BlendPartialRetargetingDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(BlendPartialRetargetingDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(BlendPartialRetargetingDemo)
    HK_TRACKER_MEMBER(BlendPartialRetargetingDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(BlendPartialRetargetingDemo, m_animatedSkeleton, 0, "hkaAnimatedSkeleton* [2]") // class hkaAnimatedSkeleton* [2]
    HK_TRACKER_MEMBER(BlendPartialRetargetingDemo, m_binding, 0, "hkaAnimationBinding* [2]") // class hkaAnimationBinding* [2]
    HK_TRACKER_MEMBER(BlendPartialRetargetingDemo, m_skinBindings, 0, "hkArray<hkaMeshBinding *, hkContainerHeapAllocator> [2]") // hkArray< class hkaMeshBinding *, struct hkContainerHeapAllocator > [2]
    HK_TRACKER_MEMBER(BlendPartialRetargetingDemo, m_retargetedControl, 0, "hkaDefaultAnimationControl*") // class hkaDefaultAnimationControl*
    HK_TRACKER_MEMBER(BlendPartialRetargetingDemo, m_partialControl, 0, "hkaDefaultAnimationControl*") // class hkaDefaultAnimationControl*
    HK_TRACKER_MEMBER(BlendPartialRetargetingDemo, m_mapper, 0, "hkaSkeletonMapper*") // class hkaSkeletonMapper*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(BlendPartialRetargetingDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Api/Retargeting/Chain/ChainRetargetingDemo.h>


// ChainRetargetingDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ChainRetargetingDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ChainRetargetingDemo)
    HK_TRACKER_MEMBER(ChainRetargetingDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(ChainRetargetingDemo, m_animatedSkeleton, 0, "hkaAnimatedSkeleton* [2]") // class hkaAnimatedSkeleton* [2]
    HK_TRACKER_MEMBER(ChainRetargetingDemo, m_binding, 0, "hkaAnimationBinding*") // class hkaAnimationBinding*
    HK_TRACKER_MEMBER(ChainRetargetingDemo, m_skeleton, 0, "hkaSkeleton* [2]") // class hkaSkeleton* [2]
    HK_TRACKER_MEMBER(ChainRetargetingDemo, m_skinBindings, 0, "hkArray<hkaMeshBinding *, hkContainerHeapAllocator> [2]") // hkArray< class hkaMeshBinding *, struct hkContainerHeapAllocator > [2]
    HK_TRACKER_MEMBER(ChainRetargetingDemo, m_attachments, 0, "hkArray<hkaBoneAttachment *, hkContainerHeapAllocator> [2]") // hkArray< class hkaBoneAttachment *, struct hkContainerHeapAllocator > [2]
    HK_TRACKER_MEMBER(ChainRetargetingDemo, m_attachmentObjects, 0, "hkArray<hkgDisplayObject*, hkContainerHeapAllocator> [2]") // hkArray< class hkgDisplayObject*, struct hkContainerHeapAllocator > [2]
    HK_TRACKER_MEMBER(ChainRetargetingDemo, m_mapper, 0, "hkaSkeletonMapper*") // class hkaSkeletonMapper*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ChainRetargetingDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Api/Retargeting/Showcase/RetargetingShowcaseDemo.h>


// AnimationMappingShowcaseDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AnimationMappingShowcaseDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(MappedCharacter)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AnimationMappingShowcaseDemo)
    HK_TRACKER_MEMBER(AnimationMappingShowcaseDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(AnimationMappingShowcaseDemo, m_characters, 0, "hkArray<AnimationMappingShowcaseDemo::MappedCharacter*, hkContainerHeapAllocator>") // hkArray< struct AnimationMappingShowcaseDemo::MappedCharacter*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(AnimationMappingShowcaseDemo, m_windowedAverageRetargeting, 0, "WindowedAverage*") // class WindowedAverage*
    HK_TRACKER_MEMBER(AnimationMappingShowcaseDemo, m_windowedAverageSampling, 0, "WindowedAverage*") // class WindowedAverage*
    HK_TRACKER_MEMBER(AnimationMappingShowcaseDemo, m_splashScreen, 0, "SplashScreen*") // class SplashScreen*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(AnimationMappingShowcaseDemo, s_libraryName, hkDefaultAnimationDemo)


// MappedCharacter AnimationMappingShowcaseDemo

HK_TRACKER_DECLARE_CLASS_BEGIN(AnimationMappingShowcaseDemo::MappedCharacter)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AnimationMappingShowcaseDemo::MappedCharacter)
    HK_TRACKER_MEMBER(AnimationMappingShowcaseDemo::MappedCharacter, m_animatedSkeleton, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
    HK_TRACKER_MEMBER(AnimationMappingShowcaseDemo::MappedCharacter, m_binding, 0, "hkaAnimationBinding*") // class hkaAnimationBinding*
    HK_TRACKER_MEMBER(AnimationMappingShowcaseDemo::MappedCharacter, m_skinBindings, 0, "hkArray<hkaMeshBinding *, hkContainerHeapAllocator>") // hkArray< class hkaMeshBinding *, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(AnimationMappingShowcaseDemo::MappedCharacter, m_attachments, 0, "hkArray<hkaBoneAttachment *, hkContainerHeapAllocator>") // hkArray< class hkaBoneAttachment *, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(AnimationMappingShowcaseDemo::MappedCharacter, m_attachmentObjects, 0, "hkArray<hkgDisplayObject*, hkContainerHeapAllocator>") // hkArray< class hkgDisplayObject*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(AnimationMappingShowcaseDemo::MappedCharacter, m_map, 0, "hkArray<hkaSkeletonMapperData*, hkContainerHeapAllocator>") // hkArray< class hkaSkeletonMapperData*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(AnimationMappingShowcaseDemo::MappedCharacter, s_libraryName)

#include <Demos/Animation/Api/Retargeting/Timings/RetargetingTimingsDemo.h>


// RetargetingTimingsDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(RetargetingTimingsDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(MappedCharacter)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(RetargetingTimingsDemo)
    HK_TRACKER_MEMBER(RetargetingTimingsDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(RetargetingTimingsDemo, m_bindings, 0, "hkArray<hkaAnimationBinding*, hkContainerHeapAllocator>") // hkArray< class hkaAnimationBinding*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(RetargetingTimingsDemo, m_skeletons, 0, "hkArray<hkaSkeleton*, hkContainerHeapAllocator>") // hkArray< class hkaSkeleton*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(RetargetingTimingsDemo, m_mappedCharacters, 0, "hkArray<RetargetingTimingsDemo::MappedCharacter, hkContainerHeapAllocator>") // hkArray< struct RetargetingTimingsDemo::MappedCharacter, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(RetargetingTimingsDemo, s_libraryName, hkDefaultAnimationDemo)


// MappedCharacter RetargetingTimingsDemo

HK_TRACKER_DECLARE_CLASS_BEGIN(RetargetingTimingsDemo::MappedCharacter)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(RetargetingTimingsDemo::MappedCharacter)
    HK_TRACKER_MEMBER(RetargetingTimingsDemo::MappedCharacter, m_character, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
    HK_TRACKER_MEMBER(RetargetingTimingsDemo::MappedCharacter, m_pose, 0, "hkaPose*") // class hkaPose*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(RetargetingTimingsDemo::MappedCharacter, s_libraryName)

#include <Demos/Animation/Api/SkeletalMapping/SkeletonMappingDemo.h>


// SkeletonMappingDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SkeletonMappingDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SkeletonMappingDemo)
    HK_TRACKER_MEMBER(SkeletonMappingDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(SkeletonMappingDemo, m_highToLowMapper, 0, "hkaSkeletonMapper*") // class hkaSkeletonMapper*
    HK_TRACKER_MEMBER(SkeletonMappingDemo, m_lowToHighMapper, 0, "hkaSkeletonMapper*") // class hkaSkeletonMapper*
    HK_TRACKER_MEMBER(SkeletonMappingDemo, m_highSkeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(SkeletonMappingDemo, m_lowSkeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(SkeletonMappingDemo, m_highAnimatedSkeleton, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
    HK_TRACKER_MEMBER(SkeletonMappingDemo, m_highAnimation, 0, "hkaAnimation*") // class hkaAnimation*
    HK_TRACKER_MEMBER(SkeletonMappingDemo, m_highBinding, 0, "hkaAnimationBinding*") // class hkaAnimationBinding*
    HK_TRACKER_MEMBER(SkeletonMappingDemo, m_lowAnimatedSkeleton, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
    HK_TRACKER_MEMBER(SkeletonMappingDemo, m_lowAnimation, 0, "hkaAnimation*") // class hkaAnimation*
    HK_TRACKER_MEMBER(SkeletonMappingDemo, m_lowBinding, 0, "hkaAnimationBinding*") // class hkaAnimationBinding*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SkeletonMappingDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Test/Feature/Animation/Util/hkaDemoGraph.h>


// hkaDemoGraph ::
HK_TRACKER_IMPLEMENT_SIMPLE(hkaDemoGraph, s_libraryName)

#include <Demos/Animation/Test/Feature/Compression/Timings/SampleAndBlend/SampleAndBlendTimingsDemo.h>


// SampleAndBlendTimingsDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SampleAndBlendTimingsDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SampleAndBlendTimingsDemo)
    HK_TRACKER_MEMBER(SampleAndBlendTimingsDemo, m_skeleton, 0, "hkaSkeleton *") // class hkaSkeleton *
    HK_TRACKER_MEMBER(SampleAndBlendTimingsDemo, m_bindings, 0, "hkArray<hkaAnimationBinding *, hkContainerHeapAllocator>") // hkArray< class hkaAnimationBinding *, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(SampleAndBlendTimingsDemo, m_animatedSkeletons, 0, "hkArray<hkaAnimatedSkeleton *, hkContainerHeapAllocator>") // hkArray< class hkaAnimatedSkeleton *, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SampleAndBlendTimingsDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/Animation/Test/Feature/Compression/Timings/SampleOnly/SampleOnlyTimingsDemo.h>


// SampleOnlyTimingsDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SampleOnlyTimingsDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SampleOnlyTimingsDemo)
    HK_TRACKER_MEMBER(SampleOnlyTimingsDemo, m_skeleton, 0, "hkaSkeleton *") // class hkaSkeleton *
    HK_TRACKER_MEMBER(SampleOnlyTimingsDemo, m_bindings, 0, "hkArray<hkaAnimationBinding *, hkContainerHeapAllocator>") // hkArray< class hkaAnimationBinding *, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(SampleOnlyTimingsDemo, m_controls, 0, "hkArray<hkaDefaultAnimationControl *, hkContainerHeapAllocator>") // hkArray< class hkaDefaultAnimationControl *, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SampleOnlyTimingsDemo, s_libraryName, hkDefaultAnimationDemo)

#include <Demos/DemoCommon/DemoFramework/hkDefaultAnimationDemo.h>


// hkDefaultAnimationDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(hkDefaultAnimationDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(hkDefaultAnimationDemo)
    HK_TRACKER_MEMBER(hkDefaultAnimationDemo, m_animationViewersContext, 0, "hkaAnimationContext*") // class hkaAnimationContext*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(hkDefaultAnimationDemo, s_libraryName, hkDefaultDemo)

#include <Demos/DemoCommon/Utilities/Animation/AnimationUtils.h>


// AnimationUtils ::
HK_TRACKER_IMPLEMENT_SIMPLE(AnimationUtils, s_libraryName)

#include <Demos/DemoCommon/Utilities/CameraUtils/AnimatedCamera.h>


// AnimatedCamera ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AnimatedCamera)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AnimatedCamera)
    HK_TRACKER_MEMBER(AnimatedCamera, m_skeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(AnimatedCamera, m_binding, 0, "hkaAnimationBinding*") // class hkaAnimationBinding*
    HK_TRACKER_MEMBER(AnimatedCamera, m_camera, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
    HK_TRACKER_MEMBER(AnimatedCamera, m_control, 0, "hkaDefaultAnimationControl*") // class hkaDefaultAnimationControl*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(AnimatedCamera, s_libraryName)

#include <Demos/DemoCommon/Utilities/Character/DemoCharacter/AnimatedDemoCharacter/AnimatedDemoCharacter.h>


// AnimatedDemoCharacterAnimationSet ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AnimatedDemoCharacterAnimationSet)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AnimatedDemoCharacterAnimationSet)
    HK_TRACKER_MEMBER(AnimatedDemoCharacterAnimationSet, m_skeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(AnimatedDemoCharacterAnimationSet, m_idle, 0, "hkaAnimationBinding*") // class hkaAnimationBinding*
    HK_TRACKER_MEMBER(AnimatedDemoCharacterAnimationSet, m_walk, 0, "hkaAnimationBinding*") // class hkaAnimationBinding*
    HK_TRACKER_MEMBER(AnimatedDemoCharacterAnimationSet, m_run, 0, "hkaAnimationBinding*") // class hkaAnimationBinding*
    HK_TRACKER_MEMBER(AnimatedDemoCharacterAnimationSet, m_jump, 0, "hkaAnimationBinding*") // class hkaAnimationBinding*
    HK_TRACKER_MEMBER(AnimatedDemoCharacterAnimationSet, m_inAir, 0, "hkaAnimationBinding*") // class hkaAnimationBinding*
    HK_TRACKER_MEMBER(AnimatedDemoCharacterAnimationSet, m_land, 0, "hkaAnimationBinding*") // class hkaAnimationBinding*
    HK_TRACKER_MEMBER(AnimatedDemoCharacterAnimationSet, m_dive, 0, "hkaAnimationBinding*") // class hkaAnimationBinding*
    HK_TRACKER_MEMBER(AnimatedDemoCharacterAnimationSet, m_rigContainer, 0, "hkRootLevelContainer*") // class hkRootLevelContainer*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(AnimatedDemoCharacterAnimationSet, s_libraryName)


// AnimatedDemoCharacterDisplay ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AnimatedDemoCharacterDisplay)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AnimatedDemoCharacterDisplay)
    HK_TRACKER_MEMBER(AnimatedDemoCharacterDisplay, m_skinBindings, 0, "hkArray<hkaMeshBinding *, hkContainerHeapAllocator>") // hkArray< class hkaMeshBinding *, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(AnimatedDemoCharacterDisplay, m_skinDisplay, 0, "hkArray<hkgDisplayObject*, hkContainerHeapAllocator>") // hkArray< class hkgDisplayObject*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(AnimatedDemoCharacterDisplay, s_libraryName)


// AnimatedCharacterFactory ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AnimatedCharacterFactory)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AnimatedCharacterFactory)
    HK_TRACKER_MEMBER(AnimatedCharacterFactory, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(AnimatedCharacterFactory, m_animSet, 0, "AnimatedDemoCharacterAnimationSet [6]") // struct AnimatedDemoCharacterAnimationSet [6]
    HK_TRACKER_MEMBER(AnimatedCharacterFactory, m_display, 0, "AnimatedDemoCharacterDisplay [6]") // struct AnimatedDemoCharacterDisplay [6]
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(AnimatedCharacterFactory, s_libraryName, CharacterFactory)


// AnimatedDemoCharacterCinfo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AnimatedDemoCharacterCinfo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AnimatedDemoCharacterCinfo)
    HK_TRACKER_MEMBER(AnimatedDemoCharacterCinfo, m_animationSet, 0, "AnimatedDemoCharacterAnimationSet*") // struct AnimatedDemoCharacterAnimationSet*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(AnimatedDemoCharacterCinfo, s_libraryName, DemoCharacterCinfo)


// AnimatedDemoCharacter ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AnimatedDemoCharacter)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AnimatedDemoCharacter)
    HK_TRACKER_MEMBER(AnimatedDemoCharacter, m_stateManager, 0, "SimpleBipedStateManager*") // class SimpleBipedStateManager*
    HK_TRACKER_MEMBER(AnimatedDemoCharacter, m_animationMachine, 0, "AnimationEventQueue*") // class AnimationEventQueue*
    HK_TRACKER_MEMBER(AnimatedDemoCharacter, m_animationStateMachine, 0, "SimpleBipedStateContext*") // class SimpleBipedStateContext*
    HK_TRACKER_MEMBER(AnimatedDemoCharacter, m_animatedSkeleton, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
    HK_TRACKER_MEMBER(AnimatedDemoCharacter, m_skinBindings, 0, "hkArray<hkaMeshBinding *, hkContainerHeapAllocator>") // hkArray< class hkaMeshBinding *, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(AnimatedDemoCharacter, m_skins, 0, "hkArray<hkgDisplayObject*, hkContainerHeapAllocator>") // hkArray< class hkgDisplayObject*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(AnimatedDemoCharacter, s_libraryName, DemoCharacter)

#include <Demos/DemoCommon/Utilities/Character/DemoCharacter/AnimatedDemoCharacter/StateMachine/SimpleBipedStateMachine.h>


// AnimationEventQueue ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AnimationEventQueue)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(AnimationCommand)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(AnimationCommandType)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AnimationEventQueue)
    HK_TRACKER_MEMBER(AnimationEventQueue, m_animatedSkeleton, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
    HK_TRACKER_MEMBER(AnimationEventQueue, m_eventQueue, 0, "hkArray<AnimationEventQueue::AnimationCommand, hkContainerHeapAllocator>") // hkArray< struct AnimationEventQueue::AnimationCommand, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(AnimationEventQueue, s_libraryName, hkReferencedObject)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(AnimationEventQueue, AnimationCommandType, s_libraryName)

// hk.MemoryTracker ignore EaseParams
// hk.MemoryTracker ignore SetWeightParams
// hk.MemoryTracker ignore SetTimeParams
// hk.MemoryTracker ignore SetSpeedParams

// AnimationCommand AnimationEventQueue
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(AnimationEventQueue, AnimationCommand, s_libraryName)


// SimpleBipedStateInput ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SimpleBipedStateInput)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SimpleBipedStateInput)
    HK_TRACKER_MEMBER(SimpleBipedStateInput, m_animMachine, 0, "AnimationEventQueue*") // class AnimationEventQueue*
    HK_TRACKER_MEMBER(SimpleBipedStateInput, m_context, 0, "SimpleBipedStateContext*") // class SimpleBipedStateContext*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(SimpleBipedStateInput, s_libraryName)


// SimpleBipedState ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SimpleBipedState)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SimpleBipedState)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_ABSTRACT(SimpleBipedState, s_libraryName, hkReferencedObject)


// SimpleBipedStateManager ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SimpleBipedStateManager)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SimpleBipedStateManager)
    HK_TRACKER_MEMBER(SimpleBipedStateManager, m_registeredStates, 0, "hkPointerMap<hkUint32, SimpleBipedState*, hkContainerHeapAllocator>") // class hkPointerMap< hkUint32, class SimpleBipedState*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SimpleBipedStateManager, s_libraryName, hkReferencedObject)


// SimpleBipedStateContext ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SimpleBipedStateContext)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SimpleBipedStateContext)
    HK_TRACKER_MEMBER(SimpleBipedStateContext, m_stateManager, 0, "SimpleBipedStateManager*") // const class SimpleBipedStateManager*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SimpleBipedStateContext, s_libraryName, hkReferencedObject)

// None SimpleBipedStateTypes
HK_TRACKER_IMPLEMENT_SIMPLE(SimpleBipedStateTypes, s_libraryName)
// None SimpleBipedAnimControls
HK_TRACKER_IMPLEMENT_SIMPLE(SimpleBipedAnimControls, s_libraryName)
#include <Demos/DemoCommon/Utilities/Character/DemoCharacter/AnimatedDemoCharacter/StateMachine/States/SimpleBipedStates.h>


// SimpleBipedWalkState ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SimpleBipedWalkState)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SimpleBipedWalkState)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SimpleBipedWalkState, s_libraryName, SimpleBipedState)


// SimpleBipedStandState ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SimpleBipedStandState)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SimpleBipedStandState)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SimpleBipedStandState, s_libraryName, SimpleBipedState)


// SimpleBipedLandState ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SimpleBipedLandState)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SimpleBipedLandState)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SimpleBipedLandState, s_libraryName, SimpleBipedState)


// SimpleBipedJumpState ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SimpleBipedJumpState)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SimpleBipedJumpState)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SimpleBipedJumpState, s_libraryName, SimpleBipedState)


// SimpleBipedInAirState ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SimpleBipedInAirState)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SimpleBipedInAirState)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SimpleBipedInAirState, s_libraryName, SimpleBipedState)


// SimpleBipedDiveState ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SimpleBipedDiveState)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SimpleBipedDiveState)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SimpleBipedDiveState, s_libraryName, SimpleBipedState)

#include <Demos/DemoCommon/Utilities/WindowedAverage/WindowedAverage.h>


// WindowedAverage ::

HK_TRACKER_DECLARE_CLASS_BEGIN(WindowedAverage)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(WindowedAverage)
    HK_TRACKER_MEMBER(WindowedAverage, m_samples, 0, "hkArray<float, hkContainerHeapAllocator>") // hkArray< float, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(WindowedAverage, s_libraryName)


#endif // HK_FEATURE_PRODUCT_ANIMATION


#if defined(HK_FEATURE_PRODUCT_ANIMATION) && defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
#include <Common/Base/Memory/Tracker/hkTrackerClassDefinition.h>

 void HK_CALL DemosANIMATIONPHYSICS_2012Register() {}

#include <Demos/Animation/Api/MotionExtraction/CharacterController/CharacterAnimationDemo.h>


// CharacterAnimationDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(CharacterAnimationDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(CharacterAnimationDemo)
    HK_TRACKER_MEMBER(CharacterAnimationDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(CharacterAnimationDemo, m_skinBindings, 0, "hkArray<hkaMeshBinding *, hkContainerHeapAllocator>") // hkArray< class hkaMeshBinding *, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(CharacterAnimationDemo, m_phantom, 0, "hkpShapePhantom*") // class hkpShapePhantom*
    HK_TRACKER_MEMBER(CharacterAnimationDemo, m_standShape, 0, "hkpShape*") // class hkpShape*
    HK_TRACKER_MEMBER(CharacterAnimationDemo, m_characterContext, 0, "MyStateMachineContext") // struct MyStateMachineContext
    HK_TRACKER_MEMBER(CharacterAnimationDemo, m_stateMachine, 0, "MyStateMachine*") // class MyStateMachine*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(CharacterAnimationDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Animation/Api/MotionExtraction/CharacterController/StateMachine/MyInAirState.h>


// MyInAirState ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MyInAirState)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MyInAirState)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(MyInAirState, s_libraryName, MyState)

#include <Demos/Animation/Api/MotionExtraction/CharacterController/StateMachine/MyStandState.h>


// MyStandState ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MyStandState)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MyStandState)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(MyStandState, s_libraryName, MyState)

#include <Demos/Animation/Api/MotionExtraction/CharacterController/StateMachine/MyState.h>


// MyState ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MyState)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MyState)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_ABSTRACT(MyState, s_libraryName, hkReferencedObject)

#include <Demos/Animation/Api/MotionExtraction/CharacterController/StateMachine/MyStateMachine.h>


// MyStateMachineContext ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MyStateMachineContext)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MyStateMachineContext)
    HK_TRACKER_MEMBER(MyStateMachineContext, m_animatedSkeleton, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
    HK_TRACKER_MEMBER(MyStateMachineContext, m_walkControl, 0, "hkaDefaultAnimationControl*") // class hkaDefaultAnimationControl*
    HK_TRACKER_MEMBER(MyStateMachineContext, m_idleControl, 0, "hkaDefaultAnimationControl*") // class hkaDefaultAnimationControl*
    HK_TRACKER_MEMBER(MyStateMachineContext, m_protectControl, 0, "hkaDefaultAnimationControl*") // class hkaDefaultAnimationControl*
    HK_TRACKER_MEMBER(MyStateMachineContext, m_world, 0, "hkpWorld*") // class hkpWorld*
    HK_TRACKER_MEMBER(MyStateMachineContext, m_characterProxy, 0, "hkpCharacterProxy*") // class hkpCharacterProxy*
    HK_TRACKER_MEMBER(MyStateMachineContext, m_ragdollInstance, 0, "hkaRagdollInstance*") // class hkaRagdollInstance*
    HK_TRACKER_MEMBER(MyStateMachineContext, m_girlToRagdollMapper, 0, "hkaSkeletonMapper*") // class hkaSkeletonMapper*
    HK_TRACKER_MEMBER(MyStateMachineContext, m_ragdollToGirlMapper, 0, "hkaSkeletonMapper*") // class hkaSkeletonMapper*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(MyStateMachineContext, s_libraryName)


// MyStateMachineInput ::
HK_TRACKER_IMPLEMENT_SIMPLE(MyStateMachineInput, s_libraryName)


// MyStateMachineOutput ::
HK_TRACKER_IMPLEMENT_SIMPLE(MyStateMachineOutput, s_libraryName)


// MyStateMachine ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MyStateMachine)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MyStateMachine)
    HK_TRACKER_MEMBER(MyStateMachine, m_registeredStates, 0, "MyState* [6]") // class MyState* [6]
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(MyStateMachine, s_libraryName, hkReferencedObject)

// None MyStateType
HK_TRACKER_IMPLEMENT_SIMPLE(MyStateType, s_libraryName)
#include <Demos/Animation/Api/MotionExtraction/CharacterController/StateMachine/MyWalkState.h>


// MyWalkState ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MyWalkState)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MyWalkState)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(MyWalkState, s_libraryName, MyState)

#include <Demos/Animation/Api/Ragdoll/BlendTest/BlendTestDemo.h>


// BlendTestDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(BlendTestDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(BlendTestDemo)
    HK_TRACKER_MEMBER(BlendTestDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(BlendTestDemo, m_highToLowMapper, 0, "hkaSkeletonMapper*") // class hkaSkeletonMapper*
    HK_TRACKER_MEMBER(BlendTestDemo, m_lowToHighMapper, 0, "hkaSkeletonMapper*") // class hkaSkeletonMapper*
    HK_TRACKER_MEMBER(BlendTestDemo, m_control, 0, "hkaDefaultAnimationControl* [1]") // class hkaDefaultAnimationControl* [1]
    HK_TRACKER_MEMBER(BlendTestDemo, m_animatedSkeleton, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
    HK_TRACKER_MEMBER(BlendTestDemo, m_ragdollInstance, 0, "hkaRagdollInstance*") // class hkaRagdollInstance*
    HK_TRACKER_MEMBER(BlendTestDemo, m_ragdollSkeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(BlendTestDemo, m_oldData, 0, "hkArray<hkaKeyFrameHierarchyUtility::WorkElem, hkContainerHeapAllocator>") // hkArray< struct hkaKeyFrameHierarchyUtility::WorkElem, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(BlendTestDemo, m_motor, 0, "hkpPositionConstraintMotor*") // class hkpPositionConstraintMotor*
    HK_TRACKER_MEMBER(BlendTestDemo, m_otherMotor, 0, "hkpPositionConstraintMotor*") // class hkpPositionConstraintMotor*
    HK_TRACKER_MEMBER(BlendTestDemo, m_mapper, 0, "hkpPoweredChainMapper*") // class hkpPoweredChainMapper*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(BlendTestDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Animation/Api/Ragdoll/ConstraintMatching/ConstraintMatchingDemo.h>


// ConstraintMatchingDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ConstraintMatchingDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ConstraintMatchingDemo)
    HK_TRACKER_MEMBER(ConstraintMatchingDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(ConstraintMatchingDemo, m_highToLowMapper, 0, "hkaSkeletonMapper*") // class hkaSkeletonMapper*
    HK_TRACKER_MEMBER(ConstraintMatchingDemo, m_lowToHighMapper, 0, "hkaSkeletonMapper*") // class hkaSkeletonMapper*
    HK_TRACKER_MEMBER(ConstraintMatchingDemo, m_highSkeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(ConstraintMatchingDemo, m_animatedSkeleton, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
    HK_TRACKER_MEMBER(ConstraintMatchingDemo, m_animation, 0, "hkaAnimation*") // class hkaAnimation*
    HK_TRACKER_MEMBER(ConstraintMatchingDemo, m_binding, 0, "hkaAnimationBinding*") // class hkaAnimationBinding*
    HK_TRACKER_MEMBER(ConstraintMatchingDemo, m_ragdollInstance, 0, "hkaRagdollInstance*") // class hkaRagdollInstance*
    HK_TRACKER_MEMBER(ConstraintMatchingDemo, m_rigidBodyController, 0, "hkaRagdollRigidBodyController*") // class hkaRagdollRigidBodyController*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ConstraintMatchingDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Animation/Api/Ragdoll/Dismemberment/DismembermentDemo.h>


// DismembermentDemoRagdollInstanceAndController ::

HK_TRACKER_DECLARE_CLASS_BEGIN(DismembermentDemoRagdollInstanceAndController)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(ControllerType)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(DismembermentDemoRagdollInstanceAndController)
    HK_TRACKER_MEMBER(DismembermentDemoRagdollInstanceAndController, m_ragdollInstance, 0, "hkaRagdollInstance *") // class hkaRagdollInstance *
    HK_TRACKER_MEMBER(DismembermentDemoRagdollInstanceAndController, m_originalRagdollInstance, 0, "hkaRagdollInstance *") // const class hkaRagdollInstance *
    HK_TRACKER_MEMBER(DismembermentDemoRagdollInstanceAndController, m_ragdollRigidBodyController, 0, "hkaRagdollRigidBodyController*") // class hkaRagdollRigidBodyController*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(DismembermentDemoRagdollInstanceAndController, s_libraryName, hkReferencedObject)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(DismembermentDemoRagdollInstanceAndController, ControllerType, s_libraryName)


// DismembermentDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(DismembermentDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(DismembermentDemo)
    HK_TRACKER_MEMBER(DismembermentDemo, m_binding, 0, "hkaAnimationBinding*") // class hkaAnimationBinding*
    HK_TRACKER_MEMBER(DismembermentDemo, m_ragdollFromAnimation, 0, "hkaSkeletonMapper*") // class hkaSkeletonMapper*
    HK_TRACKER_MEMBER(DismembermentDemo, m_animationFromRagdoll, 0, "hkaSkeletonMapper*") // class hkaSkeletonMapper*
    HK_TRACKER_MEMBER(DismembermentDemo, m_animationSkeleton, 0, "hkaSkeleton*") // const class hkaSkeleton*
    HK_TRACKER_MEMBER(DismembermentDemo, m_ragdollSkeleton, 0, "hkaSkeleton*") // const class hkaSkeleton*
    HK_TRACKER_MEMBER(DismembermentDemo, m_originalRagdoll, 0, "hkaRagdollInstance*") // class hkaRagdollInstance*
    HK_TRACKER_MEMBER(DismembermentDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(DismembermentDemo, m_control, 0, "hkaDefaultAnimationControl*") // class hkaDefaultAnimationControl*
    HK_TRACKER_MEMBER(DismembermentDemo, m_character, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
    HK_TRACKER_MEMBER(DismembermentDemo, m_skinBindings, 0, "hkArray<hkaMeshBinding *, hkContainerHeapAllocator>") // hkArray< class hkaMeshBinding *, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(DismembermentDemo, m_skinFromRigidBody, 0, "hkPointerMap<hkpRigidBody*, hkaMeshBinding*, hkContainerHeapAllocator>") // class hkPointerMap< class hkpRigidBody*, class hkaMeshBinding*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(DismembermentDemo, m_ragdolls, 0, "hkArray<DismembermentDemoRagdollInstanceAndController*, hkContainerHeapAllocator>") // hkArray< class DismembermentDemoRagdollInstanceAndController*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(DismembermentDemo, m_randomizer, 0, "hkPseudoRandomGenerator*") // class hkPseudoRandomGenerator*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(DismembermentDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Animation/Api/Ragdoll/PenetrationDetection/PenetrationDemo.h>


// PenetrationDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(PenetrationDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(PenetrationDemo)
    HK_TRACKER_MEMBER(PenetrationDemo, m_posesLowRes, 0, "hkaPose* [6]") // class hkaPose* [6]
    HK_TRACKER_MEMBER(PenetrationDemo, m_ragdollRaycastInterface, 0, "hkaRagdollRaycastInterface*") // class hkaRagdollRaycastInterface*
    HK_TRACKER_MEMBER(PenetrationDemo, m_ragdollPhantom, 0, "hkpAabbPhantom*") // class hkpAabbPhantom*
    HK_TRACKER_MEMBER(PenetrationDemo, m_detectRagdollPenetration, 0, "hkaDetectRagdollPenetration*") // class hkaDetectRagdollPenetration*
    HK_TRACKER_MEMBER(PenetrationDemo, m_penetratedBones, 0, "hkaDetectRagdollPenetration::Output") // struct hkaDetectRagdollPenetration::Output
    HK_TRACKER_MEMBER(PenetrationDemo, m_ragdollInstance, 0, "hkaRagdollInstance*") // class hkaRagdollInstance*
    HK_TRACKER_MEMBER(PenetrationDemo, m_loader, 0, "hkLoader*") // class hkLoader*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(PenetrationDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Animation/Api/Ragdoll/RagdollController/RagdollControllerDemo.h>


// RagdollControllerDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(RagdollControllerDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(RagdollControllerDemo)
    HK_TRACKER_MEMBER(RagdollControllerDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(RagdollControllerDemo, m_highToLowMapper, 0, "hkaSkeletonMapper*") // class hkaSkeletonMapper*
    HK_TRACKER_MEMBER(RagdollControllerDemo, m_lowToHighMapper, 0, "hkaSkeletonMapper*") // class hkaSkeletonMapper*
    HK_TRACKER_MEMBER(RagdollControllerDemo, m_animatedSkeleton, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
    HK_TRACKER_MEMBER(RagdollControllerDemo, m_animationControlListener, 0, "RagdollControllerDemo::AnimationControlListener*") // class RagdollControllerDemo::AnimationControlListener*
    HK_TRACKER_MEMBER(RagdollControllerDemo, m_ragdollInstance, 0, "hkaRagdollInstance*") // class hkaRagdollInstance*
    HK_TRACKER_MEMBER(RagdollControllerDemo, m_ragdollSkeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(RagdollControllerDemo, m_ragdollRigidBodyController, 0, "hkaRagdollRigidBodyController*") // class hkaRagdollRigidBodyController*
    HK_TRACKER_MEMBER(RagdollControllerDemo, m_posConstraintMotor, 0, "hkpPositionConstraintMotor*") // class hkpPositionConstraintMotor*
    HK_TRACKER_MEMBER(RagdollControllerDemo, m_velConstraintMotor, 0, "hkpVelocityConstraintMotor*") // class hkpVelocityConstraintMotor*
    HK_TRACKER_MEMBER(RagdollControllerDemo, m_skinBindings, 0, "hkArray<hkaMeshBinding *, hkContainerHeapAllocator>") // hkArray< class hkaMeshBinding *, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(RagdollControllerDemo, m_boneAttachments, 0, "hkArray<hkaBoneAttachment *, hkContainerHeapAllocator>") // hkArray< class hkaBoneAttachment *, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(RagdollControllerDemo, m_boneAttachmentObjects, 0, "hkArray<hkgDisplayObject*, hkContainerHeapAllocator>") // hkArray< class hkgDisplayObject*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(RagdollControllerDemo, m_ballGun, 0, "hkpBallGun*") // class hkpBallGun*
    HK_TRACKER_MEMBER(RagdollControllerDemo, m_extension, 0, "RagdollControllerDemo::Extension*") // struct RagdollControllerDemo::Extension*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(RagdollControllerDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Animation/Api/Ragdoll/RagdollScaling/RagdollScalingDemo.h>


// RagdollScalingDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(RagdollScalingDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(RagdollScalingDemo)
    HK_TRACKER_MEMBER(RagdollScalingDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(RagdollScalingDemo, m_ragdollSkeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(RagdollScalingDemo, m_animationSkeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(RagdollScalingDemo, m_binding, 0, "hkaAnimationBinding*") // class hkaAnimationBinding*
    HK_TRACKER_MEMBER(RagdollScalingDemo, m_control, 0, "hkaDefaultAnimationControl*") // class hkaDefaultAnimationControl*
    HK_TRACKER_MEMBER(RagdollScalingDemo, m_character, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
    HK_TRACKER_MEMBER(RagdollScalingDemo, m_ragdoll, 0, "hkaRagdollInstance*") // class hkaRagdollInstance*
    HK_TRACKER_MEMBER(RagdollScalingDemo, m_ragdollFromAnimation, 0, "hkaSkeletonMapper*") // class hkaSkeletonMapper*
    HK_TRACKER_MEMBER(RagdollScalingDemo, m_animationFromRagdoll, 0, "hkaSkeletonMapper*") // class hkaSkeletonMapper*
    HK_TRACKER_MEMBER(RagdollScalingDemo, m_ragdollRigidBodyController, 0, "hkaRagdollRigidBodyController*") // class hkaRagdollRigidBodyController*
    HK_TRACKER_MEMBER(RagdollScalingDemo, m_skinBindings, 0, "hkArray<hkaMeshBinding *, hkContainerHeapAllocator>") // hkArray< class hkaMeshBinding *, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(RagdollScalingDemo, m_geometry, 0, "hkGeometry*") // struct hkGeometry*
    HK_TRACKER_MEMBER(RagdollScalingDemo, m_displayConvex, 0, "hkDisplayConvex*") // class hkDisplayConvex*
    HK_TRACKER_MEMBER(RagdollScalingDemo, m_geometryArray, 0, "hkArray<hkDisplayGeometry*, hkContainerHeapAllocator>") // hkArray< class hkDisplayGeometry*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(RagdollScalingDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/DemoCommon/Utilities/Character/DemoCharacter/AnimatedDemoCharacter/RagdollDemoCharacter.h>


// RagdollDemoCharacterAnimationSet ::

HK_TRACKER_DECLARE_CLASS_BEGIN(RagdollDemoCharacterAnimationSet)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(RagdollDemoCharacterAnimationSet)
    HK_TRACKER_MEMBER(RagdollDemoCharacterAnimationSet, m_die, 0, "hkaAnimationBinding*") // class hkaAnimationBinding*
    HK_TRACKER_MEMBER(RagdollDemoCharacterAnimationSet, m_getUp, 0, "hkaAnimationBinding*") // class hkaAnimationBinding*
    HK_TRACKER_MEMBER(RagdollDemoCharacterAnimationSet, m_poseMatchingAnims, 0, "hkaAnimationBinding* [3]") // class hkaAnimationBinding* [3]
    HK_TRACKER_MEMBER(RagdollDemoCharacterAnimationSet, m_ragdollInstance, 0, "hkaRagdollInstance*") // class hkaRagdollInstance*
    HK_TRACKER_MEMBER(RagdollDemoCharacterAnimationSet, m_highResToRagdollMapper, 0, "hkaSkeletonMapper*") // class hkaSkeletonMapper*
    HK_TRACKER_MEMBER(RagdollDemoCharacterAnimationSet, m_ragdollToHighResMapper, 0, "hkaSkeletonMapper*") // class hkaSkeletonMapper*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(RagdollDemoCharacterAnimationSet, s_libraryName)


// RagdollCharacterFactory ::

HK_TRACKER_DECLARE_CLASS_BEGIN(RagdollCharacterFactory)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(FilterLayers)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(RagdollCharacterFactory)
    HK_TRACKER_MEMBER(RagdollCharacterFactory, m_ragdollAnimSet, 0, "RagdollDemoCharacterAnimationSet [6]") // struct RagdollDemoCharacterAnimationSet [6]
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(RagdollCharacterFactory, s_libraryName, AnimatedCharacterFactory)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(RagdollCharacterFactory, FilterLayers, s_libraryName)


// RagdollDemoCharacterCinfo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(RagdollDemoCharacterCinfo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(RagdollDemoCharacterCinfo)
    HK_TRACKER_MEMBER(RagdollDemoCharacterCinfo, m_animationSet, 0, "AnimatedDemoCharacterAnimationSet*") // struct AnimatedDemoCharacterAnimationSet*
    HK_TRACKER_MEMBER(RagdollDemoCharacterCinfo, m_ragdollAnimationSet, 0, "RagdollDemoCharacterAnimationSet*") // struct RagdollDemoCharacterAnimationSet*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(RagdollDemoCharacterCinfo, s_libraryName, DemoCharacterCinfo)


// RagdollDemoCharacter ::

HK_TRACKER_DECLARE_CLASS_BEGIN(RagdollDemoCharacter)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(PoseMatchingSystem)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(RagdollDemoCharacter)
    HK_TRACKER_MEMBER(RagdollDemoCharacter, m_stateManager, 0, "RagdollBipedStateManager*") // class RagdollBipedStateManager*
    HK_TRACKER_MEMBER(RagdollDemoCharacter, m_animationMachine, 0, "AnimationEventQueue*") // class AnimationEventQueue*
    HK_TRACKER_MEMBER(RagdollDemoCharacter, m_wrapperStateMachine, 0, "RagdollBipedStateContext*") // class RagdollBipedStateContext*
    HK_TRACKER_MEMBER(RagdollDemoCharacter, m_animationStateMachine, 0, "SimpleBipedStateContext*") // class SimpleBipedStateContext*
    HK_TRACKER_MEMBER(RagdollDemoCharacter, m_animatedSkeleton, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
    HK_TRACKER_MEMBER(RagdollDemoCharacter, m_currentAnimationPose, 0, "hkaPose*") // class hkaPose*
    HK_TRACKER_MEMBER(RagdollDemoCharacter, m_ragdollInstance, 0, "hkaRagdollInstance*") // class hkaRagdollInstance*
    HK_TRACKER_MEMBER(RagdollDemoCharacter, m_highResToRagdollMapper, 0, "hkaSkeletonMapper*") // class hkaSkeletonMapper*
    HK_TRACKER_MEMBER(RagdollDemoCharacter, m_ragdollToHighResMapper, 0, "hkaSkeletonMapper*") // class hkaSkeletonMapper*
    HK_TRACKER_MEMBER(RagdollDemoCharacter, m_poseMatchingSystem, 0, "RagdollDemoCharacter::PoseMatchingSystem*") // struct RagdollDemoCharacter::PoseMatchingSystem*
    HK_TRACKER_MEMBER(RagdollDemoCharacter, m_skinBindings, 0, "hkArray<hkaMeshBinding *, hkContainerHeapAllocator>") // hkArray< class hkaMeshBinding *, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(RagdollDemoCharacter, m_skins, 0, "hkArray<hkgDisplayObject*, hkContainerHeapAllocator>") // hkArray< class hkgDisplayObject*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(RagdollDemoCharacter, s_libraryName, DemoCharacter)


// PoseMatchingSystem RagdollDemoCharacter

HK_TRACKER_DECLARE_CLASS_BEGIN(RagdollDemoCharacter::PoseMatchingSystem)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(RagdollDemoCharacter::PoseMatchingSystem)
    HK_TRACKER_MEMBER(RagdollDemoCharacter::PoseMatchingSystem, m_poseMatchingAnims, 0, "hkaAnimationBinding* [3]") // class hkaAnimationBinding* [3]
    HK_TRACKER_MEMBER(RagdollDemoCharacter::PoseMatchingSystem, m_blendControl, 0, "hkaDefaultAnimationControl*") // class hkaDefaultAnimationControl*
    HK_TRACKER_MEMBER(RagdollDemoCharacter::PoseMatchingSystem, m_poseMatchUtils, 0, "hkaPoseMatchingUtility*") // class hkaPoseMatchingUtility*
    HK_TRACKER_MEMBER(RagdollDemoCharacter::PoseMatchingSystem, m_mixerControls, 0, "hkArray<hkaDefaultAnimationControl*, hkContainerHeapAllocator>") // hkArray< class hkaDefaultAnimationControl*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(RagdollDemoCharacter::PoseMatchingSystem, s_libraryName)

#include <Demos/DemoCommon/Utilities/Character/DemoCharacter/AnimatedDemoCharacter/StateMachine/RagdollBipedStateMachine.h>


// RagdollBipedStateInput ::

HK_TRACKER_DECLARE_CLASS_BEGIN(RagdollBipedStateInput)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(RagdollBipedStateInput)
    HK_TRACKER_MEMBER(RagdollBipedStateInput, m_ragdollContext, 0, "RagdollBipedStateContext*") // class RagdollBipedStateContext*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(RagdollBipedStateInput, s_libraryName, SimpleBipedStateInput)


// RagdollBipedState ::

HK_TRACKER_DECLARE_CLASS_BEGIN(RagdollBipedState)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(RagdollBipedState)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_ABSTRACT(RagdollBipedState, s_libraryName, hkReferencedObject)


// RagdollBipedStateManager ::

HK_TRACKER_DECLARE_CLASS_BEGIN(RagdollBipedStateManager)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(RagdollBipedStateManager)
    HK_TRACKER_MEMBER(RagdollBipedStateManager, m_registeredStates, 0, "hkPointerMap<hkUint32, RagdollBipedState*, hkContainerHeapAllocator>") // class hkPointerMap< hkUint32, class RagdollBipedState*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(RagdollBipedStateManager, s_libraryName, hkReferencedObject)


// RagdollBipedStateContext ::

HK_TRACKER_DECLARE_CLASS_BEGIN(RagdollBipedStateContext)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(RagdollBipedStateContext)
    HK_TRACKER_MEMBER(RagdollBipedStateContext, m_stateManager, 0, "RagdollBipedStateManager*") // const class RagdollBipedStateManager*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(RagdollBipedStateContext, s_libraryName, hkReferencedObject)

// None RagdollBipedStateTypes
HK_TRACKER_IMPLEMENT_SIMPLE(RagdollBipedStateTypes, s_libraryName)
// None RagdollBipedAnimControls
HK_TRACKER_IMPLEMENT_SIMPLE(RagdollBipedAnimControls, s_libraryName)
#include <Demos/DemoCommon/Utilities/Character/DemoCharacter/AnimatedDemoCharacter/StateMachine/States/RagdollBipedStates.h>


// RagdollBipedWrapperState ::

HK_TRACKER_DECLARE_CLASS_BEGIN(RagdollBipedWrapperState)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(RagdollBipedWrapperState)
    HK_TRACKER_MEMBER(RagdollBipedWrapperState, m_childState, 0, "SimpleBipedState*") // class SimpleBipedState*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(RagdollBipedWrapperState, s_libraryName, RagdollBipedState)


// RagdollBipedDeadState ::

HK_TRACKER_DECLARE_CLASS_BEGIN(RagdollBipedDeadState)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(RagdollBipedDeadState)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(RagdollBipedDeadState, s_libraryName, RagdollBipedState)


// RagdollBipedDyingState ::

HK_TRACKER_DECLARE_CLASS_BEGIN(RagdollBipedDyingState)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(RagdollBipedDyingState)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(RagdollBipedDyingState, s_libraryName, RagdollBipedState)


// RagdollBipedGettingUpState ::

HK_TRACKER_DECLARE_CLASS_BEGIN(RagdollBipedGettingUpState)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(RagdollBipedGettingUpState)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(RagdollBipedGettingUpState, s_libraryName, RagdollBipedState)

#include <Demos/Physics2012/Api/Constraints/EaseConstraintsAction/EaseConstraintsActionDemo.h>


// EaseConstraintsActionDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(EaseConstraintsActionDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(EaseConstraintsActionDemo)
    HK_TRACKER_MEMBER(EaseConstraintsActionDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(EaseConstraintsActionDemo, m_ragdolls, 0, "hkaRagdollInstance* [4]") // class hkaRagdollInstance* [4]
    HK_TRACKER_MEMBER(EaseConstraintsActionDemo, m_lowAnimationPose, 0, "hkaPose*") // class hkaPose*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(EaseConstraintsActionDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/PhysicalAttachments/CharacterAttachments/CharacterAttachments.h>


// CharacterAttachments ::

HK_TRACKER_DECLARE_CLASS_BEGIN(CharacterAttachments)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(CharacterAttachments)
    HK_TRACKER_MEMBER(CharacterAttachments, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(CharacterAttachments, m_loadedData, 0, "hkResource*") // class hkResource*
    HK_TRACKER_MEMBER(CharacterAttachments, m_control, 0, "hkaDefaultAnimationControl*") // class hkaDefaultAnimationControl*
    HK_TRACKER_MEMBER(CharacterAttachments, m_animatedSkeleton, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
    HK_TRACKER_MEMBER(CharacterAttachments, m_ragdollInstance, 0, "hkaRagdollInstance*") // class hkaRagdollInstance*
    HK_TRACKER_MEMBER(CharacterAttachments, m_ragdollSkeleton, 0, "hkaSkeleton*") // class hkaSkeleton*
    HK_TRACKER_MEMBER(CharacterAttachments, m_highToLowMapper, 0, "hkaSkeletonMapper*") // class hkaSkeletonMapper*
    HK_TRACKER_MEMBER(CharacterAttachments, m_dynamicBodies, 0, "hkArray<hkpRigidBody*, hkContainerHeapAllocator>") // hkArray< class hkpRigidBody*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(CharacterAttachments, m_filterViewer, 0, "CollisionFilterViewerUtil") // class CollisionFilterViewerUtil
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(CharacterAttachments, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/PhysicalAttachments/CharacterAttachments/CharacterAttachmentsHelpers.h>


// CharacterAttachmentsHelpers ::

HK_TRACKER_DECLARE_CLASS_BEGIN(CharacterAttachmentsHelpers)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(ConstraintStabilityTricks)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_IMPLEMENT_SIMPLE(CharacterAttachmentsHelpers, s_libraryName)


// ConstraintStabilityTricks CharacterAttachmentsHelpers
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(CharacterAttachmentsHelpers, ConstraintStabilityTricks, s_libraryName)

#include <Demos/ShowCase/Animation/AnimationShowcase.h>


// AnimationShowcase ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AnimationShowcase)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(ObjectMap)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(WhichLeg)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(WhichArm)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AnimationShowcase)
    HK_TRACKER_MEMBER(AnimationShowcase, m_raycastInterface, 0, "hkaRaycastInterface*") // class hkaRaycastInterface*
    HK_TRACKER_MEMBER(AnimationShowcase, m_footPlacementComponent, 0, "hkaFootPlacementIkSolver* [2]") // class hkaFootPlacementIkSolver* [2]
    HK_TRACKER_MEMBER(AnimationShowcase, m_ragdollInstance, 0, "hkaRagdollInstance*") // class hkaRagdollInstance*
    HK_TRACKER_MEMBER(AnimationShowcase, m_ragdollToHighResMapper, 0, "hkaSkeletonMapper*") // class hkaSkeletonMapper*
    HK_TRACKER_MEMBER(AnimationShowcase, m_highResToRagdollMapper, 0, "hkaSkeletonMapper*") // class hkaSkeletonMapper*
    HK_TRACKER_MEMBER(AnimationShowcase, m_ragdollDisplayBodies, 0, "hkArray<hkgDisplayObject*, hkContainerHeapAllocator>") // hkArray< class hkgDisplayObject*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(AnimationShowcase, m_rigidBodyController, 0, "hkaRagdollRigidBodyController*") // class hkaRagdollRigidBodyController*
    HK_TRACKER_MEMBER(AnimationShowcase, m_lowerBodyBones, 0, "hkArray<hkInt16, hkContainerHeapAllocator>") // hkArray< hkInt16, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(AnimationShowcase, m_matchingPose, 0, "AnimationMixerSkeletalAnimation*") // class AnimationMixerSkeletalAnimation*
    HK_TRACKER_MEMBER(AnimationShowcase, m_matchingPoseControl, 0, "AnimationMixerControl*") // class AnimationMixerControl*
    HK_TRACKER_MEMBER(AnimationShowcase, m_blendControl, 0, "hkaDefaultAnimationControl*") // class hkaDefaultAnimationControl*
    HK_TRACKER_MEMBER(AnimationShowcase, m_poseMatchUtils, 0, "hkaPoseMatchingUtility*") // class hkaPoseMatchingUtility*
    HK_TRACKER_MEMBER(AnimationShowcase, m_skinBindings, 0, "hkArray<hkaMeshBinding *, hkContainerHeapAllocator>") // hkArray< class hkaMeshBinding *, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(AnimationShowcase, m_cameras, 0, "hkxCamera **") // class hkxCamera **
    HK_TRACKER_MEMBER(AnimationShowcase, m_characterProxy, 0, "hkpCharacterProxy*") // class hkpCharacterProxy*
    HK_TRACKER_MEMBER(AnimationShowcase, m_proxyListener, 0, "AnimCharacterListener*") // class AnimCharacterListener*
    HK_TRACKER_MEMBER(AnimationShowcase, m_proxyDisplay, 0, "hkgDisplayObject*") // class hkgDisplayObject*
    HK_TRACKER_MEMBER(AnimationShowcase, m_wallPoints, 0, "hkArray<hkTransformf, hkContainerHeapAllocator>") // hkArray< hkTransformf, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(AnimationShowcase, m_bricks, 0, "hkArray<hkpRigidBody *, hkContainerHeapAllocator>") // hkArray< class hkpRigidBody *, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(AnimationShowcase, m_lightmapDisplay, 0, "hkgDisplayObject*") // class hkgDisplayObject*
    HK_TRACKER_MEMBER(AnimationShowcase, m_vertexColorDisplay, 0, "hkgDisplayObject*") // class hkgDisplayObject*
    HK_TRACKER_MEMBER(AnimationShowcase, m_chuckables, 0, "hkArray<AnimationShowcase::ObjectMap, hkContainerHeapAllocator>") // hkArray< struct AnimationShowcase::ObjectMap, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(AnimationShowcase, m_chuckedItems, 0, "hkArray<hkpRigidBody *, hkContainerHeapAllocator>") // hkArray< class hkpRigidBody *, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(AnimationShowcase, m_stateManager, 0, "AnimStateManager*") // class AnimStateManager*
    HK_TRACKER_MEMBER(AnimationShowcase, m_animationMachine, 0, "AnimationMachine*") // class AnimationMachine*
    HK_TRACKER_MEMBER(AnimationShowcase, m_animationStateMachine, 0, "AnimStateContext*") // class AnimStateContext*
    HK_TRACKER_MEMBER(AnimationShowcase, m_animatedSkeleton, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
    HK_TRACKER_MEMBER(AnimationShowcase, m_selected, 0, "hkStringPtr") // hkStringPtr
    HK_TRACKER_MEMBER(AnimationShowcase, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(AnimationShowcase, m_rigContainer, 0, "hkRootLevelContainer*") // class hkRootLevelContainer*
    HK_TRACKER_MEMBER(AnimationShowcase, m_warpPoints, 0, "hkArray<hkTransformf, hkContainerHeapAllocator>") // hkArray< hkTransformf, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(AnimationShowcase, s_libraryName, hkDefaultPhysics2012Demo)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(AnimationShowcase, WhichLeg, s_libraryName)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(AnimationShowcase, WhichArm, s_libraryName)


// ObjectMap AnimationShowcase

HK_TRACKER_DECLARE_CLASS_BEGIN(AnimationShowcase::ObjectMap)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AnimationShowcase::ObjectMap)
    HK_TRACKER_MEMBER(AnimationShowcase::ObjectMap, m_rb, 0, "hkpRigidBody*") // class hkpRigidBody*
    HK_TRACKER_MEMBER(AnimationShowcase::ObjectMap, m_dispObj, 0, "hkgDisplayObject*") // class hkgDisplayObject*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(AnimationShowcase::ObjectMap, s_libraryName)

#include <Demos/ShowCase/Animation/AnimationShowcaseOptions.h>


// hkAnimDisplayOptions ::
HK_TRACKER_IMPLEMENT_SIMPLE(hkAnimDisplayOptions, s_libraryName)


// hkAnimProxyOptions ::
HK_TRACKER_IMPLEMENT_SIMPLE(hkAnimProxyOptions, s_libraryName)


// hkAnimIkOptions ::
HK_TRACKER_IMPLEMENT_SIMPLE(hkAnimIkOptions, s_libraryName)


// hkAnimMatchOptions ::
HK_TRACKER_IMPLEMENT_SIMPLE(hkAnimMatchOptions, s_libraryName)


// hkAnimGetupOptions ::
HK_TRACKER_IMPLEMENT_SIMPLE(hkAnimGetupOptions, s_libraryName)


// hkAnimGetHitOptions ::

HK_TRACKER_DECLARE_CLASS_BEGIN(hkAnimGetHitOptions)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Velocity)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Position)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Snap)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_IMPLEMENT_SIMPLE(hkAnimGetHitOptions, s_libraryName)


// Velocity hkAnimGetHitOptions
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(hkAnimGetHitOptions, Velocity, s_libraryName)


// Position hkAnimGetHitOptions
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(hkAnimGetHitOptions, Position, s_libraryName)


// Snap hkAnimGetHitOptions
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(hkAnimGetHitOptions, Snap, s_libraryName)


// hkAnimPhysicsOptions ::
HK_TRACKER_IMPLEMENT_SIMPLE(hkAnimPhysicsOptions, s_libraryName)


// hkAnimMiscOptions ::
HK_TRACKER_IMPLEMENT_SIMPLE(hkAnimMiscOptions, s_libraryName)


// AnimationShowcaseOptions ::
HK_TRACKER_IMPLEMENT_SIMPLE(AnimationShowcaseOptions, s_libraryName)

#include <Demos/ShowCase/Animation/Components/AnimProxyListener.h>


// AnimCharacterListener ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AnimCharacterListener)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AnimCharacterListener)
    HK_TRACKER_MEMBER(AnimCharacterListener, m_options, 0, "AnimationShowcaseOptions*") // const class AnimationShowcaseOptions*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(AnimCharacterListener, s_libraryName, hkReferencedObject)

#include <Demos/ShowCase/Animation/Statemachine/AnimState.h>


// AnimationMachine ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AnimationMachine)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(AnimationCommand)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(AnimationCommandType)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AnimationMachine)
    HK_TRACKER_MEMBER(AnimationMachine, m_animatedSkeleton, 0, "hkaAnimatedSkeleton*") // class hkaAnimatedSkeleton*
    HK_TRACKER_MEMBER(AnimationMachine, m_eventQueue, 0, "hkArray<AnimationMachine::AnimationCommand, hkContainerHeapAllocator>") // hkArray< struct AnimationMachine::AnimationCommand, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(AnimationMachine, s_libraryName, hkReferencedObject)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(AnimationMachine, AnimationCommandType, s_libraryName)

// hk.MemoryTracker ignore EaseParams
// hk.MemoryTracker ignore SetWeightParams
// hk.MemoryTracker ignore SetTimeParams
// hk.MemoryTracker ignore SetSpeedParams

// AnimationCommand AnimationMachine
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(AnimationMachine, AnimationCommand, s_libraryName)


// AnimStateInput ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AnimStateInput)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AnimStateInput)
    HK_TRACKER_MEMBER(AnimStateInput, m_animMachine, 0, "AnimationMachine*") // class AnimationMachine*
    HK_TRACKER_MEMBER(AnimStateInput, m_context, 0, "AnimStateContext*") // class AnimStateContext*
    HK_TRACKER_MEMBER(AnimStateInput, m_options, 0, "AnimationShowcaseOptions*") // class AnimationShowcaseOptions*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(AnimStateInput, s_libraryName)


// AnimState ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AnimState)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AnimState)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_ABSTRACT(AnimState, s_libraryName, hkReferencedObject)


// AnimStateManager ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AnimStateManager)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AnimStateManager)
    HK_TRACKER_MEMBER(AnimStateManager, m_registeredStates, 0, "hkPointerMap<hkUint32, AnimState*, hkContainerHeapAllocator>") // class hkPointerMap< hkUint32, class AnimState*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(AnimStateManager, s_libraryName, hkReferencedObject)


// AnimStateContext ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AnimStateContext)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AnimStateContext)
    HK_TRACKER_MEMBER(AnimStateContext, m_stateManager, 0, "AnimStateManager*") // const class AnimStateManager*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(AnimStateContext, s_libraryName, hkReferencedObject)

#include <Demos/ShowCase/Animation/Statemachine/AnimStateTypes.h>

// None AnimStateTypes
HK_TRACKER_IMPLEMENT_SIMPLE(AnimStateTypes, s_libraryName)
// None AnimControls
HK_TRACKER_IMPLEMENT_SIMPLE(AnimControls, s_libraryName)
#include <Demos/ShowCase/Animation/Statemachine/States/AnimDeadState.h>


// AnimDeadState ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AnimDeadState)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AnimDeadState)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(AnimDeadState, s_libraryName, AnimState)

#include <Demos/ShowCase/Animation/Statemachine/States/AnimDiveState.h>


// AnimDiveState ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AnimDiveState)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AnimDiveState)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(AnimDiveState, s_libraryName, AnimState)

#include <Demos/ShowCase/Animation/Statemachine/States/AnimDyingState.h>


// AnimDyingState ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AnimDyingState)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AnimDyingState)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(AnimDyingState, s_libraryName, AnimState)

#include <Demos/ShowCase/Animation/Statemachine/States/AnimGettingUpState.h>


// AnimGettingUpState ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AnimGettingUpState)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AnimGettingUpState)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(AnimGettingUpState, s_libraryName, AnimState)

#include <Demos/ShowCase/Animation/Statemachine/States/AnimInAirState.h>


// AnimInAirState ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AnimInAirState)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AnimInAirState)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(AnimInAirState, s_libraryName, AnimState)

#include <Demos/ShowCase/Animation/Statemachine/States/AnimJumpState.h>


// AnimJumpState ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AnimJumpState)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AnimJumpState)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(AnimJumpState, s_libraryName, AnimState)

#include <Demos/ShowCase/Animation/Statemachine/States/AnimLandState.h>


// AnimLandState ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AnimLandState)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AnimLandState)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(AnimLandState, s_libraryName, AnimState)

#include <Demos/ShowCase/Animation/Statemachine/States/AnimStandState.h>


// AnimStandState ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AnimStandState)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AnimStandState)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(AnimStandState, s_libraryName, AnimState)

#include <Demos/ShowCase/Animation/Statemachine/States/AnimWalkState.h>


// AnimWalkState ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AnimWalkState)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AnimWalkState)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(AnimWalkState, s_libraryName, AnimState)


#endif // HK_FEATURE_PRODUCT_ANIMATION && HK_FEATURE_PRODUCT_PHYSICS_2012


#if defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
#include <Common/Base/Memory/Tracker/hkTrackerClassDefinition.h>

 void HK_CALL DemosPHYSICS_2012Register() {}

#include <Demos/Common/Api/MemoryWalk/MemoryWalk.h>


// MemoryWalkDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MemoryWalkDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(DemoVariant)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Allocation)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Block)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MemoryWalkDemo)
    HK_TRACKER_MEMBER(MemoryWalkDemo, m_variant, 0, "MemoryWalkDemo::DemoVariant") // struct MemoryWalkDemo::DemoVariant
    HK_TRACKER_MEMBER(MemoryWalkDemo, m_allocs, 0, "hkArray<MemoryWalkDemo::Allocation, hkContainerHeapAllocator>") // hkArray< struct MemoryWalkDemo::Allocation, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(MemoryWalkDemo, m_blocks, 0, "hkArray<MemoryWalkDemo::Block, hkContainerHeapAllocator>") // hkArray< struct MemoryWalkDemo::Block, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(MemoryWalkDemo, m_memoryStart, 0, "char*") // char*
    HK_TRACKER_MEMBER(MemoryWalkDemo, m_memory, 0, "hkFreeListAllocator*") // class hkFreeListAllocator*
    HK_TRACKER_MEMBER(MemoryWalkDemo, m_largeBlockAllocator, 0, "hkLargeBlockAllocator*") // class hkLargeBlockAllocator*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(MemoryWalkDemo, s_libraryName, hkDefaultPhysics2012Demo)


// DemoVariant MemoryWalkDemo

HK_TRACKER_DECLARE_CLASS_BEGIN(MemoryWalkDemo::DemoVariant)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Operation)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MemoryWalkDemo::DemoVariant)
    HK_TRACKER_MEMBER(MemoryWalkDemo::DemoVariant, m_name, 0, "char*") // const char*
    HK_TRACKER_MEMBER(MemoryWalkDemo::DemoVariant, m_details, 0, "char*") // const char*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(MemoryWalkDemo::DemoVariant, s_libraryName)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(MemoryWalkDemo::DemoVariant, Operation, s_libraryName)


// Allocation MemoryWalkDemo
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(MemoryWalkDemo, Allocation, s_libraryName)


// Block MemoryWalkDemo

HK_TRACKER_DECLARE_CLASS_BEGIN(MemoryWalkDemo::Block)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MemoryWalkDemo::Block)
    HK_TRACKER_MEMBER(MemoryWalkDemo::Block, m_start, 0, "void*") // void*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(MemoryWalkDemo::Block, s_libraryName)

#include <Demos/Common/Api/Serialize/NativePackfileLoad/NativePackfileLoadDemo.h>


// NativePackfileLoadDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(NativePackfileLoadDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(NativePackfileLoadDemo)
    HK_TRACKER_MEMBER(NativePackfileLoadDemo, m_dataBuffer, 0, "hkArray<char, hkContainerHeapAllocator>") // hkArray< char, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(NativePackfileLoadDemo, m_resource, 0, "hkResource*") // class hkResource*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(NativePackfileLoadDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Common/Api/Serialize/SimpleLoad/SimpleLoadDemo.h>


// SimpleLoadDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SimpleLoadDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SimpleLoadDemo)
    HK_TRACKER_MEMBER(SimpleLoadDemo, m_loadedData, 0, "hkResource*") // class hkResource*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SimpleLoadDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/DemoCommon/DemoFramework/PhysicsStepper.h>


// PhysicsDemoStepper ::

HK_TRACKER_DECLARE_CLASS_BEGIN(PhysicsDemoStepper)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(PhysicsDemoStepper)
    HK_TRACKER_MEMBER(PhysicsDemoStepper, m_world, 0, "hkpWorld*") // class hkpWorld*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(PhysicsDemoStepper, s_libraryName, DemoStepper)

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysics2012Demo.h>


// hkDefaultPhysics2012Demo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(hkDefaultPhysics2012Demo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(PhysicsOptions)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(DemoFlags)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(hkDefaultPhysics2012Demo)
    HK_TRACKER_MEMBER(hkDefaultPhysics2012Demo, m_mouseSpring, 0, "hkpMouseSpringAction*") // class hkpMouseSpringAction*
    HK_TRACKER_MEMBER(hkDefaultPhysics2012Demo, m_physicsViewersContext, 0, "hkpPhysicsContext*") // class hkpPhysicsContext*
    HK_TRACKER_MEMBER(hkDefaultPhysics2012Demo, m_world, 0, "hkpWorld*") // class hkpWorld*
    HK_TRACKER_MEMBER(hkDefaultPhysics2012Demo, m_splash, 0, "SplashScreen*") // class SplashScreen*
    HK_TRACKER_MEMBER(hkDefaultPhysics2012Demo, m_solverMemoryGraph, 0, "hkgSeriesGraph*") // class hkgSeriesGraph*
    HK_TRACKER_MEMBER(hkDefaultPhysics2012Demo, m_mouseSpringAppliedCallbacks, 0, "hkArray<void*, hkContainerHeapAllocator>") // hkArray< void*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(hkDefaultPhysics2012Demo, s_libraryName, hkDefaultDemo)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(hkDefaultPhysics2012Demo, DemoFlags, s_libraryName)


// PhysicsOptions hkDefaultPhysics2012Demo
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(hkDefaultPhysics2012Demo, PhysicsOptions, s_libraryName)

#include <Demos/DemoCommon/Utilities/Character/CharacterProxy/RigidBodyCharacterProxy/RigidBodyCharacterProxy.h>


// RigidBodyCharacterProxy ::

HK_TRACKER_DECLARE_CLASS_BEGIN(RigidBodyCharacterProxy)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(RigidBodyCharacterProxy)
    HK_TRACKER_MEMBER(RigidBodyCharacterProxy, m_characterRb, 0, "hkpCharacterRigidBody *") // class hkpCharacterRigidBody *
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(RigidBodyCharacterProxy, s_libraryName, CharacterProxy)

#include <Demos/DemoCommon/Utilities/Character/CharacterUtils.h>

// hk.MemoryTracker ignore CharacterUtils
#include <Demos/DemoCommon/Utilities/Character/DemoCharacter/PhysicsDemoCharacter/PhysicsDemoCharacter.h>


// Physics2012CharacterFactory ::

HK_TRACKER_DECLARE_CLASS_BEGIN(Physics2012CharacterFactory)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(Physics2012CharacterFactory)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(Physics2012CharacterFactory, s_libraryName, CharacterFactory)

#include <Demos/DemoCommon/Utilities/Character/DemoCharacter/UserControlledDemoCharacter.h>


// UserControlledDemoCharacter ::

HK_TRACKER_DECLARE_CLASS_BEGIN(UserControlledDemoCharacter)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(UserControlledDemoCharacter)
    HK_TRACKER_MEMBER(UserControlledDemoCharacter, m_demoCharacter, 0, "DemoCharacter*") // class DemoCharacter*
    HK_TRACKER_MEMBER(UserControlledDemoCharacter, m_transparentObjects, 0, "hkArray<hkUlong, hkContainerHeapAllocator>") // hkArray< hkUlong, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(UserControlledDemoCharacter, s_libraryName, hkReferencedObject)

#include <Demos/DemoCommon/Utilities/ContactPainter/ContactPainter.h>


// ContactPainter ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ContactPainter)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ContactPainter)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ContactPainter, s_libraryName, hkpContactListener)

#include <Demos/DemoCommon/Utilities/ContactReporter/ContactReporter.h>


// ContactReporter ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ContactReporter)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(ContactPointInfo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ContactReporter)
    HK_TRACKER_MEMBER(ContactReporter, m_infos, 0, "hkArray<ContactReporter::ContactPointInfo*, hkContainerHeapAllocator>") // hkArray< struct ContactReporter::ContactPointInfo*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(ContactReporter, m_extantInfos, 0, "hkArray<ContactReporter::ContactPointInfo*, hkContainerHeapAllocator>") // hkArray< struct ContactReporter::ContactPointInfo*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ContactReporter, s_libraryName, hkpContactListener)


// ContactPointInfo ContactReporter
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(ContactReporter, ContactPointInfo, s_libraryName)

#include <Demos/DemoCommon/Utilities/FixedConstraint/hkFixedConstraint.h>


// hkFixedConstraintData ::

HK_TRACKER_DECLARE_CLASS_BEGIN(hkFixedConstraintData)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(hkFixedConstraintData)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(hkFixedConstraintData, s_libraryName, hkpGenericConstraintData)

#include <Demos/DemoCommon/Utilities/GameUtils/CollisionFilterViewerUtil/CollisionFilterViewerUtil.h>


// CollisionFilterViewerUtil ::

HK_TRACKER_DECLARE_CLASS_BEGIN(CollisionFilterViewerUtil)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(CollisionFilterViewerUtil)
    HK_TRACKER_MEMBER(CollisionFilterViewerUtil, m_bodiesColored, 0, "hkArray<hkpRigidBody*, hkContainerHeapAllocator>") // hkArray< const class hkpRigidBody*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(CollisionFilterViewerUtil, m_colors, 0, "hkArray<hkUint32, hkContainerHeapAllocator>") // hkArray< hkUint32, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(CollisionFilterViewerUtil, s_libraryName)

#include <Demos/DemoCommon/Utilities/GameUtils/Fracture/ConcreteFractureCollisionListener.h>


// ConcreteFractureCollisionListener ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ConcreteFractureCollisionListener)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ConcreteFractureCollisionListener)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ConcreteFractureCollisionListener, s_libraryName, FractureCollisionListener)

#include <Demos/DemoCommon/Utilities/GameUtils/Fracture/EntityTimeQueue.h>


// EntityTimeQueue ::

HK_TRACKER_DECLARE_CLASS_BEGIN(EntityTimeQueue)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(TemporaryEntityInfo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(EntityTimeQueue)
    HK_TRACKER_MEMBER(EntityTimeQueue, m_entityInfos, 0, "hkArray<EntityTimeQueue::TemporaryEntityInfo, hkContainerHeapAllocator>") // hkArray< struct EntityTimeQueue::TemporaryEntityInfo, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(EntityTimeQueue, s_libraryName)


// TemporaryEntityInfo EntityTimeQueue

HK_TRACKER_DECLARE_CLASS_BEGIN(EntityTimeQueue::TemporaryEntityInfo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(EntityTimeQueue::TemporaryEntityInfo)
    HK_TRACKER_MEMBER(EntityTimeQueue::TemporaryEntityInfo, m_entity, 0, "hkpEntity*") // class hkpEntity*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(EntityTimeQueue::TemporaryEntityInfo, s_libraryName)

#include <Demos/DemoCommon/Utilities/GameUtils/Fracture/FractureCollisionListener.h>


// FractureCollisionListener ::

HK_TRACKER_DECLARE_CLASS_BEGIN(FractureCollisionListener)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(FractureCollisionListener)
    HK_TRACKER_MEMBER(FractureCollisionListener, m_fracturedBodies, 0, "hkArray<hkpRigidBody*, hkContainerHeapAllocator>*") // hkArray< class hkpRigidBody*, struct hkContainerHeapAllocator >*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_ABSTRACT(FractureCollisionListener, s_libraryName, hkReferencedObject)

#include <Demos/DemoCommon/Utilities/GameUtils/Fracture/FractureUtil.h>


// FractureUtil ::

HK_TRACKER_DECLARE_CLASS_BEGIN(FractureUtil)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(ShapeInfo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(FractureInput)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(GlassFractureInput)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(GlassFractureOutput)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(ConcreteFractureInput)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(ConcreteFractureOutput)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(ExportGeometryAsProperty)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_IMPLEMENT_SIMPLE(FractureUtil, s_libraryName)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(FractureUtil, ExportGeometryAsProperty, s_libraryName)


// ShapeInfo FractureUtil

HK_TRACKER_DECLARE_CLASS_BEGIN(FractureUtil::ShapeInfo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(FractureUtil::ShapeInfo)
    HK_TRACKER_MEMBER(FractureUtil::ShapeInfo, m_shape, 0, "hkpConvexShape*") // class hkpConvexShape*
    HK_TRACKER_MEMBER(FractureUtil::ShapeInfo, m_geometry, 0, "hkGeometry*") // struct hkGeometry*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(FractureUtil::ShapeInfo, s_libraryName)


// FractureInput FractureUtil

HK_TRACKER_DECLARE_CLASS_BEGIN(FractureUtil::FractureInput)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(FractureUtil::FractureInput)
    HK_TRACKER_MEMBER(FractureUtil::FractureInput, m_shape, 0, "hkpConvexShape*") // const class hkpConvexShape*
    HK_TRACKER_MEMBER(FractureUtil::FractureInput, m_displayObject, 0, "hkgDisplayObject*") // class hkgDisplayObject*
    HK_TRACKER_MEMBER(FractureUtil::FractureInput, m_displayContext, 0, "hkgDisplayContext*") // class hkgDisplayContext*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(FractureUtil::FractureInput, s_libraryName)


// GlassFractureInput FractureUtil

HK_TRACKER_DECLARE_CLASS_BEGIN(FractureUtil::GlassFractureInput)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(FractureUtil::GlassFractureInput)
    HK_TRACKER_MEMBER(FractureUtil::GlassFractureInput, m_generator, 0, "hkPseudoRandomGenerator*") // class hkPseudoRandomGenerator*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(FractureUtil::GlassFractureInput, s_libraryName, FractureUtil::FractureInput)


// GlassFractureOutput FractureUtil

HK_TRACKER_DECLARE_CLASS_BEGIN(FractureUtil::GlassFractureOutput)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(FractureUtil::GlassFractureOutput)
    HK_TRACKER_MEMBER(FractureUtil::GlassFractureOutput, m_innerShapes, 0, "hkInplaceArray<FractureUtil::ShapeInfo, 64, hkContainerHeapAllocator>") // class hkInplaceArray< struct FractureUtil::ShapeInfo, 64, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(FractureUtil::GlassFractureOutput, m_outerShapes, 0, "hkInplaceArray<FractureUtil::ShapeInfo, 16, hkContainerHeapAllocator>") // class hkInplaceArray< struct FractureUtil::ShapeInfo, 16, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(FractureUtil::GlassFractureOutput, m_innerShapesDisplayObjects, 0, "hkInplaceArray<hkgDisplayObject*, 64, hkContainerHeapAllocator>") // class hkInplaceArray< class hkgDisplayObject*, 64, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(FractureUtil::GlassFractureOutput, m_outerShapesDisplayObjects, 0, "hkInplaceArray<hkgDisplayObject*, 64, hkContainerHeapAllocator>") // class hkInplaceArray< class hkgDisplayObject*, 64, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(FractureUtil::GlassFractureOutput, s_libraryName)


// ConcreteFractureInput FractureUtil

HK_TRACKER_DECLARE_CLASS_BEGIN(FractureUtil::ConcreteFractureInput)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(FractureUtil::ConcreteFractureInput)
    HK_TRACKER_MEMBER(FractureUtil::ConcreteFractureInput, m_generator, 0, "hkPseudoRandomGenerator*") // class hkPseudoRandomGenerator*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(FractureUtil::ConcreteFractureInput, s_libraryName, FractureUtil::FractureInput)


// ConcreteFractureOutput FractureUtil

HK_TRACKER_DECLARE_CLASS_BEGIN(FractureUtil::ConcreteFractureOutput)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(FractureUtil::ConcreteFractureOutput)
    HK_TRACKER_MEMBER(FractureUtil::ConcreteFractureOutput, m_shapes, 0, "hkInplaceArray<FractureUtil::ShapeInfo, 64, hkContainerHeapAllocator>") // class hkInplaceArray< struct FractureUtil::ShapeInfo, 64, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(FractureUtil::ConcreteFractureOutput, m_bulletHoleDebrisShapes, 0, "hkInplaceArray<FractureUtil::ShapeInfo, 64, hkContainerHeapAllocator>") // class hkInplaceArray< struct FractureUtil::ShapeInfo, 64, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(FractureUtil::ConcreteFractureOutput, m_displayObjects, 0, "hkInplaceArray<hkgDisplayObject*, 64, hkContainerHeapAllocator>") // class hkInplaceArray< class hkgDisplayObject*, 64, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(FractureUtil::ConcreteFractureOutput, m_bulletHoleDebrisDisplayObjects, 0, "hkInplaceArray<hkgDisplayObject*, 64, hkContainerHeapAllocator>") // class hkInplaceArray< class hkgDisplayObject*, 64, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(FractureUtil::ConcreteFractureOutput, s_libraryName)

#include <Demos/DemoCommon/Utilities/GameUtils/Fracture/GlassFractureCollisionListener.h>


// GlassFractureCollisionListener ::

HK_TRACKER_DECLARE_CLASS_BEGIN(GlassFractureCollisionListener)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(GlassFractureCollisionListener)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(GlassFractureCollisionListener, s_libraryName, FractureCollisionListener)

#include <Demos/DemoCommon/Utilities/GameUtils/Fracture/SetBodyVelocityAsCriticalOperation.h>


// SetBodyVelocityAsCriticalOperation ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SetBodyVelocityAsCriticalOperation)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SetBodyVelocityAsCriticalOperation)
    HK_TRACKER_MEMBER(SetBodyVelocityAsCriticalOperation, m_body, 0, "hkpRigidBody*") // class hkpRigidBody*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SetBodyVelocityAsCriticalOperation, s_libraryName, hkWorldOperation::UserCallback)

#include <Demos/DemoCommon/Utilities/GameUtils/GameUtils.h>


// GameUtils ::

HK_TRACKER_DECLARE_CLASS_BEGIN(GameUtils)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(RagdollCinfo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(RagdollPartType)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(RagdollWantHandsAndFeet)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(RagdollInterBoneCollisions)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_IMPLEMENT_SIMPLE(GameUtils, s_libraryName)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(GameUtils, RagdollPartType, s_libraryName)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(GameUtils, RagdollWantHandsAndFeet, s_libraryName)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(GameUtils, RagdollInterBoneCollisions, s_libraryName)


// RagdollCinfo GameUtils
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(GameUtils, RagdollCinfo, s_libraryName)

#include <Demos/DemoCommon/Utilities/GameUtils/Landscape/FlatLand.h>


// FlatLand ::

HK_TRACKER_DECLARE_CLASS_BEGIN(FlatLand)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(FlatLand)
    HK_TRACKER_MEMBER(FlatLand, m_vertices, 0, "hkArray<float, hkContainerHeapAllocator>") // hkArray< float, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(FlatLand, m_indices, 0, "hkArray<hkUint16, hkContainerHeapAllocator>") // hkArray< hkUint16, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(FlatLand, s_libraryName, hkReferencedObject)

#include <Demos/DemoCommon/Utilities/GameUtils/Landscape/LandscapeRepository.h>


// LandscapeContainer ::

HK_TRACKER_DECLARE_CLASS_BEGIN(LandscapeContainer)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(LandscapeContainer)
    HK_TRACKER_MEMBER(LandscapeContainer, m_shape, 0, "hkpShape*") // class hkpShape*
    HK_TRACKER_MEMBER(LandscapeContainer, m_packfileData, 0, "hkPackfileData*") // class hkPackfileData*
    HK_TRACKER_MEMBER(LandscapeContainer, m_spawnVolumes, 0, "hkArray<hkAabb, hkContainerHeapAllocator>") // hkArray< class hkAabb, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(LandscapeContainer, s_libraryName, hkReferencedObject)


// AabbSpawnUtil ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AabbSpawnUtil)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AabbSpawnUtil)
    HK_TRACKER_MEMBER(AabbSpawnUtil, m_spawnedAabbs, 0, "hkArray<hkArray<hkAabb, hkContainerHeapAllocator>, hkContainerHeapAllocator>") // hkArray< hkArray< class hkAabb, struct hkContainerHeapAllocator >, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(AabbSpawnUtil, s_libraryName, hkReferencedObject)


// LandscapeRepository ::

HK_TRACKER_DECLARE_CLASS_BEGIN(LandscapeRepository)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(LandscapeEntry)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(LandscapeRepository)
    HK_TRACKER_MEMBER(LandscapeRepository, m_landscapeEntries, 0, "hkArray<LandscapeRepository::LandscapeEntry, hkContainerHeapAllocator>") // hkArray< struct LandscapeRepository::LandscapeEntry, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(LandscapeRepository, m_cachedLandscapes, 0, "hkArray<LandscapeContainer*, hkContainerHeapAllocator>") // hkArray< class LandscapeContainer*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(LandscapeRepository, s_libraryName, hkReferencedObject)


// LandscapeEntry LandscapeRepository

HK_TRACKER_DECLARE_CLASS_BEGIN(LandscapeRepository::LandscapeEntry)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(LandscapeRepository::LandscapeEntry)
    HK_TRACKER_MEMBER(LandscapeRepository::LandscapeEntry, m_name, 0, "char*") // const char*
    HK_TRACKER_MEMBER(LandscapeRepository::LandscapeEntry, m_param, 0, "void*") // void*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(LandscapeRepository::LandscapeEntry, s_libraryName)


// LandscapeEntryRegister ::

HK_TRACKER_DECLARE_CLASS_BEGIN(LandscapeEntryRegister)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(LandscapeEntryRegister)
    HK_TRACKER_MEMBER(LandscapeEntryRegister, m_name, 0, "char*") // const char*
    HK_TRACKER_MEMBER(LandscapeEntryRegister, m_param, 0, "void*") // void*
    HK_TRACKER_MEMBER(LandscapeEntryRegister, m_next, 0, "LandscapeEntryRegister*") // struct LandscapeEntryRegister*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(LandscapeEntryRegister, s_libraryName)

#include <Demos/DemoCommon/Utilities/GameUtils/Landscape/RoundTrack.h>


// RoundTrackDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(RoundTrackDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(RoundTrackDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(RoundTrackDemo, s_libraryName, hkReferencedObject)

#include <Demos/DemoCommon/Utilities/GameUtils/TankModel/TankModel.h>


// TankModel ::

HK_TRACKER_DECLARE_CLASS_BEGIN(TankModel)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(TankModel)
    HK_TRACKER_MEMBER(TankModel, m_skiL, 0, "hkpRigidBody*") // class hkpRigidBody*
    HK_TRACKER_MEMBER(TankModel, m_skiR, 0, "hkpRigidBody*") // class hkpRigidBody*
    HK_TRACKER_MEMBER(TankModel, m_body, 0, "hkpRigidBody*") // class hkpRigidBody*
    HK_TRACKER_MEMBER(TankModel, m_tower, 0, "hkpRigidBody*") // class hkpRigidBody*
    HK_TRACKER_MEMBER(TankModel, m_gun, 0, "hkpRigidBody*") // class hkpRigidBody*
    HK_TRACKER_MEMBER(TankModel, m_towerMotor, 0, "hkpLimitedHingeConstraintData*") // class hkpLimitedHingeConstraintData*
    HK_TRACKER_MEMBER(TankModel, m_gunMotor, 0, "hkpLimitedHingeConstraintData*") // class hkpLimitedHingeConstraintData*
    HK_TRACKER_MEMBER(TankModel, m_left, 0, "hkpSurfaceVelocityUtil*") // class hkpSurfaceVelocityUtil*
    HK_TRACKER_MEMBER(TankModel, m_right, 0, "hkpSurfaceVelocityUtil*") // class hkpSurfaceVelocityUtil*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(TankModel, s_libraryName)

#include <Demos/DemoCommon/Utilities/GameUtils/TransmissionCalculatorUtil.h>


// TransmissionCalculatorUtil ::
HK_TRACKER_IMPLEMENT_SIMPLE(TransmissionCalculatorUtil, s_libraryName)

#include <Demos/DemoCommon/Utilities/Loading/PhysicsLoadingUtil.h>


// PhysicsLoadingUtil ::

HK_TRACKER_DECLARE_CLASS_BEGIN(PhysicsLoadingUtil)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(InputOptions)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Output)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_IMPLEMENT_SIMPLE(PhysicsLoadingUtil, s_libraryName)


// InputOptions PhysicsLoadingUtil
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(PhysicsLoadingUtil, InputOptions, s_libraryName)


// Output PhysicsLoadingUtil

HK_TRACKER_DECLARE_CLASS_BEGIN(PhysicsLoadingUtil::Output)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(PhysicsLoadingUtil::Output)
    HK_TRACKER_MEMBER(PhysicsLoadingUtil::Output, m_physicsData, 0, "hkpPhysicsData *") // class hkpPhysicsData *
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(PhysicsLoadingUtil::Output, s_libraryName, LoadingUtil::Output)

#include <Demos/DemoCommon/Utilities/MarbleAction/MarbleAction.h>


// MarbleAction ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MarbleAction)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MarbleAction)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(MarbleAction, s_libraryName, hkpUnaryAction)

#include <Demos/DemoCommon/Utilities/Particles/Listener/CollisionParticleListener.h>


// CollisionParticleListener ::

HK_TRACKER_DECLARE_CLASS_BEGIN(CollisionParticleListener)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(ContactInfo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(CollisionParticleListener)
    HK_TRACKER_MEMBER(CollisionParticleListener, m_contacts, 0, "hkArray<CollisionParticleListener::ContactInfo, hkContainerHeapAllocator>") // hkArray< struct CollisionParticleListener::ContactInfo, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(CollisionParticleListener, s_libraryName, hkReferencedObject)


// ContactInfo CollisionParticleListener
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(CollisionParticleListener, ContactInfo, s_libraryName)

#include <Demos/DemoCommon/Utilities/Particles/Listener/ScrapeParticleListener.h>


// ScrapeParticleListener ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ScrapeParticleListener)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(ContactInfo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ScrapeParticleListener)
    HK_TRACKER_MEMBER(ScrapeParticleListener, m_contacts, 0, "hkArray<ScrapeParticleListener::ContactInfo, hkContainerHeapAllocator>") // hkArray< struct ScrapeParticleListener::ContactInfo, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ScrapeParticleListener, s_libraryName, hkReferencedObject)


// ContactInfo ScrapeParticleListener
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(ScrapeParticleListener, ContactInfo, s_libraryName)

#include <Demos/DemoCommon/Utilities/Particles/Utilities/ParticleCollisionUtil.h>


// ParticleCollisionUtil ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ParticleCollisionUtil)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ParticleCollisionUtil)
    HK_TRACKER_MEMBER(ParticleCollisionUtil, m_world, 0, "hkpWorld*") // class hkpWorld*
    HK_TRACKER_MEMBER(ParticleCollisionUtil, m_phantom, 0, "hkpSimpleShapePhantom*") // class hkpSimpleShapePhantom*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(ParticleCollisionUtil, s_libraryName)

#include <Demos/DemoCommon/Utilities/Particles/Utilities/ParticleUtilsPhysics.h>


// WorldRayCastInterface ParticleUtils

HK_TRACKER_DECLARE_CLASS_BEGIN(ParticleUtils::WorldRayCastInterface)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ParticleUtils::WorldRayCastInterface)
    HK_TRACKER_MEMBER(ParticleUtils::WorldRayCastInterface, m_world, 0, "hkpWorld*") // class hkpWorld*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ParticleUtils::WorldRayCastInterface, s_libraryName, SparksParticleSystem::RayCastInterface)

#include <Demos/DemoCommon/Utilities/SolverAllocatorBuffer/SolverAllocatorBuffer.h>


// SolverAllocatorBuffer ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SolverAllocatorBuffer)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SolverAllocatorBuffer)
    HK_TRACKER_MEMBER(SolverAllocatorBuffer, m_solverBuffer, 0, "hkArray<hkUint8, hkContainerHeapAllocator>") // hkArray< hkUint8, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(SolverAllocatorBuffer, m_oldBufferStart, 0, "char*") // char*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SolverAllocatorBuffer, s_libraryName, hkReferencedObject)

#include <Demos/DemoCommon/Utilities/SoundFx/Sfx.h>


// SfxHandler ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SfxHandler)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SfxHandler)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_ABSTRACT(SfxHandler, s_libraryName, hkReferencedObject)


// SfxFade ::
HK_TRACKER_IMPLEMENT_SIMPLE(SfxFade, s_libraryName)


// SfxEffectMap ::
HK_TRACKER_IMPLEMENT_SIMPLE(SfxEffectMap, s_libraryName)


// SfxSource ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SfxSource)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SfxSource)
    HK_TRACKER_MEMBER(SfxSource, m_constraint, 0, "hkpConstraintInstance*") // class hkpConstraintInstance*
    HK_TRACKER_MEMBER(SfxSource, m_bodies, 0, "hkpRigidBody* [2]") // class hkpRigidBody* [2]
    HK_TRACKER_MEMBER(SfxSource, m_userData, 0, "void*") // void*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SfxSource, s_libraryName, hkReferencedObject)


// SfxContactManifoldSource ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SfxContactManifoldSource)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SfxContactManifoldSource)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SfxContactManifoldSource, s_libraryName, SfxSource)


// SfxManager ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SfxManager)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Probe)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SfxManager)
    HK_TRACKER_MEMBER(SfxManager, m_world, 0, "hkpWorld*") // class hkpWorld*
    HK_TRACKER_MEMBER(SfxManager, m_sources, 0, "hkArray<SfxSource*, hkContainerHeapAllocator>") // hkArray< class SfxSource*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(SfxManager, m_handler, 0, "SfxHandler*") // class SfxHandler*
    HK_TRACKER_MEMBER(SfxManager, m_tracking, 0, "hkArray<hkpRigidBody*, hkContainerHeapAllocator>") // hkArray< class hkpRigidBody*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(SfxManager, m_tracked, 0, "hkArray<hkpRigidBody*, hkContainerHeapAllocator>") // hkArray< class hkpRigidBody*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(SfxManager, m_probe, 0, "SfxManager::Probe") // class SfxManager::Probe
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SfxManager, s_libraryName, hkReferencedObject)


// Probe SfxManager

HK_TRACKER_DECLARE_CLASS_BEGIN(SfxManager::Probe)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SfxManager::Probe)
    HK_TRACKER_MEMBER(SfxManager::Probe, m_manager, 0, "SfxManager*") // class SfxManager*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SfxManager::Probe, s_libraryName, hkpAabbPhantom)

#include <Demos/DemoCommon/Utilities/SoundFx/SfxHandler.h>


// SfxBaseHandler ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SfxBaseHandler)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(OmniSlot)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(eBuffer)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SfxBaseHandler)
    HK_TRACKER_MEMBER(SfxBaseHandler, m_manager, 0, "SfxManager*") // class SfxManager*
    HK_TRACKER_MEMBER(SfxBaseHandler, m_system, 0, "hkgSoundSystem*") // class hkgSoundSystem*
    HK_TRACKER_MEMBER(SfxBaseHandler, m_buffers, 0, "hkArray<hkgSoundBuffer*, hkContainerHeapAllocator>") // hkArray< class hkgSoundBuffer*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(SfxBaseHandler, m_tracked, 0, "hkArray<hkpRigidBody*, hkContainerHeapAllocator>") // hkArray< class hkpRigidBody*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(SfxBaseHandler, m_excluded, 0, "hkArray<hkpRigidBody*, hkContainerHeapAllocator>") // hkArray< class hkpRigidBody*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(SfxBaseHandler, m_omniSlots, 0, "hkArray<SfxBaseHandler::OmniSlot, hkContainerHeapAllocator>") // hkArray< struct SfxBaseHandler::OmniSlot, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(SfxBaseHandler, m_omniSources, 0, "hkArray<hkgSoundSource*, hkContainerHeapAllocator>") // hkArray< class hkgSoundSource*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SfxBaseHandler, s_libraryName, SfxHandler)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(SfxBaseHandler, eBuffer, s_libraryName)


// OmniSlot SfxBaseHandler
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(SfxBaseHandler, OmniSlot, s_libraryName)


// Environment SfxBaseEffects

HK_TRACKER_DECLARE_CLASS_BEGIN(SfxBaseEffects::Environment)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SfxBaseEffects::Environment)
    HK_TRACKER_MEMBER(SfxBaseEffects::Environment, m_source, 0, "hkgSoundSource*") // class hkgSoundSource*
    HK_TRACKER_MEMBER(SfxBaseEffects::Environment, m_handler, 0, "SfxBaseHandler*") // class SfxBaseHandler*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SfxBaseEffects::Environment, s_libraryName, SfxSource)


// Omni SfxBaseEffects

HK_TRACKER_DECLARE_CLASS_BEGIN(SfxBaseEffects::Omni)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SfxBaseEffects::Omni)
    HK_TRACKER_MEMBER(SfxBaseEffects::Omni, m_source, 0, "hkgSoundSource*") // class hkgSoundSource*
    HK_TRACKER_MEMBER(SfxBaseEffects::Omni, m_handler, 0, "SfxBaseHandler*") // class SfxBaseHandler*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SfxBaseEffects::Omni, s_libraryName, SfxSource)


// Fmo SfxBaseEffects

HK_TRACKER_DECLARE_CLASS_BEGIN(SfxBaseEffects::Fmo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SfxBaseEffects::Fmo)
    HK_TRACKER_MEMBER(SfxBaseEffects::Fmo, m_source, 0, "hkgSoundSource*") // class hkgSoundSource*
    HK_TRACKER_MEMBER(SfxBaseEffects::Fmo, m_handler, 0, "SfxBaseHandler*") // class SfxBaseHandler*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SfxBaseEffects::Fmo, s_libraryName, SfxSource)


// Impact SfxBaseEffects

HK_TRACKER_DECLARE_CLASS_BEGIN(SfxBaseEffects::Impact)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SfxBaseEffects::Impact)
    HK_TRACKER_MEMBER(SfxBaseEffects::Impact, m_handler, 0, "SfxBaseHandler*") // class SfxBaseHandler*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SfxBaseEffects::Impact, s_libraryName, SfxContactManifoldSource)


// FrictionImpact SfxBaseEffects

HK_TRACKER_DECLARE_CLASS_BEGIN(SfxBaseEffects::FrictionImpact)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SfxBaseEffects::FrictionImpact)
    HK_TRACKER_MEMBER(SfxBaseEffects::FrictionImpact, m_friction_source, 0, "hkgSoundSource*") // class hkgSoundSource*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SfxBaseEffects::FrictionImpact, s_libraryName, SfxBaseEffects::Impact)

#include <Demos/DemoCommon/Utilities/VehicleApi/FrictionMapVehicleRaycastWheelCollide.h>


// FrictionMapVehicleRaycastWheelCollide ::

HK_TRACKER_DECLARE_CLASS_BEGIN(FrictionMapVehicleRaycastWheelCollide)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(FrictionMapVehicleRaycastWheelCollide)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(FrictionMapVehicleRaycastWheelCollide, s_libraryName, hkpVehicleRayCastWheelCollide)

#include <Demos/DemoCommon/Utilities/VehicleApi/LinearCastVehicleSetup.h>


// LinearCastVehicleSetup ::

HK_TRACKER_DECLARE_CLASS_BEGIN(LinearCastVehicleSetup)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(LinearCastVehicleSetup)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(LinearCastVehicleSetup, s_libraryName, VehicleSetup)

#include <Demos/DemoCommon/Utilities/VehicleApi/VehicleApiUtils.h>


// VehicleApiUtils ::
HK_TRACKER_IMPLEMENT_SIMPLE(VehicleApiUtils, s_libraryName)

#include <Demos/DemoCommon/Utilities/VehicleApi/VehicleSetup.h>


// VehicleSetup ::

HK_TRACKER_DECLARE_CLASS_BEGIN(VehicleSetup)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(VehicleSetup)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(VehicleSetup, s_libraryName, hkReferencedObject)

#include <Demos/DemoCommon/Utilities/VehicleDisplay/VehicleDisplayUtils.h>


// VehicleDisplayUtils ::

HK_TRACKER_DECLARE_CLASS_BEGIN(VehicleDisplayUtils)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(DisplayMeterInfo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(VehicleDataAndDisplayInfo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_IMPLEMENT_SIMPLE(VehicleDisplayUtils, s_libraryName)


// DisplayMeterInfo VehicleDisplayUtils
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(VehicleDisplayUtils, DisplayMeterInfo, s_libraryName)


// VehicleDataAndDisplayInfo VehicleDisplayUtils

HK_TRACKER_DECLARE_CLASS_BEGIN(VehicleDisplayUtils::VehicleDataAndDisplayInfo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(VehicleDisplayUtils::VehicleDataAndDisplayInfo)
    HK_TRACKER_MEMBER(VehicleDisplayUtils::VehicleDataAndDisplayInfo, m_vehicle, 0, "hkpVehicleInstance*") // class hkpVehicleInstance*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(VehicleDisplayUtils::VehicleDataAndDisplayInfo, s_libraryName)

#include <Demos/Physics2012/Api/Collide/Broadphase/Culling/BroadphaseCullingDemo.h>


// BroadphaseCullingDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(BroadphaseCullingDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Variant)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(BroadphaseCullingDemo)
    HK_TRACKER_MEMBER(BroadphaseCullingDemo, m_userObjects, 0, "hkArray<hkpSimpleShapePhantom*, hkContainerHeapAllocator>") // hkArray< class hkpSimpleShapePhantom*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(BroadphaseCullingDemo, s_libraryName, hkDefaultPhysics2012Demo)


// Variant BroadphaseCullingDemo

HK_TRACKER_DECLARE_CLASS_BEGIN(BroadphaseCullingDemo::Variant)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(BroadphaseCullingDemo::Variant)
    HK_TRACKER_MEMBER(BroadphaseCullingDemo::Variant, m_name, 0, "char*") // const char*
    HK_TRACKER_MEMBER(BroadphaseCullingDemo::Variant, m_details, 0, "char*") // const char*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(BroadphaseCullingDemo::Variant, s_libraryName)

#include <Demos/Physics2012/Api/Collide/Broadphase/MultiPendulums/MultiPendulumsDemo.h>


// MultiPendulumsDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MultiPendulumsDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MultiPendulumsDemo)
    HK_TRACKER_MEMBER(MultiPendulumsDemo, m_marbleaction, 0, "MarbleAction*") // class MarbleAction*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(MultiPendulumsDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/CollisionFiltering/CollisionFilter/CollisionFilterDemo.h>


// CollisionFilterDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(CollisionFilterDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(CollisionFilterDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(CollisionFilterDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/CollisionFiltering/ConstraintCollisionFilter/ConstraintCollisionFilterDemo.h>


// ConstrainedSystemCollisionFilterDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ConstrainedSystemCollisionFilterDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ConstrainedSystemCollisionFilterDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ConstrainedSystemCollisionFilterDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/CollisionFiltering/PairCollisionFilter/PairCollisionFilterDemo.h>


// PairwiseCollisionFilterDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(PairwiseCollisionFilterDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(PairwiseCollisionFilterDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(PairwiseCollisionFilterDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/CollisionFiltering/ShapeCollectionFilter/ShapeCollectionFilterDemo.h>


// ShapeCollectionFilterDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ShapeCollectionFilterDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(MyVector4)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ShapeCollectionFilterDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ShapeCollectionFilterDemo, s_libraryName, hkDefaultPhysics2012Demo)


// MyVector4 ShapeCollectionFilterDemo
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(ShapeCollectionFilterDemo, MyVector4, s_libraryName)

#include <Demos/Physics2012/Api/Collide/CollisionFiltering/UserCollisionFilter/UserCollisionFilterDemo.h>


// UserCollisionFilterDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(UserCollisionFilterDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(UserCollisionFilterDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(UserCollisionFilterDemo, s_libraryName, hkDefaultPhysics2012Demo)


// MyCollisionFilter ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MyCollisionFilter)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MyCollisionFilter)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(MyCollisionFilter, s_libraryName, hkpCollisionFilter)

#include <Demos/Physics2012/Api/Collide/ContactPointCallbacks/ContactState/ContactStateDemo.h>


// ContactStateDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ContactStateDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ContactStateDemo)
    HK_TRACKER_MEMBER(ContactStateDemo, m_body, 0, "hkpRigidBody*") // class hkpRigidBody*
    HK_TRACKER_MEMBER(ContactStateDemo, m_shapeKeys, 0, "hkArray<hkUint32, hkContainerHeapAllocator>") // hkArray< hkUint32, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(ContactStateDemo, m_listener, 0, "MyContactStateListener*") // class MyContactStateListener*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ContactStateDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/ContactPointCallbacks/DeterministicCallbacks/DeterministicCallbacksDemo.h>


// DeterministicCallbacksDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(DeterministicCallbacksDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(DeterministicCallbacksDemo)
    HK_TRACKER_MEMBER(DeterministicCallbacksDemo, m_ragdolls, 0, "hkArray<hkpPhysicsSystem*, hkContainerHeapAllocator>") // hkArray< class hkpPhysicsSystem*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(DeterministicCallbacksDemo, m_testListener, 0, "TestListener*") // class TestListener*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(DeterministicCallbacksDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/ContactPointCallbacks/EndOfStepCallback/EndOfStepCallbackDemo.h>


// EndOfStepCallbackDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(EndOfStepCallbackDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(EndOfStepCallbackDemo)
    HK_TRACKER_MEMBER(EndOfStepCallbackDemo, m_body, 0, "hkpRigidBody* [9]") // class hkpRigidBody* [9]
    HK_TRACKER_MEMBER(EndOfStepCallbackDemo, m_listener, 0, "MyEndOfStepListener*") // class MyEndOfStepListener*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(EndOfStepCallbackDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/ContactPointCallbacks/ShapeKeysInCallback/ShapeKeysInCallbackDemo.h>


// ShapeKeysInCallbackDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ShapeKeysInCallbackDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ShapeKeysInCallbackDemo)
    HK_TRACKER_MEMBER(ShapeKeysInCallbackDemo, m_listener, 0, "MyContactListener*") // class MyContactListener*
    HK_TRACKER_MEMBER(ShapeKeysInCallbackDemo, m_body, 0, "hkpRigidBody*") // class hkpRigidBody*
    HK_TRACKER_MEMBER(ShapeKeysInCallbackDemo, m_flatLand, 0, "FlatLand*") // class FlatLand*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ShapeKeysInCallbackDemo, s_libraryName, hkDefaultPhysics2012Demo)


// MyContactListener ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MyContactListener)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MyContactListener)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(MyContactListener, s_libraryName, hkReferencedObject)

#include <Demos/Physics2012/Api/Collide/ContactPointCallbacks/UserCollisionResponse/UserCollisionResponseDemo.h>


// UserCollisionResponseDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(UserCollisionResponseDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(UserCollisionResponseDemo)
    HK_TRACKER_MEMBER(UserCollisionResponseDemo, m_sphereRigidBody, 0, "hkpRigidBody*") // class hkpRigidBody*
    HK_TRACKER_MEMBER(UserCollisionResponseDemo, m_collisionResolution, 0, "MyCollisionResolution*") // class MyCollisionResolution*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(UserCollisionResponseDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/Midphase/MoppOfMopps/MoppOfMoppsDemo.h>


// MoppOfMoppsDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MoppOfMoppsDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MoppOfMoppsDemo)
    HK_TRACKER_MEMBER(MoppOfMoppsDemo, m_loadedData, 0, "hkResource*") // class hkResource*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(MoppOfMoppsDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/Midphase/NmMachine/NmMachineDemo.h>


// NmMachineDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(NmMachineDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(NmMachineDemo)
    HK_TRACKER_MEMBER(NmMachineDemo, m_track, 0, "hkReferencedObject*") // class hkReferencedObject*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(NmMachineDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/Queries/ClosestPoints/ClosestPointsDemo.h>


// ClosestPointsDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ClosestPointsDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ClosestPointsDemo)
    HK_TRACKER_MEMBER(ClosestPointsDemo, m_bodies, 0, "hkArray<hkpRigidBody*, hkContainerHeapAllocator>") // hkArray< class hkpRigidBody*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ClosestPointsDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/Queries/ClosestPointsWithWelding/ClosestPointsWithWeldingDemo.h>


// GroundFreeBody ::

HK_TRACKER_DECLARE_CLASS_BEGIN(GroundFreeBody)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(GroundFreeBody)
    HK_TRACKER_MEMBER(GroundFreeBody, m_groundBody, 0, "hkpRigidBody*") // class hkpRigidBody*
    HK_TRACKER_MEMBER(GroundFreeBody, m_freeBody, 0, "hkpRigidBody*") // class hkpRigidBody*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(GroundFreeBody, s_libraryName)


// ClosestPointsWithWeldingDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ClosestPointsWithWeldingDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Options)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ClosestPointsWithWeldingDemo)
    HK_TRACKER_MEMBER(ClosestPointsWithWeldingDemo, m_groundFreeBody, 0, "hkArray<GroundFreeBody, hkContainerHeapAllocator>") // hkArray< struct GroundFreeBody, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ClosestPointsWithWeldingDemo, s_libraryName, hkDefaultPhysics2012Demo)


// Options ClosestPointsWithWeldingDemo
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(ClosestPointsWithWeldingDemo, Options, s_libraryName)

#include <Demos/Physics2012/Api/Collide/Queries/ConvexBvTreeQuery/ConvexBvTreeQueryDemo.h>


// ConvexBvTreeQueryDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ConvexBvTreeQueryDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ConvexBvTreeQueryDemo)
    HK_TRACKER_MEMBER(ConvexBvTreeQueryDemo, m_moppShape, 0, "hkpMoppBvTreeShape*") // class hkpMoppBvTreeShape*
    HK_TRACKER_MEMBER(ConvexBvTreeQueryDemo, m_rigidBody, 0, "hkpRigidBody*") // class hkpRigidBody*
    HK_TRACKER_MEMBER(ConvexBvTreeQueryDemo, m_generator, 0, "hkPseudoRandomGenerator*") // class hkPseudoRandomGenerator*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ConvexBvTreeQueryDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/Queries/ShapeQuery/ShapeQueryDemo.h>


// ShapeQueryDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ShapeQueryDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(QueryObject)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ShapeQueryDemo)
    HK_TRACKER_MEMBER(ShapeQueryDemo, m_qShapes, 0, "hkArray<hkpShape*, hkContainerHeapAllocator>") // hkArray< class hkpShape*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(ShapeQueryDemo, m_fixedSmallBodies, 0, "hkArray<hkpRigidBody*, hkContainerHeapAllocator>") // hkArray< class hkpRigidBody*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(ShapeQueryDemo, m_queryObjects, 0, "hkArray<ShapeQueryDemo::QueryObject, hkContainerHeapAllocator>") // hkArray< struct ShapeQueryDemo::QueryObject, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(ShapeQueryDemo, m_rayCastPhantoms, 0, "hkArray<hkpAabbPhantom*, hkContainerHeapAllocator>") // hkArray< class hkpAabbPhantom*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(ShapeQueryDemo, m_simplePhantoms, 0, "hkArray<hkpSimpleShapePhantom*, hkContainerHeapAllocator>") // hkArray< class hkpSimpleShapePhantom*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(ShapeQueryDemo, m_cachingPhantoms, 0, "hkArray<hkpCachingShapePhantom*, hkContainerHeapAllocator>") // hkArray< class hkpCachingShapePhantom*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(ShapeQueryDemo, m_groundShapeFactory, 0, "FlatLand") // class FlatLand
    HK_TRACKER_MEMBER(ShapeQueryDemo, m_treeManagerData, 0, "hkArray<hkUint8, hkContainerHeapAllocator>") // hkArray< hkUint8, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(ShapeQueryDemo, m_semaphore, 0, "hkScopedPtr<hkSemaphore>") // class hkScopedPtr< class hkSemaphore >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ShapeQueryDemo, s_libraryName, hkDefaultPhysics2012Demo)


// QueryObject ShapeQueryDemo

HK_TRACKER_DECLARE_CLASS_BEGIN(ShapeQueryDemo::QueryObject)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ShapeQueryDemo::QueryObject)
    HK_TRACKER_MEMBER(ShapeQueryDemo::QueryObject, m_collidable, 0, "hkpCollidable*") // class hkpCollidable*
    HK_TRACKER_MEMBER(ShapeQueryDemo::QueryObject, m_transform, 0, "hkTransform*") // hkTransform*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(ShapeQueryDemo::QueryObject, s_libraryName)

#include <Demos/Physics2012/Api/Collide/RayCasting/AutoSplitJob/AutoSplitJobDemo.h>


// AutoSplitJobDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AutoSplitJobDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AutoSplitJobDemo)
    HK_TRACKER_MEMBER(AutoSplitJobDemo, m_collidables, 0, "hkArray<hkpCollidable*, hkContainerHeapAllocator>") // hkArray< const class hkpCollidable*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(AutoSplitJobDemo, m_treeManagerData, 0, "hkArray<hkUint8, hkContainerHeapAllocator>") // hkArray< hkUint8, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(AutoSplitJobDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/RayCasting/OptimizedWorldRayCast/OptimizedWorldRaycastDemo.h>


// OptimizedWorldRaycastDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(OptimizedWorldRaycastDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(OptimizedWorldRaycastDemo)
    HK_TRACKER_MEMBER(OptimizedWorldRaycastDemo, m_phantom, 0, "hkpAabbPhantom*") // class hkpAabbPhantom*
    HK_TRACKER_MEMBER(OptimizedWorldRaycastDemo, m_phantomUseCache, 0, "hkpAabbPhantom*") // class hkpAabbPhantom*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(OptimizedWorldRaycastDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/RayCasting/RayCastAgainstProxy/RaycastAgainstProxyDemo.h>


// RaycastAgainstProxy ::

HK_TRACKER_DECLARE_CLASS_BEGIN(RaycastAgainstProxy)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(RaycastAgainstProxy)
    HK_TRACKER_MEMBER(RaycastAgainstProxy, m_proxyPhantom, 0, "myProxyPhantom*") // class myProxyPhantom*
    HK_TRACKER_MEMBER(RaycastAgainstProxy, m_tagFileData, 0, "hkResource*") // class hkResource*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(RaycastAgainstProxy, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/RayCasting/RayCastCallback/RaycastCallbackDemo.h>


// RaycastCallbackDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(RaycastCallbackDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(MyFilteredRayCastCallback)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(RaycastCallbackDemo)
    HK_TRACKER_MEMBER(RaycastCallbackDemo, m_bodies, 0, "hkArray<hkpRigidBody*, hkContainerHeapAllocator>") // hkArray< class hkpRigidBody*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(RaycastCallbackDemo, s_libraryName, hkDefaultPhysics2012Demo)


// MyFilteredRayCastCallback RaycastCallbackDemo

HK_TRACKER_DECLARE_CLASS_BEGIN(RaycastCallbackDemo::MyFilteredRayCastCallback)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(RaycastCallbackDemo::MyFilteredRayCastCallback)
    HK_TRACKER_MEMBER(RaycastCallbackDemo::MyFilteredRayCastCallback, m_output, 0, "hkpWorldRayCastOutput*") // struct hkpWorldRayCastOutput*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(RaycastCallbackDemo::MyFilteredRayCastCallback, s_libraryName, hkpBroadPhaseCastCollector)

#include <Demos/Physics2012/Api/Collide/RayCasting/RayCastFiltering/RaycastFilteringDemo.h>


// RaycastFilteringDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(RaycastFilteringDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(MyVector4)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(RaycastFilteringDemo)
    HK_TRACKER_MEMBER(RaycastFilteringDemo, m_semaphore, 0, "hkScopedPtr<hkSemaphore>") // class hkScopedPtr< class hkSemaphore >
    HK_TRACKER_MEMBER(RaycastFilteringDemo, m_linearCastCollidables, 0, "hkArray<hkpCollidable*, hkContainerHeapAllocator>") // hkArray< const class hkpCollidable*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(RaycastFilteringDemo, s_libraryName, hkDefaultPhysics2012Demo)


// MyVector4 RaycastFilteringDemo
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(RaycastFilteringDemo, MyVector4, s_libraryName)

#include <Demos/Physics2012/Api/Collide/RayCasting/RayCastJobUsingCollector/RayCastJobUsingCollectorDemo.h>


// RayCastJobUsingCollectorDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(RayCastJobUsingCollectorDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(RayCastJobUsingCollectorDemo)
    HK_TRACKER_MEMBER(RayCastJobUsingCollectorDemo, m_semaphore, 0, "hkScopedPtr<hkSemaphore>") // class hkScopedPtr< class hkSemaphore >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(RayCastJobUsingCollectorDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/RayCasting/Raytrace/RaytraceDemo.h>


// RayTraceDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(RayTraceDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(RayTraceDemo)
    HK_TRACKER_MEMBER(RayTraceDemo, m_texture, 0, "hkgTexture*") // class hkgTexture*
    HK_TRACKER_MEMBER(RayTraceDemo, m_context, 0, "hkgDisplayContext*") // class hkgDisplayContext*
    HK_TRACKER_MEMBER(RayTraceDemo, m_shape, 0, "hkpShape*") // const class hkpShape*
    HK_TRACKER_MEMBER(RayTraceDemo, m_canvasData, 0, "hkUint8*") // hkUint8*
    HK_TRACKER_MEMBER(RayTraceDemo, m_stopwatch, 0, "hkStopwatch") // class hkStopwatch
    HK_TRACKER_MEMBER(RayTraceDemo, m_landscapeContainer, 0, "LandscapeContainer*") // class LandscapeContainer*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(RayTraceDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/RayCasting/ShapeRayCast/ShapeRaycastDemo.h>


// ShapeRaycastDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ShapeRaycastDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(CastMode)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ShapeRaycastDemo)
    HK_TRACKER_MEMBER(ShapeRaycastDemo, m_bodies, 0, "hkArray<hkpRigidBody*, hkContainerHeapAllocator>") // hkArray< class hkpRigidBody*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(ShapeRaycastDemo, m_planeDisp, 0, "hkDisplayPlane*") // class hkDisplayPlane*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ShapeRaycastDemo, s_libraryName, hkDefaultPhysics2012Demo)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(ShapeRaycastDemo, CastMode, s_libraryName)

#include <Demos/Physics2012/Api/Collide/RayCasting/UserRayHitCollector/UserRayHitCollectorDemo.h>


// UserRayHitCollectorDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(UserRayHitCollectorDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(UserRayHitCollectorDemo)
    HK_TRACKER_MEMBER(UserRayHitCollectorDemo, m_treeManagerData, 0, "hkArray<hkUint8, hkContainerHeapAllocator>") // hkArray< hkUint8, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(UserRayHitCollectorDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/RayCasting/WorldRayCast/WorldRaycastDemo.h>


// WorldRaycastDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(WorldRaycastDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(WorldRaycastDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(WorldRaycastDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/Shapes/BvCompressedMesh/BvCompressedMeshDemo.h>


// BvCompressedMeshDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(BvCompressedMeshDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(BvCompressedMeshDemo)
    HK_TRACKER_MEMBER(BvCompressedMeshDemo, m_meshShape, 0, "hkpBvCompressedMeshShape *") // class hkpBvCompressedMeshShape *
    HK_TRACKER_MEMBER(BvCompressedMeshDemo, m_meshBody, 0, "hkpRigidBody *") // class hkpRigidBody *
    HK_TRACKER_MEMBER(BvCompressedMeshDemo, m_displayGeometries, 0, "hkArray<hkDisplayConvex *, hkContainerHeapAllocator>") // hkArray< class hkDisplayConvex *, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(BvCompressedMeshDemo, m_groupFilter, 0, "hkpGroupFilter *") // class hkpGroupFilter *
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(BvCompressedMeshDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/Shapes/CompressedAndExtendedMeshes/CompressedMeshDemo.h>


// CompressedMeshDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(CompressedMeshDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(GeometryInfo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(CompressedMeshDemo)
    HK_TRACKER_MEMBER(CompressedMeshDemo, m_shape, 0, "hkpShape*") // class hkpShape*
    HK_TRACKER_MEMBER(CompressedMeshDemo, m_builder, 0, "hkpCompressedMeshShapeBuilder") // class hkpCompressedMeshShapeBuilder
    HK_TRACKER_MEMBER(CompressedMeshDemo, m_keys, 0, "hkArray<hkArray<hkUint32, hkContainerHeapAllocator>, hkContainerHeapAllocator>") // hkArray< hkArray< hkUint32, struct hkContainerHeapAllocator >, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(CompressedMeshDemo, m_geometryInstances, 0, "hkxSceneDataToGeometryConverter::GeometryInstances") // struct hkxSceneDataToGeometryConverter::GeometryInstances
    HK_TRACKER_MEMBER(CompressedMeshDemo, m_geomInfo, 0, "hkArray<CompressedMeshDemo::GeometryInfo, hkContainerHeapAllocator>") // hkArray< struct CompressedMeshDemo::GeometryInfo, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(CompressedMeshDemo, m_out, 0, "hkOstream") // class hkOstream
    HK_TRACKER_MEMBER(CompressedMeshDemo, m_semaphore, 0, "hkSemaphore") // class hkSemaphore
    HK_TRACKER_MEMBER(CompressedMeshDemo, m_castBody, 0, "hkpRigidBody*") // class hkpRigidBody*
    HK_TRACKER_MEMBER(CompressedMeshDemo, m_terrainBody, 0, "hkpRigidBody*") // class hkpRigidBody*
    HK_TRACKER_MEMBER(CompressedMeshDemo, m_terrainShape, 0, "hkpShape*") // const class hkpShape*
    HK_TRACKER_MEMBER(CompressedMeshDemo, m_compMesh, 0, "hkpCompressedMeshShape*") // class hkpCompressedMeshShape*
    HK_TRACKER_MEMBER(CompressedMeshDemo, m_loadedData, 0, "hkResource*") // class hkResource*
    HK_TRACKER_MEMBER(CompressedMeshDemo, m_geometry, 0, "hkGeometry") // struct hkGeometry
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(CompressedMeshDemo, s_libraryName, hkDefaultPhysics2012Demo)


// GeometryInfo CompressedMeshDemo
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(CompressedMeshDemo, GeometryInfo, s_libraryName)

#include <Demos/Physics2012/Api/Collide/Shapes/Convex/ConvexShapesDemo.h>


// ConvexShapesDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ConvexShapesDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ConvexShapesDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ConvexShapesDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/Shapes/HeightField/CoarseGridHeightField/CoarseGridHeightFieldDemo.h>


// CoarseGridHeightFieldDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(CoarseGridHeightFieldDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(CoarseGridHeightFieldDemo)
    HK_TRACKER_MEMBER(CoarseGridHeightFieldDemo, m_heightData, 0, "hkUint16*") // hkUint16*
    HK_TRACKER_MEMBER(CoarseGridHeightFieldDemo, m_heightFieldShape, 0, "CoarseSampledHeightFieldShape*") // class CoarseSampledHeightFieldShape*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(CoarseGridHeightFieldDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/Shapes/HeightField/HeightFieldRayVsLinearCast/HeightFieldRayVsLinearCastDemo.h>


// HeightFieldRayVsLinearCastDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(HeightFieldRayVsLinearCastDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(HeightFieldRayVsLinearCastDemo)
    HK_TRACKER_MEMBER(HeightFieldRayVsLinearCastDemo, m_shape, 0, "hkpShape*") // class hkpShape*
    HK_TRACKER_MEMBER(HeightFieldRayVsLinearCastDemo, m_simpleShapePhantom, 0, "hkpSimpleShapePhantom*") // class hkpSimpleShapePhantom*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(HeightFieldRayVsLinearCastDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/Shapes/HeightField/PlaneShape/PlaneShapeDemo.h>


// PlaneShapeDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(PlaneShapeDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(PlaneShapeDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(PlaneShapeDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/Shapes/HeightField/SampledHeightField/SampledHeightFieldDemo.h>


// SampledHeightFieldDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SampledHeightFieldDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SampledHeightFieldDemo)
    HK_TRACKER_MEMBER(SampledHeightFieldDemo, m_heightData, 0, "hkUint16*") // hkUint16*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SampledHeightFieldDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/Shapes/HeightField/TriSampledHeightField/TriSampledHeightFieldDemo.h>


// TriSampledHeightFieldDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(TriSampledHeightFieldDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(TriSampledHeightFieldDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(TriSampledHeightFieldDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/Shapes/HeightField/UserHeightField/UserHeightFieldDemo.h>


// HollowSphereShape ::

HK_TRACKER_DECLARE_CLASS_BEGIN(HollowSphereShape)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(HollowSphereShape)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(HollowSphereShape, s_libraryName, hkpHeightFieldShape)


// UserHeightFieldDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(UserHeightFieldDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(UserHeightFieldDemo)
    HK_TRACKER_MEMBER(UserHeightFieldDemo, m_sphereDisp, 0, "hkDisplaySphere*") // class hkDisplaySphere*
    HK_TRACKER_MEMBER(UserHeightFieldDemo, m_rigidBody, 0, "hkpRigidBody*") // class hkpRigidBody*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(UserHeightFieldDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/Shapes/Misc/Compound/CompoundShapesDemo.h>


// AggregateShapesDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AggregateShapesDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AggregateShapesDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(AggregateShapesDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/Shapes/Misc/LandscapeComparison/LandscapeDemoUtil.h>


// LandscapeDemoUtil ::

HK_TRACKER_DECLARE_CLASS_BEGIN(LandscapeDemoUtil)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(LandscapeShape)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(LandscapeSource)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(FilterLayers)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(LandscapeDemoUtil)
    HK_TRACKER_MEMBER(LandscapeDemoUtil, m_collisionFilterInfos, 0, "hkArray<hkUint32, hkContainerHeapAllocator>") // hkArray< hkUint32, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(LandscapeDemoUtil, m_externalData, 0, "hkArray<hkReferencedObject*, hkContainerHeapAllocator>") // hkArray< class hkReferencedObject*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(LandscapeDemoUtil, m_externalGeom, 0, "hkGeometry") // struct hkGeometry
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(LandscapeDemoUtil, s_libraryName, hkReferencedObject)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(LandscapeDemoUtil, LandscapeShape, s_libraryName)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(LandscapeDemoUtil, LandscapeSource, s_libraryName)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(LandscapeDemoUtil, FilterLayers, s_libraryName)

#include <Demos/Physics2012/Api/Collide/Shapes/Mopp/BattlefieldMopp/BattlefieldMoppDemo.h>


// BattlefieldMoppDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(BattlefieldMoppDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(BattlefieldMoppDemo)
    HK_TRACKER_MEMBER(BattlefieldMoppDemo, m_explodingBombs, 0, "hkArray<hkpRigidBody*, hkContainerHeapAllocator>") // hkArray< class hkpRigidBody*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(BattlefieldMoppDemo, m_terrain, 0, "hkReferencedObject*") // class hkReferencedObject*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(BattlefieldMoppDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/Shapes/Mopp/DestructibleMopp/DestructibleMoppDemo.h>


// DestructibleMoppDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(DestructibleMoppDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(DestructibleMoppDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(DestructibleMoppDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/Shapes/Mopp/Mopp/MoppDemo.h>


// MoppDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MoppDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MoppDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(MoppDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/Shapes/Mopp/MoppCodeStreaming/MoppCodeStreamingDemo.h>


// MoppCodeStreamingDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MoppCodeStreamingDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MoppCodeStreamingDemo)
    HK_TRACKER_MEMBER(MoppCodeStreamingDemo, m_vertices, 0, "hkArray<float, hkContainerHeapAllocator>") // hkArray< float, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(MoppCodeStreamingDemo, m_indices, 0, "hkArray<hkUint16, hkContainerHeapAllocator>") // hkArray< hkUint16, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(MoppCodeStreamingDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/Shapes/Mopp/MoppInstancing/MoppInstancingDemo.h>


// MoppInstancingDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MoppInstancingDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MoppInstancingDemo)
    HK_TRACKER_MEMBER(MoppInstancingDemo, m_originalMopp, 0, "hkpMoppBvTreeShape*") // class hkpMoppBvTreeShape*
    HK_TRACKER_MEMBER(MoppInstancingDemo, m_smallMopp, 0, "hkpMoppBvTreeShape*") // class hkpMoppBvTreeShape*
    HK_TRACKER_MEMBER(MoppInstancingDemo, m_bigMopp, 0, "hkpMoppBvTreeShape*") // class hkpMoppBvTreeShape*
    HK_TRACKER_MEMBER(MoppInstancingDemo, m_fixedBodies, 0, "hkpRigidBody* [3]") // class hkpRigidBody* [3]
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(MoppInstancingDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/Shapes/Mopp/SerializeMopp/SerializeMoppDemo.h>


// SerializeMoppDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SerializeMoppDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SerializeMoppDemo)
    HK_TRACKER_MEMBER(SerializeMoppDemo, m_body, 0, "hkpRigidBody *") // class hkpRigidBody *
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SerializeMoppDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/Shapes/OfflineGeneration/ObbUtil/ObbUtilDemo.h>


// ObbUtilDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ObbUtilDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ObbUtilDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ObbUtilDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/Shapes/OfflineGeneration/ShapeSubtract/ShapeSubtractDemo.h>


// ShapeSubtractDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ShapeSubtractDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ShapeSubtractDemo)
    HK_TRACKER_MEMBER(ShapeSubtractDemo, m_subtractBody, 0, "hkpRigidBody *") // class hkpRigidBody *
    HK_TRACKER_MEMBER(ShapeSubtractDemo, m_body, 0, "hkpRigidBody *") // class hkpRigidBody *
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ShapeSubtractDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/Shapes/StaticCompound/Construction/StaticCompoundShapeConstructionDemo.h>


// StaticCompoundShapeConstructionDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(StaticCompoundShapeConstructionDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(DemoData)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(StaticCompoundShapeConstructionDemo)
    HK_TRACKER_MEMBER(StaticCompoundShapeConstructionDemo, m_data, 0, "StaticCompoundShapeConstructionDemo::DemoData") // class StaticCompoundShapeConstructionDemo::DemoData
    HK_TRACKER_MEMBER(StaticCompoundShapeConstructionDemo, m_staticCompoundShape, 0, "hkpStaticCompoundShape *") // class hkpStaticCompoundShape *
    HK_TRACKER_MEMBER(StaticCompoundShapeConstructionDemo, m_debrisPackfileData, 0, "hkResource*") // class hkResource*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(StaticCompoundShapeConstructionDemo, s_libraryName, hkDefaultPhysics2012Demo)


// DemoData StaticCompoundShapeConstructionDemo

HK_TRACKER_DECLARE_CLASS_BEGIN(StaticCompoundShapeConstructionDemo::DemoData)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(StaticCompoundShapeConstructionDemo::DemoData)
    HK_TRACKER_MEMBER(StaticCompoundShapeConstructionDemo::DemoData, m_rays, 0, "hkArray<hkVector4f, hkContainerHeapAllocator>") // hkArray< hkVector4f, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(StaticCompoundShapeConstructionDemo::DemoData, s_libraryName)

#include <Demos/Physics2012/Api/Collide/Shapes/StaticCompound/DisablingKeys/StaticCompoundShapeKeyDisablingDemo.h>


// StaticCompoundShapeKeyDisablingDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(StaticCompoundShapeKeyDisablingDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(StaticCompoundShapeKeyDisablingDemo)
    HK_TRACKER_MEMBER(StaticCompoundShapeKeyDisablingDemo, m_staticCompoundShape, 0, "hkpStaticCompoundShape*") // class hkpStaticCompoundShape*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(StaticCompoundShapeKeyDisablingDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/Shapes/StaticCompound/Filtering/StaticCompoundShapeFilteringDemo.h>


// StaticCompoundShapeFilteringDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(StaticCompoundShapeFilteringDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(StaticCompoundShapeFilteringDemo)
    HK_TRACKER_MEMBER(StaticCompoundShapeFilteringDemo, m_displayGeometries, 0, "hkArray<hkDisplayConvex *, hkContainerHeapAllocator>") // hkArray< class hkDisplayConvex *, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(StaticCompoundShapeFilteringDemo, m_groupFilter, 0, "hkpGroupFilter *") // class hkpGroupFilter *
    HK_TRACKER_MEMBER(StaticCompoundShapeFilteringDemo, m_bigSphere, 0, "hkpSphereShape *") // class hkpSphereShape *
    HK_TRACKER_MEMBER(StaticCompoundShapeFilteringDemo, m_smallSphere, 0, "hkpSphereShape *") // class hkpSphereShape *
    HK_TRACKER_MEMBER(StaticCompoundShapeFilteringDemo, m_fallingBodies, 0, "hkArray<hkpRigidBody*, hkContainerHeapAllocator>") // hkArray< class hkpRigidBody*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(StaticCompoundShapeFilteringDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Collide/Shapes/Voxel/UserVoxelBvTreeShape.h>


// UserVoxelBvTreeShape ::

HK_TRACKER_DECLARE_CLASS_BEGIN(UserVoxelBvTreeShape)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(UserVoxelBvTreeShape)
    HK_TRACKER_MEMBER(UserVoxelBvTreeShape, m_childContainer, 0, "hkpSingleShapeContainer") // class hkpSingleShapeContainer
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(UserVoxelBvTreeShape, s_libraryName, hkpBvTreeShape)

#include <Demos/Physics2012/Api/Collide/Shapes/Voxel/UserVoxelShapeCollection.h>


// UserVoxelShapeCollection ::

HK_TRACKER_DECLARE_CLASS_BEGIN(UserVoxelShapeCollection)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(UserVoxelShapeCollection)
    HK_TRACKER_MEMBER(UserVoxelShapeCollection, m_voxelData, 0, "MarchingCubes*") // class MarchingCubes*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(UserVoxelShapeCollection, s_libraryName, hkpShapeCollection)

#include <Demos/Physics2012/Api/Collide/Shapes/Voxel/VoxelShapeDemo.h>


// VoxelShapeDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(VoxelShapeDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Particle)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(VoxelShapeDemo)
    HK_TRACKER_MEMBER(VoxelShapeDemo, m_voxelData, 0, "MarchingCubes*") // class MarchingCubes*
    HK_TRACKER_MEMBER(VoxelShapeDemo, m_voxelBody, 0, "hkpRigidBody*") // class hkpRigidBody*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(VoxelShapeDemo, s_libraryName, hkDefaultPhysics2012Demo)


// Particle VoxelShapeDemo
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(VoxelShapeDemo, Particle, s_libraryName)

#include <Demos/Physics2012/Api/Collide/Welding/MeshWeldingDemo.h>


// MeshWeldingDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MeshWeldingDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MeshWeldingDemo)
    HK_TRACKER_MEMBER(MeshWeldingDemo, m_ringData, 0, "hkResource*") // class hkResource*
    HK_TRACKER_MEMBER(MeshWeldingDemo, m_movingBody, 0, "hkpRigidBody*") // class hkpRigidBody*
    HK_TRACKER_MEMBER(MeshWeldingDemo, triangleList, 0, "hkArray<hkUint16, hkContainerHeapAllocator> [2]") // hkArray< hkUint16, struct hkContainerHeapAllocator > [2]
    HK_TRACKER_MEMBER(MeshWeldingDemo, m_boxShape, 0, "hkpBoxShape*") // class hkpBoxShape*
    HK_TRACKER_MEMBER(MeshWeldingDemo, cxShapes, 0, "hkpConvexShape* [10]") // class hkpConvexShape* [10]
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(MeshWeldingDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Constraints/BallAndSocket/BallAndSocketDemo.h>


// BallAndSocketDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(BallAndSocketDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(BallAndSocketDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(BallAndSocketDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Constraints/BallAndSocketRope/BallAndSocketRopeDemo.h>


// BallAndSocketRopeDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(BallAndSocketRopeDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(BallAndSocketRopeDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(BallAndSocketRopeDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Constraints/BreakableConstraint/BreakableConstraintDemo.h>


// BreakableConstraintDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(BreakableConstraintDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(BreakableConstraintDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(BreakableConstraintDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Constraints/Chain/Bridge/BridgeDemo.h>


// BridgeDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(BridgeDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(BridgeDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(BridgeDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Constraints/Chain/ChainCfm/ChainCfmDemo.h>


// ChainCfmDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ChainCfmDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(ControllerInfo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ChainCfmDemo)
    HK_TRACKER_MEMBER(ChainCfmDemo, m_controllers, 0, "hkArray<ChainCfmDemo::ControllerInfo, hkContainerHeapAllocator>") // hkArray< struct ChainCfmDemo::ControllerInfo, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ChainCfmDemo, s_libraryName, hkDefaultPhysics2012Demo)


// ControllerInfo ChainCfmDemo

HK_TRACKER_DECLARE_CLASS_BEGIN(ChainCfmDemo::ControllerInfo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ChainCfmDemo::ControllerInfo)
    HK_TRACKER_MEMBER(ChainCfmDemo::ControllerInfo, m_var, 0, "float*") // float*
    HK_TRACKER_MEMBER(ChainCfmDemo::ControllerInfo, m_name, 0, "char*") // const char*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(ChainCfmDemo::ControllerInfo, s_libraryName)

#include <Demos/Physics2012/Api/Constraints/Chain/ChainNet/ChainNetDemo.h>


// ChainNetDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ChainNetDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ChainNetDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ChainNetDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Constraints/Chain/Spider/SpiderDemo.h>


// SpiderDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SpiderDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Leg)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(SpiderLayout)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(calcLegMatrizesIn)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SpiderDemo)
    HK_TRACKER_MEMBER(SpiderDemo, m_legs, 0, "hkArray<SpiderDemo::Leg, hkContainerHeapAllocator>") // hkArray< struct SpiderDemo::Leg, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SpiderDemo, s_libraryName, hkDefaultPhysics2012Demo)


// Leg SpiderDemo

HK_TRACKER_DECLARE_CLASS_BEGIN(SpiderDemo::Leg)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SpiderDemo::Leg)
    HK_TRACKER_MEMBER(SpiderDemo::Leg, m_constraint, 0, "hkpConstraintChainInstance*") // class hkpConstraintChainInstance*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(SpiderDemo::Leg, s_libraryName)


// SpiderLayout SpiderDemo
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(SpiderDemo, SpiderLayout, s_libraryName)


// calcLegMatrizesIn SpiderDemo
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(SpiderDemo, calcLegMatrizesIn, s_libraryName)

#include <Demos/Physics2012/Api/Constraints/Chain/SwingingRope/SwingingRopeDemo.h>


// SwingingRopeDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SwingingRopeDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SwingingRopeDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SwingingRopeDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Constraints/ClonedConstraint/ClonedConstraintDemo.h>


// ClonedConstraintDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ClonedConstraintDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ClonedConstraintDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ClonedConstraintDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Constraints/Cogs/CogsDemo.h>


// CogsDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(CogsDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(CogsDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(CogsDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Constraints/ConstraintDataCheck/ConstraintDataCheck.h>


// ConstraintDataCheckDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ConstraintDataCheckDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ConstraintDataCheckDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ConstraintDataCheckDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Constraints/ConstraintKit/ConstraintKitDemo.h>


// ConstraintKitDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ConstraintKitDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ConstraintKitDemo)
    HK_TRACKER_MEMBER(ConstraintKitDemo, m_constraint, 0, "hkpConstraintInstance*") // class hkpConstraintInstance*
    HK_TRACKER_MEMBER(ConstraintKitDemo, m_constraintData, 0, "hkpGenericConstraintData*") // class hkpGenericConstraintData*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ConstraintKitDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Constraints/ConstraintKit2/ConstraintKit2Demo.h>


// ConstraintKit2Demo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ConstraintKit2Demo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ConstraintKit2Demo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ConstraintKit2Demo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Constraints/ConstraintStability/RagdollPoseRecovery/RagdollPoseRecoveryDemo.h>


// RagdollPoseRecoveryDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(RagdollPoseRecoveryDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(RagdollPoseRecoveryDemo)
    HK_TRACKER_MEMBER(RagdollPoseRecoveryDemo, m_violatedConstraintListener, 0, "ConstraintProjectorListener*") // class ConstraintProjectorListener*
    HK_TRACKER_MEMBER(RagdollPoseRecoveryDemo, m_lastImpactPositions, 0, "hkArray<hkVector4f, hkContainerHeapAllocator>") // hkArray< hkVector4f, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(RagdollPoseRecoveryDemo, m_lastImpactDirections, 0, "hkArray<hkVector4f, hkContainerHeapAllocator>") // hkArray< hkVector4f, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(RagdollPoseRecoveryDemo, m_ragdolls, 0, "hkArray<hkpPhysicsSystem*, hkContainerHeapAllocator>") // hkArray< class hkpPhysicsSystem*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(RagdollPoseRecoveryDemo, m_easeConstraintsAction, 0, "hkpEaseConstraintsAction*") // class hkpEaseConstraintsAction*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(RagdollPoseRecoveryDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Constraints/CustomAtomConstraint/CustomAtomConstraintDemo.h>


// CustomAtomConstraintDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(CustomAtomConstraintDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(CustomAtomConstraintDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(CustomAtomConstraintDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Constraints/DeformableConstraint/DeformableConstraintDemo.h>


// DestructionConstraintDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(DestructionConstraintDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(DestructionConstraintDemo)
    HK_TRACKER_MEMBER(DestructionConstraintDemo, m_bodyA, 0, "hkpRigidBody*") // class hkpRigidBody*
    HK_TRACKER_MEMBER(DestructionConstraintDemo, m_bodyB, 0, "hkpRigidBody*") // class hkpRigidBody*
    HK_TRACKER_MEMBER(DestructionConstraintDemo, m_constraint, 0, "hkpDeformableFixedConstraintData*") // class hkpDeformableFixedConstraintData*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(DestructionConstraintDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Constraints/FixedConstraint/FixedConstraintDemo.h>


// FixedConstraintDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(FixedConstraintDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(FixedConstraintDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(FixedConstraintDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Constraints/Hinge/HingeDemo.h>


// HingeDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(HingeDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(HingeDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(HingeDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Constraints/HingeWithFriction/HingeWithFrictionDemo.h>


// HingeWithFrictionDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(HingeWithFrictionDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(HingeWithFrictionDemo)
    HK_TRACKER_MEMBER(HingeWithFrictionDemo, m_constraintData, 0, "hkpLimitedHingeConstraintData*") // class hkpLimitedHingeConstraintData*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(HingeWithFrictionDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Constraints/LimitedHinge/LimitedHingeDemo.h>


// LimitedHingeDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(LimitedHingeDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(LimitedHingeDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(LimitedHingeDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Constraints/MalleableConstraint/MalleableConstraintDemo.h>


// MalleableConstraintDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MalleableConstraintDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MalleableConstraintDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(MalleableConstraintDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Constraints/PointToPath/PointToPathDemo.h>


// PointToPathDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(PointToPathDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(PointToPathDemo)
    HK_TRACKER_MEMBER(PointToPathDemo, m_helix, 0, "hkpLinearParametricCurve*") // class hkpLinearParametricCurve*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(PointToPathDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Constraints/PointToPlane/PointToPlaneDemo.h>


// PointToPlaneDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(PointToPlaneDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(PointToPlaneDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(PointToPlaneDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Constraints/PoweredHinge/PoweredHingeDemo.h>


// PoweredHingeDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(PoweredHingeDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(PoweredHingeDemo)
    HK_TRACKER_MEMBER(PoweredHingeDemo, m_constraintData, 0, "hkpLimitedHingeConstraintData*") // class hkpLimitedHingeConstraintData*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(PoweredHingeDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Constraints/PoweredRagdoll/PoweredRagdollDemo.h>


// PoweredRagdollDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(PoweredRagdollDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(PoweredRagdollDemo)
    HK_TRACKER_MEMBER(PoweredRagdollDemo, m_constraintData, 0, "hkpRagdollConstraintData*") // class hkpRagdollConstraintData*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(PoweredRagdollDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Constraints/Prismatic/PrismaticDemo.h>


// PrismaticDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(PrismaticDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(PrismaticDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(PrismaticDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Constraints/Pulley/PulleyDemo.h>


// PulleyDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(PulleyDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(PulleyDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(PulleyDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Constraints/Ragdoll/RagdollDemo.h>


// RagdollDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(RagdollDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(RagdollDemo)
    HK_TRACKER_MEMBER(RagdollDemo, m_easeConstraintsAction, 0, "hkpEaseConstraintsAction*") // class hkpEaseConstraintsAction*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(RagdollDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Constraints/Solver/SolverDemo.h>


// SolverDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SolverDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(TextInfo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SolverDemo)
    HK_TRACKER_MEMBER(SolverDemo, m_texts, 0, "hkArray<SolverDemo::TextInfo, hkContainerHeapAllocator>") // hkArray< struct SolverDemo::TextInfo, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SolverDemo, s_libraryName, hkDefaultPhysics2012Demo)


// TextInfo SolverDemo

HK_TRACKER_DECLARE_CLASS_BEGIN(SolverDemo::TextInfo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SolverDemo::TextInfo)
    HK_TRACKER_MEMBER(SolverDemo::TextInfo, m_text, 0, "hkStringPtr") // hkStringPtr
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(SolverDemo::TextInfo, s_libraryName)

#include <Demos/Physics2012/Api/Constraints/Solver/SolverWorld.h>


// hkpSolverWorld ::

HK_TRACKER_DECLARE_CLASS_BEGIN(hkpSolverWorld)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(hkpSolverWorld)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(hkpSolverWorld, s_libraryName, hkReferencedObject)

#include <Demos/Physics2012/Api/Constraints/SpringDamperMotor/SpringDamperMotorDemo.h>


// SpringDamperMotorDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SpringDamperMotorDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SpringDamperMotorDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SpringDamperMotorDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Constraints/StiffSpring/StiffSpringDemo.h>


// StiffSpringDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(StiffSpringDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(StiffSpringDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(StiffSpringDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Constraints/Wheel/WheelDemo.h>


// WheelDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(WheelDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(WheelDemo)
    HK_TRACKER_MEMBER(WheelDemo, m_wheelConstraint, 0, "hkpWheelConstraintData*") // class hkpWheelConstraintData*
    HK_TRACKER_MEMBER(WheelDemo, m_wheelRigidBody, 0, "hkpRigidBody*") // class hkpRigidBody*
    HK_TRACKER_MEMBER(WheelDemo, m_chassis, 0, "hkpRigidBody*") // class hkpRigidBody*
    HK_TRACKER_MEMBER(WheelDemo, m_viewer, 0, "hkWheelViewer*") // class hkWheelViewer*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(WheelDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/Actions/BinaryAction/BinaryActionDemo.h>


// BinaryActionDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(BinaryActionDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(BinaryActionDemo)
    HK_TRACKER_MEMBER(BinaryActionDemo, m_boxRigidBody1, 0, "hkpRigidBody*") // class hkpRigidBody*
    HK_TRACKER_MEMBER(BinaryActionDemo, m_boxRigidBody2, 0, "hkpRigidBody*") // class hkpRigidBody*
    HK_TRACKER_MEMBER(BinaryActionDemo, m_springAction, 0, "hkpSpringAction*") // class hkpSpringAction*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(BinaryActionDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/Actions/BuoyancyAction/Buoyancy.h>


// BuoyancyDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(BuoyancyDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(BuoyancyDemo)
    HK_TRACKER_MEMBER(BuoyancyDemo, m_environment, 0, "BuoyancyAction::Environment*") // struct BuoyancyAction::Environment*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(BuoyancyDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/Actions/BuoyancyAction/BuoyancyAction.h>


// BuoyancyAction ::

HK_TRACKER_DECLARE_CLASS_BEGIN(BuoyancyAction)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Environment)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(SurfaceTriangle)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(BuoyancyAction)
    HK_TRACKER_MEMBER(BuoyancyAction, m_env, 0, "BuoyancyAction::Environment*") // const struct BuoyancyAction::Environment*
    HK_TRACKER_MEMBER(BuoyancyAction, m_vertices, 0, "hkArray<hkVector4f, hkContainerHeapAllocator>") // hkArray< hkVector4f, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(BuoyancyAction, m_triangles, 0, "hkArray<BuoyancyAction::SurfaceTriangle, hkContainerHeapAllocator>") // hkArray< struct BuoyancyAction::SurfaceTriangle, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(BuoyancyAction, s_libraryName, hkpUnaryAction)


// Environment BuoyancyAction

HK_TRACKER_DECLARE_CLASS_BEGIN(BuoyancyAction::Environment)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(BuoyancyAction::Environment)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_ABSTRACT_BASE(BuoyancyAction::Environment, s_libraryName)


// SurfaceTriangle BuoyancyAction
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(BuoyancyAction, SurfaceTriangle, s_libraryName)

#include <Demos/Physics2012/Api/Dynamics/Actions/GravityAction/GravityAction.h>


// GravityAction ::

HK_TRACKER_DECLARE_CLASS_BEGIN(GravityAction)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(GravityAction)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(GravityAction, s_libraryName, hkpUnaryAction)

#include <Demos/Physics2012/Api/Dynamics/Actions/GravityAction/GravityActionDemo.h>


// GravityActionDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(GravityActionDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(GravityActionDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(GravityActionDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/Actions/MotorAction/MotorActionDemo.h>


// MotorActionDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MotorActionDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MotorActionDemo)
    HK_TRACKER_MEMBER(MotorActionDemo, m_border, 0, "hkpBroadPhaseBorder*") // class hkpBroadPhaseBorder*
    HK_TRACKER_MEMBER(MotorActionDemo, m_motorAction, 0, "hkpMotorAction*") // class hkpMotorAction*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(MotorActionDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/Actions/UnaryAction/AntiGravityAction.h>


// AntiGravityAction ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AntiGravityAction)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AntiGravityAction)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(AntiGravityAction, s_libraryName, hkpUnaryAction)

#include <Demos/Physics2012/Api/Dynamics/Actions/UnaryAction/UnaryActionDemo.h>


// UnaryActionDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(UnaryActionDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(UnaryActionDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(UnaryActionDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/Actions/WindAction/Explosion/ExplosionDemo.h>


// ExplosionInfo ::
HK_TRACKER_IMPLEMENT_SIMPLE(ExplosionInfo, s_libraryName)


// Explosion ::

HK_TRACKER_DECLARE_CLASS_BEGIN(Explosion)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(Explosion)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(Explosion, s_libraryName, hkpWind)


// ExplosionManager ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ExplosionManager)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ExplosionManager)
    HK_TRACKER_MEMBER(ExplosionManager, m_explosions, 0, "hkArray<Explosion*, hkContainerHeapAllocator>") // hkArray< class Explosion*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ExplosionManager, s_libraryName, hkpWind)


// ExplosionDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ExplosionDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ExplosionDemo)
    HK_TRACKER_MEMBER(ExplosionDemo, m_explosionManager, 0, "ExplosionManager") // class ExplosionManager
    HK_TRACKER_MEMBER(ExplosionDemo, m_region, 0, "hkpWindRegion*") // class hkpWindRegion*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ExplosionDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/Actions/WindAction/PrevailingWind/PrevailingWindDemo.h>


// PrevailingWindDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(PrevailingWindDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(PrevailingWindDemo)
    HK_TRACKER_MEMBER(PrevailingWindDemo, m_wind, 0, "hkpPrevailingWind*") // class hkpPrevailingWind*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(PrevailingWindDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/Actions/WindAction/Resistance/ResistanceDemo.h>


// ResistanceManager ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ResistanceManager)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ResistanceManager)
    HK_TRACKER_MEMBER(ResistanceManager, m_bodies, 0, "hkArray<hkpRigidBody*, hkContainerHeapAllocator>") // hkArray< class hkpRigidBody*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(ResistanceManager, m_wind, 0, "hkpWind *") // class hkpWind *
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ResistanceManager, s_libraryName, hkpWorldPostSimulationListener)


// ResistanceDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ResistanceDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ResistanceDemo)
    HK_TRACKER_MEMBER(ResistanceDemo, m_bodies, 0, "hkArray<hkpRigidBody*, hkContainerHeapAllocator>") // hkArray< class hkpRigidBody*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(ResistanceDemo, m_resistanceManager, 0, "ResistanceManager") // class ResistanceManager
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ResistanceDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/Actions/WindAction/WindAction/WindActionDemo.h>


// WindActionDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(WindActionDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(WindActionDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(WindActionDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/Actions/WindAction/WindRegion/WindRegionDemo.h>


// WindRegionDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(WindRegionDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(WindRegionDemo)
    HK_TRACKER_MEMBER(WindRegionDemo, m_region, 0, "hkpWindRegion*") // class hkpWindRegion*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(WindRegionDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/Listeners/ActivationCallbacks/ActivationCallbacksDemo.h>


// ActivationCallbacksDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ActivationCallbacksDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ActivationCallbacksDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ActivationCallbacksDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/Listeners/WorldListener/HoverExampleAction.h>


// HoverExampleAction ::

HK_TRACKER_DECLARE_CLASS_BEGIN(HoverExampleAction)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(HoverExampleAction)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(HoverExampleAction, s_libraryName, hkpUnaryAction)

#include <Demos/Physics2012/Api/Dynamics/MemoryIssues/LimitedSolverMemory/LimitedSolverMemoryDemo.h>


// LimitedSolverMemoryDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(LimitedSolverMemoryDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(LimitedSolverMemoryDemo)
    HK_TRACKER_MEMBER(LimitedSolverMemoryDemo, m_oldBuffer, 0, "char*") // char*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(LimitedSolverMemoryDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/MemoryIssues/LimitingMemory/LimitingMemoryDemo.h>


// MySimpleObjectWatchDog ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MySimpleObjectWatchDog)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MySimpleObjectWatchDog)
    HK_TRACKER_MEMBER(MySimpleObjectWatchDog, m_ragdolls, 0, "hkArray<hkpPhysicsSystem *, hkContainerHeapAllocator>") // hkArray< class hkpPhysicsSystem *, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(MySimpleObjectWatchDog, m_debris, 0, "hkArray<hkpRigidBody *, hkContainerHeapAllocator>") // hkArray< class hkpRigidBody *, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(MySimpleObjectWatchDog, s_libraryName, hkWorldMemoryAvailableWatchDog)


// LimitingMemoryDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(LimitingMemoryDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(LimitingMemoryDemo)
    HK_TRACKER_MEMBER(LimitingMemoryDemo, m_watchDog, 0, "MySimpleObjectWatchDog*") // class MySimpleObjectWatchDog*
    HK_TRACKER_MEMBER(LimitingMemoryDemo, m_filter, 0, "hkpGroupFilter*") // class hkpGroupFilter*
    HK_TRACKER_MEMBER(LimitingMemoryDemo, m_geom, 0, "hkGeometry*") // struct hkGeometry*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(LimitingMemoryDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/MemoryIssues/LimitingMemory2/LimitingMemory2Demo.h>


// LimitingMemory2Demo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(LimitingMemory2Demo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(LimitingMemory2Demo)
    HK_TRACKER_MEMBER(LimitingMemory2Demo, m_landscape, 0, "hkReferencedObject*") // class hkReferencedObject*
    HK_TRACKER_MEMBER(LimitingMemory2Demo, m_watchDog, 0, "hkpDefaultWorldMemoryWatchDog*") // class hkpDefaultWorldMemoryWatchDog*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(LimitingMemory2Demo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/MemoryIssues/ResizeSolverBuffer/ResizeSolverBufferDemo.h>


// ResizeSolverBufferDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ResizeSolverBufferDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ResizeSolverBufferDemo)
    HK_TRACKER_MEMBER(ResizeSolverBufferDemo, m_memUsageInfo, 0, "hkWorldMemoryAvailableWatchDog::MemUsageInfo") // struct hkWorldMemoryAvailableWatchDog::MemUsageInfo
    HK_TRACKER_MEMBER(ResizeSolverBufferDemo, m_originalBuffer, 0, "char*") // char*
    HK_TRACKER_MEMBER(ResizeSolverBufferDemo, m_myBuffer, 0, "char*") // char*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ResizeSolverBufferDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/MemoryIssues/SuspendInactiveAgents/SuspendInactiveAgentsDemo.h>


// SuspendInactiveAgentsDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SuspendInactiveAgentsDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SuspendInactiveAgentsDemo)
    HK_TRACKER_MEMBER(SuspendInactiveAgentsDemo, m_landscape, 0, "hkReferencedObject*") // class hkReferencedObject*
    HK_TRACKER_MEMBER(SuspendInactiveAgentsDemo, m_suspendInactiveAgentsUtil, 0, "hkpSuspendInactiveAgentsUtil*") // class hkpSuspendInactiveAgentsUtil*
    HK_TRACKER_MEMBER(SuspendInactiveAgentsDemo, m_boxRigidBody, 0, "hkpRigidBody*") // class hkpRigidBody*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SuspendInactiveAgentsDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/Phantoms/PhantomBatchMove/PhantomBatchMoveDemo.h>


// PhantomBatchMoveDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(PhantomBatchMoveDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(PhantomBatchMoveDemo)
    HK_TRACKER_MEMBER(PhantomBatchMoveDemo, m_characterProxy, 0, "hkArray<hkpCharacterProxy*, hkContainerHeapAllocator>") // hkArray< class hkpCharacterProxy*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(PhantomBatchMoveDemo, m_aabbPhantoms, 0, "hkArray<hkpAabbPhantom*, hkContainerHeapAllocator>") // hkArray< class hkpAabbPhantom*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(PhantomBatchMoveDemo, m_stopwatch, 0, "hkStopwatch") // class hkStopwatch
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(PhantomBatchMoveDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/Phantoms/PhantomEvents/PhantomEventsDemo.h>


// PhantomEventsDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(PhantomEventsDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(PhantomEventsDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(PhantomEventsDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/Phantoms/PhantomObject/PhantomObjectDemo.h>


// PhantomObjectDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(PhantomObjectDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Options)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(PhantomObjectDemo)
    HK_TRACKER_MEMBER(PhantomObjectDemo, m_phantom, 0, "hkpAabbPhantom*") // class hkpAabbPhantom*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(PhantomObjectDemo, s_libraryName, hkDefaultPhysics2012Demo)


// Options PhantomObjectDemo
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(PhantomObjectDemo, Options, s_libraryName)

#include <Demos/Physics2012/Api/Dynamics/RigidBodies/BreakOffParts/BreakOffPartsDemo.h>


// BreakOffPartsDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(BreakOffPartsDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(BreakOffPartsDemo)
    HK_TRACKER_MEMBER(BreakOffPartsDemo, m_breakUtil, 0, "hkpBreakOffPartsUtil*") // class hkpBreakOffPartsUtil*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(BreakOffPartsDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/RigidBodies/ConstraintProjection/ConstraintProjectionDemo.h>


// ConstraintProjectionDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ConstraintProjectionDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ConstraintProjectionDemo)
    HK_TRACKER_MEMBER(ConstraintProjectionDemo, m_violatedConstraintListener, 0, "ConstraintProjectorListener*") // class ConstraintProjectorListener*
    HK_TRACKER_MEMBER(ConstraintProjectionDemo, m_lastImpactPositions, 0, "hkArray<hkVector4f, hkContainerHeapAllocator>") // hkArray< hkVector4f, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(ConstraintProjectionDemo, m_lastImpactDirections, 0, "hkArray<hkVector4f, hkContainerHeapAllocator>") // hkArray< hkVector4f, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(ConstraintProjectionDemo, m_ragdolls, 0, "hkArray<hkpPhysicsSystem*, hkContainerHeapAllocator>") // hkArray< class hkpPhysicsSystem*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(ConstraintProjectionDemo, m_ragdollAttachmentPoints, 0, "hkArray<hkVector4f, hkContainerHeapAllocator>") // hkArray< hkVector4f, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(ConstraintProjectionDemo, m_rigidBodyCache, 0, "hkpPhysicsSystem*") // class hkpPhysicsSystem*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ConstraintProjectionDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/RigidBodies/DisablingConstraints/DisablingConstraintsDemo.h>


// DisablingConstraintsDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(DisablingConstraintsDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(DisablingConstraintsDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(DisablingConstraintsDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/RigidBodies/Friction/FrictionDemo.h>


// FrictionDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(FrictionDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(FrictionDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(FrictionDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/RigidBodies/FrictionChange/FrictionChangeDemo.h>


// FrictionChangeDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(FrictionChangeDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(FrictionChangeDemo)
    HK_TRACKER_MEMBER(FrictionChangeDemo, m_movingBody, 0, "hkpRigidBody*") // class hkpRigidBody*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(FrictionChangeDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/RigidBodies/GravityChange/GravityChangeDemo.h>


// GravityChangeDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(GravityChangeDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(GravityChangeDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(GravityChangeDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/RigidBodies/InitialPenetration/InitialPenetrationDemo.h>


// InitialPenetrationDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(InitialPenetrationDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(InitialPenetrationDemo)
    HK_TRACKER_MEMBER(InitialPenetrationDemo, m_complexRBs, 0, "hkArray<hkpRigidBody*, hkContainerHeapAllocator>") // hkArray< class hkpRigidBody*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(InitialPenetrationDemo, m_complexShapes, 0, "hkArray<hkpShape*, hkContainerHeapAllocator>") // hkArray< class hkpShape*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(InitialPenetrationDemo, m_debrisPackfileData, 0, "hkResource*") // class hkResource*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(InitialPenetrationDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/RigidBodies/Keyframing/KeyframingDemo.h>


// KeyframingDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(KeyframingDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(KeyframingDemo)
    HK_TRACKER_MEMBER(KeyframingDemo, m_keyframedBody, 0, "hkpRigidBody*") // class hkpRigidBody*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(KeyframingDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/RigidBodies/Modifiers/CenterOfMassChanger/CenterOfMassChangerDemo.h>


// CenterOfMassChangerDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(CenterOfMassChangerDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(CenterOfMassChangerDemo)
    HK_TRACKER_MEMBER(CenterOfMassChangerDemo, m_utils, 0, "hkArray<hkpCenterOfMassChangerUtil*, hkContainerHeapAllocator>") // hkArray< class hkpCenterOfMassChangerUtil*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(CenterOfMassChangerDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/RigidBodies/Modifiers/MassChanger/MassChangerDemo.h>


// MassChangerDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MassChangerDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MassChangerDemo)
    HK_TRACKER_MEMBER(MassChangerDemo, m_bodies, 0, "hkpRigidBody* [4]") // class hkpRigidBody* [4]
    HK_TRACKER_MEMBER(MassChangerDemo, m_cmcu, 0, "hkpCollisionMassChangerUtil*") // class hkpCollisionMassChangerUtil*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(MassChangerDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/RigidBodies/Modifiers/NonUniformMassAndInertiaChanger/NonUniformMassAndInertiaChangerDemo.h>


// NonUniformMassChangerDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(NonUniformMassChangerDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(NonUniformMassChangerDemo)
    HK_TRACKER_MEMBER(NonUniformMassChangerDemo, m_utils, 0, "hkArray<hkpCollisionMassChangerUtil*, hkContainerHeapAllocator>") // hkArray< class hkpCollisionMassChangerUtil*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(NonUniformMassChangerDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/RigidBodies/Modifiers/SoftContact/SoftContactDemo.h>


// SoftContactDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SoftContactDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SoftContactDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SoftContactDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/RigidBodies/Modifiers/SurfaceVelocity/Filtered/FilteredSurfaceVelocityDemo.h>


// FilteredSurfaceVelocityDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(FilteredSurfaceVelocityDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(FilteredSurfaceVelocityDemo)
    HK_TRACKER_MEMBER(FilteredSurfaceVelocityDemo, m_listener, 0, "FilteredSurfaceVelocityDemo_PhantomListener*") // class FilteredSurfaceVelocityDemo_PhantomListener*
    HK_TRACKER_MEMBER(FilteredSurfaceVelocityDemo, m_phantom, 0, "hkpAabbPhantom*") // class hkpAabbPhantom*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(FilteredSurfaceVelocityDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/RigidBodies/Modifiers/SurfaceVelocity/Unfiltered/UnfilteredSurfaceVelocityDemo.h>


// UnfilteredSurfaceVelocityDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(UnfilteredSurfaceVelocityDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(UnfilteredSurfaceVelocityDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(UnfilteredSurfaceVelocityDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/RigidBodies/Modifiers/ViscousSurface/ViscousSurfaceDemo.h>


// ViscousSurfaceDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ViscousSurfaceDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ViscousSurfaceDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ViscousSurfaceDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/RigidBodies/MotionTypeChange/MotionTypeChangeDemo.h>


// MotionTypeChangeDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MotionTypeChangeDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MotionTypeChangeDemo)
    HK_TRACKER_MEMBER(MotionTypeChangeDemo, m_pointer, 0, "hkpRigidBody*") // class hkpRigidBody*
    HK_TRACKER_MEMBER(MotionTypeChangeDemo, m_handSpheres, 0, "hkArray<hkpRigidBody*, hkContainerHeapAllocator>") // hkArray< class hkpRigidBody*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(MotionTypeChangeDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/RigidBodies/Restitution/RestitutionDemo.h>


// RestitutionDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(RestitutionDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(RestitutionDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(RestitutionDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/World/AddRemoveBodies/AddRemoveBodiesDemo.h>


// AddRemoveBodiesDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AddRemoveBodiesDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AddRemoveBodiesDemo)
    HK_TRACKER_MEMBER(AddRemoveBodiesDemo, m_bodies, 0, "hkpRigidBody* [10]") // class hkpRigidBody* [10]
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(AddRemoveBodiesDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/World/AddRemoveConstraints/AddRemoveConstraintsDemo.h>


// AddRemoveConstraintsDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AddRemoveConstraintsDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AddRemoveConstraintsDemo)
    HK_TRACKER_MEMBER(AddRemoveConstraintsDemo, m_fixedBody, 0, "hkpRigidBody*") // class hkpRigidBody*
    HK_TRACKER_MEMBER(AddRemoveConstraintsDemo, m_dynamicBody, 0, "hkpRigidBody*") // class hkpRigidBody*
    HK_TRACKER_MEMBER(AddRemoveConstraintsDemo, m_constraint, 0, "hkpConstraintInstance*") // class hkpConstraintInstance*
    HK_TRACKER_MEMBER(AddRemoveConstraintsDemo, m_constraintData, 0, "hkpBallAndSocketConstraintData*") // class hkpBallAndSocketConstraintData*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(AddRemoveConstraintsDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/World/BatchAddRemoveBodies/BatchAddRemoveBodiesDemo.h>


// BatchAddRemoveBodiesDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(BatchAddRemoveBodiesDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(BatchAddRemoveBodiesDemo)
    HK_TRACKER_MEMBER(BatchAddRemoveBodiesDemo, m_gridOccupied, 0, "hkArray<hkBool, hkContainerHeapAllocator>") // hkArray< hkBool, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(BatchAddRemoveBodiesDemo, m_entities, 0, "hkArray<hkpEntity*, hkContainerHeapAllocator>") // hkArray< class hkpEntity*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(BatchAddRemoveBodiesDemo, m_timer, 0, "hkStopwatch") // class hkStopwatch
    HK_TRACKER_MEMBER(BatchAddRemoveBodiesDemo, m_capture, 0, "hkMonitorStreamAnalyzer") // class hkMonitorStreamAnalyzer
    HK_TRACKER_MEMBER(BatchAddRemoveBodiesDemo, m_textOutput, 0, "hkStringPtr") // hkStringPtr
    HK_TRACKER_MEMBER(BatchAddRemoveBodiesDemo, m_myFlatLand, 0, "myFlatLand*") // class myFlatLand*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(BatchAddRemoveBodiesDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Dynamics/World/SlidingWorld/SlidingWorldDemo.h>


// SlidingWorldDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SlidingWorldDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(SlidingWorldDemoMode)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SlidingWorldDemo)
    HK_TRACKER_MEMBER(SlidingWorldDemo, m_boxes, 0, "hkArray<hkpRigidBody*, hkContainerHeapAllocator>") // hkArray< class hkpRigidBody*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SlidingWorldDemo, s_libraryName, hkDefaultPhysics2012Demo)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(SlidingWorldDemo, SlidingWorldDemoMode, s_libraryName)

#include <Demos/Physics2012/Api/Dynamics/World/WorldSnapshot/WorldSnapshotDemo.h>


// WorldSnapshotDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(WorldSnapshotDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(WorldSnapshotDemo)
    HK_TRACKER_MEMBER(WorldSnapshotDemo, m_loadedData, 0, "hkResource*") // class hkResource*
    HK_TRACKER_MEMBER(WorldSnapshotDemo, m_physicsData, 0, "hkpPhysicsData*") // class hkpPhysicsData*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(WorldSnapshotDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Vehicle/BigRig/BigRigDemo.h>


// BigRigDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(BigRigDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(BigRigDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(BigRigDemo, s_libraryName, CarDemo)

#include <Demos/Physics2012/Api/Vehicle/BigRig/TractorSetup.h>


// TractorSetup ::

HK_TRACKER_DECLARE_CLASS_BEGIN(TractorSetup)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(TractorSetup)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(TractorSetup, s_libraryName, VehicleSetup)

#include <Demos/Physics2012/Api/Vehicle/BigRig/TrailerSetup.h>


// TrailerSetup ::

HK_TRACKER_DECLARE_CLASS_BEGIN(TrailerSetup)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(TrailerSetup)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(TrailerSetup, s_libraryName, VehicleSetup)

#include <Demos/Physics2012/Api/Vehicle/Car/CarDemo.h>


// CarDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(CarDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(CarDemo)
    HK_TRACKER_MEMBER(CarDemo, m_vehicles, 0, "hkArray<VehicleDisplayUtils::VehicleDataAndDisplayInfo, hkContainerHeapAllocator>") // hkArray< struct VehicleDisplayUtils::VehicleDataAndDisplayInfo, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(CarDemo, m_track, 0, "hkReferencedObject*") // class hkReferencedObject*
    HK_TRACKER_MEMBER(CarDemo, m_displayWheelId, 0, "hkArray<hkArray<hkInt32, hkContainerHeapAllocator>, hkContainerHeapAllocator>") // hkArray< hkArray< hkInt32, struct hkContainerHeapAllocator >, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(CarDemo, m_reorientAction, 0, "hkpReorientAction*") // class hkpReorientAction*
    HK_TRACKER_MEMBER(CarDemo, m_ragdolls, 0, "hkArray<hkRagdoll*, hkContainerHeapAllocator>") // hkArray< class hkRagdoll*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(CarDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Vehicle/LinearCastVehicle/LinearCastVehicle.h>


// LinearCastVehicleDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(LinearCastVehicleDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(LinearCastVehicleDemo)
    HK_TRACKER_MEMBER(LinearCastVehicleDemo, m_vehicle, 0, "hkpVehicleInstance*") // class hkpVehicleInstance*
    HK_TRACKER_MEMBER(LinearCastVehicleDemo, m_track, 0, "hkReferencedObject*") // class hkReferencedObject*
    HK_TRACKER_MEMBER(LinearCastVehicleDemo, m_displayWheelId, 0, "hkArray<hkInt32, hkContainerHeapAllocator>") // hkArray< hkInt32, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(LinearCastVehicleDemo, m_reorientAction, 0, "hkpReorientAction*") // class hkpReorientAction*
    HK_TRACKER_MEMBER(LinearCastVehicleDemo, m_ragdolls, 0, "hkArray<hkRagdoll*, hkContainerHeapAllocator>") // hkArray< class hkRagdoll*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(LinearCastVehicleDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Vehicle/Motorcycle/MotorcycleDemo.h>


// MotorcycleDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MotorcycleDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MotorcycleDemo)
    HK_TRACKER_MEMBER(MotorcycleDemo, m_constraint, 0, "hkArray<hkpConstraintInstance*, hkContainerHeapAllocator>") // hkArray< class hkpConstraintInstance*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(MotorcycleDemo, m_genericConstraint, 0, "hkArray<hkpGenericConstraintData*, hkContainerHeapAllocator>") // hkArray< class hkpGenericConstraintData*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(MotorcycleDemo, s_libraryName, CarDemo)

#include <Demos/Physics2012/Api/Vehicle/Motorcycle/MotorcycleSetup.h>


// MotorcycleSetup ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MotorcycleSetup)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MotorcycleSetup)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(MotorcycleSetup, s_libraryName, VehicleSetup)

#include <Demos/Physics2012/Api/Vehicle/PerWheelCar/PerWheelCarDemo.h>


// PerWheelCarDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(PerWheelCarDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(PerWheelCarDemo)
    HK_TRACKER_MEMBER(PerWheelCarDemo, m_vehicles, 0, "hkArray<VehicleDisplayUtils::VehicleDataAndDisplayInfo, hkContainerHeapAllocator>") // hkArray< struct VehicleDisplayUtils::VehicleDataAndDisplayInfo, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(PerWheelCarDemo, m_track, 0, "hkReferencedObject*") // class hkReferencedObject*
    HK_TRACKER_MEMBER(PerWheelCarDemo, m_displayWheelId, 0, "hkArray<hkArray<hkInt32, hkContainerHeapAllocator>, hkContainerHeapAllocator>") // hkArray< hkArray< hkInt32, struct hkContainerHeapAllocator >, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(PerWheelCarDemo, m_ragdolls, 0, "hkArray<hkRagdoll*, hkContainerHeapAllocator>") // hkArray< class hkRagdoll*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(PerWheelCarDemo, m_platform, 0, "hkpRigidBody*") // class hkpRigidBody*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(PerWheelCarDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Vehicle/PerWheelCar/PerWheelSetup.h>


// PerWheelSetup ::

HK_TRACKER_DECLARE_CLASS_BEGIN(PerWheelSetup)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(PerWheelSetup)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(PerWheelSetup, s_libraryName, VehicleSetup)

#include <Demos/Physics2012/Api/Vehicle/SerializedManager/SerializedManagerDemo.h>


// SerializedManager ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SerializedManager)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SerializedManager)
    HK_TRACKER_MEMBER(SerializedManager, m_path, 0, "hkStringPtr") // hkStringPtr
    HK_TRACKER_MEMBER(SerializedManager, m_vehicleManager, 0, "hkpVehicleManager*") // class hkpVehicleManager*
    HK_TRACKER_MEMBER(SerializedManager, m_resource, 0, "hkResource*") // class hkResource*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SerializedManager, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Vehicle/SerializedVehicle/SerializedVehicleDemo.h>


// SerializedVehicle ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SerializedVehicle)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SerializedVehicle)
    HK_TRACKER_MEMBER(SerializedVehicle, m_loadedDataVehicle, 0, "hkResource*") // class hkResource*
    HK_TRACKER_MEMBER(SerializedVehicle, m_loadedDataLandscape, 0, "hkResource*") // class hkResource*
    HK_TRACKER_MEMBER(SerializedVehicle, m_vehicleSystem, 0, "hkpPhysicsSystem*") // class hkpPhysicsSystem*
    HK_TRACKER_MEMBER(SerializedVehicle, m_landscape, 0, "hkpRigidBody*") // class hkpRigidBody*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SerializedVehicle, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Vehicle/SixWheelTruck/SixWheelTruckDemo.h>


// SixWheelTruckDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SixWheelTruckDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SixWheelTruckDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SixWheelTruckDemo, s_libraryName, CarDemo)

#include <Demos/Physics2012/Api/Vehicle/SixWheelTruck/SixWheelTruckSetup.h>


// SixWheelTruckSetup ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SixWheelTruckSetup)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SixWheelTruckSetup)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SixWheelTruckSetup, s_libraryName, VehicleSetup)

#include <Demos/Physics2012/Api/Vehicle/Tank/TankDemo.h>


// TankDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(TankDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(TankDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(TankDemo, s_libraryName, CarDemo)

#include <Demos/Physics2012/Api/Vehicle/Tank/TankSetup.h>


// TankSetup ::

HK_TRACKER_DECLARE_CLASS_BEGIN(TankSetup)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(TankSetup)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(TankSetup, s_libraryName, VehicleSetup)

#include <Demos/Physics2012/Api/Vehicle/Tank/TankSteering.h>


// TankSteering ::

HK_TRACKER_DECLARE_CLASS_BEGIN(TankSteering)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(TankSteering)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(TankSteering, s_libraryName, hkpVehicleDefaultSteering)

#include <Demos/Physics2012/Api/Vehicle/Truck/TruckDemo.h>


// TruckDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(TruckDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(TruckDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(TruckDemo, s_libraryName, CarDemo)

#include <Demos/Physics2012/Api/Vehicle/Truck/TruckSetup.h>


// TruckSetup ::

HK_TRACKER_DECLARE_CLASS_BEGIN(TruckSetup)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(TruckSetup)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(TruckSetup, s_libraryName, VehicleSetup)

#include <Demos/Physics2012/Api/Vehicle/VehicleApi/VehicleApiDemo.h>


// VehicleApiDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(VehicleApiDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(VehicleApiDemo)
    HK_TRACKER_MEMBER(VehicleApiDemo, m_vehicle, 0, "hkpVehicleInstance*") // class hkpVehicleInstance*
    HK_TRACKER_MEMBER(VehicleApiDemo, m_displayWheelId, 0, "hkArray<hkInt32, hkContainerHeapAllocator>") // hkArray< hkInt32, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(VehicleApiDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Vehicle/VehicleCloning/VehicleCloningDemo.h>


// VehicleCloning ::

HK_TRACKER_DECLARE_CLASS_BEGIN(VehicleCloning)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(VehicleCloning)
    HK_TRACKER_MEMBER(VehicleCloning, m_displayWheelId, 0, "hkArray<hkArray<hkInt32, hkContainerHeapAllocator>, hkContainerHeapAllocator>") // hkArray< hkArray< hkInt32, struct hkContainerHeapAllocator >, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(VehicleCloning, m_vehicles, 0, "hkArray<hkpVehicleInstance*, hkContainerHeapAllocator>") // hkArray< class hkpVehicleInstance*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(VehicleCloning, m_track, 0, "FlatLand*") // class FlatLand*
    HK_TRACKER_MEMBER(VehicleCloning, m_landscapeContainer, 0, "LandscapeContainer*") // class LandscapeContainer*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(VehicleCloning, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/Api/Vehicle/Wheel/BackSetup.h>


// BackSetup ::

HK_TRACKER_DECLARE_CLASS_BEGIN(BackSetup)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(BackSetup)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(BackSetup, s_libraryName, VehicleSetup)

#include <Demos/Physics2012/Api/Vehicle/Wheel/FrontSetup.h>


// FrontSetup ::

HK_TRACKER_DECLARE_CLASS_BEGIN(FrontSetup)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(FrontSetup)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(FrontSetup, s_libraryName, VehicleSetup)

#include <Demos/Physics2012/Api/Vehicle/Wheel/UnicycleSetup.h>


// UnicycleSetup ::

HK_TRACKER_DECLARE_CLASS_BEGIN(UnicycleSetup)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(UnicycleSetup)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(UnicycleSetup, s_libraryName, VehicleSetup)

#include <Demos/Physics2012/Api/Vehicle/Wheel/WheelVehicleDemo.h>


// WheelVehicleDemoTweakerOptions ::
HK_TRACKER_IMPLEMENT_SIMPLE(WheelVehicleDemoTweakerOptions, s_libraryName)


// WheelVehicleDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(WheelVehicleDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(WheelVehicleDemo)
    HK_TRACKER_MEMBER(WheelVehicleDemo, m_vehicles, 0, "hkArray<VehicleDisplayUtils::VehicleDataAndDisplayInfo, hkContainerHeapAllocator>") // hkArray< struct VehicleDisplayUtils::VehicleDataAndDisplayInfo, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(WheelVehicleDemo, m_wheels, 0, "hkArray<hkArray<hkpWheel*, hkContainerHeapAllocator>, hkContainerHeapAllocator>") // hkArray< hkArray< class hkpWheel*, struct hkContainerHeapAllocator >, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(WheelVehicleDemo, m_axles, 0, "hkArray<hkArray<hkpWheelFrictionConstraintAtom::Axle, hkContainerHeapAllocator>, hkContainerHeapAllocator>") // hkArray< hkArray< struct hkpWheelFrictionConstraintAtom::Axle, struct hkContainerHeapAllocator >, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(WheelVehicleDemo, m_track, 0, "FlatLand*") // class FlatLand*
    HK_TRACKER_MEMBER(WheelVehicleDemo, m_displayWheelId, 0, "hkArray<hkArray<hkInt32, hkContainerHeapAllocator>, hkContainerHeapAllocator>") // hkArray< hkArray< hkInt32, struct hkContainerHeapAllocator >, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(WheelVehicleDemo, m_mouseTweakerSettings, 0, "DemoMouseTweaker::MouseTweakerSettings") // struct DemoMouseTweaker::MouseTweakerSettings
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(WheelVehicleDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/CharacterControl/CharacterProxy/AsymetricCharacter/AsymetricCharacterDemo.h>


// AsymetricCharacterDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AsymetricCharacterDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AsymetricCharacterDemo)
    HK_TRACKER_MEMBER(AsymetricCharacterDemo, m_characterProxy, 0, "hkpCharacterProxy*") // class hkpCharacterProxy*
    HK_TRACKER_MEMBER(AsymetricCharacterDemo, m_characterContext, 0, "hkpCharacterContext*") // class hkpCharacterContext*
    HK_TRACKER_MEMBER(AsymetricCharacterDemo, m_phantom, 0, "hkpShapePhantom*") // class hkpShapePhantom*
    HK_TRACKER_MEMBER(AsymetricCharacterDemo, m_data, 0, "float*") // float*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(AsymetricCharacterDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/CharacterControl/CharacterProxy/CharacterAndTriggerVolumes/CharacterAndTriggerVolumesDemo.h>


// CharacterAndTriggerVolumesDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(CharacterAndTriggerVolumesDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(ShapeViewerMode)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(CharacterAndTriggerVolumesDemo)
    HK_TRACKER_MEMBER(CharacterAndTriggerVolumesDemo, m_characterProxy, 0, "TriggerVolumeAwareCharacterProxy*") // class TriggerVolumeAwareCharacterProxy*
    HK_TRACKER_MEMBER(CharacterAndTriggerVolumesDemo, m_characterContext, 0, "hkpCharacterContext*") // class hkpCharacterContext*
    HK_TRACKER_MEMBER(CharacterAndTriggerVolumesDemo, m_phantom, 0, "hkpShapePhantom*") // class hkpShapePhantom*
    HK_TRACKER_MEMBER(CharacterAndTriggerVolumesDemo, m_standShape, 0, "hkpShape*") // class hkpShape*
    HK_TRACKER_MEMBER(CharacterAndTriggerVolumesDemo, m_crouchShape, 0, "hkpShape*") // class hkpShape*
    HK_TRACKER_MEMBER(CharacterAndTriggerVolumesDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(CharacterAndTriggerVolumesDemo, m_rigidBodyDisplayObjects, 0, "hkPointerMap<hkpRigidBody*, hkgDisplayObject*, hkContainerHeapAllocator>") // class hkPointerMap< class hkpRigidBody*, class hkgDisplayObject*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(CharacterAndTriggerVolumesDemo, s_libraryName, hkDefaultPhysics2012Demo)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(CharacterAndTriggerVolumesDemo, ShapeViewerMode, s_libraryName)

#include <Demos/Physics2012/UseCase/CharacterControl/CharacterProxy/CharacterAndTriggers/CharacterAndTriggersDemo.h>


// CharacterAndTriggersDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(CharacterAndTriggersDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(CharacterAndTriggersDemo)
    HK_TRACKER_MEMBER(CharacterAndTriggersDemo, m_characterProxy, 0, "hkpCharacterProxy*") // class hkpCharacterProxy*
    HK_TRACKER_MEMBER(CharacterAndTriggersDemo, m_characterContext, 0, "hkpCharacterContext*") // class hkpCharacterContext*
    HK_TRACKER_MEMBER(CharacterAndTriggersDemo, m_phantom, 0, "hkpShapePhantom*") // class hkpShapePhantom*
    HK_TRACKER_MEMBER(CharacterAndTriggersDemo, m_standShape, 0, "hkpShape*") // class hkpShape*
    HK_TRACKER_MEMBER(CharacterAndTriggersDemo, m_crouchShape, 0, "hkpShape*") // class hkpShape*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(CharacterAndTriggersDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/CharacterControl/CharacterProxy/CharacterController/CharacterControllerDemo.h>


// CharacterDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(CharacterDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(CharacterDemo)
    HK_TRACKER_MEMBER(CharacterDemo, m_characterProxy, 0, "hkpCharacterProxy*") // class hkpCharacterProxy*
    HK_TRACKER_MEMBER(CharacterDemo, m_characterContext, 0, "hkpCharacterContext*") // class hkpCharacterContext*
    HK_TRACKER_MEMBER(CharacterDemo, m_phantom, 0, "hkpShapePhantom*") // class hkpShapePhantom*
    HK_TRACKER_MEMBER(CharacterDemo, m_standShape, 0, "hkpShape*") // class hkpShape*
    HK_TRACKER_MEMBER(CharacterDemo, m_crouchShape, 0, "hkpShape*") // class hkpShape*
    HK_TRACKER_MEMBER(CharacterDemo, m_listener, 0, "MyCharacterListener*") // class MyCharacterListener*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(CharacterDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/CharacterControl/CharacterProxy/CharacterInteraction/CharacterInteractionDemo.h>


// CharacterInteractionDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(CharacterInteractionDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(CharacterInteractionDemo)
    HK_TRACKER_MEMBER(CharacterInteractionDemo, m_characterProxy, 0, "hkpCharacterProxy*") // class hkpCharacterProxy*
    HK_TRACKER_MEMBER(CharacterInteractionDemo, m_characterContext, 0, "hkpCharacterContext*") // class hkpCharacterContext*
    HK_TRACKER_MEMBER(CharacterInteractionDemo, m_listener, 0, "ZeroPlanesCharacterInteractionListener*") // class ZeroPlanesCharacterInteractionListener*
    HK_TRACKER_MEMBER(CharacterInteractionDemo, m_rigidBodies, 0, "hkArray<hkpRigidBody*, hkContainerHeapAllocator>") // hkArray< class hkpRigidBody*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(CharacterInteractionDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/CharacterControl/CharacterProxy/CharacterPhantomInteraction/CharacterPhantomInteractionDemo.h>


// CharacterPhantomInteractionDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(CharacterPhantomInteractionDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(CharacterPhantomInteractionDemo)
    HK_TRACKER_MEMBER(CharacterPhantomInteractionDemo, m_characterProxy, 0, "hkpCharacterProxy*") // class hkpCharacterProxy*
    HK_TRACKER_MEMBER(CharacterPhantomInteractionDemo, m_characterContext, 0, "hkpCharacterContext*") // class hkpCharacterContext*
    HK_TRACKER_MEMBER(CharacterPhantomInteractionDemo, m_phantom, 0, "hkpShapePhantom*") // class hkpShapePhantom*
    HK_TRACKER_MEMBER(CharacterPhantomInteractionDemo, m_standShape, 0, "hkpShape*") // class hkpShape*
    HK_TRACKER_MEMBER(CharacterPhantomInteractionDemo, m_crouchShape, 0, "hkpShape*") // class hkpShape*
    HK_TRACKER_MEMBER(CharacterPhantomInteractionDemo, m_strings, 0, "hkArray<hkStringPtr, hkContainerHeapAllocator>") // hkArray< hkStringPtr, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(CharacterPhantomInteractionDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/CharacterControl/CharacterProxy/CharacterPriority/CharacterPriorityDemo.h>


// CharacterPriorityDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(CharacterPriorityDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(CharacterPriorityDemo)
    HK_TRACKER_MEMBER(CharacterPriorityDemo, m_characterProxy, 0, "hkpCharacterProxy*") // class hkpCharacterProxy*
    HK_TRACKER_MEMBER(CharacterPriorityDemo, m_characterContext, 0, "hkpCharacterContext*") // class hkpCharacterContext*
    HK_TRACKER_MEMBER(CharacterPriorityDemo, m_phantom, 0, "hkpShapePhantom*") // class hkpShapePhantom*
    HK_TRACKER_MEMBER(CharacterPriorityDemo, m_objects, 0, "hkpRigidBody* [3]") // class hkpRigidBody* [3]
    HK_TRACKER_MEMBER(CharacterPriorityDemo, m_listener, 0, "MyCharacterPriorityListener*") // class MyCharacterPriorityListener*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(CharacterPriorityDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/CharacterControl/CharacterProxy/LowFrequencyCharacters/LowFrequencyCharactersDemo.h>


// LowFrequencyCharactersDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(LowFrequencyCharactersDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(LowFrequencyCharactersDemo)
    HK_TRACKER_MEMBER(LowFrequencyCharactersDemo, m_characterProxy, 0, "hkpCharacterProxy* [101]") // class hkpCharacterProxy* [101]
    HK_TRACKER_MEMBER(LowFrequencyCharactersDemo, m_characterContext, 0, "hkpCharacterContext* [101]") // class hkpCharacterContext* [101]
    HK_TRACKER_MEMBER(LowFrequencyCharactersDemo, m_data, 0, "float*") // float*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(LowFrequencyCharactersDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/CharacterControl/CharacterProxy/MultipleCharacters/MultipleCharactersDemo.h>


// MultipleCharactersDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MultipleCharactersDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MultipleCharactersDemo)
    HK_TRACKER_MEMBER(MultipleCharactersDemo, m_characterProxy, 0, "hkArray<hkpCharacterProxy*, hkContainerHeapAllocator>") // hkArray< class hkpCharacterProxy*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(MultipleCharactersDemo, m_characterContext, 0, "hkArray<hkpCharacterContext*, hkContainerHeapAllocator>") // hkArray< class hkpCharacterContext*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(MultipleCharactersDemo, m_landscapeContainer, 0, "LandscapeContainer*") // class LandscapeContainer*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(MultipleCharactersDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/CharacterControl/CharacterProxy/MultipleCharacters/TerrainHeightFieldShape.h>


// TerrainHeightFieldShape ::

HK_TRACKER_DECLARE_CLASS_BEGIN(TerrainHeightFieldShape)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(TerrainHeightFieldShape)
    HK_TRACKER_MEMBER(TerrainHeightFieldShape, m_data, 0, "float*") // float*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(TerrainHeightFieldShape, s_libraryName, hkpSampledHeightFieldShape)

#include <Demos/Physics2012/UseCase/CharacterControl/CharacterProxy/StairClimbing/StairClimbingDemo.h>


// StairClimbingDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(StairClimbingDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Options)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(StairClimbingDemo)
    HK_TRACKER_MEMBER(StairClimbingDemo, m_phantom, 0, "hkpShapePhantom*") // class hkpShapePhantom*
    HK_TRACKER_MEMBER(StairClimbingDemo, m_characterProxy, 0, "hkpCharacterProxy*") // class hkpCharacterProxy*
    HK_TRACKER_MEMBER(StairClimbingDemo, m_characterProxyContext, 0, "hkpCharacterContext*") // class hkpCharacterContext*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(StairClimbingDemo, s_libraryName, hkDefaultPhysics2012Demo)


// Options StairClimbingDemo
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(StairClimbingDemo, Options, s_libraryName)

#include <Demos/Physics2012/UseCase/CharacterControl/CharacterProxyVsRigidBody/CharacterControlVs/CharacterControlVsDemo.h>


// CharacterControlVsDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(CharacterControlVsDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(CharacterControlVsDemo)
    HK_TRACKER_MEMBER(CharacterControlVsDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(CharacterControlVsDemo, m_standShape, 0, "hkpShape*") // class hkpShape*
    HK_TRACKER_MEMBER(CharacterControlVsDemo, m_crouchShape, 0, "hkpShape*") // class hkpShape*
    HK_TRACKER_MEMBER(CharacterControlVsDemo, m_newShape, 0, "hkpShape*") // class hkpShape*
    HK_TRACKER_MEMBER(CharacterControlVsDemo, m_phantom, 0, "hkpShapePhantom*") // class hkpShapePhantom*
    HK_TRACKER_MEMBER(CharacterControlVsDemo, m_characterProxy, 0, "hkpCharacterProxy*") // class hkpCharacterProxy*
    HK_TRACKER_MEMBER(CharacterControlVsDemo, m_characterProxyContext, 0, "hkpCharacterContext*") // class hkpCharacterContext*
    HK_TRACKER_MEMBER(CharacterControlVsDemo, m_listenerProxy, 0, "hkCharacterProxyForLadderListener*") // class hkCharacterProxyForLadderListener*
    HK_TRACKER_MEMBER(CharacterControlVsDemo, m_characterRigidBody, 0, "hkpCharacterRigidBody*") // class hkpCharacterRigidBody*
    HK_TRACKER_MEMBER(CharacterControlVsDemo, m_characterRigidBodyContext, 0, "hkpCharacterContext*") // class hkpCharacterContext*
    HK_TRACKER_MEMBER(CharacterControlVsDemo, m_listenerRigidBody, 0, "hkCharacterRbForLadderListener*") // class hkCharacterRbForLadderListener*
    HK_TRACKER_MEMBER(CharacterControlVsDemo, m_objectIds, 0, "hkArray<hkUlong, hkContainerHeapAllocator>") // hkArray< hkUlong, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(CharacterControlVsDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/CharacterControl/CharacterProxyVsRigidBody/Multithreaded/MultithreadedCharactersDemo.h>


// MultithreadedCharactersDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MultithreadedCharactersDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MultithreadedCharactersDemo)
    HK_TRACKER_MEMBER(MultithreadedCharactersDemo, m_characterProxies, 0, "hkArray<hkpCharacterProxy*, hkContainerHeapAllocator>") // hkArray< class hkpCharacterProxy*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(MultithreadedCharactersDemo, m_characterRigidBodies, 0, "hkArray<hkpCharacterRigidBody*, hkContainerHeapAllocator>") // hkArray< class hkpCharacterRigidBody*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(MultithreadedCharactersDemo, m_characterContexts, 0, "hkArray<hkpCharacterContext*, hkContainerHeapAllocator>") // hkArray< class hkpCharacterContext*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(MultithreadedCharactersDemo, m_characterProxyJobData, 0, "hkpCharacterProxyJobUtil::JobData*") // class hkpCharacterProxyJobUtil::JobData*
    HK_TRACKER_MEMBER(MultithreadedCharactersDemo, m_flatLand, 0, "FlatLand*") // class FlatLand*
    HK_TRACKER_MEMBER(MultithreadedCharactersDemo, m_treeManagerData, 0, "hkArray<hkUint8, hkContainerHeapAllocator>") // hkArray< hkUint8, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(MultithreadedCharactersDemo, m_collidables, 0, "hkArray<hkpCollidable*, hkContainerHeapAllocator>") // hkArray< const class hkpCollidable*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(MultithreadedCharactersDemo, m_groupFilter, 0, "hkpGroupFilter*") // class hkpGroupFilter*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(MultithreadedCharactersDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/CharacterControl/CharacterProxyVsRigidBody/UnevenTerrainVs/UnevenTerrainVsDemo.h>


// UnevenTerrainVsDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(UnevenTerrainVsDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Options)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(FilterInfo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(UnevenTerrainVsDemo)
    HK_TRACKER_MEMBER(UnevenTerrainVsDemo, m_characterRigidBody, 0, "hkpCharacterRigidBody*") // class hkpCharacterRigidBody*
    HK_TRACKER_MEMBER(UnevenTerrainVsDemo, m_characterContext, 0, "hkpCharacterContext*") // class hkpCharacterContext*
    HK_TRACKER_MEMBER(UnevenTerrainVsDemo, m_phantom, 0, "hkpShapePhantom*") // class hkpShapePhantom*
    HK_TRACKER_MEMBER(UnevenTerrainVsDemo, m_characterProxy, 0, "hkpCharacterProxy*") // class hkpCharacterProxy*
    HK_TRACKER_MEMBER(UnevenTerrainVsDemo, m_characterProxyContext, 0, "hkpCharacterContext*") // class hkpCharacterContext*
    HK_TRACKER_MEMBER(UnevenTerrainVsDemo, m_landscapeContainer, 0, "LandscapeContainer*") // class LandscapeContainer*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(UnevenTerrainVsDemo, s_libraryName, hkDefaultPhysics2012Demo)


// Options UnevenTerrainVsDemo
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(UnevenTerrainVsDemo, Options, s_libraryName)


// FilterInfo UnevenTerrainVsDemo
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(UnevenTerrainVsDemo, FilterInfo, s_libraryName)

#include <Demos/Physics2012/UseCase/CharacterControl/CharacterRigidBody/AsymetricCharacterRb/AsymetricCharacterRbDemo.h>


// AsymetricCharacterRbDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(AsymetricCharacterRbDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(AsymetricCharacterRbDemo)
    HK_TRACKER_MEMBER(AsymetricCharacterRbDemo, m_characterRigidBody, 0, "hkpCharacterRigidBody*") // class hkpCharacterRigidBody*
    HK_TRACKER_MEMBER(AsymetricCharacterRbDemo, m_characterContext, 0, "hkpCharacterContext*") // class hkpCharacterContext*
    HK_TRACKER_MEMBER(AsymetricCharacterRbDemo, m_data, 0, "float*") // float*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(AsymetricCharacterRbDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/CharacterControl/CharacterRigidBody/CharacterRbAndCollisionArtifacts/CharacterRbAndCollisionArtifactsDemo.h>


// CharacterRbAndCollisionArtifactsDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(CharacterRbAndCollisionArtifactsDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(CharacterRbAndCollisionArtifactsDemo)
    HK_TRACKER_MEMBER(CharacterRbAndCollisionArtifactsDemo, m_standShape, 0, "hkpShape*") // class hkpShape*
    HK_TRACKER_MEMBER(CharacterRbAndCollisionArtifactsDemo, m_characterRigidBody, 0, "hkpCharacterRigidBody*") // class hkpCharacterRigidBody*
    HK_TRACKER_MEMBER(CharacterRbAndCollisionArtifactsDemo, m_characterContext, 0, "hkpCharacterContext*") // class hkpCharacterContext*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(CharacterRbAndCollisionArtifactsDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/CharacterControl/CharacterRigidBody/ControlCharacterRb/ControlCharacterRbDemo.h>


// ControlCharacterRbDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ControlCharacterRbDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ControlCharacterRbDemo)
    HK_TRACKER_MEMBER(ControlCharacterRbDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(ControlCharacterRbDemo, m_standShape, 0, "hkpShape*") // class hkpShape*
    HK_TRACKER_MEMBER(ControlCharacterRbDemo, m_crouchShape, 0, "hkpShape*") // class hkpShape*
    HK_TRACKER_MEMBER(ControlCharacterRbDemo, m_newShape, 0, "hkpShape*") // class hkpShape*
    HK_TRACKER_MEMBER(ControlCharacterRbDemo, m_characterRigidBody, 0, "hkpCharacterRigidBody*") // class hkpCharacterRigidBody*
    HK_TRACKER_MEMBER(ControlCharacterRbDemo, m_characterContext, 0, "hkpCharacterContext*") // class hkpCharacterContext*
    HK_TRACKER_MEMBER(ControlCharacterRbDemo, m_objectIds, 0, "hkArray<hkUlong, hkContainerHeapAllocator>") // hkArray< hkUlong, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(ControlCharacterRbDemo, m_previousGround, 0, "hkpSurfaceInfo*") // struct hkpSurfaceInfo*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ControlCharacterRbDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/CharacterControl/CharacterRigidBody/InteractionCharacterRb/InteractionCharacterRbDemo.h>


// InteractionCharacterRbDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(InteractionCharacterRbDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(InteractionCharacterRbDemo)
    HK_TRACKER_MEMBER(InteractionCharacterRbDemo, m_characterRigidBody, 0, "hkpCharacterRigidBody*") // class hkpCharacterRigidBody*
    HK_TRACKER_MEMBER(InteractionCharacterRbDemo, m_characterContext, 0, "hkpCharacterContext*") // class hkpCharacterContext*
    HK_TRACKER_MEMBER(InteractionCharacterRbDemo, m_objectIds, 0, "hkArray<hkUlong, hkContainerHeapAllocator>") // hkArray< hkUlong, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(InteractionCharacterRbDemo, m_rigidBodies, 0, "hkArray<hkpRigidBody*, hkContainerHeapAllocator>") // hkArray< class hkpRigidBody*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(InteractionCharacterRbDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/CharacterControl/CharacterRigidBody/MovingSupportRb/MovingSupportRbDemo.h>


// MovingSupportRbDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MovingSupportRbDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MovingSupportRbDemo)
    HK_TRACKER_MEMBER(MovingSupportRbDemo, m_horPlatform, 0, "hkpRigidBody*") // class hkpRigidBody*
    HK_TRACKER_MEMBER(MovingSupportRbDemo, m_verPlatform, 0, "hkpRigidBody*") // class hkpRigidBody*
    HK_TRACKER_MEMBER(MovingSupportRbDemo, m_standShape, 0, "hkpShape*") // class hkpShape*
    HK_TRACKER_MEMBER(MovingSupportRbDemo, m_characterRigidBody, 0, "hkpCharacterRigidBody*") // class hkpCharacterRigidBody*
    HK_TRACKER_MEMBER(MovingSupportRbDemo, m_characterContext, 0, "hkpCharacterContext*") // class hkpCharacterContext*
    HK_TRACKER_MEMBER(MovingSupportRbDemo, m_bodies, 0, "hkArray<hkpRigidBody*, hkContainerHeapAllocator>") // hkArray< class hkpRigidBody*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(MovingSupportRbDemo, m_bodyType, 0, "hkPointerMap<hkpRigidBody*, hkUint32, hkContainerHeapAllocator>") // class hkPointerMap< class hkpRigidBody*, hkUint32, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(MovingSupportRbDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/CharacterControl/CharacterRigidBody/MultipleCharacterRbs/MultipleCharacterRbsDemo.h>


// MultipleCharacterRbsDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MultipleCharacterRbsDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MultipleCharacterRbsDemo)
    HK_TRACKER_MEMBER(MultipleCharacterRbsDemo, m_characterRigidBodies, 0, "hkArray<hkpCharacterRigidBody*, hkContainerHeapAllocator>") // hkArray< class hkpCharacterRigidBody*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(MultipleCharacterRbsDemo, m_characterContexts, 0, "hkArray<hkpCharacterContext*, hkContainerHeapAllocator>") // hkArray< class hkpCharacterContext*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(MultipleCharacterRbsDemo, m_landscapeContainer, 0, "LandscapeContainer*") // class LandscapeContainer*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(MultipleCharacterRbsDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/CharacterControl/CharacterRigidBody/PushedCharacterRbs/PushedCharacterRbsDemo.h>


// PushedCharacterRbsDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(PushedCharacterRbsDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(PushedCharacterRbsDemo)
    HK_TRACKER_MEMBER(PushedCharacterRbsDemo, m_characterRigidBody, 0, "hkpCharacterRigidBody*") // class hkpCharacterRigidBody*
    HK_TRACKER_MEMBER(PushedCharacterRbsDemo, m_characterContext, 0, "hkpCharacterContext*") // class hkpCharacterContext*
    HK_TRACKER_MEMBER(PushedCharacterRbsDemo, m_characterRigidBodies, 0, "hkArray<hkpCharacterRigidBody*, hkContainerHeapAllocator>") // hkArray< class hkpCharacterRigidBody*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(PushedCharacterRbsDemo, m_characterContexts, 0, "hkArray<hkpCharacterContext*, hkContainerHeapAllocator>") // hkArray< class hkpCharacterContext*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(PushedCharacterRbsDemo, m_desiredPositions, 0, "hkArray<hkVector4f, hkContainerHeapAllocator>") // hkArray< hkVector4f, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(PushedCharacterRbsDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/CharacterControl/CharacterRigidBody/StairClimbingRb/StairClimbingRbDemo.h>


// StairClimbingRbDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(StairClimbingRbDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Options)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(StairClimbingRbDemo)
    HK_TRACKER_MEMBER(StairClimbingRbDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(StairClimbingRbDemo, m_standShape, 0, "hkpShape*") // class hkpShape*
    HK_TRACKER_MEMBER(StairClimbingRbDemo, m_newShape, 0, "hkpShape*") // class hkpShape*
    HK_TRACKER_MEMBER(StairClimbingRbDemo, m_characterRigidBody, 0, "hkpCharacterRigidBody*") // class hkpCharacterRigidBody*
    HK_TRACKER_MEMBER(StairClimbingRbDemo, m_characterContext, 0, "hkpCharacterContext*") // class hkpCharacterContext*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(StairClimbingRbDemo, s_libraryName, hkDefaultPhysics2012Demo)


// Options StairClimbingRbDemo
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(StairClimbingRbDemo, Options, s_libraryName)

#include <Demos/Physics2012/UseCase/CharacterControl/CharacterRigidBody/TriggersAndPhantomsCharacterRb/TriggersAndPhantomsCharacterRbDemo.h>


// TriggersAndPhantomsCharacterRbDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(TriggersAndPhantomsCharacterRbDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(TriggersAndPhantomsCharacterRbDemo)
    HK_TRACKER_MEMBER(TriggersAndPhantomsCharacterRbDemo, m_standShape, 0, "hkpShape*") // class hkpShape*
    HK_TRACKER_MEMBER(TriggersAndPhantomsCharacterRbDemo, m_characterRigidBody, 0, "hkpCharacterRigidBody*") // class hkpCharacterRigidBody*
    HK_TRACKER_MEMBER(TriggersAndPhantomsCharacterRbDemo, m_characterContext, 0, "hkpCharacterContext*") // class hkpCharacterContext*
    HK_TRACKER_MEMBER(TriggersAndPhantomsCharacterRbDemo, m_phantoms, 0, "hkArray<hkpSimpleShapePhantom*, hkContainerHeapAllocator>") // hkArray< class hkpSimpleShapePhantom*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(TriggersAndPhantomsCharacterRbDemo, m_phantomListeners, 0, "hkArray<MyPhantomForCharacterRbListener*, hkContainerHeapAllocator>") // hkArray< class MyPhantomForCharacterRbListener*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(TriggersAndPhantomsCharacterRbDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/CompoundBodies/CompoundBodiesDemo.h>


// CompoundBodiesDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(CompoundBodiesDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(CompoundBodiesDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(CompoundBodiesDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/ContinuousPhysics/Basics/ContinuousBasicsDemo.h>


// ContinuousBasicsDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ContinuousBasicsDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Segment)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ContinuousBasicsDemo)
    HK_TRACKER_MEMBER(ContinuousBasicsDemo, m_bodyA, 0, "hkpRigidBody*") // class hkpRigidBody*
    HK_TRACKER_MEMBER(ContinuousBasicsDemo, m_bodyB, 0, "hkpRigidBody*") // class hkpRigidBody*
    HK_TRACKER_MEMBER(ContinuousBasicsDemo, m_displayVectors, 0, "hkArray<ContinuousBasicsDemo::Segment, hkContainerHeapAllocator>") // hkArray< struct ContinuousBasicsDemo::Segment, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ContinuousBasicsDemo, s_libraryName, hkDefaultPhysics2012Demo)


// Segment ContinuousBasicsDemo
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(ContinuousBasicsDemo, Segment, s_libraryName)

#include <Demos/Physics2012/UseCase/ContinuousPhysics/BrickWall/BrickWallDemo.h>


// BrickWallDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(BrickWallDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(BrickWallDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(BrickWallDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/ContinuousPhysics/CrashTestDummies/CrashTestDummiesDemo.h>


// CrashTestDummiesDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(CrashTestDummiesDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(CrashTestDummiesDemo)
    HK_TRACKER_MEMBER(CrashTestDummiesDemo, m_ragdoll, 0, "hkpPhysicsSystem*") // class hkpPhysicsSystem*
    HK_TRACKER_MEMBER(CrashTestDummiesDemo, m_filter, 0, "hkpGroupFilter*") // class hkpGroupFilter*
    HK_TRACKER_MEMBER(CrashTestDummiesDemo, m_car, 0, "hkpRigidBody*") // class hkpRigidBody*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(CrashTestDummiesDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/ContinuousPhysics/DiscreteVsContinuous/DiscreteVsContinuousDemo.h>


// DiscreteVsContinuousDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(DiscreteVsContinuousDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(DiscreteVsContinuousDemo)
    HK_TRACKER_MEMBER(DiscreteVsContinuousDemo, m_world2, 0, "hkpWorld*") // class hkpWorld*
    HK_TRACKER_MEMBER(DiscreteVsContinuousDemo, m_rigidBodies, 0, "hkArray<hkpRigidBody*, hkContainerHeapAllocator>") // hkArray< class hkpRigidBody*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(DiscreteVsContinuousDemo, m_rigidBodies2, 0, "hkArray<hkpRigidBody*, hkContainerHeapAllocator>") // hkArray< class hkpRigidBody*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(DiscreteVsContinuousDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/ContinuousPhysics/KnownIssues/Centrifuge/CentrifugeDemo.h>


// CentrifugeDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(CentrifugeDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(CentrifugeDemo)
    HK_TRACKER_MEMBER(CentrifugeDemo, m_centrifuge, 0, "hkpRigidBody*") // class hkpRigidBody*
    HK_TRACKER_MEMBER(CentrifugeDemo, m_sphere, 0, "hkpRigidBody*") // class hkpRigidBody*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(CentrifugeDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/ContinuousPhysics/PrioritiesAndQualities/HighSpeedCollision/HighSpeedCollisionDemo.h>


// HighSpeedCollisionDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(HighSpeedCollisionDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(HighSpeedCollisionDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(HighSpeedCollisionDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/ContinuousPhysics/PrioritiesAndQualities/HingeHittingTable/HingeHittingTableDemo.h>


// HingeHittingTableDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(HingeHittingTableDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(HingeHittingTableDemo)
    HK_TRACKER_MEMBER(HingeHittingTableDemo, m_heavyLoad, 0, "hkpRigidBody*") // class hkpRigidBody*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(HingeHittingTableDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/ContinuousPhysics/PrioritiesAndQualities/SqueezedBall/SqueezedBallDemo.h>


// SqueezedBallDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SqueezedBallDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SqueezedBallDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SqueezedBallDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/ContinuousPhysics/PrioritiesAndQualities/ThreeWaySqueeze/ThreeWaySqueezeDemo.h>


// ThreeWaySqueezeDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ThreeWaySqueezeDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ThreeWaySqueezeDemo)
    HK_TRACKER_MEMBER(ThreeWaySqueezeDemo, m_objects, 0, "hkpRigidBody* [3]") // class hkpRigidBody* [3]
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ThreeWaySqueezeDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/ContinuousPhysics/RagdollVsMopp/RagdollVsMoppDemo.h>


// ragdollVsMoppDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ragdollVsMoppDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Parameter)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ragdollVsMoppDemo)
    HK_TRACKER_MEMBER(ragdollVsMoppDemo, m_ragdoll, 0, "hkpPhysicsSystem*") // class hkpPhysicsSystem*
    HK_TRACKER_MEMBER(ragdollVsMoppDemo, m_filter, 0, "hkpGroupFilter*") // class hkpGroupFilter*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ragdollVsMoppDemo, s_libraryName, hkDefaultPhysics2012Demo)


// Parameter ragdollVsMoppDemo

HK_TRACKER_DECLARE_CLASS_BEGIN(ragdollVsMoppDemo::Parameter)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ragdollVsMoppDemo::Parameter)
    HK_TRACKER_MEMBER(ragdollVsMoppDemo::Parameter, m_name, 0, "char*") // const char*
    HK_TRACKER_MEMBER(ragdollVsMoppDemo::Parameter, m_details, 0, "char*") // const char*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(ragdollVsMoppDemo::Parameter, s_libraryName)

#include <Demos/Physics2012/UseCase/ContinuousPhysics/ReintegrateBodies/ReintegrateBodiesDemo.h>


// ReintegrateBodiesDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ReintegrateBodiesDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ReintegrateBodiesDemo)
    HK_TRACKER_MEMBER(ReintegrateBodiesDemo, m_bodies, 0, "hkArray<hkpRigidBody*, hkContainerHeapAllocator>") // hkArray< class hkpRigidBody*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ReintegrateBodiesDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/ContinuousPhysics/ToiCollisionsForKeyframedBodies/ToiCollisionsForKeyframedBodiesDemo.h>


// ToiCollisionsForKeyframedBodies ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ToiCollisionsForKeyframedBodies)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ToiCollisionsForKeyframedBodies)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ToiCollisionsForKeyframedBodies, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/Creatures/CreaturesDemo.h>


// CreaturesDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(CreaturesDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Leg)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(LeggedCreatureLayout)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(LeggedCreatureData)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(LeglessCreatureData)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(calcLegMatrizesIn)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(CreatureType)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(CreaturesDemo)
    HK_TRACKER_MEMBER(CreaturesDemo, m_leggedCreatureData, 0, "hkArray<CreaturesDemo::LeggedCreatureData, hkContainerHeapAllocator>") // hkArray< struct CreaturesDemo::LeggedCreatureData, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(CreaturesDemo, m_snakeData, 0, "hkArray<CreaturesDemo::LeglessCreatureData, hkContainerHeapAllocator>") // hkArray< struct CreaturesDemo::LeglessCreatureData, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(CreaturesDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(CreaturesDemo, m_snakeBox, 0, "hkpShape*") // class hkpShape*
    HK_TRACKER_MEMBER(CreaturesDemo, m_snakeSphere, 0, "hkpShape*") // class hkpShape*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(CreaturesDemo, s_libraryName, hkDefaultPhysics2012Demo)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(CreaturesDemo, CreatureType, s_libraryName)


// Leg CreaturesDemo

HK_TRACKER_DECLARE_CLASS_BEGIN(CreaturesDemo::Leg)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(CreaturesDemo::Leg)
    HK_TRACKER_MEMBER(CreaturesDemo::Leg, m_constraint, 0, "hkpConstraintChainInstance*") // class hkpConstraintChainInstance*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(CreaturesDemo::Leg, s_libraryName)


// LeggedCreatureLayout CreaturesDemo
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(CreaturesDemo, LeggedCreatureLayout, s_libraryName)


// LeggedCreatureData CreaturesDemo

HK_TRACKER_DECLARE_CLASS_BEGIN(CreaturesDemo::LeggedCreatureData)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(CreaturesDemo::LeggedCreatureData)
    HK_TRACKER_MEMBER(CreaturesDemo::LeggedCreatureData, m_legs, 0, "hkArray<CreaturesDemo::Leg, hkContainerHeapAllocator>") // hkArray< struct CreaturesDemo::Leg, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(CreaturesDemo::LeggedCreatureData, m_center, 0, "hkpRigidBody*") // class hkpRigidBody*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(CreaturesDemo::LeggedCreatureData, s_libraryName)


// LeglessCreatureData CreaturesDemo

HK_TRACKER_DECLARE_CLASS_BEGIN(CreaturesDemo::LeglessCreatureData)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(CreaturesDemo::LeglessCreatureData)
    HK_TRACKER_MEMBER(CreaturesDemo::LeglessCreatureData, m_muscles, 0, "hkArray<hkpLimitedHingeConstraintData*, hkContainerHeapAllocator>") // hkArray< class hkpLimitedHingeConstraintData*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(CreaturesDemo::LeglessCreatureData, m_wheels, 0, "hkArray<hkpHingeConstraintData*, hkContainerHeapAllocator>") // hkArray< class hkpHingeConstraintData*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(CreaturesDemo::LeglessCreatureData, s_libraryName)


// calcLegMatrizesIn CreaturesDemo
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(CreaturesDemo, calcLegMatrizesIn, s_libraryName)

#include <Demos/Physics2012/UseCase/CustomCollectors/BackfacesCulledRayHitCollector/BackfacesCulledRayHitCollector.h>


// BackfacesCulledRayHitCollector ::

HK_TRACKER_DECLARE_CLASS_BEGIN(BackfacesCulledRayHitCollector)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(BackfacesCulledRayHitCollector)
    HK_TRACKER_MEMBER(BackfacesCulledRayHitCollector, m_hits, 0, "hkInplaceArray<hkpWorldRayCastOutput, 8, hkContainerHeapAllocator>") // class hkInplaceArray< struct hkpWorldRayCastOutput, 8, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(BackfacesCulledRayHitCollector, s_libraryName, hkpRayHitCollector)

#include <Demos/Physics2012/UseCase/CustomCollectors/FirstRayHitCollector/FirstRayHitCollector.h>


// hkpFirstRayHitCollector ::

HK_TRACKER_DECLARE_CLASS_BEGIN(hkpFirstRayHitCollector)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(hkpFirstRayHitCollector)
    HK_TRACKER_MEMBER(hkpFirstRayHitCollector, m_rayHit, 0, "hkpWorldRayCastOutput") // struct hkpWorldRayCastOutput
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(hkpFirstRayHitCollector, s_libraryName, hkpRayHitCollector)

#include <Demos/Physics2012/UseCase/Destruction/BreakOff/BreakOffExtendedMeshDemo.h>


// BreakOffExtendedMeshDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(BreakOffExtendedMeshDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(BreakOffExtendedMeshDemo)
    HK_TRACKER_MEMBER(BreakOffExtendedMeshDemo, m_breakUtil, 0, "hkpBreakOffPartsUtil*") // class hkpBreakOffPartsUtil*
    HK_TRACKER_MEMBER(BreakOffExtendedMeshDemo, m_loader, 0, "hkLoader*") // class hkLoader*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(BreakOffExtendedMeshDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/Destruction/DestructibleBridge/DestructibleBridgeDemo.h>


// DestructibleBridgeDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(DestructibleBridgeDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(DestructibleBridgeDemo)
    HK_TRACKER_MEMBER(DestructibleBridgeDemo, m_breakUtil, 0, "hkpBreakOffPartsUtil*") // class hkpBreakOffPartsUtil*
    HK_TRACKER_MEMBER(DestructibleBridgeDemo, m_terrainData, 0, "hkReferencedObject*") // class hkReferencedObject*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(DestructibleBridgeDemo, s_libraryName, hkDefaultPhysics2012Demo)

// None DestructibleBridgeDemoType
HK_TRACKER_IMPLEMENT_SIMPLE(DestructibleBridgeDemoType, s_libraryName)
#include <Demos/Physics2012/UseCase/Destruction/DestructibleBridge/DestructibleBridgeUtil.h>


// DestructibleBridgeUtil ::

HK_TRACKER_DECLARE_CLASS_BEGIN(DestructibleBridgeUtil)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(TerrainData)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(AirplaneData)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_IMPLEMENT_SIMPLE(DestructibleBridgeUtil, s_libraryName)


// TerrainData DestructibleBridgeUtil
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(DestructibleBridgeUtil, TerrainData, s_libraryName)


// AirplaneData DestructibleBridgeUtil
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(DestructibleBridgeUtil, AirplaneData, s_libraryName)

#include <Demos/Physics2012/UseCase/Destruction/DestructibleBridge/DestructibleMoppUtility.h>


// DestructibleMoppUtility ::

HK_TRACKER_DECLARE_CLASS_BEGIN(DestructibleMoppUtility)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(ConvexShapeData)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(ShapeData)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_IMPLEMENT_SIMPLE(DestructibleMoppUtility, s_libraryName)


// ConvexShapeData DestructibleMoppUtility

HK_TRACKER_DECLARE_CLASS_BEGIN(DestructibleMoppUtility::ConvexShapeData)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(DestructibleMoppUtility::ConvexShapeData)
    HK_TRACKER_MEMBER(DestructibleMoppUtility::ConvexShapeData, m_shape, 0, "hkpConvexShape*") // const class hkpConvexShape*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(DestructibleMoppUtility::ConvexShapeData, s_libraryName)


// ShapeData DestructibleMoppUtility

HK_TRACKER_DECLARE_CLASS_BEGIN(DestructibleMoppUtility::ShapeData)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(DestructibleMoppUtility::ShapeData)
    HK_TRACKER_MEMBER(DestructibleMoppUtility::ShapeData, m_shape, 0, "hkpShape*") // class hkpShape*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(DestructibleMoppUtility::ShapeData, s_libraryName)

#include <Demos/Physics2012/UseCase/Doors/DoorsDemo.h>


// DoorSpring ::

HK_TRACKER_DECLARE_CLASS_BEGIN(DoorSpring)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(DoorSpring)
    HK_TRACKER_MEMBER(DoorSpring, m_hinge, 0, "hkpConstraintInstance*") // const class hkpConstraintInstance*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(DoorSpring, s_libraryName, hkpUnaryAction)


// PlayerWalkAction ::

HK_TRACKER_DECLARE_CLASS_BEGIN(PlayerWalkAction)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(PlayerWalkAction)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(PlayerWalkAction, s_libraryName, hkpUnaryAction)


// DoorsDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(DoorsDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(DoorsDemo)
    HK_TRACKER_MEMBER(DoorsDemo, m_data, 0, "hkResource*") // class hkResource*
    HK_TRACKER_MEMBER(DoorsDemo, m_doorTrigger, 0, "hkpAabbPhantom*") // class hkpAabbPhantom*
    HK_TRACKER_MEMBER(DoorsDemo, m_poweredHingeDatas, 0, "hkArray<hkpLimitedHingeConstraintData*, hkContainerHeapAllocator>") // hkArray< class hkpLimitedHingeConstraintData*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(DoorsDemo, m_poweredHingeInstances, 0, "hkArray<hkpConstraintInstance*, hkContainerHeapAllocator>") // hkArray< class hkpConstraintInstance*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(DoorsDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/Fountain/FountainDemo.h>


// FountainDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(FountainDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(FountainDemo)
    HK_TRACKER_MEMBER(FountainDemo, m_phantom, 0, "hkpAabbPhantom*") // class hkpAabbPhantom*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(FountainDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/Fracture/SimpleFracturePatterns/SimpleFracturePatternsDemo.h>


// SimpleFracturePatternsDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SimpleFracturePatternsDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SimpleFracturePatternsDemo)
    HK_TRACKER_MEMBER(SimpleFracturePatternsDemo, m_collisionListener, 0, "FractureCollisionListener*") // class FractureCollisionListener*
    HK_TRACKER_MEMBER(SimpleFracturePatternsDemo, m_fracturedBodies, 0, "hkArray<hkpRigidBody*, hkContainerHeapAllocator>") // hkArray< class hkpRigidBody*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(SimpleFracturePatternsDemo, m_entitiesWaitingForCollisionListeners, 0, "EntityTimeQueue") // class EntityTimeQueue
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SimpleFracturePatternsDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/ImportedMeshMaterial/ImportedMeshMaterialDemo.h>


// ImportedMeshMaterialDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ImportedMeshMaterialDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Options)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ImportedMeshMaterialDemo)
    HK_TRACKER_MEMBER(ImportedMeshMaterialDemo, m_loader, 0, "hkLoader*") // class hkLoader*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ImportedMeshMaterialDemo, s_libraryName, hkDefaultPhysics2012Demo)


// Options ImportedMeshMaterialDemo
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(ImportedMeshMaterialDemo, Options, s_libraryName)

#include <Demos/Physics2012/UseCase/Machine/ArmConveyor/ArmConveyorDemo.h>


// ArmConveyorDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ArmConveyorDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ArmConveyorDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ArmConveyorDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/Machine/ConveyorBelts/ConveyorBeltsDemo.h>


// ConveyorBeltsDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ConveyorBeltsDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Options)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(ConveyorBeltBlueprint)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ConveyorBeltsDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ConveyorBeltsDemo, s_libraryName, hkDefaultPhysics2012Demo)


// Options ConveyorBeltsDemo
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(ConveyorBeltsDemo, Options, s_libraryName)


// ConveyorBeltBlueprint ConveyorBeltsDemo
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(ConveyorBeltsDemo, ConveyorBeltBlueprint, s_libraryName)

#include <Demos/Physics2012/UseCase/Machine/Pinion/PinionDemo.h>


// PinionDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(PinionDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(PinionDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(PinionDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/Machine/Pinion/PinionMotorAction.h>


// PinionMotorAction ::

HK_TRACKER_DECLARE_CLASS_BEGIN(PinionMotorAction)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(PinionMotorAction)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(PinionMotorAction, s_libraryName, hkpUnaryAction)

#include <Demos/Physics2012/UseCase/PhantomEyes/PhantomEyesDemo.h>


// PhantomEyesDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(PhantomEyesDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(PhantomEyesDemo)
    HK_TRACKER_MEMBER(PhantomEyesDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(PhantomEyesDemo, m_robotRB, 0, "hkpRigidBody*") // class hkpRigidBody*
    HK_TRACKER_MEMBER(PhantomEyesDemo, m_robotDisplayObject, 0, "hkgDisplayObject*") // class hkgDisplayObject*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(PhantomEyesDemo, s_libraryName, hkDefaultPhysics2012Demo)


// MyPhantomCallbackShape ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MyPhantomCallbackShape)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MyPhantomCallbackShape)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(MyPhantomCallbackShape, s_libraryName, hkpPhantomCallbackShape)


// MyPhantomAction ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MyPhantomAction)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MyPhantomAction)
    HK_TRACKER_MEMBER(MyPhantomAction, m_leftEye, 0, "MyPhantomCallbackShape*") // class MyPhantomCallbackShape*
    HK_TRACKER_MEMBER(MyPhantomAction, m_rightEye, 0, "MyPhantomCallbackShape*") // class MyPhantomCallbackShape*
    HK_TRACKER_MEMBER(MyPhantomAction, m_frontEye, 0, "MyPhantomCallbackShape*") // class MyPhantomCallbackShape*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(MyPhantomAction, s_libraryName, hkpUnaryAction)

#include <Demos/Physics2012/UseCase/PlanetGravity/LaunchPadListener.h>


// LaunchPadListener ::

HK_TRACKER_DECLARE_CLASS_BEGIN(LaunchPadListener)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(LaunchPadListener)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(LaunchPadListener, s_libraryName, hkReferencedObject)

#include <Demos/Physics2012/UseCase/PlanetGravity/PhantomTrackAction.h>


// PhantomTrackAction ::

HK_TRACKER_DECLARE_CLASS_BEGIN(PhantomTrackAction)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(PhantomTrackAction)
    HK_TRACKER_MEMBER(PhantomTrackAction, m_phantom, 0, "hkpAabbPhantom*") // class hkpAabbPhantom*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(PhantomTrackAction, s_libraryName, hkpUnaryAction)

#include <Demos/Physics2012/UseCase/PlanetGravity/PlanetGravityAction.h>


// PlanetGravityAction ::

HK_TRACKER_DECLARE_CLASS_BEGIN(PlanetGravityAction)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(PlanetGravityAction)
    HK_TRACKER_MEMBER(PlanetGravityAction, m_planetBody, 0, "hkpRigidBody*") // class hkpRigidBody*
    HK_TRACKER_MEMBER(PlanetGravityAction, m_hullCollidable, 0, "hkpCollidable*") // const class hkpCollidable*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(PlanetGravityAction, s_libraryName, hkpUnaryAction)

#include <Demos/Physics2012/UseCase/PlanetGravity/PlanetGravityDemo.h>


// PlanetGravityDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(PlanetGravityDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Turret)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(PlanetGravityDemo)
    HK_TRACKER_MEMBER(PlanetGravityDemo, m_loadedData, 0, "hkResource*") // class hkResource*
    HK_TRACKER_MEMBER(PlanetGravityDemo, m_physicsData, 0, "hkpPhysicsData*") // class hkpPhysicsData*
    HK_TRACKER_MEMBER(PlanetGravityDemo, m_standShape, 0, "hkpShape*") // class hkpShape*
    HK_TRACKER_MEMBER(PlanetGravityDemo, m_crouchShape, 0, "hkpShape*") // class hkpShape*
    HK_TRACKER_MEMBER(PlanetGravityDemo, m_characterContext, 0, "hkpCharacterContext*") // class hkpCharacterContext*
    HK_TRACKER_MEMBER(PlanetGravityDemo, m_turrets, 0, "hkArray<PlanetGravityDemo::Turret, hkContainerHeapAllocator>") // hkArray< struct PlanetGravityDemo::Turret, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(PlanetGravityDemo, m_flashLight, 0, "hkgLight*") // class hkgLight*
    HK_TRACKER_MEMBER(PlanetGravityDemo, m_listeners, 0, "hkArray<hkpContactListener*, hkContainerHeapAllocator>") // hkArray< class hkpContactListener*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(PlanetGravityDemo, s_libraryName, hkDefaultPhysics2012Demo)


// Turret PlanetGravityDemo

HK_TRACKER_DECLARE_CLASS_BEGIN(PlanetGravityDemo::Turret)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(PlanetGravityDemo::Turret)
    HK_TRACKER_MEMBER(PlanetGravityDemo::Turret, constraint, 0, "hkpConstraintInstance*") // class hkpConstraintInstance*
    HK_TRACKER_MEMBER(PlanetGravityDemo::Turret, hinge, 0, "hkpLimitedHingeConstraintData*") // class hkpLimitedHingeConstraintData*
    HK_TRACKER_MEMBER(PlanetGravityDemo::Turret, turretRigidBody, 0, "hkpRigidBody*") // class hkpRigidBody*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(PlanetGravityDemo::Turret, s_libraryName)

#include <Demos/Physics2012/UseCase/PlanetGravity/SimpleGravityPhantom.h>


// SimpleGravityPhantom ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SimpleGravityPhantom)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SimpleGravityPhantom)
    HK_TRACKER_MEMBER(SimpleGravityPhantom, m_body, 0, "hkpRigidBody*") // class hkpRigidBody*
    HK_TRACKER_MEMBER(SimpleGravityPhantom, m_hullCollidable, 0, "hkpCollidable*") // const class hkpCollidable*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SimpleGravityPhantom, s_libraryName, hkpAabbPhantom)

#include <Demos/Physics2012/UseCase/PlanetGravity/TeleporterPhantomCallbackShape.h>


// TeleporterPhantomCallbackShape ::

HK_TRACKER_DECLARE_CLASS_BEGIN(TeleporterPhantomCallbackShape)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(TeleporterPhantomCallbackShape)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(TeleporterPhantomCallbackShape, s_libraryName, hkpPhantomCallbackShape)

#include <Demos/Physics2012/UseCase/RagdollOnStairs/RagdollOnStairsDemo.h>


// RagdollOnStairsDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(RagdollOnStairsDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(RagdollOnStairsDemo)
    HK_TRACKER_MEMBER(RagdollOnStairsDemo, m_ragdolls, 0, "hkArray<hkpPhysicsSystem*, hkContainerHeapAllocator>") // hkArray< class hkpPhysicsSystem*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(RagdollOnStairsDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/RopeBridge/RopeBridgeDemo.h>


// RopeBridgeDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(RopeBridgeDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(RopeBridgeDemo)
    HK_TRACKER_MEMBER(RopeBridgeDemo, m_marbleaction, 0, "MarbleAction*") // class MarbleAction*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(RopeBridgeDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/Snake/SnakeDemo.h>


// SnakeDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SnakeDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Options)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SnakeDemo)
    HK_TRACKER_MEMBER(SnakeDemo, m_muscles, 0, "hkArray<hkpLimitedHingeConstraintData*, hkContainerHeapAllocator>") // hkArray< class hkpLimitedHingeConstraintData*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(SnakeDemo, m_wheels, 0, "hkArray<hkpHingeConstraintData*, hkContainerHeapAllocator>") // hkArray< class hkpHingeConstraintData*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SnakeDemo, s_libraryName, hkDefaultPhysics2012Demo)


// Options SnakeDemo
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(SnakeDemo, Options, s_libraryName)

#include <Demos/Physics2012/UseCase/TriggerVolume/KeyframedTriggerVolume/KeyframedTriggerVolumeDemo.h>


// KeyframedTriggerVolumeDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(KeyframedTriggerVolumeDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(KeyframedTriggerVolumeDemo)
    HK_TRACKER_MEMBER(KeyframedTriggerVolumeDemo, m_triggerBody, 0, "hkpRigidBody* [2]") // class hkpRigidBody* [2]
    HK_TRACKER_MEMBER(KeyframedTriggerVolumeDemo, m_body, 0, "hkpRigidBody* [3]") // class hkpRigidBody* [3]
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(KeyframedTriggerVolumeDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/TriggerVolume/TriggerVolumeComparison/TriggerVolumeComparisonDemo.h>


// TriggerVolumeComparisonDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(TriggerVolumeComparisonDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(DemoTriggerVolume)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(DemoPhantomCallbackShape)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(DemoShapePhantom)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(DemoAabbPhantom)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(PingpongAction)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(DemoVariant)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(HitType)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(CollisionPhase)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(EntityType)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(TriggerVolumeComparisonDemo)
    HK_TRACKER_MEMBER(TriggerVolumeComparisonDemo, m_fixedTriggerVolume, 0, "TriggerVolumeComparisonDemo::DemoTriggerVolume*") // class TriggerVolumeComparisonDemo::DemoTriggerVolume*
    HK_TRACKER_MEMBER(TriggerVolumeComparisonDemo, m_fixedPhantomCallbackShape, 0, "TriggerVolumeComparisonDemo::DemoPhantomCallbackShape*") // class TriggerVolumeComparisonDemo::DemoPhantomCallbackShape*
    HK_TRACKER_MEMBER(TriggerVolumeComparisonDemo, m_fixedShapePhantom, 0, "TriggerVolumeComparisonDemo::DemoShapePhantom*") // class TriggerVolumeComparisonDemo::DemoShapePhantom*
    HK_TRACKER_MEMBER(TriggerVolumeComparisonDemo, m_fixedAabbPhantom, 0, "TriggerVolumeComparisonDemo::DemoAabbPhantom*") // class TriggerVolumeComparisonDemo::DemoAabbPhantom*
    HK_TRACKER_MEMBER(TriggerVolumeComparisonDemo, m_shapePhantoms, 0, "hkArray<TriggerVolumeComparisonDemo::DemoShapePhantom*, hkContainerHeapAllocator>") // hkArray< class TriggerVolumeComparisonDemo::DemoShapePhantom*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(TriggerVolumeComparisonDemo, m_aabbPhantoms, 0, "hkArray<TriggerVolumeComparisonDemo::DemoAabbPhantom*, hkContainerHeapAllocator>") // hkArray< class TriggerVolumeComparisonDemo::DemoAabbPhantom*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(TriggerVolumeComparisonDemo, m_characterRigidBodies, 0, "hkArray<hkpCharacterRigidBody*, hkContainerHeapAllocator>") // hkArray< class hkpCharacterRigidBody*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(TriggerVolumeComparisonDemo, m_characterProxies, 0, "hkArray<hkpCharacterProxy*, hkContainerHeapAllocator>") // hkArray< class hkpCharacterProxy*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(TriggerVolumeComparisonDemo, m_sphereShape, 0, "hkpConvexShape*") // class hkpConvexShape*
    HK_TRACKER_MEMBER(TriggerVolumeComparisonDemo, m_charControlShape, 0, "hkpShape*") // class hkpShape*
    HK_TRACKER_MEMBER(TriggerVolumeComparisonDemo, m_sphereInfo, 0, "hkpRigidBodyCinfo") // class hkpRigidBodyCinfo
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(TriggerVolumeComparisonDemo, s_libraryName, hkDefaultPhysics2012Demo)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(TriggerVolumeComparisonDemo, DemoVariant, s_libraryName)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(TriggerVolumeComparisonDemo, HitType, s_libraryName)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(TriggerVolumeComparisonDemo, CollisionPhase, s_libraryName)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(TriggerVolumeComparisonDemo, EntityType, s_libraryName)


// DemoTriggerVolume TriggerVolumeComparisonDemo

HK_TRACKER_DECLARE_CLASS_BEGIN(TriggerVolumeComparisonDemo::DemoTriggerVolume)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(TriggerVolumeComparisonDemo::DemoTriggerVolume)
    HK_TRACKER_MEMBER(TriggerVolumeComparisonDemo::DemoTriggerVolume, m_resultBits, 0, "hkBitField*") // class hkBitField*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(TriggerVolumeComparisonDemo::DemoTriggerVolume, s_libraryName, hkpTriggerVolume)


// DemoPhantomCallbackShape TriggerVolumeComparisonDemo

HK_TRACKER_DECLARE_CLASS_BEGIN(TriggerVolumeComparisonDemo::DemoPhantomCallbackShape)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(TriggerVolumeComparisonDemo::DemoPhantomCallbackShape)
    HK_TRACKER_MEMBER(TriggerVolumeComparisonDemo::DemoPhantomCallbackShape, m_resultBits, 0, "hkBitField*") // class hkBitField*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(TriggerVolumeComparisonDemo::DemoPhantomCallbackShape, s_libraryName, hkpPhantomCallbackShape)


// DemoShapePhantom TriggerVolumeComparisonDemo

HK_TRACKER_DECLARE_CLASS_BEGIN(TriggerVolumeComparisonDemo::DemoShapePhantom)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(TriggerVolumeComparisonDemo::DemoShapePhantom)
    HK_TRACKER_MEMBER(TriggerVolumeComparisonDemo::DemoShapePhantom, m_displayPhantom, 0, "hkpSimpleShapePhantom*") // class hkpSimpleShapePhantom*
    HK_TRACKER_MEMBER(TriggerVolumeComparisonDemo::DemoShapePhantom, m_resultBits, 0, "hkBitField*") // class hkBitField*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(TriggerVolumeComparisonDemo::DemoShapePhantom, s_libraryName, hkpSimpleShapePhantom)


// DemoAabbPhantom TriggerVolumeComparisonDemo

HK_TRACKER_DECLARE_CLASS_BEGIN(TriggerVolumeComparisonDemo::DemoAabbPhantom)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(TriggerVolumeComparisonDemo::DemoAabbPhantom)
    HK_TRACKER_MEMBER(TriggerVolumeComparisonDemo::DemoAabbPhantom, m_displayPhantom, 0, "hkpSimpleShapePhantom*") // class hkpSimpleShapePhantom*
    HK_TRACKER_MEMBER(TriggerVolumeComparisonDemo::DemoAabbPhantom, m_resultBits, 0, "hkBitField*") // class hkBitField*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(TriggerVolumeComparisonDemo::DemoAabbPhantom, s_libraryName, hkpAabbPhantom)


// PingpongAction TriggerVolumeComparisonDemo

HK_TRACKER_DECLARE_CLASS_BEGIN(TriggerVolumeComparisonDemo::PingpongAction)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(TriggerVolumeComparisonDemo::PingpongAction)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(TriggerVolumeComparisonDemo::PingpongAction, s_libraryName, hkpUnaryAction)

#include <Demos/Physics2012/UseCase/TriggerVolume/TriggerVolumeDemo/TriggerVolumeDemo.h>


// TriggerVolumeDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(TriggerVolumeDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(TriggerVolumeDemo)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(TriggerVolumeDemo, s_libraryName, hkDefaultPhysics2012Demo)

#include <Demos/Physics2012/UseCase/WeldingIssues/WeldingIssues.h>


// WeldingIssues ::

HK_TRACKER_DECLARE_CLASS_BEGIN(WeldingIssues)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Options)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(WeldingIssues)
    HK_TRACKER_MEMBER(WeldingIssues, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(WeldingIssues, m_character, 0, "hkArray<hkpCharacterRigidBody*, hkContainerHeapAllocator>") // hkArray< class hkpCharacterRigidBody*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(WeldingIssues, s_libraryName, hkDefaultPhysics2012Demo)


// Options WeldingIssues
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(WeldingIssues, Options, s_libraryName)

#include <Demos/Physics2012/UseCase/WindChimes/WindChimesDemo.h>


// WindChimesDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(WindChimesDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(WindChimesDemo)
    HK_TRACKER_MEMBER(WindChimesDemo, m_loader, 0, "hkLoader*") // class hkLoader*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(WindChimesDemo, s_libraryName, hkDefaultPhysics2012Demo)


// WindChimesCollisionListener ::

HK_TRACKER_DECLARE_CLASS_BEGIN(WindChimesCollisionListener)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(ContactPointInfo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(WindChimesCollisionListener)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(WindChimesCollisionListener, s_libraryName, hkReferencedObject)


// ContactPointInfo WindChimesCollisionListener
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(WindChimesCollisionListener, ContactPointInfo, s_libraryName)


#endif // HK_FEATURE_PRODUCT_PHYSICS_2012
#include <Common/Base/Memory/Tracker/hkTrackerClassDefinition.h>

 void HK_CALL DemosRegister() {}

#include <Demos/Common/Api/Base/RegisterCheck/ExampleSystem.h>


// ExampleSystem ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ExampleSystem)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ExampleSystem)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ExampleSystem, s_libraryName, hkReferencedObject)

#include <Demos/Common/Api/CustomAttributes/ClassWithAttributes.h>


// ClassWithAttributes ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ClassWithAttributes)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ClassWithAttributes)
    HK_TRACKER_MEMBER(ClassWithAttributes, m_pathToResource, 0, "char*") // const char*
    HK_TRACKER_MEMBER(ClassWithAttributes, m_name, 0, "char*") // const char*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(ClassWithAttributes, s_libraryName)

#include <Demos/Common/Api/CustomAttributes/ExampleAttributes.h>


// ExampleBooleanAttribute ::
HK_TRACKER_IMPLEMENT_SIMPLE(ExampleBooleanAttribute, s_libraryName)


// ExampleStringAttribute ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ExampleStringAttribute)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ExampleStringAttribute)
    HK_TRACKER_MEMBER(ExampleStringAttribute, m_str, 0, "char*") // const char*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(ExampleStringAttribute, s_libraryName)


// ExampleIntListAttribute ::
HK_TRACKER_IMPLEMENT_SIMPLE(ExampleIntListAttribute, s_libraryName)


// ExampleStringPairsAttribute ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ExampleStringPairsAttribute)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Item)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_IMPLEMENT_SIMPLE(ExampleStringPairsAttribute, s_libraryName)


// Item ExampleStringPairsAttribute

HK_TRACKER_DECLARE_CLASS_BEGIN(ExampleStringPairsAttribute::Item)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ExampleStringPairsAttribute::Item)
    HK_TRACKER_MEMBER(ExampleStringPairsAttribute::Item, m_key, 0, "char*") // const char*
    HK_TRACKER_MEMBER(ExampleStringPairsAttribute::Item, m_value, 0, "char*") // const char*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(ExampleStringPairsAttribute::Item, s_libraryName)


// ExampleStringRole ::
HK_TRACKER_IMPLEMENT_SIMPLE(ExampleStringRole, s_libraryName)


// ExampleRangeReal ::
HK_TRACKER_IMPLEMENT_SIMPLE(ExampleRangeReal, s_libraryName)


// ExampleRawByteData ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ExampleRawByteData)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ExampleRawByteData)
    HK_TRACKER_MEMBER(ExampleRawByteData, m_data, 0, "char*") // const char*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(ExampleRawByteData, s_libraryName)

#include <Demos/Common/Api/Mesh/MeshSimplification/MeshSimplificationDemo.h>


// MeshSimplificationDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MeshSimplificationDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MeshSimplificationDemo)
    HK_TRACKER_MEMBER(MeshSimplificationDemo, m_originalMesh, 0, "hkxMesh*") // class hkxMesh*
    HK_TRACKER_MEMBER(MeshSimplificationDemo, m_loader, 0, "hkLoader*") // class hkLoader*
    HK_TRACKER_MEMBER(MeshSimplificationDemo, m_sections, 0, "hkArray<hkxMeshSection*, hkContainerHeapAllocator>") // hkArray< class hkxMeshSection*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(MeshSimplificationDemo, m_geom, 0, "hkGeometry [3]") // struct hkGeometry [3]
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(MeshSimplificationDemo, s_libraryName, hkDefaultDemo)

#include <Demos/Common/Api/Serialize/Browse/BrowseDemo.h>


// BrowseDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(BrowseDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Variant)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(BrowseDemo)
    HK_TRACKER_MEMBER(BrowseDemo, m_fileBrowser, 0, "FileBrowser") // class FileBrowser
    HK_TRACKER_MEMBER(BrowseDemo, m_loadedData, 0, "hkResource *") // class hkResource *
    HK_TRACKER_MEMBER(BrowseDemo, m_contents, 0, "hkRootLevelContainer*") // class hkRootLevelContainer*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(BrowseDemo, s_libraryName, hkDefaultDemo)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(BrowseDemo, Variant, s_libraryName)

#include <Demos/Common/Api/Serialize/CustomPatches/CustomPatchesDemo.h>


// CustomContainer ::

HK_TRACKER_DECLARE_CLASS_BEGIN(CustomContainer)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Item)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(CustomContainer)
    HK_TRACKER_MEMBER(CustomContainer, m_classMember, 0, "CustomContainer::Item") // class CustomContainer::Item
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(CustomContainer, s_libraryName, hkReferencedObject)


// Item CustomContainer

HK_TRACKER_DECLARE_CLASS_BEGIN(CustomContainer::Item)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(CustomContainer::Item)
    HK_TRACKER_MEMBER(CustomContainer::Item, m_arrayAddedMember, 0, "hkArray<hkUint8, hkContainerHeapAllocator>") // hkArray< hkUint8, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(CustomContainer::Item, s_libraryName)

#include <Demos/Common/Test/Feature/ConvexHull/ConvexHullDemo.h>


// ConvexHullDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ConvexHullDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Variant)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ConvexHullDemo)
    HK_TRACKER_MEMBER(ConvexHullDemo, m_variant, 0, "ConvexHullDemo::Variant*") // const struct ConvexHullDemo::Variant*
    HK_TRACKER_MEMBER(ConvexHullDemo, m_stopWatch, 0, "hkStopwatch") // class hkStopwatch
    HK_TRACKER_MEMBER(ConvexHullDemo, m_hullPerSeconds, 0, "hkPointerMap<hkInt32, hkInt32, hkContainerHeapAllocator>") // class hkPointerMap< hkInt32, hkInt32, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(ConvexHullDemo, m_points, 0, "hkArray<hkVector4f, hkContainerHeapAllocator>") // hkArray< hkVector4f, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ConvexHullDemo, s_libraryName, hkDefaultDemo)


// Variant ConvexHullDemo

HK_TRACKER_DECLARE_CLASS_BEGIN(ConvexHullDemo::Variant)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ConvexHullDemo::Variant)
    HK_TRACKER_MEMBER(ConvexHullDemo::Variant, m_name, 0, "char*") // const char*
    HK_TRACKER_MEMBER(ConvexHullDemo::Variant, m_details, 0, "char*") // const char*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(ConvexHullDemo::Variant, s_libraryName)

#include <Demos/Common/Test/Feature/LoadAssetsAsObjects/LoadAssetsAsObjectsDemo.h>


// LoadAssetsAsObjectsDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(LoadAssetsAsObjectsDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(FindAssetFilter)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(TeeStream)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Error)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(LoadAssetsAsObjectsDemo)
    HK_TRACKER_MEMBER(LoadAssetsAsObjectsDemo, m_fileFinder, 0, "FileFinder") // class FileFinder
    HK_TRACKER_MEMBER(LoadAssetsAsObjectsDemo, m_fileOutput, 0, "hkOstream") // class hkOstream
    HK_TRACKER_MEMBER(LoadAssetsAsObjectsDemo, m_log, 0, "LoadAssetsAsObjectsDemo::TeeStream") // struct LoadAssetsAsObjectsDemo::TeeStream
    HK_TRACKER_MEMBER(LoadAssetsAsObjectsDemo, m_output, 0, "hkOstream") // class hkOstream
    HK_TRACKER_MEMBER(LoadAssetsAsObjectsDemo, m_error, 0, "LoadAssetsAsObjectsDemo::Error*") // class LoadAssetsAsObjectsDemo::Error*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(LoadAssetsAsObjectsDemo, s_libraryName, hkDefaultDemo)


// FindAssetFilter LoadAssetsAsObjectsDemo

HK_TRACKER_DECLARE_CLASS_BEGIN(LoadAssetsAsObjectsDemo::FindAssetFilter)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(LoadAssetsAsObjectsDemo::FindAssetFilter)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(LoadAssetsAsObjectsDemo::FindAssetFilter, s_libraryName, FileFinder::Filter)


// TeeStream LoadAssetsAsObjectsDemo

HK_TRACKER_DECLARE_CLASS_BEGIN(LoadAssetsAsObjectsDemo::TeeStream)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(LoadAssetsAsObjectsDemo::TeeStream)
    HK_TRACKER_MEMBER(LoadAssetsAsObjectsDemo::TeeStream, m_streams, 0, "hkArray<hkStreamWriter*, hkContainerHeapAllocator>") // hkArray< class hkStreamWriter*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(LoadAssetsAsObjectsDemo::TeeStream, s_libraryName, hkStreamWriter)


// Error LoadAssetsAsObjectsDemo

HK_TRACKER_DECLARE_CLASS_BEGIN(LoadAssetsAsObjectsDemo::Error)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(LoadAssetsAsObjectsDemo::Error)
    HK_TRACKER_MEMBER(LoadAssetsAsObjectsDemo::Error, m_nextError, 0, "hkError *") // class hkError *
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(LoadAssetsAsObjectsDemo::Error, s_libraryName, hkError)

#include <Demos/DemoCommon/DemoFramework/Callable.h>


// CallbackStorage CallbackUtil

HK_TRACKER_DECLARE_CLASS_BEGIN(CallbackUtil::CallbackStorage)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(CallbackUtil::CallbackStorage)
    HK_TRACKER_MEMBER(CallbackUtil::CallbackStorage, m_invoker, 0, "void*") // void*
    HK_TRACKER_MEMBER(CallbackUtil::CallbackStorage, m_obj, 0, "void*") // void*
    HK_TRACKER_MEMBER(CallbackUtil::CallbackStorage, m_args, 0, "void* [1]") // void* [1]
    HK_TRACKER_MEMBER(CallbackUtil::CallbackStorage, m_method, 0, "void* [3]") // void* [3]
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(CallbackUtil::CallbackStorage, s_libraryName)

#include <Demos/DemoCommon/DemoFramework/MonitorStatsRecorder.h>


// MonitorStatsRecorder ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MonitorStatsRecorder)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(OutputFormat)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MonitorStatsRecorder)
    HK_TRACKER_MEMBER(MonitorStatsRecorder, m_analyzer, 0, "hkMonitorStreamAnalyzer*") // class hkMonitorStreamAnalyzer*
    HK_TRACKER_MEMBER(MonitorStatsRecorder, m_monitorValues, 0, "hkArray<float, hkContainerHeapAllocator>") // hkArray< float, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(MonitorStatsRecorder, m_demo, 0, "hkDefaultDemo*") // class hkDefaultDemo*
    HK_TRACKER_MEMBER(MonitorStatsRecorder, m_monitorNames, 0, "char**") // const char**
    HK_TRACKER_MEMBER(MonitorStatsRecorder, m_fileName, 0, "hkStringBuf") // class hkStringBuf
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(MonitorStatsRecorder, s_libraryName)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(MonitorStatsRecorder, OutputFormat, s_libraryName)

#include <Demos/DemoCommon/DemoFramework/TrackerHandlers/hkTrackerExtLayoutHandler.h>

// hk.MemoryTracker ignore hkTrackerExtLayoutHandler
#include <Demos/DemoCommon/DemoFramework/hkDefaultDemo.h>


// DemoStepper ::

HK_TRACKER_DECLARE_CLASS_BEGIN(DemoStepper)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(DemoStepper)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_ABSTRACT(DemoStepper, s_libraryName, hkReferencedObject)


// hkDefaultDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(hkDefaultDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(DefaultOptions)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(IdAndEnabled)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(CameraAxis)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(FactoryType)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(hkDefaultDemo)
    HK_TRACKER_MEMBER(hkDefaultDemo, m_steppers, 0, "hkArray<DemoStepper*, hkContainerHeapAllocator>") // hkArray< class DemoStepper*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(hkDefaultDemo, m_menuPath, 0, "extStringPtr") // class extStringPtr
    HK_TRACKER_MEMBER(hkDefaultDemo, m_demoPath, 0, "extStringPtr") // class extStringPtr
    HK_TRACKER_MEMBER(hkDefaultDemo, m_resourcePath, 0, "extStringPtr") // class extStringPtr
    HK_TRACKER_MEMBER(hkDefaultDemo, m_lastProgress, 0, "hkStopwatch*") // class hkStopwatch*
    HK_TRACKER_MEMBER(hkDefaultDemo, m_progressName, 0, "extStringPtr") // class extStringPtr
    HK_TRACKER_MEMBER(hkDefaultDemo, m_delayedCleanup, 0, "hkArray<hkReferencedObject*, hkContainerHeapAllocator>") // hkArray< class hkReferencedObject*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(hkDefaultDemo, m_characterFactory, 0, "CharacterFactory *") // class CharacterFactory *
    HK_TRACKER_MEMBER(hkDefaultDemo, m_debugViewerNames, 0, "extArray<extStringPtr>") // class extArray< class extStringPtr >
    HK_TRACKER_MEMBER(hkDefaultDemo, m_debugProcesses, 0, "extArray<hkProcess*>") // class extArray< class hkProcess* >
    HK_TRACKER_MEMBER(hkDefaultDemo, m_vdb, 0, "hkVisualDebugger*") // class hkVisualDebugger*
    HK_TRACKER_MEMBER(hkDefaultDemo, m_vdbClassReg, 0, "hkVtableClassRegistry*") // class hkVtableClassRegistry*
    HK_TRACKER_MEMBER(hkDefaultDemo, m_contexts, 0, "hkArray<hkProcessContext*, hkContainerHeapAllocator>") // hkArray< class hkProcessContext*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(hkDefaultDemo, m_graphedTimerNames, 0, "hkArray<extStringPtr, hkContainerHeapAllocator>") // hkArray< class extStringPtr, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(hkDefaultDemo, m_jobQueue, 0, "hkJobQueue*") // class hkJobQueue*
    HK_TRACKER_MEMBER(hkDefaultDemo, m_spuUtil, 0, "hkSpuUtil*") // class hkSpuUtil*
    HK_TRACKER_MEMBER(hkDefaultDemo, m_threadPool, 0, "hkThreadPool *") // class hkThreadPool *
    HK_TRACKER_MEMBER(hkDefaultDemo, m_taskQueue, 0, "hkTaskQueue *") // class hkTaskQueue *
    HK_TRACKER_MEMBER(hkDefaultDemo, m_aiDemoComponent, 0, "hkReferencedObject*") // class hkReferencedObject*
    HK_TRACKER_MEMBER(hkDefaultDemo, m_monitorRecorder, 0, "MonitorStatsRecorder*") // struct MonitorStatsRecorder*
    HK_TRACKER_MEMBER(hkDefaultDemo, m_errorEnabledStack, 0, "hkArray<hkDefaultDemo::IdAndEnabled, hkContainerHeapAllocator>") // hkArray< struct hkDefaultDemo::IdAndEnabled, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(hkDefaultDemo, s_libraryName, hkDemo)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(hkDefaultDemo, CameraAxis, s_libraryName)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(hkDefaultDemo, FactoryType, s_libraryName)


// DefaultOptions hkDefaultDemo
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(hkDefaultDemo, DefaultOptions, s_libraryName)


// IdAndEnabled hkDefaultDemo
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(hkDefaultDemo, IdAndEnabled, s_libraryName)

#include <Demos/DemoCommon/DemoFramework/hkDemo.h>


// hkDemoFrameTimer ::

HK_TRACKER_DECLARE_CLASS_BEGIN(hkDemoFrameTimer)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(hkDemoFrameTimer)
    HK_TRACKER_MEMBER(hkDemoFrameTimer, m_ticksSoFar, 0, "hkStopwatch") // class hkStopwatch
    HK_TRACKER_MEMBER(hkDemoFrameTimer, m_totalTicks, 0, "hkStopwatch") // class hkStopwatch
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(hkDemoFrameTimer, s_libraryName)


// hkDemoEnvironment ::

HK_TRACKER_DECLARE_CLASS_BEGIN(hkDemoEnvironment)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(ViewportData)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(ReportingLevel)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(hkDemoEnvironment)
    HK_TRACKER_MEMBER(hkDemoEnvironment, m_window, 0, "hkgWindow*") // class hkgWindow*
    HK_TRACKER_MEMBER(hkDemoEnvironment, m_displayHandler, 0, "hkgDisplayHandler*") // class hkgDisplayHandler*
    HK_TRACKER_MEMBER(hkDemoEnvironment, m_sceneConverter, 0, "hkgSceneDataConverter*") // class hkgSceneDataConverter*
    HK_TRACKER_MEMBER(hkDemoEnvironment, m_displayWorld, 0, "hkgDisplayWorld*") // class hkgDisplayWorld*
    HK_TRACKER_MEMBER(hkDemoEnvironment, m_textDisplay, 0, "hkTextDisplay*") // class hkTextDisplay*
    HK_TRACKER_MEMBER(hkDemoEnvironment, m_viewportData, 0, "extArray<hkDemoEnvironment::ViewportData>") // class extArray< struct hkDemoEnvironment::ViewportData >
    HK_TRACKER_MEMBER(hkDemoEnvironment, m_gamePad, 0, "hkgPad*") // class hkgPad*
    HK_TRACKER_MEMBER(hkDemoEnvironment, m_gamePadB, 0, "hkgPad*") // class hkgPad*
    HK_TRACKER_MEMBER(hkDemoEnvironment, m_movieRecorder, 0, "hkgMovieRecorder*") // class hkgMovieRecorder*
    HK_TRACKER_MEMBER(hkDemoEnvironment, m_options, 0, "hkDemoFrameworkOptions*") // struct hkDemoFrameworkOptions*
    HK_TRACKER_MEMBER(hkDemoEnvironment, m_frameTimer, 0, "hkDemoFrameTimer") // class hkDemoFrameTimer
    HK_TRACKER_MEMBER(hkDemoEnvironment, m_menuPath, 0, "extStringPtr") // class extStringPtr
    HK_TRACKER_MEMBER(hkDemoEnvironment, m_demoPath, 0, "extStringPtr") // class extStringPtr
    HK_TRACKER_MEMBER(hkDemoEnvironment, m_resourcePath, 0, "extStringPtr") // class extStringPtr
    HK_TRACKER_MEMBER(hkDemoEnvironment, m_virtualFrameBufferServer, 0, "hkVirtualFramebufferServer*") // class hkVirtualFramebufferServer*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(hkDemoEnvironment, s_libraryName, hkVirtualGamepadHandler)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(hkDemoEnvironment, ReportingLevel, s_libraryName)


// ViewportData hkDemoEnvironment

HK_TRACKER_DECLARE_CLASS_BEGIN(hkDemoEnvironment::ViewportData)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(hkDemoEnvironment::ViewportData)
    HK_TRACKER_MEMBER(hkDemoEnvironment::ViewportData, m_displayHandler, 0, "hkgDisplayHandler*") // class hkgDisplayHandler*
    HK_TRACKER_MEMBER(hkDemoEnvironment::ViewportData, m_sceneConverter, 0, "hkgSceneDataConverter*") // class hkgSceneDataConverter*
    HK_TRACKER_MEMBER(hkDemoEnvironment::ViewportData, m_displayWorld, 0, "hkgDisplayWorld*") // class hkgDisplayWorld*
    HK_TRACKER_MEMBER(hkDemoEnvironment::ViewportData, m_textDisplay, 0, "hkTextDisplay*") // class hkTextDisplay*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(hkDemoEnvironment::ViewportData, s_libraryName)


// hkDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(hkDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(RegressionInfo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(KeyPressCallbackInfo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Result)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(PostStepActions)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(hkDemo)
    HK_TRACKER_MEMBER(hkDemo, m_additionalRegressions, 0, "extArray<hkDemo::RegressionInfo>") // class extArray< struct hkDemo::RegressionInfo >
    HK_TRACKER_MEMBER(hkDemo, m_regressionNameToIndexMap, 0, "hkStorageStringMap<hkInt32, extContainerAllocator>") // class hkStorageStringMap< hkInt32, struct extContainerAllocator >
    HK_TRACKER_MEMBER(hkDemo, m_env, 0, "hkDemoEnvironment*") // class hkDemoEnvironment*
    HK_TRACKER_MEMBER(hkDemo, m_error, 0, "extStringPtr") // class extStringPtr
    HK_TRACKER_MEMBER(hkDemo, m_name, 0, "extStringPtr") // class extStringPtr
    HK_TRACKER_MEMBER(hkDemo, m_keyPressCallbacks, 0, "extArray<hkDemo::KeyPressCallbackInfo>") // class extArray< struct hkDemo::KeyPressCallbackInfo >
    HK_TRACKER_MEMBER(hkDemo, m_keyHeldCallbacks, 0, "extArray<hkDemo::KeyPressCallbackInfo>") // class extArray< struct hkDemo::KeyPressCallbackInfo >
    HK_TRACKER_MEMBER(hkDemo, m_keyReleaseCallbacks, 0, "extArray<hkDemo::KeyPressCallbackInfo>") // class extArray< struct hkDemo::KeyPressCallbackInfo >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_ABSTRACT(hkDemo, s_libraryName, hkReferencedObject)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(hkDemo, Result, s_libraryName)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(hkDemo, PostStepActions, s_libraryName)


// RegressionInfo hkDemo

HK_TRACKER_DECLARE_CLASS_BEGIN(hkDemo::RegressionInfo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(RegressionType)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(hkDemo::RegressionInfo)
    HK_TRACKER_MEMBER(hkDemo::RegressionInfo, m_name, 0, "extStringPtr") // class extStringPtr
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(hkDemo::RegressionInfo, s_libraryName)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(hkDemo::RegressionInfo, RegressionType, s_libraryName)


// KeyPressCallbackInfo hkDemo

HK_TRACKER_DECLARE_CLASS_BEGIN(hkDemo::KeyPressCallbackInfo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(hkDemo::KeyPressCallbackInfo)
    HK_TRACKER_MEMBER(hkDemo::KeyPressCallbackInfo, description, 0, "char*") // const char*
    HK_TRACKER_MEMBER(hkDemo::KeyPressCallbackInfo, cb, 0, "Callable0<hkInt32>") // class Callable0< hkInt32 >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(hkDemo::KeyPressCallbackInfo, s_libraryName)


// ErrorDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ErrorDemo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ErrorDemo)
    HK_TRACKER_MEMBER(ErrorDemo, m_failed, 0, "char*") // const char*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ErrorDemo, s_libraryName, hkDemo)

#include <Demos/DemoCommon/DemoFramework/hkDemoConsole.h>

// hk.MemoryTracker ignore hkDemoConsole
#include <Demos/DemoCommon/DemoFramework/hkDemoDatabase.h>

// hk.MemoryTracker ignore hkDemoEntryRegister
// hk.MemoryTracker ignore hkDemoEntry
// hk.MemoryTracker ignore hkDemoDatabase
// None DemoType
HK_TRACKER_IMPLEMENT_SIMPLE(DemoType, s_libraryName)
#include <Demos/DemoCommon/DemoFramework/hkDemoFramework.h>


// hkDemoReferencedObjectCache ::

HK_TRACKER_DECLARE_CLASS_BEGIN(hkDemoReferencedObjectCache)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Entry)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(hkDemoReferencedObjectCache)
    HK_TRACKER_MEMBER(hkDemoReferencedObjectCache, m_cache, 0, "hkStringMap<hkDemoReferencedObjectCache::Entry*, hkContainerHeapAllocator>") // class hkStringMap< struct hkDemoReferencedObjectCache::Entry*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(hkDemoReferencedObjectCache, m_entries, 0, "hkArray<hkDemoReferencedObjectCache::Entry*, hkContainerHeapAllocator>") // hkArray< struct hkDemoReferencedObjectCache::Entry*, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(hkDemoReferencedObjectCache, s_libraryName)


// Entry hkDemoReferencedObjectCache

HK_TRACKER_DECLARE_CLASS_BEGIN(hkDemoReferencedObjectCache::Entry)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(hkDemoReferencedObjectCache::Entry)
    HK_TRACKER_MEMBER(hkDemoReferencedObjectCache::Entry, m_refObj, 0, "hkReferencedObject*") // class hkReferencedObject*
    HK_TRACKER_MEMBER(hkDemoReferencedObjectCache::Entry, m_extendedKey, 0, "hkStringPtr") // hkStringPtr
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(hkDemoReferencedObjectCache::Entry, s_libraryName)

#include <Demos/DemoCommon/DemoFramework/hkDemoFrameworkOptions.h>


// hkDemoFrameworkOptions ::

HK_TRACKER_DECLARE_CLASS_BEGIN(hkDemoFrameworkOptions)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(MemorySystemType)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(hkDemoFrameworkOptions)
    HK_TRACKER_MEMBER(hkDemoFrameworkOptions, m_vdbCaptureFile, 0, "char*") // const char*
    HK_TRACKER_MEMBER(hkDemoFrameworkOptions, m_defaultDemo, 0, "char*") // const char*
    HK_TRACKER_MEMBER(hkDemoFrameworkOptions, m_windowTitle, 0, "char*") // const char*
    HK_TRACKER_MEMBER(hkDemoFrameworkOptions, m_masterFile, 0, "char*") // const char*
    HK_TRACKER_MEMBER(hkDemoFrameworkOptions, m_renderer, 0, "char*") // const char*
    HK_TRACKER_MEMBER(hkDemoFrameworkOptions, m_physicsArgs, 0, "char*") // const char*
    HK_TRACKER_MEMBER(hkDemoFrameworkOptions, m_statsDir, 0, "char*") // const char*
    HK_TRACKER_MEMBER(hkDemoFrameworkOptions, m_overrideFileDir, 0, "char*") // const char*
    HK_TRACKER_MEMBER(hkDemoFrameworkOptions, m_argv, 0, "char**") // const char**
    HK_TRACKER_MEMBER(hkDemoFrameworkOptions, m_inputFilename, 0, "char*") // const char*
    HK_TRACKER_MEMBER(hkDemoFrameworkOptions, m_movieFilename, 0, "char*") // const char*
    HK_TRACKER_MEMBER(hkDemoFrameworkOptions, m_outputRecordDir, 0, "char*") // const char*
    HK_TRACKER_MEMBER(hkDemoFrameworkOptions, m_firstMonitor, 0, "char**") // const char**
    HK_TRACKER_MEMBER(hkDemoFrameworkOptions, m_logFile, 0, "char*") // const char*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(hkDemoFrameworkOptions, s_libraryName)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(hkDemoFrameworkOptions, MemorySystemType, s_libraryName)

#include <Demos/DemoCommon/DemoFramework/hkFloatingPointExceptionCheck.h>


// hkFPUExceptionDisabler ::
HK_TRACKER_IMPLEMENT_SIMPLE(hkFPUExceptionDisabler, s_libraryName)

#include <Demos/DemoCommon/DemoFramework/hkPerformanceCounterUtility.h>


// hkPerformanceCounterUtility ::

HK_TRACKER_DECLARE_CLASS_BEGIN(hkPerformanceCounterUtility)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(CounterSelect)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(hkPerformanceCounterUtility)
    HK_TRACKER_MEMBER(hkPerformanceCounterUtility, m_demoName, 0, "hkStringPtr") // hkStringPtr
    HK_TRACKER_MEMBER(hkPerformanceCounterUtility, m_timerHeading, 0, "hkStringPtr") // hkStringPtr
    HK_TRACKER_MEMBER(hkPerformanceCounterUtility, m_streamUtility, 0, "hkMonitorStreamAnalyzer*") // class hkMonitorStreamAnalyzer*
    HK_TRACKER_MEMBER(hkPerformanceCounterUtility, m_frameInfo, 0, "hkMonitorStreamFrameInfo") // struct hkMonitorStreamFrameInfo
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(hkPerformanceCounterUtility, s_libraryName)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(hkPerformanceCounterUtility, CounterSelect, s_libraryName)

#include <Demos/DemoCommon/DemoFramework/hkTestDemo.h>


// TestDemoError ::

HK_TRACKER_DECLARE_CLASS_BEGIN(TestDemoError)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(TestDemoError)
    HK_TRACKER_MEMBER(TestDemoError, m_owner, 0, "TestDemo*") // class TestDemo*
    HK_TRACKER_MEMBER(TestDemoError, m_errorBuffer, 0, "extStringBuf") // class extStringBuf
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(TestDemoError, s_libraryName, hkDefaultError)


// TestDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(TestDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(FailReason)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(TestDemo)
    HK_TRACKER_MEMBER(TestDemo, m_error, 0, "TestDemoError") // class TestDemoError
    HK_TRACKER_MEMBER(TestDemo, m_testString, 0, "extStringBuf") // class extStringBuf
    HK_TRACKER_MEMBER(TestDemo, m_passString, 0, "extStringBuf") // class extStringBuf
    HK_TRACKER_MEMBER(TestDemo, m_failString, 0, "extStringBuf") // class extStringBuf
    HK_TRACKER_MEMBER(TestDemo, m_tests, 0, "hkArray<hkTestEntry*, hkContainerHeapAllocator>") // hkArray< const struct hkTestEntry*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(TestDemo, m_passedTests, 0, "extStringBuf") // class extStringBuf
    HK_TRACKER_MEMBER(TestDemo, m_failedTests, 0, "extStringBuf") // class extStringBuf
    HK_TRACKER_MEMBER(TestDemo, m_keepAliveTimer, 0, "hkStopwatch") // class hkStopwatch
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(TestDemo, s_libraryName, hkDefaultDemo)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(TestDemo, FailReason, s_libraryName)

#include <Demos/DemoCommon/DemoFramework/hkTextDisplay.h>

// hk.MemoryTracker ignore hkTextDisplay

// hkTextLog ::

HK_TRACKER_DECLARE_CLASS_BEGIN(hkTextLog)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(hkTextLog)
    HK_TRACKER_MEMBER(hkTextLog, m_stringLock, 0, "hkCriticalSection*") // class hkCriticalSection*
    HK_TRACKER_MEMBER(hkTextLog, m_lines, 0, "extArray<extStringPtr>") // class extArray< class extStringPtr >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(hkTextLog, s_libraryName, hkReferencedObject)

#include <Demos/DemoCommon/Utilities/Asset/ResourceLinker.h>


// ResourceLinker ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ResourceLinker)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Reference)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ResourceLinker)
    HK_TRACKER_MEMBER(ResourceLinker, m_resources, 0, "hkPointerMap<hkResource*, hkInt32, hkContainerHeapAllocator>") // class hkPointerMap< class hkResource*, hkInt32, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(ResourceLinker, m_resolved, 0, "hkStringMap<void*, hkContainerHeapAllocator>") // class hkStringMap< void*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(ResourceLinker, m_dangling, 0, "hkStringMap<hkInt32, hkContainerHeapAllocator>") // class hkStringMap< hkInt32, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(ResourceLinker, m_backMap, 0, "hkSerializeMultiMap<void*, ResourceLinker::Reference, hkPointerMap<void*, hkInt32, hkContainerHeapAllocator> >") // class hkSerializeMultiMap< void*, struct ResourceLinker::Reference, class hkPointerMap< void*, hkInt32, struct hkContainerHeapAllocator > >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(ResourceLinker, s_libraryName)


// Reference ResourceLinker

HK_TRACKER_DECLARE_CLASS_BEGIN(ResourceLinker::Reference)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ResourceLinker::Reference)
    HK_TRACKER_MEMBER(ResourceLinker::Reference, loc, 0, "void**") // void**
    HK_TRACKER_MEMBER(ResourceLinker::Reference, resource, 0, "hkResource*") // class hkResource*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(ResourceLinker::Reference, s_libraryName)

#include <Demos/DemoCommon/Utilities/Asset/hkAssetManagementUtil.h>


// hkAssetManagementUtil ::
HK_TRACKER_IMPLEMENT_SIMPLE(hkAssetManagementUtil, s_libraryName)

#include <Demos/DemoCommon/Utilities/Bootstrap/BootstrapDemo.h>


// BootstrapDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(BootstrapDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(DemoEntry)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(TestType)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(BootstrapDemo)
    HK_TRACKER_MEMBER(BootstrapDemo, m_originalOptions, 0, "hkDemoFrameworkOptions") // struct hkDemoFrameworkOptions
    HK_TRACKER_MEMBER(BootstrapDemo, m_demoRegressions, 0, "hkArray<hkDemo::RegressionInfo, hkContainerHeapAllocator>") // hkArray< struct hkDemo::RegressionInfo, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(BootstrapDemo, m_entries, 0, "hkArray<BootstrapDemo::DemoEntry, hkContainerHeapAllocator>") // hkArray< struct BootstrapDemo::DemoEntry, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(BootstrapDemo, m_demo, 0, "hkDemo*") // class hkDemo*
    HK_TRACKER_MEMBER(BootstrapDemo, m_allocatedData, 0, "hkResource*") // class hkResource*
    HK_TRACKER_MEMBER(BootstrapDemo, m_originalWorld, 0, "hkpWorld*") // class hkpWorld*
    HK_TRACKER_MEMBER(BootstrapDemo, m_pathToProductIndex, 0, "hkStorageStringMap<hkInt32, hkContainerHeapAllocator>") // class hkStorageStringMap< hkInt32, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(BootstrapDemo, m_productTimes, 0, "hkArray<float, hkContainerHeapAllocator>") // hkArray< float, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(BootstrapDemo, s_libraryName, hkDemo)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(BootstrapDemo, TestType, s_libraryName)


// DemoEntry BootstrapDemo

HK_TRACKER_DECLARE_CLASS_BEGIN(BootstrapDemo::DemoEntry)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(BootstrapDemo::DemoEntry)
    HK_TRACKER_MEMBER(BootstrapDemo::DemoEntry, m_entry, 0, "hkDemoEntry*") // const struct hkDemoEntry*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(BootstrapDemo::DemoEntry, s_libraryName)

#include <Demos/DemoCommon/Utilities/CameraUtils/CameraUtils.h>


// CameraUtils ::
HK_TRACKER_IMPLEMENT_SIMPLE(CameraUtils, s_libraryName)

#include <Demos/DemoCommon/Utilities/Character/CharacterProxy/CharacterProxy.h>


// CharacterProxyCinfo ::
HK_TRACKER_IMPLEMENT_SIMPLE(CharacterProxyCinfo, s_libraryName)


// CharacterProxy ::

HK_TRACKER_DECLARE_CLASS_BEGIN(CharacterProxy)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(CharacterProxy)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_ABSTRACT(CharacterProxy, s_libraryName, hkReferencedObject)

#include <Demos/DemoCommon/Utilities/Character/CharacterProxy/SimpleCharacterProxy/SimpleCharacterProxy.h>


// SimpleCharacterProxy ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SimpleCharacterProxy)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SimpleCharacterProxy)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SimpleCharacterProxy, s_libraryName, CharacterProxy)

#include <Demos/DemoCommon/Utilities/Character/CharacterStepInput.h>


// CharacterStepInput ::
HK_TRACKER_IMPLEMENT_SIMPLE(CharacterStepInput, s_libraryName)


// CharacterActionInfo ::
HK_TRACKER_IMPLEMENT_SIMPLE(CharacterActionInfo, s_libraryName)

// hk.MemoryTracker ignore CharacterUserInput
// None CharacterAction
HK_TRACKER_IMPLEMENT_SIMPLE(CharacterAction, s_libraryName)
#include <Demos/DemoCommon/Utilities/Character/DemoCharacter/DemoCharacter.h>


// CharacterFactory ::

HK_TRACKER_DECLARE_CLASS_BEGIN(CharacterFactory)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(CharacterType)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(CharacterPhysicsType)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(CharacterFactory)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_ABSTRACT(CharacterFactory, s_libraryName, hkReferencedObject)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(CharacterFactory, CharacterType, s_libraryName)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(CharacterFactory, CharacterPhysicsType, s_libraryName)


// DemoCharacterCinfo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(DemoCharacterCinfo)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(DemoCharacterCinfo)
    HK_TRACKER_MEMBER(DemoCharacterCinfo, m_characterProxy, 0, "CharacterProxy*") // class CharacterProxy*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(DemoCharacterCinfo, s_libraryName)


// DemoCharacter ::

HK_TRACKER_DECLARE_CLASS_BEGIN(DemoCharacter)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(State)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(DemoCharacter)
    HK_TRACKER_MEMBER(DemoCharacter, m_characterProxy, 0, "CharacterProxy*") // class CharacterProxy*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_ABSTRACT(DemoCharacter, s_libraryName, hkReferencedObject)


// State DemoCharacter
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(DemoCharacter, State, s_libraryName)

#include <Demos/DemoCommon/Utilities/Character/DemoCharacter/PhysicsDemoCharacter/CharacterImperfectionStyle.h>


// CharacterImperfectionStyle ::

HK_TRACKER_DECLARE_CLASS_BEGIN(CharacterImperfectionStyle)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(VelocitySource)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(CharacterImperfectionStyle)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(CharacterImperfectionStyle, s_libraryName, hkReferencedObject)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(CharacterImperfectionStyle, VelocitySource, s_libraryName)

#include <Demos/DemoCommon/Utilities/Character/DemoCharacter/SimpleDemoCharacter/SimpleDemoCharacter.h>


// SimpleDemoCharacterCinfo ::
HK_TRACKER_IMPLEMENT_SIMPLE(SimpleDemoCharacterCinfo, s_libraryName)


// SimpleDemoCharacter ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SimpleDemoCharacter)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SimpleDemoCharacter)
    HK_TRACKER_MEMBER(SimpleDemoCharacter, m_imperfectionStyle, 0, "CharacterImperfectionStyle *") // const struct CharacterImperfectionStyle *
    HK_TRACKER_MEMBER(SimpleDemoCharacter, m_laggedInput, 0, "hkQueue<CharacterStepInput>") // class hkQueue< struct CharacterStepInput >
    HK_TRACKER_MEMBER(SimpleDemoCharacter, m_laggedSteeringVel, 0, "hkQueue<hkVector4f>") // class hkQueue< hkVector4f >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SimpleDemoCharacter, s_libraryName, DemoCharacter)


// SimpleCharacterFactory ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SimpleCharacterFactory)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SimpleCharacterFactory)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SimpleCharacterFactory, s_libraryName, CharacterFactory)

#include <Demos/DemoCommon/Utilities/Drawing/DrawUtils.h>

// hk.MemoryTracker ignore DrawUtils
// hk.MemoryTracker ignore hkDrawBase
// hk.MemoryTracker ignore hkDrawRectangle
// hk.MemoryTracker ignore hkDrawLine
// hk.MemoryTracker ignore hkDrawTriangle
// hk.MemoryTracker ignore hkDrawPoint

// hkDrawAny ::

HK_TRACKER_DECLARE_CLASS_BEGIN(hkDrawAny)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(hkDrawAny)
    HK_TRACKER_MEMBER(hkDrawAny, m_pts, 0, "hkArray<hkVector4f, hkContainerHeapAllocator>") // hkArray< hkVector4f, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(hkDrawAny, m_polys, 0, "hkArray<hkInt32, hkContainerHeapAllocator>") // hkArray< hkInt32, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(hkDrawAny, s_libraryName, hkDrawBase)

#include <Demos/DemoCommon/Utilities/Drawing/TapeMeasure.h>


// TapeMeasure ::
HK_TRACKER_IMPLEMENT_SIMPLE(TapeMeasure, s_libraryName)

#include <Demos/DemoCommon/Utilities/ExceptionHandler/hkExceptionHandler.h>


// hkExceptionHandler ::
HK_TRACKER_IMPLEMENT_SIMPLE(hkExceptionHandler, s_libraryName)

#include <Demos/DemoCommon/Utilities/FileBrowser/FileBrowser.h>


// FileBrowser ::

HK_TRACKER_DECLARE_CLASS_BEGIN(FileBrowser)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(FileBrowser)
    HK_TRACKER_MEMBER(FileBrowser, m_curDir, 0, "hkStringPtr") // hkStringPtr
    HK_TRACKER_MEMBER(FileBrowser, m_listing, 0, "hkFileSystem::DirectoryListing") // struct hkFileSystem::DirectoryListing
    HK_TRACKER_MEMBER(FileBrowser, m_prevDir, 0, "hkStringPtr") // hkStringPtr
    HK_TRACKER_MEMBER(FileBrowser, m_toScan, 0, "hkArray<hkStringPtr, hkContainerHeapAllocator>") // hkArray< hkStringPtr, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(FileBrowser, s_libraryName)

#include <Demos/DemoCommon/Utilities/FileFinder/FileFinder.h>


// FileFinder ::

HK_TRACKER_DECLARE_CLASS_BEGIN(FileFinder)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Filter)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(FileFinder)
    HK_TRACKER_MEMBER(FileFinder, m_filters, 0, "hkArray<FileFinder::Filter*, hkContainerHeapAllocator>") // hkArray< struct FileFinder::Filter*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(FileFinder, m_foldersTodo, 0, "hkArray<hkStringPtr, hkContainerHeapAllocator>") // hkArray< hkStringPtr, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(FileFinder, m_filesTodo, 0, "hkArray<hkStringPtr, hkContainerHeapAllocator>") // hkArray< hkStringPtr, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(FileFinder, s_libraryName)


// Filter FileFinder

HK_TRACKER_DECLARE_CLASS_BEGIN(FileFinder::Filter)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(FileFinder::Filter)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_ABSTRACT_BASE(FileFinder::Filter, s_libraryName)

#include <Demos/DemoCommon/Utilities/GameUtils/TweakerUtils.h>


// TweakerUtils ::

HK_TRACKER_DECLARE_CLASS_BEGIN(TweakerUtils)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(NameAndDisplayLocation)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(DisplayOptions)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(FloatTweakType)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_IMPLEMENT_SIMPLE(TweakerUtils, s_libraryName)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(TweakerUtils, FloatTweakType, s_libraryName)


// NameAndDisplayLocation TweakerUtils

HK_TRACKER_DECLARE_CLASS_BEGIN(TweakerUtils::NameAndDisplayLocation)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(TweakerUtils::NameAndDisplayLocation)
    HK_TRACKER_MEMBER(TweakerUtils::NameAndDisplayLocation, m_name, 0, "extStringPtr") // class extStringPtr
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(TweakerUtils::NameAndDisplayLocation, s_libraryName)


// DisplayOptions TweakerUtils

HK_TRACKER_DECLARE_CLASS_BEGIN(TweakerUtils::DisplayOptions)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(TweakerUtils::DisplayOptions)
    HK_TRACKER_MEMBER(TweakerUtils::DisplayOptions, m_nameAndDisplayLocationOut, 0, "extArray<TweakerUtils::NameAndDisplayLocation>*") // class extArray< struct TweakerUtils::NameAndDisplayLocation >*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(TweakerUtils::DisplayOptions, s_libraryName)


// DemoMouseTweaker ::

HK_TRACKER_DECLARE_CLASS_BEGIN(DemoMouseTweaker)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(TweakAlgorithmSpec)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(MouseTweakerSettings)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_IMPLEMENT_SIMPLE(DemoMouseTweaker, s_libraryName)


// TweakAlgorithmSpec DemoMouseTweaker
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(DemoMouseTweaker, TweakAlgorithmSpec, s_libraryName)


// MouseTweakerSettings DemoMouseTweaker

HK_TRACKER_DECLARE_CLASS_BEGIN(DemoMouseTweaker::MouseTweakerSettings)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(DemoMouseTweaker::MouseTweakerSettings)
    HK_TRACKER_MEMBER(DemoMouseTweaker::MouseTweakerSettings, m_tweakee, 0, "void*") // void*
    HK_TRACKER_MEMBER(DemoMouseTweaker::MouseTweakerSettings, m_tweakName, 0, "extStringBuf") // class extStringBuf
    HK_TRACKER_MEMBER(DemoMouseTweaker::MouseTweakerSettings, m_klass, 0, "hkClass*") // const hkClass*
    HK_TRACKER_MEMBER(DemoMouseTweaker::MouseTweakerSettings, m_demoEnvironment, 0, "hkDemoEnvironment*") // class hkDemoEnvironment*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(DemoMouseTweaker::MouseTweakerSettings, s_libraryName)

#include <Demos/DemoCommon/Utilities/Geometry/GeometryMaker.h>


// GeometryMaker ::

HK_TRACKER_DECLARE_CLASS_BEGIN(GeometryMaker)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Rectangle)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_IMPLEMENT_SIMPLE(GeometryMaker, s_libraryName)


// Rectangle GeometryMaker
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(GeometryMaker, Rectangle, s_libraryName)

#include <Demos/DemoCommon/Utilities/GpuStats/GpuStatsUtil.h>


// GpuStatsUtil ::

HK_TRACKER_DECLARE_CLASS_BEGIN(GpuStatsUtil)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(ObjectsState)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(GpuStatsUtil)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(GpuStatsUtil, s_libraryName, hkReferencedObject)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(GpuStatsUtil, ObjectsState, s_libraryName)

#include <Demos/DemoCommon/Utilities/Loading/LoadingUtil.h>


// LoadingUtil ::

HK_TRACKER_DECLARE_CLASS_BEGIN(LoadingUtil)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(InputOptions)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Output)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_IMPLEMENT_SIMPLE(LoadingUtil, s_libraryName)


// InputOptions LoadingUtil

HK_TRACKER_DECLARE_CLASS_BEGIN(LoadingUtil::InputOptions)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(LoadingUtil::InputOptions)
    HK_TRACKER_MEMBER(LoadingUtil::InputOptions, m_loader, 0, "hkLoader *") // class hkLoader *
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(LoadingUtil::InputOptions, s_libraryName)


// Output LoadingUtil

HK_TRACKER_DECLARE_CLASS_BEGIN(LoadingUtil::Output)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(LoadingUtil::Output)
    HK_TRACKER_MEMBER(LoadingUtil::Output, m_resource, 0, "hkObjectResource *") // class hkObjectResource *
    HK_TRACKER_MEMBER(LoadingUtil::Output, m_rootLevelContainer, 0, "hkRootLevelContainer*") // class hkRootLevelContainer*
    HK_TRACKER_MEMBER(LoadingUtil::Output, m_scene, 0, "hkxScene*") // class hkxScene*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(LoadingUtil::Output, s_libraryName)

#include <Demos/DemoCommon/Utilities/MarchingCubes/MarchingCubes.h>


// MarchingCubes ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MarchingCubes)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(VoxelTriangles)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Voxel)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MarchingCubes)
    HK_TRACKER_MEMBER(MarchingCubes, m_triangleData, 0, "hkArray<MarchingCubes::VoxelTriangles, hkContainerHeapAllocator>") // hkArray< struct MarchingCubes::VoxelTriangles, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(MarchingCubes, m_data, 0, "hkArray<float, hkContainerHeapAllocator>") // hkArray< float, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(MarchingCubes, s_libraryName, hkReferencedObject)


// VoxelTriangles MarchingCubes

HK_TRACKER_DECLARE_CLASS_BEGIN(MarchingCubes::VoxelTriangles)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MarchingCubes::VoxelTriangles)
    HK_TRACKER_MEMBER(MarchingCubes::VoxelTriangles, m_vertices, 0, "hkArray<hkVector4f, hkContainerHeapAllocator>") // hkArray< hkVector4f, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(MarchingCubes::VoxelTriangles, m_indices, 0, "hkArray<hkUint8, hkContainerHeapAllocator>") // hkArray< hkUint8, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(MarchingCubes::VoxelTriangles, s_libraryName)


// Voxel MarchingCubes
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(MarchingCubes, Voxel, s_libraryName)

#include <Demos/DemoCommon/Utilities/MonitorHelper/MonitorHelper.h>


// MonitorHelper ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MonitorHelper)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(MonitorHelperDetails)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MonitorHelper)
    HK_TRACKER_MEMBER(MonitorHelper, m_monitorStreamAnalyser, 0, "hkMonitorStreamAnalyzer*") // class hkMonitorStreamAnalyzer*
    HK_TRACKER_MEMBER(MonitorHelper, m_rootnode, 0, "hkMonitorStreamAnalyzer::Node*") // struct hkMonitorStreamAnalyzer::Node*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(MonitorHelper, s_libraryName, hkReferencedObject)


// MonitorHelperDetails MonitorHelper

HK_TRACKER_DECLARE_CLASS_BEGIN(MonitorHelper::MonitorHelperDetails)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MonitorHelper::MonitorHelperDetails)
    HK_TRACKER_MEMBER(MonitorHelper::MonitorHelperDetails, m_name, 0, "char*") // const char*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(MonitorHelper::MonitorHelperDetails, s_libraryName)

#include <Demos/DemoCommon/Utilities/MonitorHelper/MonitorHelperMultithreaded.h>


// MultithreadedMonitorHelper ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MultithreadedMonitorHelper)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(MtMonitorHelperDetails)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(TrackedTimerEntry)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(TrackingType)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MultithreadedMonitorHelper)
    HK_TRACKER_MEMBER(MultithreadedMonitorHelper, m_demo, 0, "hkDefaultDemo*") // class hkDefaultDemo*
    HK_TRACKER_MEMBER(MultithreadedMonitorHelper, m_tree, 0, "hkMonitorStreamAnalyzer::Node*") // struct hkMonitorStreamAnalyzer::Node*
    HK_TRACKER_MEMBER(MultithreadedMonitorHelper, m_trackedTimers, 0, "hkArray<MultithreadedMonitorHelper::TrackedTimerEntry, hkContainerHeapAllocator>") // hkArray< struct MultithreadedMonitorHelper::TrackedTimerEntry, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(MultithreadedMonitorHelper, s_libraryName, hkReferencedObject)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(MultithreadedMonitorHelper, TrackingType, s_libraryName)


// MtMonitorHelperDetails MultithreadedMonitorHelper

HK_TRACKER_DECLARE_CLASS_BEGIN(MultithreadedMonitorHelper::MtMonitorHelperDetails)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MultithreadedMonitorHelper::MtMonitorHelperDetails)
    HK_TRACKER_MEMBER(MultithreadedMonitorHelper::MtMonitorHelperDetails, m_name, 0, "char*") // const char*
    HK_TRACKER_MEMBER(MultithreadedMonitorHelper::MtMonitorHelperDetails, m_node, 0, "hkMonitorStreamAnalyzer::Node*") // struct hkMonitorStreamAnalyzer::Node*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(MultithreadedMonitorHelper::MtMonitorHelperDetails, s_libraryName)


// TrackedTimerEntry MultithreadedMonitorHelper

HK_TRACKER_DECLARE_CLASS_BEGIN(MultithreadedMonitorHelper::TrackedTimerEntry)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MultithreadedMonitorHelper::TrackedTimerEntry)
    HK_TRACKER_MEMBER(MultithreadedMonitorHelper::TrackedTimerEntry, m_name, 0, "char*") // const char*
    HK_TRACKER_MEMBER(MultithreadedMonitorHelper::TrackedTimerEntry, m_childName, 0, "char*") // const char*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(MultithreadedMonitorHelper::TrackedTimerEntry, s_libraryName)

#include <Demos/DemoCommon/Utilities/ObjectComparison/ComparisonUtil.h>


// ComparisonUtil ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ComparisonUtil)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(StringValues)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ComparisonUtil)
    HK_TRACKER_MEMBER(ComparisonUtil, m_differences, 0, "hkArray<ComparisonUtil::StringValues, hkContainerHeapAllocator>") // hkArray< struct ComparisonUtil::StringValues, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(ComparisonUtil, m_diffTree, 0, "hkTree<ComparisonUtil::StringValues>") // class hkTree< struct ComparisonUtil::StringValues >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(ComparisonUtil, s_libraryName)


// StringValues ComparisonUtil

HK_TRACKER_DECLARE_CLASS_BEGIN(ComparisonUtil::StringValues)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ComparisonUtil::StringValues)
    HK_TRACKER_MEMBER(ComparisonUtil::StringValues, m_memPath, 0, "hkStringPtr") // hkStringPtr
    HK_TRACKER_MEMBER(ComparisonUtil::StringValues, m_valueA, 0, "hkStringPtr") // hkStringPtr
    HK_TRACKER_MEMBER(ComparisonUtil::StringValues, m_valueB, 0, "hkStringPtr") // hkStringPtr
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(ComparisonUtil::StringValues, s_libraryName)

#include <Demos/DemoCommon/Utilities/Particles/HkgParticleSystem/HkgDebrisParticleSystem.h>


// HkgDebrisParticleSystem ::

HK_TRACKER_DECLARE_CLASS_BEGIN(HkgDebrisParticleSystem)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(HkgParticle)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(HkgEmitParams)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(HkgDebrisParticleSystem)
    HK_TRACKER_MEMBER(HkgDebrisParticleSystem, m_demoEnvironment, 0, "hkDemoEnvironment*") // class hkDemoEnvironment*
    HK_TRACKER_MEMBER(HkgDebrisParticleSystem, m_particleDisplayObject, 0, "hkgParticleDisplayObject*") // class hkgParticleDisplayObject*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(HkgDebrisParticleSystem, s_libraryName, DebrisParticleSystem)


// HkgParticle HkgDebrisParticleSystem
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(HkgDebrisParticleSystem, HkgParticle, s_libraryName)


// HkgEmitParams HkgDebrisParticleSystem
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(HkgDebrisParticleSystem, HkgEmitParams, s_libraryName)

#include <Demos/DemoCommon/Utilities/Particles/HkgParticleSystem/HkgDustParticleSystem.h>


// HkgDustParticleSystem ::

HK_TRACKER_DECLARE_CLASS_BEGIN(HkgDustParticleSystem)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(HkgParticle)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(HkgDustParticleSystem)
    HK_TRACKER_MEMBER(HkgDustParticleSystem, m_demoEnvironment, 0, "hkDemoEnvironment*") // class hkDemoEnvironment*
    HK_TRACKER_MEMBER(HkgDustParticleSystem, m_particleDisplayObject, 0, "hkgParticleDisplayObject*") // class hkgParticleDisplayObject*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(HkgDustParticleSystem, s_libraryName, DustParticleSystem)


// HkgParticle HkgDustParticleSystem
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(HkgDustParticleSystem, HkgParticle, s_libraryName)

#include <Demos/DemoCommon/Utilities/Particles/HkgParticleSystem/HkgExplosionParticleSystem.h>


// HkgExplosionParticleSystem ::

HK_TRACKER_DECLARE_CLASS_BEGIN(HkgExplosionParticleSystem)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(HkgParticle)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(HkgEmitParams)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(HkgExplosionParticleSystem)
    HK_TRACKER_MEMBER(HkgExplosionParticleSystem, m_demoEnvironment, 0, "hkDemoEnvironment*") // class hkDemoEnvironment*
    HK_TRACKER_MEMBER(HkgExplosionParticleSystem, m_particleDisplayObject, 0, "hkgParticleDisplayObject*") // class hkgParticleDisplayObject*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(HkgExplosionParticleSystem, s_libraryName, ExplosionParticleSystem)


// HkgParticle HkgExplosionParticleSystem
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(HkgExplosionParticleSystem, HkgParticle, s_libraryName)


// HkgEmitParams HkgExplosionParticleSystem
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(HkgExplosionParticleSystem, HkgEmitParams, s_libraryName)

#include <Demos/DemoCommon/Utilities/Particles/HkgParticleSystem/HkgParticleSystem.h>


// HkgParticleSystem ::
HK_TRACKER_IMPLEMENT_SIMPLE(HkgParticleSystem, s_libraryName)

#include <Demos/DemoCommon/Utilities/Particles/HkgParticleSystem/HkgSmokeParticleSystem.h>


// HkgSmokeParticleSystem ::

HK_TRACKER_DECLARE_CLASS_BEGIN(HkgSmokeParticleSystem)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(HkgParticle)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(HkgEmitParams)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(HkgSmokeParticleSystem)
    HK_TRACKER_MEMBER(HkgSmokeParticleSystem, m_demoEnvironment, 0, "hkDemoEnvironment*") // class hkDemoEnvironment*
    HK_TRACKER_MEMBER(HkgSmokeParticleSystem, m_particleDisplayObject, 0, "hkgParticleDisplayObject*") // class hkgParticleDisplayObject*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(HkgSmokeParticleSystem, s_libraryName, SmokeParticleSystem)


// HkgParticle HkgSmokeParticleSystem
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(HkgSmokeParticleSystem, HkgParticle, s_libraryName)


// HkgEmitParams HkgSmokeParticleSystem
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(HkgSmokeParticleSystem, HkgEmitParams, s_libraryName)

#include <Demos/DemoCommon/Utilities/Particles/HkgParticleSystem/HkgSparksParticleSystem.h>


// HkgSparksParticleSystem ::

HK_TRACKER_DECLARE_CLASS_BEGIN(HkgSparksParticleSystem)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(HkgSparksParticleSystem)
    HK_TRACKER_MEMBER(HkgSparksParticleSystem, m_demoEnvironment, 0, "hkDemoEnvironment*") // class hkDemoEnvironment*
    HK_TRACKER_MEMBER(HkgSparksParticleSystem, m_particleDisplayObject, 0, "hkgParticleDisplayObject*") // class hkgParticleDisplayObject*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(HkgSparksParticleSystem, s_libraryName, SparksParticleSystem)

#include <Demos/DemoCommon/Utilities/Particles/ParticleSystem.h>


// ParticleSystem ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ParticleSystem)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ParticleSystem)
    HK_TRACKER_MEMBER(ParticleSystem, m_particleData, 0, "void*") // void*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_ABSTRACT(ParticleSystem, s_libraryName, hkReferencedObject)

#include <Demos/DemoCommon/Utilities/Particles/ParticleSystem/DebrisParticleSystem.h>


// DebrisParticleSystem ::

HK_TRACKER_DECLARE_CLASS_BEGIN(DebrisParticleSystem)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Particle)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(EmitParams)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Flags)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(DebrisParticleSystem)
    HK_TRACKER_MEMBER(DebrisParticleSystem, m_collisionUtil, 0, "ParticleCollisionUtil*") // class ParticleCollisionUtil*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(DebrisParticleSystem, s_libraryName, ParticleSystem)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(DebrisParticleSystem, Flags, s_libraryName)


// Particle DebrisParticleSystem
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(DebrisParticleSystem, Particle, s_libraryName)


// EmitParams DebrisParticleSystem

HK_TRACKER_DECLARE_CLASS_BEGIN(DebrisParticleSystem::EmitParams)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(DebrisParticleSystem::EmitParams)
    HK_TRACKER_MEMBER(DebrisParticleSystem::EmitParams, m_diskEmissionUtil, 0, "DiskEmissionUtil*") // class DiskEmissionUtil*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(DebrisParticleSystem::EmitParams, s_libraryName)

#include <Demos/DemoCommon/Utilities/Particles/ParticleSystem/DustParticleSystem.h>


// DustParticleSystem ::

HK_TRACKER_DECLARE_CLASS_BEGIN(DustParticleSystem)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Particle)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(EmitParams)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(DustParticleSystem)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(DustParticleSystem, s_libraryName, ParticleSystem)


// Particle DustParticleSystem
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(DustParticleSystem, Particle, s_libraryName)


// EmitParams DustParticleSystem
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(DustParticleSystem, EmitParams, s_libraryName)

#include <Demos/DemoCommon/Utilities/Particles/ParticleSystem/ExplosionParticleSystem.h>


// ExplosionParticleSystem ::

HK_TRACKER_DECLARE_CLASS_BEGIN(ExplosionParticleSystem)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Particle)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(EmitParams)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(ExplosionParticleSystem)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(ExplosionParticleSystem, s_libraryName, ParticleSystem)


// Particle ExplosionParticleSystem
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(ExplosionParticleSystem, Particle, s_libraryName)


// EmitParams ExplosionParticleSystem
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(ExplosionParticleSystem, EmitParams, s_libraryName)

#include <Demos/DemoCommon/Utilities/Particles/ParticleSystem/SmokeParticleSystem.h>


// SmokeParticleSystem ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SmokeParticleSystem)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Particle)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(EmitParams)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SmokeParticleSystem)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SmokeParticleSystem, s_libraryName, ParticleSystem)


// Particle SmokeParticleSystem
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(SmokeParticleSystem, Particle, s_libraryName)


// EmitParams SmokeParticleSystem
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(SmokeParticleSystem, EmitParams, s_libraryName)

#include <Demos/DemoCommon/Utilities/Particles/ParticleSystem/SparksParticleSystem.h>


// SparksParticleSystem ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SparksParticleSystem)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(RayCastInterface)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Particle)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(EmitParams)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Flags)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SparksParticleSystem)
    HK_TRACKER_MEMBER(SparksParticleSystem, m_rayCaster, 0, "SparksParticleSystem::RayCastInterface*") // struct SparksParticleSystem::RayCastInterface*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SparksParticleSystem, s_libraryName, ParticleSystem)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(SparksParticleSystem, Flags, s_libraryName)


// RayCastInterface SparksParticleSystem

HK_TRACKER_DECLARE_CLASS_BEGIN(SparksParticleSystem::RayCastInterface)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SparksParticleSystem::RayCastInterface)
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_ABSTRACT_BASE(SparksParticleSystem::RayCastInterface, s_libraryName)


// Particle SparksParticleSystem
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(SparksParticleSystem, Particle, s_libraryName)


// EmitParams SparksParticleSystem

HK_TRACKER_DECLARE_CLASS_BEGIN(SparksParticleSystem::EmitParams)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SparksParticleSystem::EmitParams)
    HK_TRACKER_MEMBER(SparksParticleSystem::EmitParams, m_diskEmissionUtil, 0, "DiskEmissionUtil*") // class DiskEmissionUtil*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(SparksParticleSystem::EmitParams, s_libraryName)

#include <Demos/DemoCommon/Utilities/Particles/Utilities/ChimneyEmissionUtil.h>


// ChimneyEmissionUtil ::
HK_TRACKER_IMPLEMENT_SIMPLE(ChimneyEmissionUtil, s_libraryName)

#include <Demos/DemoCommon/Utilities/Particles/Utilities/ContinuousEmissionUtil.h>


// ContinuousEmissionUtil ::
HK_TRACKER_IMPLEMENT_SIMPLE(ContinuousEmissionUtil, s_libraryName)

#include <Demos/DemoCommon/Utilities/Particles/Utilities/DepthSortParticlesUtil.h>


// DepthSortParticlesUtil ::
HK_TRACKER_IMPLEMENT_SIMPLE(DepthSortParticlesUtil, s_libraryName)

#include <Demos/DemoCommon/Utilities/Particles/Utilities/DiskEmissionUtil.h>


// DiskEmissionUtil ::
HK_TRACKER_IMPLEMENT_SIMPLE(DiskEmissionUtil, s_libraryName)

#include <Demos/DemoCommon/Utilities/PathContainer/PathContainer.h>


// PathContainer ::

HK_TRACKER_DECLARE_CLASS_BEGIN(PathContainer)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Path)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(PathContainer)
    HK_TRACKER_MEMBER(PathContainer, m_paths, 0, "hkArray<PathContainer::Path, hkContainerHeapAllocator>") // hkArray< struct PathContainer::Path, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(PathContainer, s_libraryName, hkReferencedObject)


// Path PathContainer

HK_TRACKER_DECLARE_CLASS_BEGIN(PathContainer::Path)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(PathContainer::Path)
    HK_TRACKER_MEMBER(PathContainer::Path, m_points, 0, "hkArray<hkVector4f, hkContainerHeapAllocator>") // hkArray< hkVector4f, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(PathContainer::Path, s_libraryName)


// PathContainerUtility ::
HK_TRACKER_IMPLEMENT_SIMPLE(PathContainerUtility, s_libraryName)

#include <Demos/DemoCommon/Utilities/SplashScreen/SplashScreen.h>


// SplashScreen ::

HK_TRACKER_DECLARE_CLASS_BEGIN(SplashScreen)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(SplashFile)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(SplashType)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SplashScreen)
    HK_TRACKER_MEMBER(SplashScreen, m_splashFile, 0, "SplashScreen::SplashFile") // struct SplashScreen::SplashFile
    HK_TRACKER_MEMBER(SplashScreen, m_demo, 0, "hkDefaultDemo*") // class hkDefaultDemo*
    HK_TRACKER_MEMBER(SplashScreen, m_window, 0, "hkgWindow*") // class hkgWindow*
    HK_TRACKER_MEMBER(SplashScreen, m_splashTexture, 0, "hkgTexture*") // class hkgTexture*
    HK_TRACKER_MEMBER(SplashScreen, m_font, 0, "hkgFont*") // class hkgFont*
    HK_TRACKER_MEMBER(SplashScreen, m_message, 0, "extStringPtr") // class extStringPtr
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(SplashScreen, s_libraryName, hkReferencedObject)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(SplashScreen, SplashType, s_libraryName)


// SplashFile SplashScreen

HK_TRACKER_DECLARE_CLASS_BEGIN(SplashScreen::SplashFile)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(SplashScreen::SplashFile)
    HK_TRACKER_MEMBER(SplashScreen::SplashFile, m_filename, 0, "char*") // const char*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(SplashScreen::SplashFile, s_libraryName)

#include <Demos/DemoCommon/Utilities/TestPlan/TestPlanDemo.h>


// TestPlanDemo ::

HK_TRACKER_DECLARE_CLASS_BEGIN(TestPlanDemo)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(TestPlanType)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(TestPlanDemo)
    HK_TRACKER_MEMBER(TestPlanDemo, m_testPlanFilename, 0, "char*") // const char*
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(TestPlanDemo, s_libraryName, hkDemo)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(TestPlanDemo, TestPlanType, s_libraryName)

#include <Demos/DemoCommon/Utilities/Tweaker/Tweak.h>


// MyStruct ::
HK_TRACKER_IMPLEMENT_SIMPLE(MyStruct, s_libraryName)


// MyContainer ::

HK_TRACKER_DECLARE_CLASS_BEGIN(MyContainer)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(MyContainer)
    HK_TRACKER_MEMBER(MyContainer, m_ptrToStruct, 0, "MyStruct*") // struct MyStruct*
    HK_TRACKER_MEMBER(MyContainer, m_arrayInt, 0, "hkArray<hkInt32, hkContainerHeapAllocator>") // hkArray< hkInt32, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(MyContainer, m_arrayPtr, 0, "hkArray<MyStruct*, hkContainerHeapAllocator>") // hkArray< struct MyStruct*, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(MyContainer, m_arrayStruct, 0, "hkArray<MyStruct, hkContainerHeapAllocator>") // hkArray< struct MyStruct, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(MyContainer, s_libraryName)

#include <Demos/DemoCommon/Utilities/Tweaker/Tweaker.h>


// Tweaker ::

HK_TRACKER_DECLARE_CLASS_BEGIN(Tweaker)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Mode)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(Tweaker)
    HK_TRACKER_MEMBER(Tweaker, m_gamepadHelp, 0, "char*") // const char*
    HK_TRACKER_MEMBER(Tweaker, m_keyboardHelp, 0, "char*") // const char*
    HK_TRACKER_MEMBER(Tweaker, m_data, 0, "void*") // void*
    HK_TRACKER_MEMBER(Tweaker, m_selected, 0, "hkStringPtr") // hkStringPtr
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(Tweaker, s_libraryName)

HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(Tweaker, Mode, s_libraryName)

#include <Demos/DemoCommon/Utilities/hkGeometrySplitter.h>


// hkSplitGeometryInput ::

HK_TRACKER_DECLARE_CLASS_BEGIN(hkSplitGeometryInput)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(IndexBuf)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(hkSplitGeometryInput)
    HK_TRACKER_MEMBER(hkSplitGeometryInput, m_indexBufs, 0, "hkArray<hkSplitGeometryInput::IndexBuf, hkContainerHeapAllocator>") // hkArray< struct hkSplitGeometryInput::IndexBuf, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(hkSplitGeometryInput, s_libraryName)


// IndexBuf hkSplitGeometryInput
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(hkSplitGeometryInput, IndexBuf, s_libraryName)


// hkSplitGeometryOutput ::

HK_TRACKER_DECLARE_CLASS_BEGIN(hkSplitGeometryOutput)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(CutVertex)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(hkSplitGeometryOutput)
    HK_TRACKER_MEMBER(hkSplitGeometryOutput, m_reusedVertices, 0, "hkArray<hkUint16, hkContainerHeapAllocator>") // hkArray< hkUint16, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(hkSplitGeometryOutput, m_cutVertices, 0, "hkArray<hkSplitGeometryOutput::CutVertex, hkContainerHeapAllocator>") // hkArray< struct hkSplitGeometryOutput::CutVertex, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(hkSplitGeometryOutput, m_outsideFaceIndices, 0, "hkArray<hkUint16, hkContainerHeapAllocator>") // hkArray< hkUint16, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(hkSplitGeometryOutput, m_insideFaceIndices, 0, "hkArray<hkUint16, hkContainerHeapAllocator>") // hkArray< hkUint16, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS_BASE(hkSplitGeometryOutput, s_libraryName)


// CutVertex hkSplitGeometryOutput
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(hkSplitGeometryOutput, CutVertex, s_libraryName)


// hkTempSplitGeom ::

HK_TRACKER_DECLARE_CLASS_BEGIN(hkTempSplitGeom)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(Triangle)
    HK_TRACKER_DECLARE_CHILD_SIMPLE(VertData)
HK_TRACKER_DECLARE_CLASS_END

HK_TRACKER_CLASS_MEMBERS_BEGIN(hkTempSplitGeom)
    HK_TRACKER_MEMBER(hkTempSplitGeom, m_vertices, 0, "hkArray<hkVector4f, hkContainerHeapAllocator>") // hkArray< hkVector4f, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(hkTempSplitGeom, m_vertDatas, 0, "hkArray<hkTempSplitGeom::VertData, hkContainerHeapAllocator>") // hkArray< struct hkTempSplitGeom::VertData, struct hkContainerHeapAllocator >
    HK_TRACKER_MEMBER(hkTempSplitGeom, m_indices, 0, "hkArray<hkUint16, hkContainerHeapAllocator>") // hkArray< hkUint16, struct hkContainerHeapAllocator >
HK_TRACKER_CLASS_MEMBERS_END()
HK_TRACKER_IMPLEMENT_CLASS(hkTempSplitGeom, s_libraryName, hkReferencedObject)


// Triangle hkTempSplitGeom
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(hkTempSplitGeom, Triangle, s_libraryName)


// VertData hkTempSplitGeom
HK_TRACKER_IMPLEMENT_CHILD_SIMPLE(hkTempSplitGeom, VertData, s_libraryName)

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
