/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef SAMPLE_AND_BLEND_ANIMATION_MULTITHREADING_DEMO_H
#define SAMPLE_AND_BLEND_ANIMATION_MULTITHREADING_DEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultAnimationDemo.h>
#include <Animation/Animation/Animation/hkaAnimationBinding.h>
#include <Animation/Animation/Playback/hkaAnimatedSkeleton.h>

class hkaPose;

class SampleAndBlendTimingsDemo : public hkDefaultAnimationDemo
{
	public:

		HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DEMO );

		SampleAndBlendTimingsDemo( hkDemoEnvironment* env );

		Result stepDemo();

	private:

		// single threaded sampling
		void sampleSt( hkaPose** poses );

		// multi-threaded sampling
		void sampleMt( hkaPose** poses );

		hkaAnimationBinding* makeMirroredAnimation( hkaAnimationBinding* binding, hkaAnimation* animation );

	private:

		// the shared skeleton
		hkRefPtr<hkaSkeleton> m_skeleton;

		// the animations we've loaded
		hkArray< hkRefPtr<hkaAnimationBinding> > m_bindings;

		// one control for each "character"
		hkArray< hkRefPtr<hkaAnimatedSkeleton> > m_animatedSkeletons;

		// Amount of animation memory when uncompressed.
		int m_numBytesUncompressed;

		// Amount of animation memory when compressed.
		int m_numBytesCompressed;

		// total time spent sampling
		hkReal m_totalSampleTimeSeconds;

		// number of frames stepped
		int m_numFrames;

};

#endif //SAMPLE_AND_BLEND_ANIMATION_MULTITHREADING_DEMO_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
