/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef ANIMATION_RETARGETING_SHOWCASE_DEMO_H
#define ANIMATION_RETARGETING_SHOWCASE_DEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultAnimationDemo.h>

#include <Animation/Animation/Mapper/hkaSkeletonMapperData.h>

class hkLoader;
class hkaSkeleton;
class hkaAnimatedSkeleton;
class hkaAnimationBinding;
class hkaMeshBinding;
class hkaBoneAttachment;
class hkgDisplayObject;
class WindowedAverage;

class AnimationMappingShowcaseDemo : public hkDefaultAnimationDemo
{
	public:

		HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DEMO );

		AnimationMappingShowcaseDemo( hkDemoEnvironment* env );

		~AnimationMappingShowcaseDemo();

		Result stepDemo(); 

	private:

		static hkInt32 HK_CALL findBoneWithName( const hkaSkeleton* , const char* );
		void initWorldFromModel( int i );
		void showHelp();

		hkLoader* m_loader;


		struct MappedCharacter
		{
			HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DEMO, MappedCharacter );

			hkaAnimatedSkeleton* m_animatedSkeleton;

			hkaAnimationBinding* m_binding;

			hkArray< hkRefPtr< hkaMeshBinding > > m_skinBindings;
			hkArray< hkRefPtr< hkaBoneAttachment > > m_attachments;
			hkArray< hkgDisplayObject* > m_attachmentObjects;

			hkQsTransform m_worldFromModel;

			hkReal m_characterHeight;

			hkArray< hkaSkeletonMapperData* > m_map;
		};

		hkReal m_speed;

		hkBool m_drawSkins;
		hkBool m_drawBoneNames;
		hkBool m_useWireFrame;
		hkBool m_useReferencePose;
		hkBool m_useExtractedMotion;
		hkBool m_useHandIK;
		hkBool m_paused;
		hkBool m_showTimings;

		hkInt32 m_activeCharacter;

		hkArray< MappedCharacter* > m_characters;

		WindowedAverage* m_windowedAverageRetargeting;
		WindowedAverage* m_windowedAverageSampling;

		class SplashScreen* m_splashScreen;
};

#endif // ANIMATION_RETARGETING_SHOWCASE_DEMO_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
