/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef ANIMATION_BLEND_PARTIAL_RETARGETING_DEMO_H
#define ANIMATION_BLEND_PARTIAL_RETARGETING_DEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultAnimationDemo.h>

#include <Animation/Animation/Mapper/hkaSkeletonMapper.h>

class hkLoader;
class hkaAnimatedSkeleton;
class hkaMeshBinding;
class hkaDefaultAnimationControl;

class BlendPartialRetargetingDemo : public hkDefaultAnimationDemo
{
	public:

		HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DEMO );

		BlendPartialRetargetingDemo( hkDemoEnvironment* env );

		~BlendPartialRetargetingDemo();

		Result stepDemo(); 

	private:

		hkLoader* m_loader;

		hkBool m_drawSkins;
		hkBool m_useExtractedMotion;
		hkBool m_enableRetargetedAnimation;
		hkBool m_enablePartialAnimation;

		hkaAnimatedSkeleton* m_animatedSkeleton[ 2 ];
		hkaAnimationBinding* m_binding[ 2 ];
		hkArray< hkRefPtr< hkaMeshBinding > > m_skinBindings[ 2 ];

		hkaDefaultAnimationControl* m_retargetedControl;
		hkaDefaultAnimationControl* m_partialControl;
	

		hkaSkeletonMapper* m_mapper;
			
		hkQsTransform m_worldFromModel[ 2 ];

};

#endif

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
