/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef ANIMATION_RETARGETING_BLENDING_DEMO_H
#define ANIMATION_RETARGETING_BLENDING_DEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultAnimationDemo.h>

#include <Animation/Animation/Mapper/hkaSkeletonMapper.h>

class hkLoader;
class hkaAnimatedSkeleton;
class hkaMeshBinding;
class hkaPose;

class BlendedRetargetingDemo : public hkDefaultAnimationDemo
{
	public:

		HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DEMO );

		BlendedRetargetingDemo( hkDemoEnvironment* env );

		~BlendedRetargetingDemo();

		Result stepDemo(); 

	private:

			// single threaded sampling
		void sampleSt( hkaPose** poses );

			// multi-threaded sampling
		void sampleMt( hkaPose** poses );

		hkLoader* m_loader;

		hkBool m_drawSkins;
		hkBool m_useExtractedMotion;

		hkaAnimatedSkeleton* m_animatedSkeleton[ 2 ];
		hkaAnimationBinding* m_binding[ 2 ];
		hkArray< hkRefPtr< hkaMeshBinding > > m_skinBindings[ 2 ];

		hkaSkeletonMapper* m_mapper[ 2 ];
			
		hkQsTransform m_worldFromModel[ 2 ];

		hkReal m_blendFraction;
};

#endif // ANIMATION_RETARGETING_BLENDING_DEMO_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
