/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_RAGDOLL_SCALING_DEMO_H
#define HK_RAGDOLL_SCALING_DEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysics2012Demo.h>
#include <Common/Base/Container/PointerMap/hkPointerMap.h>

#include <Animation/Physics2012Bridge/Instance/hkaRagdollInstance.h>
#include <Animation/Animation/Mapper/hkaSkeletonMapper.h>

// Vertex Deformation
#include <Animation/Animation/Deform/Skinning/hkaMeshBinding.h>

class hkLoader;
class hkpSimpleMeshShape;
class hkDisplayConvex;
class hkpMoppBvTreeShape;
class hkaSkeleton;
class hkaAnimation;
class hkaAnimatedSkeleton;
class hkaAnimationBinding;
class hkaRagdollInstance;
class hkaSkeletonMapper;
class hkaDefaultAnimationControl;
class hkaRagdollRigidBodyController;
class hkDisplayConvex;
class hkDisplayGeometry;

class RagdollScalingDemo : public hkDefaultPhysics2012Demo
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

        RagdollScalingDemo(hkDemoEnvironment* env);

        ~RagdollScalingDemo();

        hkDemo::Result stepDemo();

    private:

		void buildLandscape( int side, hkReal size );


        hkLoader* m_loader;

		hkaSkeleton* m_ragdollSkeleton;
		hkaSkeleton* m_animationSkeleton;
		hkaAnimationBinding* m_binding;
		hkaDefaultAnimationControl* m_control;
		hkaAnimatedSkeleton* m_character;
		hkaRagdollInstance* m_ragdoll;
   		hkaSkeletonMapper* m_ragdollFromAnimation;
		hkaSkeletonMapper* m_animationFromRagdoll;
		hkaRagdollRigidBodyController* m_ragdollRigidBodyController;

		hkQsTransform m_worldFromModel;
		hkReal m_scale;

		hkArray< hkRefPtr<hkaMeshBinding> > m_skinBindings;

		// Display geometry for the landscape
		hkGeometry* m_geometry;

		// allows the geometry to be handled by the display manager
		hkDisplayConvex* m_displayConvex;
		hkArray<hkDisplayGeometry*> m_geometryArray;
};

#endif  // HK_RAGDOLL_SCALING_DEMO_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
