/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */




#ifndef RAGDOLL_CONTROLLER_DEMO_TWEAK_OPTIONS_H
#define RAGDOLL_CONTROLLER_DEMO_TWEAK_OPTIONS_H

extern const class hkClass RagdollControllerDemoDisplayOptionsClass;
extern const class hkClass RagdollControllerDemoRagdollControlOptionsClass;
extern const class hkClass RagdollControllerDemoRigidbodyRagdollControllerOptionsClass;
extern const class hkClass RagdollControllerDemoPoweredRagdollControllerOptionsClass;
extern const class hkClass RagdollControllerDemoBallGunOptionsClass;
extern const class hkClass RagdollControllerDemoTweakOptionsClass;
extern const class hkTypeInfo RagdollControllerDemoTweakOptionsTypeInfo;

struct RagdollControllerDemoBallGunOptions
{
	HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_UTILITIES, RagdollControllerDemoBallGunOptions );
	HK_DECLARE_REFLECTION();

	RagdollControllerDemoBallGunOptions();

	void validate();

	hkReal m_bulletRadius;
	hkReal m_bulletVelocity;
	hkReal m_bulletMass;
};

struct RagdollControllerDemoDisplayOptions
{
	HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_UTILITIES, RagdollControllerDemoDisplayOptions );
	HK_DECLARE_REFLECTION();

	RagdollControllerDemoDisplayOptions();

	void validate();

	hkBool m_showTargetAnimationPose;
	hkBool m_showResultAnimationPose;
	hkBool m_showTargetRagdollPose;
	hkBool m_showDynamicRagdollPose;
	hkBool m_showRagdollRigidbodies;
	hkBool m_showSkinnedCharacter;
	hkReal m_dynamicRagdollAlpha;
};

struct RagdollControllerDemoRigidbodyRagdollControllerOptions
{
	HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_UTILITIES, RagdollControllerDemoRigidbodyRagdollControllerOptions );
	HK_DECLARE_REFLECTION();

	RagdollControllerDemoRigidbodyRagdollControllerOptions();

	void validate();

	hkReal m_hierarchyGain;
	hkReal m_velocityDamping;
	hkReal m_accelerationGain;
	hkReal m_velocityGain;
	hkReal m_positionGain;
	hkReal m_positionMaxLinearVelocity;
	hkReal m_positionMaxAngularVelocity;
	hkReal m_snapGain;
	hkReal m_snapMaxLinearVelocity;
	hkReal m_snapMaxAngularVelocity;
	hkReal m_snapMaxLinearDistance;
	hkReal m_snapMaxAngularDistance;
	hkBool m_lockFirstFrameOfAnimationLoop;
};

struct RagdollControllerDemoPositionMotorConstraintOptions
{
	HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_UTILITIES, RagdollControllerDemoPositionMotorConstraintOptions );
	HK_DECLARE_REFLECTION();

	RagdollControllerDemoPositionMotorConstraintOptions();

	void validate();

	/// Maximum force exerted by the motor.
	hkReal m_maxForceByMotor;

	/// The relative stiffness between 0 and 1.
	hkReal m_tau;

	/// The relative damping between 0 and 1.
	hkReal m_damping;

	/// A factor of the current error to calculate the recovery velocity.
	hkReal m_proportionalRecoveryVelocity;

	/// A constant velocity which is used to recover from errors.
	hkReal m_constantRecoveryVelocity;
};

class RagdollControllerDemoTweakOptions : public hkReferencedObject
{
public:
	HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_UTILITIES );
	HK_DECLARE_REFLECTION();

	enum DemoMode
	{
		RIGID_BODY_CONTROLLER,
		POSITION_MOTOR_POWERED_CONTROLLER,
		KEYFRAMED
	};

	RagdollControllerDemoTweakOptions();
	RagdollControllerDemoTweakOptions( hkFinishLoadedObjectFlag flag ) {}

	void validate();

	struct RagdollControllerDemoDisplayOptions                    m_displayOptions;
	struct RagdollControllerDemoRigidbodyRagdollControllerOptions m_rigidbodyControllerOptions;
	struct RagdollControllerDemoPositionMotorConstraintOptions    m_positionMotorConstraintOptions;
	struct RagdollControllerDemoBallGunOptions                    m_ballGunOptions;
	hkReal                                                        m_raycastGunImpulse;
	hkReal                                                        m_blendWeightOfTargetPose;
	hkBool                                                        m_useKeyframeForRootBone;
	hkEnum<DemoMode, int>                                         m_demoMode;

	static hkBool save(RagdollControllerDemoTweakOptions* options, const char* tweakOptionFileName);
	static RagdollControllerDemoTweakOptions* load(const char* tweakOptionFileName);

private:
	static void enableSerialization();
	static bool s_serializationInitialized;

};

#endif

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
