/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#include <Demos/demos.h>
#include <Demos/Animation/Api/Ragdoll/RagdollController/RagdollControllerDemoTweakOptions.h>

#include <Common/Base/Container/LocalArray/hkLocalBuffer.h>
#include <Common/Base/System/Io/Writer/Array/hkArrayStreamWriter.h>
#include <Common/Base/System/Io/FileSystem/hkFileSystem.h>
#include <Common/Serialize/Util/hkSerializeUtil.h>
#include <Common/Base/Reflection/Registry/hkDefaultClassNameRegistry.h>

#define HKA_DEMO_CLAMP( VAL, MIN, MAX ) VAL = hkMath::clamp( VAL, MIN, MAX )

//-----------------------------------------------------------------------------//
//	RagdollControllerDemoBallGunOptions
//-----------------------------------------------------------------------------//
RagdollControllerDemoBallGunOptions::RagdollControllerDemoBallGunOptions()
{
	m_bulletRadius      = 0.35f;
	m_bulletVelocity    = 20.0f;
	m_bulletMass        = 30.f;
}

void RagdollControllerDemoBallGunOptions::validate()
{
	HKA_DEMO_CLAMP(m_bulletRadius, 0.05f, 0.5f);
	HKA_DEMO_CLAMP(m_bulletVelocity, 1.0f, 50.0f);
	HKA_DEMO_CLAMP(m_bulletMass, 1.0f, 100.0f);
}

//-----------------------------------------------------------------------------//
//	RagdollControllerDemoPositionMotorConstraintOptions
//-----------------------------------------------------------------------------//
RagdollControllerDemoPositionMotorConstraintOptions::RagdollControllerDemoPositionMotorConstraintOptions()
{
	m_maxForceByMotor              = 100.0f;
	m_tau                          = 0.8f;
	m_damping                      = 1.0f;
	m_constantRecoveryVelocity     = 1.0f;
	m_proportionalRecoveryVelocity = 2.0f;
}

void RagdollControllerDemoPositionMotorConstraintOptions::validate()
{
	HKA_DEMO_CLAMP(m_maxForceByMotor, .1f, 1000.0f);
	HKA_DEMO_CLAMP(m_tau, .1f, 10.0f);
	HKA_DEMO_CLAMP(m_damping, .1f, 10.0f);
	HKA_DEMO_CLAMP(m_constantRecoveryVelocity, .1f, 10.0f);
	HKA_DEMO_CLAMP(m_proportionalRecoveryVelocity, .1f, 10.0f);
}

//-----------------------------------------------------------------------------//
//	RagdollControllerDemoDisplayOptions
//-----------------------------------------------------------------------------//
RagdollControllerDemoDisplayOptions::RagdollControllerDemoDisplayOptions()
{
	m_showTargetAnimationPose = true;
	m_showResultAnimationPose = true;
	m_showTargetRagdollPose   = true;
	m_showDynamicRagdollPose  = true;
	m_showRagdollRigidbodies  = true;
	m_showSkinnedCharacter    = true;
	m_dynamicRagdollAlpha     = 0.4f;
}

void RagdollControllerDemoDisplayOptions::validate()
{
	HKA_DEMO_CLAMP(m_dynamicRagdollAlpha, .0f, 1.0f);
}

//-----------------------------------------------------------------------------//
//	RagdollControllerDemoRigidbodyRagdollControllerOptions
//-----------------------------------------------------------------------------//
RagdollControllerDemoRigidbodyRagdollControllerOptions::RagdollControllerDemoRigidbodyRagdollControllerOptions()
	:
	m_hierarchyGain(0.17f),
	m_velocityDamping(0.0f),
	m_accelerationGain(1.0f),
	m_velocityGain(0.6f),
	m_positionGain(0.05f),
	m_positionMaxLinearVelocity(1.4f),
	m_positionMaxAngularVelocity(1.8f),
	m_snapGain(0.1f),
	m_snapMaxLinearVelocity(0.3f),
	m_snapMaxAngularVelocity(0.3f),
	m_snapMaxLinearDistance(0.03f),
	m_snapMaxAngularDistance(0.1f),
	m_lockFirstFrameOfAnimationLoop(false)
{}

void RagdollControllerDemoRigidbodyRagdollControllerOptions::validate()
{
	HKA_DEMO_CLAMP(m_hierarchyGain, .0f, 1.0f);
	HKA_DEMO_CLAMP(m_velocityDamping, .0f, 1.0f); 
	HKA_DEMO_CLAMP(m_accelerationGain, .0f, 1.0f); 
	HKA_DEMO_CLAMP(m_velocityGain, .0f, 1.0f);
	HKA_DEMO_CLAMP(m_positionGain, .0f, 1.0f);
	HKA_DEMO_CLAMP(m_positionMaxLinearVelocity, .1f, 2.0f);
	HKA_DEMO_CLAMP(m_positionMaxAngularVelocity, .1f, 2.0f);
	HKA_DEMO_CLAMP(m_snapGain, .0f, 1.0f);
	HKA_DEMO_CLAMP(m_snapMaxLinearVelocity, .1f, 2.0f);
	HKA_DEMO_CLAMP(m_snapMaxAngularVelocity, .1f, 2.0f);
	HKA_DEMO_CLAMP(m_snapMaxLinearDistance, .0f, 1.0f);
	HKA_DEMO_CLAMP(m_snapMaxAngularDistance, .0f, 1.0f);
}

//-----------------------------------------------------------------------------//
//	RagdollControllerDemoTweakOptions
//-----------------------------------------------------------------------------//

namespace {
	void static registerClassInfo(const hkClass& klass)
	{
		if ( !klass.hasVtable() )
		{
			hkDefaultClassNameRegistry::getInstance().registerClass(&klass);
		}

		const int nc = klass.getNumMembers();
		for (int ni=0; ni<nc; ++ni)
		{
			const hkClassMember& m = klass.getMember(ni);
			const hkClass* k = m.getClass();
			if (!k)
			{
				continue;
			}
			registerClassInfo(*k);
		}
	}
};

bool RagdollControllerDemoTweakOptions::s_serializationInitialized = false;

RagdollControllerDemoTweakOptions::RagdollControllerDemoTweakOptions()
{
	m_raycastGunImpulse       = 50.0f;
	m_blendWeightOfTargetPose = 0.0f;
	m_useKeyframeForRootBone  = true;
	m_demoMode                = RIGID_BODY_CONTROLLER;
}

void RagdollControllerDemoTweakOptions::validate()
{
	m_displayOptions.validate();
	m_rigidbodyControllerOptions.validate();
	m_positionMotorConstraintOptions.validate();
	m_ballGunOptions.validate();
	HKA_DEMO_CLAMP(m_raycastGunImpulse, 1.0f, 1000.0f);
	HKA_DEMO_CLAMP(m_blendWeightOfTargetPose, .0f, 1.0f);
}

hkBool RagdollControllerDemoTweakOptions::save(RagdollControllerDemoTweakOptions* options, const char* tweakOptionFileName)
{
	enableSerialization();

	hkSerializeUtil::SaveOptions saveOptions;
	saveOptions.useBinary(false);
	const hkResult res = hkSerializeUtil::save(options, tweakOptionFileName, saveOptions);
	if (HK_SUCCESS != res)
	{
		HK_TRACE("hkSerializeUtil::saveTagfile() failed for a file \"" << tweakOptionFileName << "\"\n");
		return false;
	}
	return true;
}

RagdollControllerDemoTweakOptions* RagdollControllerDemoTweakOptions::load(const char* tweakOptionFileName)
{
	enableSerialization();

	hkSerializeUtil::ErrorDetails ed;
	RagdollControllerDemoTweakOptions* options = hkSerializeUtil::loadObject<RagdollControllerDemoTweakOptions>(tweakOptionFileName, &ed);
	if (!options)
	{
		HK_TRACE("hkSerializeUtil::loadObject() failed for a file \"" << tweakOptionFileName << "\"\n");
	}
	return options;
}

void RagdollControllerDemoTweakOptions::enableSerialization()
{
	if (!s_serializationInitialized)
	{
		hkBuiltinTypeRegistry::getInstance().addType(&RagdollControllerDemoTweakOptionsTypeInfo, &RagdollControllerDemoTweakOptionsClass);
		registerClassInfo(RagdollControllerDemoTweakOptionsClass);
		s_serializationInitialized = true;
	}
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
